/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.krms;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.compliance.core.SpecialReview;
import org.kuali.coeus.common.framework.krms.KcKrmsJavaFunctionTermService;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.common.framework.sponsor.Sponsorable;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.common.framework.version.sequence.owner.SequenceOwner;
import org.kuali.coeus.sys.api.model.ScaleThreeDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class KcKrmsJavaFunctionTermServiceBase
implements KcKrmsJavaFunctionTermService {
    protected final Logger LOG = LogManager.getLogger(KcKrmsJavaFunctionTermServiceBase.class);
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final List<String> NULL_VALUES = Arrays.asList("null", "empty");
    public static final String[] restrictedElements = new String[]{" ", "`", "@", "#", "!", "$", "%", "^", "&", "*", "(", ")", "[", "]", "{", "}", "|", "\\", "/", "?", "<", ">", ",", ";", ":", "'", "\"", "`", "+"};
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="versionHistoryService")
    private VersionHistoryService versionHistoryService;

    @Override
    public Boolean checkPropertyValueForAnyPreviousVersion(SequenceOwner<?> currentVersion, String property, String valueToCompare) {
        return currentVersion.getVersionNameFieldValue() != null && this.getVersionHistories(currentVersion, currentVersion.getVersionNameFieldValue()).stream().filter(this::isArchivedOrActive).anyMatch(pastVersion -> this.isPropertyValueMatches(currentVersion, property, valueToCompare, (VersionHistory)pastVersion));
    }

    protected boolean isPropertyValueMatches(SequenceOwner<?> currentVersion, String property, String valueToCompare, VersionHistory pastVersion) {
        Object propertyValue = this.getPropertyValue(pastVersion.getSequenceOwner(), property);
        return propertyValue != null && !currentVersion.getSequenceNumber().equals(pastVersion.getSequenceOwnerSequenceNumber()) && this.propertyValueEqualsString(property, propertyValue, valueToCompare) != false;
    }

    protected boolean isArchivedOrActive(VersionHistory pastVersion) {
        return VersionStatus.ARCHIVED == pastVersion.getStatus() || VersionStatus.ACTIVE == pastVersion.getStatus();
    }

    protected List<VersionHistory> getVersionHistories(SequenceOwner<?> currentVersion, String versionNumber) {
        return this.getVersionHistoryService().loadVersionHistory(currentVersion.getClass(), versionNumber);
    }

    protected Object getPropertyValue(Object propertyObject, String property) {
        Object propertyValue = null;
        try {
            Method readMethod;
            PropertyDescriptor propDescriptor = PropertyUtils.getPropertyDescriptor((Object)propertyObject, (String)property);
            if (propDescriptor != null && (readMethod = propDescriptor.getReadMethod()) != null) {
                propertyValue = propDescriptor.getReadMethod().invoke(propertyObject, new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Count not find property " + property + "on object" + propertyObject, e);
        }
        return propertyValue;
    }

    protected Boolean propertyValueEqualsString(String propertyName, Object propertyValue, String valueToCompare) {
        try {
            if (propertyValue instanceof Integer && propertyValue.equals(Integer.valueOf(valueToCompare))) {
                return true;
            }
            if (propertyValue instanceof Long && propertyValue.equals(Long.valueOf(valueToCompare))) {
                return true;
            }
            if (propertyValue instanceof Double && propertyValue.equals(Double.valueOf(valueToCompare))) {
                return true;
            }
            if (propertyValue instanceof BigDecimal && propertyValue.equals(new BigDecimal(valueToCompare))) {
                return true;
            }
            if (propertyValue instanceof ScaleTwoDecimal && propertyValue.equals(new ScaleTwoDecimal(valueToCompare))) {
                return true;
            }
            if (propertyValue instanceof ScaleThreeDecimal && propertyValue.equals(new ScaleThreeDecimal(valueToCompare))) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Value " + valueToCompare + " cannot be numerically compared to property " + propertyName, e);
        }
        if (propertyValue instanceof Boolean && propertyValue.equals(Boolean.valueOf(valueToCompare))) {
            return true;
        }
        return valueToCompare.equals(propertyValue.toString());
    }

    protected String[] buildArrayFromCommaList(String commaList) {
        String[] newArray = commaList.split(",");
        if (newArray.length == 0) {
            newArray = new String[]{commaList.trim()};
        }
        return newArray;
    }

    @Override
    public Boolean hasPropertyChangedThisVersion(SequenceOwner<?> currentVersion, String property) {
        Object previousPropertyValue;
        if (currentVersion == null || property == null) {
            return false;
        }
        SequenceOwner<?> previousVersion = this.getLastActiveVersion(currentVersion);
        Object currentPropertyValue = this.getPropertyValue(currentVersion, property);
        return !Objects.equals(currentPropertyValue, previousPropertyValue = this.getPropertyValue(previousVersion, property));
    }

    protected SequenceOwner<?> getLastActiveVersion(SequenceOwner<?> currentVersion) {
        SequenceOwner<? extends SequenceOwner<?>> highestActiveVersion = null;
        if (currentVersion.getVersionNameFieldValue() != null) {
            for (VersionHistory pastVersion : this.getVersionHistories(currentVersion, currentVersion.getVersionNameFieldValue())) {
                if (!this.isHighestActiveVersion(highestActiveVersion, pastVersion, currentVersion)) continue;
                highestActiveVersion = pastVersion.getSequenceOwner();
            }
        }
        return highestActiveVersion;
    }

    private boolean isHighestActiveVersion(SequenceOwner<?> highestActiveVersion, VersionHistory pastVersion, SequenceOwner<?> currentVersion) {
        return !Objects.equals(pastVersion.getSequenceOwnerSequenceNumber(), currentVersion.getSequenceNumber()) && this.isArchivedOrActive(pastVersion) && (highestActiveVersion == null || pastVersion.getSequenceOwnerSequenceNumber() > highestActiveVersion.getSequenceNumber());
    }

    @Override
    public Boolean doSponsorAndPrimeSponsorMatch(Sponsorable grantsBo) {
        return Objects.equals(grantsBo.getSponsorCode(), grantsBo.getPrimeSponsorCode());
    }

    protected String specialCharacterRule(String stringToCheck) {
        for (String element : restrictedElements) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)element, (CharSequence)stringToCheck)) continue;
            return FALSE;
        }
        return TRUE;
    }

    @Override
    public Boolean doesPrimeSponsorTypeMatch(Sponsorable documentBo, String primeSponsorType) {
        if (StringUtils.isEmpty((CharSequence)documentBo.getPrimeSponsorCode())) {
            return false;
        }
        Sponsor primeSponsor = (Sponsor)this.getBusinessObjectService().findBySinglePrimaryKey(Sponsor.class, (Object)documentBo.getPrimeSponsorCode());
        return Objects.equals(primeSponsor.getSponsorTypeCode(), primeSponsorType);
    }

    protected boolean specialReviewTypeCodeAndApprovalTypeCodeMatch(List<? extends SpecialReview<?>> specialReviews, String specialReviewTypeCode, String approvalTypeCode) {
        return specialReviews.stream().filter(specialReview -> specialReviewTypeCode.equals(specialReview.getSpecialReviewTypeCode())).allMatch(specialReview -> approvalTypeCode.equals(specialReview.getApprovalTypeCode()));
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }
}

