/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.print;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.Printable;
import org.kuali.coeus.common.framework.print.PrintableAttachment;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.common.framework.print.PrintingService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.xml.SafeXmlUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="printingService")
public class PrintingServiceImpl
implements PrintingService {
    private static final Logger LOG = LogManager.getLogger(PrintingServiceImpl.class);
    @Autowired
    @Qualifier(value="dateTimeService")
    private DateTimeService dateTimeService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService kualiConfigurationService;

    protected Map<String, byte[]> getPrintBytes(Printable printableArtifact) throws PrintingException {
        LinkedHashMap<String, byte[]> pdfByteMap = new LinkedHashMap<String, byte[]>();
        Map<String, XmlObject> streamMap = printableArtifact.renderXML();
        boolean loggingEnable = this.kualiConfigurationService.getPropertyValueAsBoolean("print.logging.enable");
        if (loggingEnable) {
            this.logPrintDetails(streamMap);
        }
        Set ignored = pdfByteMap.keySet();
        try {
            if (printableArtifact.getXSLTemplates() != null) {
                int xslCount = 0;
                for (Source source : printableArtifact.getXSLTemplates()) {
                    ++xslCount;
                    StreamSource xslt = (StreamSource)source;
                    if (xslt.getInputStream() == null || xslt.getInputStream().available() <= 0) {
                        LOG.error("Stylesheet is not available");
                        continue;
                    }
                    this.createPdfWithFOP(streamMap, pdfByteMap, xslCount, xslt);
                }
            } else if (printableArtifact.getXSLTemplateWithBookmarks() != null) {
                for (Map.Entry<String, Source> templatesWithBookmark : printableArtifact.getXSLTemplateWithBookmarks().entrySet()) {
                    if (ignored.contains(templatesWithBookmark.getKey())) continue;
                    StreamSource xslt = (StreamSource)templatesWithBookmark.getValue();
                    this.createPdfWithFOP(streamMap, pdfByteMap, 0, xslt, templatesWithBookmark.getKey());
                }
            }
        }
        catch (IOException | TransformerException | FOPException e) {
            LOG.error(e.getMessage(), e);
            throw new PrintingException(e.getMessage(), e);
        }
        return pdfByteMap;
    }

    protected void createPdfWithFOP(Map<String, XmlObject> streamMap, Map<String, byte[]> pdfByteMap, int xslCount, StreamSource xslt) throws FOPException, TransformerException {
        this.createPdfWithFOP(streamMap, pdfByteMap, xslCount, xslt, null);
    }

    protected void createPdfWithFOP(Map<String, XmlObject> streamMap, Map<String, byte[]> pdfByteMap, int xslCount, StreamSource xslt, String bookmark) throws FOPException, TransformerException {
        FopFactory fopFactory;
        try {
            fopFactory = FopFactory.newInstance((URI)new URI(this.getKualiConfigurationService().getPropertyValueAsString("application.url")));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        TransformerFactory factory = SafeXmlUtils.safeTransformerFactory();
        Transformer transformer = factory.newTransformer(xslt);
        String externalizableImagesUrl = this.getKualiConfigurationService().getPropertyValueAsString("kra.externalizable.images.url");
        transformer.setParameter("externalImagesUrl", externalizableImagesUrl);
        FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
        for (Map.Entry<String, XmlObject> xmlData : streamMap.entrySet()) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlData.getValue().xmlText().getBytes());
            StreamSource src = new StreamSource(inputStream);
            Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)outputStream);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
            byte[] pdfBytes = outputStream.toByteArray();
            if (pdfBytes == null || pdfBytes.length <= 0) continue;
            String pdfMapKey = bookmark == null ? this.createBookMark(xslCount, xmlData.getKey()) : bookmark;
            pdfByteMap.put(pdfMapKey, pdfBytes);
        }
    }

    protected String createBookMark(int xslCount, String bookmarkKey) {
        return bookmarkKey + (String)(xslCount == 1 ? "" : " " + xslCount);
    }

    @Override
    public AttachmentDataSource print(Printable printableArtifacts) throws PrintingException {
        ArrayList<Printable> printables = new ArrayList<Printable>();
        printables.add(printableArtifacts);
        return this.print(printables);
    }

    @Override
    public AttachmentDataSource print(List<Printable> printableArtifactList) throws PrintingException {
        ArrayList<String> bookmarksList = new ArrayList<String>();
        ArrayList<byte[]> pdfBaosList = new ArrayList<byte[]>();
        for (Printable printableArtifact : printableArtifactList) {
            Map<String, byte[]> printBytes = this.getPrintBytes(printableArtifact);
            if (printableArtifact.getAttachments() != null) {
                printBytes.putAll(printableArtifact.getAttachments());
            }
            for (Map.Entry<String, byte[]> entry : printBytes.entrySet()) {
                if (!this.isPdfGoodToMerge(entry.getValue())) continue;
                bookmarksList.add(entry.getKey());
                pdfBaosList.add(entry.getValue());
            }
        }
        PrintableAttachment printablePdf = new PrintableAttachment();
        byte[] mergedPdfBytes = this.mergePdfBytes(pdfBaosList, bookmarksList);
        if (mergedPdfBytes == null) {
            mergedPdfBytes = new byte[]{};
        }
        printablePdf.setData(mergedPdfBytes);
        StringBuilder fileName = new StringBuilder();
        fileName.append(this.getReportName());
        fileName.append(".pdf");
        printablePdf.setName(fileName.toString());
        printablePdf.setType("application/pdf");
        boolean loggingEnable = this.kualiConfigurationService.getPropertyValueAsBoolean("print.pdf.logging.enable");
        if (loggingEnable) {
            this.logPdfPrintDetails(printablePdf);
        }
        return printablePdf;
    }

    protected boolean isPdfGoodToMerge(byte[] pdfBytes) {
        try {
            new PdfReader(pdfBytes);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected String getReportName() {
        String dateString = this.getDateTimeService().getCurrentDate().toString();
        return StringUtils.deleteWhitespace((String)dateString);
    }

    protected byte[] mergePdfBytes(List<byte[]> pdfBytesList, List<String> bookmarksList) throws PrintingException {
        Document document = null;
        PdfWriter writer = null;
        ByteArrayOutputStream mergedPdfReport = new ByteArrayOutputStream();
        PdfReader[] pdfReaderArr = new PdfReader[pdfBytesList.size()];
        int pdfReaderCount = 0;
        for (byte[] fileBytes : pdfBytesList) {
            LOG.debug("File Size " + fileBytes.length + " For " + bookmarksList.get(pdfReaderCount));
            try {
                PdfReader reader;
                pdfReaderArr[pdfReaderCount] = reader = new PdfReader(fileBytes);
                ++pdfReaderCount;
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        for (int count = 0; count < pdfReaderArr.length; ++count) {
            PdfReader reader = pdfReaderArr[count];
            if (reader == null) {
                LOG.debug("Empty PDF byetes found for " + bookmarksList.get(count));
                continue;
            }
            int nop = reader.getNumberOfPages();
            if (count == 0) {
                document = nop > 0 ? new Document(reader.getPageSizeWithRotation(1)) : new Document();
                try {
                    writer = PdfWriter.getInstance((Document)document, (OutputStream)mergedPdfReport);
                }
                catch (DocumentException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    throw new PrintingException(e.getMessage(), e);
                }
                document.open();
            }
            PdfContentByte cb = writer.getDirectContent();
            int pageCount = 0;
            while (pageCount < nop) {
                document.setPageSize(reader.getPageSize(++pageCount));
                document.newPage();
                PdfImportedPage page = writer.getImportedPage(reader, pageCount);
                cb.addTemplate((PdfTemplate)page, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                PdfOutline root = cb.getRootOutline();
                if (pageCount != 1) continue;
                String pageName = bookmarksList.get(count);
                cb.addOutline(new PdfOutline(root, new PdfDestination(2), pageName), pageName);
            }
        }
        if (document != null) {
            try {
                document.close();
                return mergedPdfReport.toByteArray();
            }
            catch (Exception e) {
                LOG.error("Exception occurred because the generated PDF document has no pages", (Throwable)e);
            }
        }
        return null;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logPrintDetails(Map<String, XmlObject> xmlStreamMap) {
        String loggingDirectory = this.kualiConfigurationService.getPropertyValueAsString("print.logging.directory");
        Iterator<String> it = xmlStreamMap.keySet().iterator();
        if (loggingDirectory != null) {
            BufferedWriter out = null;
            try {
                while (it.hasNext()) {
                    String key = it.next();
                    XmlObject xmlBytes = xmlStreamMap.get(key);
                    String xmlString = xmlBytes.xmlText();
                    String dateString = this.getDateTimeService().getCurrentTimestamp().toString();
                    String reportName = StringUtils.deleteWhitespace((String)key);
                    String createdTime = StringUtils.replaceChars((String)StringUtils.deleteWhitespace((String)dateString), (String)":", (String)"_");
                    File dir = this.getLoggingDir(loggingDirectory);
                    File file = new File(dir, reportName + "_" + createdTime + ".xml");
                    out = new BufferedWriter(new FileWriter(file));
                    out.write(xmlString);
                }
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (out != null) {
                        out.flush();
                        out.close();
                    }
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void logPdfPrintDetails(AttachmentDataSource pdf) {
        String loggingDirectory = this.kualiConfigurationService.getPropertyValueAsString("print.logging.directory");
        if (loggingDirectory != null && pdf != null && pdf.getData() != null) {
            String dateString = new Timestamp(new Date().getTime()).toString();
            String createdTime = StringUtils.replaceChars((String)StringUtils.deleteWhitespace((String)dateString), (String)":", (String)"_");
            String fileName = StringUtils.replaceChars((String)StringUtils.deleteWhitespace((String)pdf.getName().replace(".pdf", "")), (String)":", (String)"_") + "_" + createdTime + ".pdf";
            try {
                FileUtils.writeByteArrayToFile((File)new File(this.getLoggingDir(loggingDirectory), fileName), (byte[])pdf.getData());
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected File getLoggingDir(String loggingDirectory) {
        File dir = new File(loggingDirectory);
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdirs();
        }
        return dir;
    }

    public void setKualiConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public ConfigurationService getKualiConfigurationService() {
        return this.kualiConfigurationService;
    }
}

