/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.unit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.coeus.common.impl.unit.UnitLookupDao;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component(value="unitService")
public class UnitServiceImpl
implements UnitService {
    private static final String GET_UNITS_CACHE_KEY = "{getUnits}";
    private static final String COLUMN = ":";
    private static final String SEPARATOR = ";1;";
    private static final String DASH = "$-$";
    private static final String UNIT_NUMBER = "unitNumber";
    public static final String ACTIVE = "active";
    public static final String ACTIVE_YES = "Y";
    public static final String DELIMITER = ",";
    public static final String UNIT_ADMINISTRATOR_TYPE_CODE = "unitAdministratorTypeCode";
    @Autowired
    @Qualifier(value="unitLookupDao")
    private UnitLookupDao unitLookupDao;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="kcCommonLocalCacheManager")
    private CacheManager cacheManager;

    @Override
    @Cacheable(value={"http://kc.kuali.org/core/v5_0/UnitType"}, key="'{getUnitCaseSensitive}' + 'id=' + #p0")
    public Unit getUnitCaseInsensitive(String unitNumber) {
        Unit unit = null;
        if (StringUtils.isNotEmpty((CharSequence)unitNumber)) {
            unit = this.getUnitLookupDao().findUnitbyNumberCaseInsensitive(unitNumber);
        }
        return unit;
    }

    @Override
    @Cacheable(value={"http://kc.kuali.org/core/v5_0/UnitType"}, key="'{getUnitName}' + 'id=' + #p0")
    public String getUnitName(String unitNumber) {
        Unit unit = this.getUnit(unitNumber);
        return unit != null ? unit.getUnitName() : null;
    }

    public List<Unit> getUnits() {
        Cache unitCache = this.cacheManager.getCache("http://kc.kuali.org/core/v5_0/UnitType");
        List cachedUnits = (List)unitCache.get((Object)GET_UNITS_CACHE_KEY, List.class);
        if (cachedUnits != null) {
            return cachedUnits;
        }
        ArrayList<Unit> units = new ArrayList<Unit>(this.getBusinessObjectService().findAllOrderBy(Unit.class, UNIT_NUMBER, true));
        unitCache.put((Object)GET_UNITS_CACHE_KEY, units);
        return units;
    }

    @Override
    @Cacheable(value={"http://kc.kuali.org/core/v5_0/UnitType"}, key="'id=' + #p0")
    public Unit getUnit(String unitNumber) {
        if (StringUtils.isNotEmpty((CharSequence)unitNumber)) {
            return this.getUnits().stream().filter(unit -> StringUtils.equals((CharSequence)unit.getUnitNumber(), (CharSequence)unitNumber)).findFirst().orElse(null);
        }
        return null;
    }

    @Override
    @Cacheable(value={"http://kc.kuali.org/core/v5_0/UnitType"}, key="'{getActiveUnit}' + 'id=' + #p0")
    public Unit getActiveUnit(String unitNumber) {
        if (StringUtils.isNotEmpty((CharSequence)unitNumber)) {
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put(UNIT_NUMBER, unitNumber);
            fields.put(ACTIVE, Boolean.TRUE);
            List units = this.getBusinessObjectService().findMatching(Unit.class, fields);
            return units.size() != 0 ? (Unit)units.get(0) : null;
        }
        return null;
    }

    @Override
    @Cacheable(value={"http://kc.kuali.org/core/v5_0/UnitType"}, key="'{getSubUnits}' + 'id=' + #p0")
    public List<Unit> getSubUnits(String unitNumber) {
        return this.getUnits().stream().filter(unit -> StringUtils.equals((CharSequence)unit.getParentUnitNumber(), (CharSequence)unitNumber)).collect(Collectors.toList());
    }

    @Override
    @Cacheable(value={"http://kc.kuali.org/core/v5_0/UnitType"}, key="'{getActiveSubUnits}' + 'id=' + #p0")
    public List<Unit> getActiveSubUnits(String unitNumber) {
        return this.getUnits().stream().filter(unit -> StringUtils.equals((CharSequence)unit.getParentUnitNumber(), (CharSequence)unitNumber) && unit.isActive()).collect(Collectors.toList());
    }

    @Override
    @Cacheable(value={"http://kc.kuali.org/core/v5_0/UnitType"}, key="'{getAllSubUnits}' + 'id=' + #p0")
    public List<Unit> getAllSubUnits(String unitNumber) {
        return this.findUnitsWithDirectParent((List<Unit>)this.getUnits(), unitNumber);
    }

    protected List<Unit> findUnitsWithDirectParent(List<Unit> units, String directParent) {
        if (CollectionUtils.isNotEmpty(units)) {
            List matched = ListUtils.select(units, input -> input.getParentUnitNumber() != null && input.getParentUnitNumber().equals(directParent));
            ArrayList<Unit> totalMatched = new ArrayList<Unit>(matched);
            for (Unit child : matched) {
                totalMatched.addAll(this.findUnitsWithDirectParent(units, child.getUnitNumber()));
            }
            return totalMatched;
        }
        return Collections.emptyList();
    }

    @Override
    @Cacheable(value={"http://kc.kuali.org/core/v5_0/UnitType"}, key="'{getUnitHierarchyForUnit}' + 'id=' + #p0")
    public List<Unit> getUnitHierarchyForUnit(String unitNumber) {
        return this.getParentUnitsInclusive((List<Unit>)this.getUnits(), unitNumber);
    }

    @Override
    @Cacheable(value={"http://kc.kuali.org/core/v5_0/UnitType"}, key="'{appliesToUnit}' + 'unit=' + #p0 + '|' + 'unitNumbers=' + #p1")
    public boolean appliesToUnit(String unit, String unitNumbers) {
        if (unitNumbers == null) {
            return Boolean.FALSE;
        }
        for (String environmentUnitNumber : unitNumbers.split(DELIMITER)) {
            List<Unit> unitHierarchyForUnit = this.getUnitHierarchyForUnit(environmentUnitNumber);
            if (!this.appliesToAnyUnitInHierarchy(unit, unitHierarchyForUnit)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean appliesToAnyUnitInHierarchy(String unitNumberToCheck, List<Unit> unitHierarchyForUnit) {
        for (Unit unit : unitHierarchyForUnit) {
            String unitNumber = unit.getUnitNumber();
            if (!unitNumber.equals(unitNumberToCheck)) continue;
            return true;
        }
        return false;
    }

    protected List<Unit> getParentUnitsInclusive(List<Unit> units, String unit) {
        if (StringUtils.isBlank((CharSequence)unit)) {
            return List.of();
        }
        if (CollectionUtils.isNotEmpty(units)) {
            ArrayList<Unit> parentUnits = new ArrayList<Unit>();
            for (Unit parentUnit = (Unit)units.stream().filter(match -> unit.equals(match.getUnitNumber())).findFirst().orElse(null); parentUnit != null; parentUnit = parentUnit.getParentUnit()) {
                parentUnits.add(parentUnit);
            }
            return parentUnits;
        }
        return List.of();
    }

    @Override
    public String getSubUnitsForTreeView(String unitNumber) {
        String subUnits = null;
        int startIdx = unitNumber.indexOf("px\">", unitNumber.indexOf("<tr>"));
        for (Unit unit : this.getSubUnits(unitNumber.substring(startIdx + 4, unitNumber.indexOf(COLUMN, startIdx) - 1))) {
            if (StringUtils.isNotBlank(subUnits)) {
                subUnits = subUnits + "#SEPARATOR#" + unit.getUnitNumber() + " : " + unit.getUnitName();
                continue;
            }
            subUnits = unit.getUnitNumber() + " : " + unit.getUnitName();
        }
        return subUnits;
    }

    @Override
    @Cacheable(value={"http://kc.kuali.org/core/v5_0/UnitType"}, key="'{getTopUnit}'")
    public Unit getTopUnit() {
        return this.getUnitLookupDao().getTopUnit();
    }

    @Override
    public String getInitialUnitsForUnitHierarchy() {
        return this.getInitialUnitsForUnitHierarchy(3);
    }

    @Override
    public String getInitialUnitsForUnitHierarchy(int depth) {
        List<Unit> sortedTruncatedUnits = this.sortUnits(this.truncate((List<Unit>)this.getUnits(), depth));
        return sortedTruncatedUnits.stream().map(unit -> (String)(StringUtils.isNotBlank((CharSequence)unit.getParentUnitNumber()) ? unit.getParentUnitNumber() + DASH : "") + unit.getUnitNumber() + " : " + unit.getUnitName()).collect(Collectors.joining(SEPARATOR));
    }

    protected List<Unit> sortUnits(List<Unit> units) {
        ArrayList<Unit> unsortedUnits = new ArrayList<Unit>(units);
        ArrayList<Unit> sortedUnits = new ArrayList<Unit>();
        LinkedList processQueue = new LinkedList();
        processQueue.addAll(unsortedUnits.stream().filter(unit -> StringUtils.isBlank((CharSequence)unit.getParentUnitNumber())).sorted(Comparator.comparing(Unit::getUnitNumber)).collect(Collectors.toList()));
        while (!processQueue.isEmpty()) {
            Unit toProcess = (Unit)processQueue.remove();
            unsortedUnits.remove(toProcess);
            sortedUnits.add(toProcess);
            processQueue.addAll(unsortedUnits.stream().filter(unit -> unit.getParentUnitNumber().equals(toProcess.getUnitNumber())).sorted(Comparator.comparing(Unit::getUnitNumber)).collect(Collectors.toList()));
        }
        return sortedUnits;
    }

    protected List<Unit> truncate(List<Unit> units, int depth) {
        ArrayList<Unit> unprocessed = new ArrayList<Unit>(units);
        ArrayList<Unit> processed = new ArrayList<Unit>();
        List<Unit> parents = unprocessed.stream().filter(unit -> StringUtils.isBlank((CharSequence)unit.getParentUnitNumber())).collect(Collectors.toList());
        this.processTruncate(unprocessed, processed, parents);
        for (int currentDepth = 1; currentDepth < depth && !unprocessed.isEmpty(); ++currentDepth) {
            List<Unit> currentParents = parents;
            parents = unprocessed.stream().filter(unit -> currentParents.stream().map(Unit::getUnitNumber).collect(Collectors.toList()).contains(unit.getParentUnitNumber())).collect(Collectors.toList());
            this.processTruncate(unprocessed, processed, parents);
        }
        return processed;
    }

    protected void processTruncate(List<Unit> unprocessedList, List<Unit> processedList, List<Unit> currentlyProcessing) {
        processedList.addAll(currentlyProcessing);
        unprocessedList.removeAll(currentlyProcessing);
    }

    @Override
    public List<UnitAdministrator> retrieveUnitAdministratorsByUnitNumber(String unitNumber) {
        return this.getBusinessObjectService().findMatching(UnitAdministrator.class, Collections.singletonMap(UNIT_NUMBER, unitNumber));
    }

    @Override
    public List<UnitAdministrator> retrieveUnitAdministratorsByUnitNumberAndType(String unitNumber, String typeCode) {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put(UNIT_NUMBER, unitNumber);
        fields.put(UNIT_ADMINISTRATOR_TYPE_CODE, typeCode);
        return this.getBusinessObjectService().findMatching(UnitAdministrator.class, fields);
    }

    @Override
    public int getMaxUnitTreeDepth() {
        return this.getBusinessObjectService().findAll(Unit.class).size();
    }

    public UnitLookupDao getUnitLookupDao() {
        return this.unitLookupDao;
    }

    public void setUnitLookupDao(UnitLookupDao unitLookupDao) {
        this.unitLookupDao = unitLookupDao;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

