/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.custom.attr.CustomAttribute;
import org.kuali.coeus.common.util.Wrapper;

public class CustomDataEntry {
    private Long customAttributeId;
    private String name;
    private String label;
    private String group;
    private Boolean allowsMultipleValues;
    private List<String> values;

    public Long getCustomAttributeId() {
        return this.customAttributeId;
    }

    public void setCustomAttributeId(Long customAttributeId) {
        this.customAttributeId = customAttributeId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Boolean getAllowsMultipleValues() {
        return this.allowsMultipleValues;
    }

    public void setAllowsMultipleValues(Boolean allowsMultipleValues) {
        this.allowsMultipleValues = allowsMultipleValues;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public static Map.Entry<Long, CustomDataEntry> createEntry(DocumentCustomData customData) {
        CustomAttribute customAttribute = customData.getCustomAttribute();
        CustomDataEntry customDataEntry = new CustomDataEntry();
        customDataEntry.setCustomAttributeId(customData.getCustomAttributeId());
        customDataEntry.setLabel(customAttribute.getLabel());
        customDataEntry.setName(customAttribute.getName());
        customDataEntry.setGroup(customAttribute.getGroupName());
        customDataEntry.setAllowsMultipleValues(customAttribute.getAllowsMultipleValues());
        if (customAttribute.getAllowsMultipleValues()) {
            customData.deserializeListValue();
            List<Wrapper<String>> deserializedListValue = customData.getDeserializedListValue();
            customDataEntry.setValues(deserializedListValue == null ? List.of() : deserializedListValue.stream().map(Wrapper::getValue).collect(Collectors.toList()));
        } else {
            customDataEntry.setValues(List.of(Optional.ofNullable(customData.getValue()).orElse("")));
        }
        return Map.entry(customDataEntry.getCustomAttributeId(), customDataEntry);
    }
}

