/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch.serializers;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetJustificationWrapper;
import org.kuali.coeus.common.framework.compliance.core.SpecialReview;
import org.kuali.coeus.elasticsearch.CentralAdminContactDocument;
import org.kuali.coeus.elasticsearch.GrantsSearchDocument;
import org.kuali.coeus.elasticsearch.NoteDocument;
import org.kuali.coeus.elasticsearch.NotificationDocument;
import org.kuali.coeus.elasticsearch.SpecialReviewDocument;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchDocumentSerializer;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchInstitutionalProposalSerializer;
import org.kuali.coeus.sys.framework.util.DateUtils;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardCfda;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.award.infrastructure.AwardPermissionConstants;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalBoLite;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ElasticsearchAwardSerializer
extends ElasticsearchDocumentSerializer {
    @Autowired
    @Qualifier(value="esInstitutionalProposalSerializer")
    private ElasticsearchInstitutionalProposalSerializer institutionalProposalSerializer;

    @Override
    public GrantsSearchDocument translateDocument(Object doc) {
        AwardDocument document = (AwardDocument)doc;
        Award award = document.getAward();
        GrantsSearchDocument esDoc = new GrantsSearchDocument();
        this.setGenericDocumentFields(esDoc, document);
        esDoc.setPrimaryKey(String.valueOf(award.getAwardId()));
        esDoc.setNamespace(document.getNamespace());
        esDoc.setAccountId(award.getAccountNumber());
        esDoc.setSequenceNumber(award.getSequenceNumber());
        esDoc.setSequenceStatus(award.getAwardSequenceStatus());
        esDoc.setTypeCode(String.valueOf(award.getAwardTypeCode()));
        award.refreshReferenceObject("awardType");
        esDoc.setTypeDescription(award.getAwardType().getDescription());
        esDoc.setStartDate(DateUtils.toUtc(award.getAwardEffectiveDate()));
        esDoc.setStatusCode(String.valueOf(award.getStatusCode()));
        esDoc.setActivityTypes(Set.of(award.getActivityType().getDescription()));
        esDoc.setStatusDescription(award.getStatusDescription());
        esDoc.setEndDate(DateUtils.toUtc(award.findLatestFinalExpirationDate()));
        if (award.getAwardExecutionDate() != null) {
            esDoc.addExecutionDate(DateUtils.toUtc(award.getAwardExecutionDate()));
        }
        esDoc.setSponsorNumber(award.getSponsorAwardNumber());
        esDoc.setTotalObligatedAmount(award.getObligatedTotal().doubleValue());
        esDoc.setNoticeDate(award.getNoticeDate());
        esDoc.setAwardTransactionTypeCode(award.getAwardTransactionTypeCode());
        esDoc.addCfdaNumber(award.getAwardCfdas().stream().map(AwardCfda::getCfdaNumber).collect(Collectors.toSet()));
        esDoc.setSpecialReviews(award.getSpecialReviews().stream().map(specialReview -> new SpecialReviewDocument(specialReview.getSpecialReviewType().getDescription(), this.getSpecialReviewApprovalType((SpecialReview)specialReview))).collect(Collectors.toList()));
        esDoc.setKeywords(award.getKeywords().stream().map(keyword -> keyword.getScienceKeyword().getDescription()).collect(Collectors.toSet()));
        esDoc.setCentralAdminContacts(award.getAwardCentralAdminContacts().stream().map(cac -> new CentralAdminContactDocument(cac.getFullName(), cac.getEmailAddress(), cac.getUnitAdministratorType().getDescription())).collect(Collectors.toList()));
        esDoc.setNotifications(award.getAwardNotifications().stream().map(n -> new NotificationDocument(n.getSubject(), n.getMessage())).collect(Collectors.toList()));
        esDoc.setComments(award.getAwardComments().stream().map(c -> c.getComments()).filter(StringUtils::isNotEmpty).collect(Collectors.toSet()));
        esDoc.setNotes(award.getAwardNotepads().stream().map(n -> new NoteDocument(n.getNoteTopic(), n.getComments())).collect(Collectors.toList()));
        esDoc.setBudgetJustifications(award.getBudgets().stream().map(b -> new BudgetJustificationWrapper(b.getBudgetJustification()).getJustificationText()).filter(StringUtils::isNotEmpty).collect(Collectors.toSet()));
        this.setSearchDocCustomDataIfEnabled(esDoc, award);
        this.setCommonFields(esDoc, award);
        return esDoc;
    }

    void setCommonFields(GrantsSearchDocument esDoc, Award award) {
        esDoc.setAwardNumber(award.getAwardNumber());
        esDoc.setTitle(award.getTitle());
        esDoc.setSponsorCode(award.getSponsorCode());
        esDoc.setSponsorName(award.getSponsorName());
        esDoc.setPrimeSponsorCode(award.getPrimeSponsorCode());
        esDoc.setPrimeSponsorName(award.getPrimeSponsorName());
        esDoc.setLeadUnitNumber(award.getLeadUnitNumber());
        esDoc.setLeadUnitName(award.getLeadUnitName());
        esDoc.setNsfSequenceNumber(award.getNsfSequenceNumber());
        this.setAwardPersonFields(esDoc, award);
        this.setIpAndPdSpecificFields(esDoc, award);
    }

    protected void setAwardPersonFields(GrantsSearchDocument esDoc, Award award) {
        Map<String, Long> personnelCriteria = Map.of("awardId", award.getAwardId());
        List projectPersons = this.businessObjectService.findMatching(AwardPerson.class, personnelCriteria);
        super.setPersonFields(esDoc, projectPersons);
        projectPersons.stream().filter(AwardPerson::isPrincipalInvestigator).findFirst().ifPresent(awardPerson -> {
            esDoc.setPrincipalInvestigatorId(awardPerson.getPersonId());
            esDoc.setPrincipalInvestigatorName(awardPerson.getLastName() + ", " + awardPerson.getFirstName());
        });
    }

    protected void setIpAndPdSpecificFields(GrantsSearchDocument esDoc, Award award) {
        Collection<String> fundingIPNumbers = this.getAwardFundingProposalNumbers(award);
        fundingIPNumbers.forEach(proposalNumber -> {
            esDoc.addProposalNumber((String)proposalNumber);
            esDoc.addInstitutionalProposalNumber((String)proposalNumber);
        });
        this.setPdSpecificFields(esDoc, this.institutionalProposalSerializer.getDevProposalsForIPs(fundingIPNumbers));
    }

    protected Collection<String> getAwardFundingProposalNumbers(Award award) {
        Collection fundingProposalIds;
        if (CollectionUtils.isNotEmpty(award.getAllFundingProposals()) && CollectionUtils.isNotEmpty((Collection)(fundingProposalIds = (Collection)award.getAllFundingProposals().stream().map(AwardFundingProposal::getProposalId).collect(Collectors.toSet())))) {
            return this.businessObjectService.findMatching(InstitutionalProposalBoLite.class, Map.of("proposalId", fundingProposalIds)).stream().map(InstitutionalProposalBoLite::getProposalNumber).collect(Collectors.toSet());
        }
        return Collections.emptyList();
    }

    @Override
    public String getNamespace() {
        return "KC-AWARD";
    }

    @Override
    public Set<String> getViewPermissions() {
        return Set.of(AwardPermissionConstants.VIEW_AWARD.getAwardPermission());
    }

    @Override
    public boolean supports(Object document) {
        return document instanceof AwardDocument;
    }
}

