/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch.serializers;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.compliance.core.SpecialReview;
import org.kuali.coeus.elasticsearch.GrantsSearchDocument;
import org.kuali.coeus.elasticsearch.NoteDocument;
import org.kuali.coeus.elasticsearch.NotificationDocument;
import org.kuali.coeus.elasticsearch.SpecialReviewDocument;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchDocumentSerializer;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.sys.framework.util.DateUtils;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonBoLite;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalBoLite;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalCfda;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kim.api.identity.PersonService;

public class ElasticsearchInstitutionalProposalSerializer
extends ElasticsearchDocumentSerializer {
    @Override
    public GrantsSearchDocument translateDocument(Object doc) {
        InstitutionalProposalDocument document = (InstitutionalProposalDocument)doc;
        InstitutionalProposal ip = document.getInstitutionalProposal();
        GrantsSearchDocument esDoc = new GrantsSearchDocument();
        this.setGenericDocumentFields(esDoc, document);
        esDoc.setPrimaryKey(String.valueOf(ip.getProposalId()));
        esDoc.setNamespace(document.getNamespace());
        esDoc.setSequenceNumber(ip.getSequenceNumber());
        esDoc.setSequenceStatus(ip.getProposalSequenceStatus());
        esDoc.setTypeCode(String.valueOf(ip.getProposalTypeCode()));
        esDoc.setTypeDescription(ip.getProposalType().getDescription());
        esDoc.setStatusCode(String.valueOf(ip.getStatusCode()));
        esDoc.setStatusDescription(ip.getProposalStatus().getDescription());
        esDoc.setActivityTypes(Set.of(ip.getActivityType().getDescription()));
        esDoc.setStartDate(DateUtils.toUtc(ip.getRequestedStartDateInitial()));
        esDoc.setEndDate(DateUtils.toUtc(ip.getRequestedEndDateInitial()));
        esDoc.setSponsorNumber(ip.getSponsorProposalNumber());
        esDoc.addCfdaNumber(ip.getProposalCfdas().stream().map(InstitutionalProposalCfda::getCfdaNumber).collect(Collectors.toSet()));
        esDoc.setSpecialReviews(ip.getSpecialReviews().stream().map(specialReview -> new SpecialReviewDocument(specialReview.getSpecialReviewType().getDescription(), this.getSpecialReviewApprovalType((SpecialReview)specialReview))).collect(Collectors.toList()));
        this.setSearchDocCustomDataIfEnabled(esDoc, ip);
        this.setCommonFields(esDoc, ip);
        return esDoc;
    }

    void setCommonFields(GrantsSearchDocument esDoc, InstitutionalProposal ip) {
        esDoc.addProposalNumber(ip.getProposalNumber());
        esDoc.addInstitutionalProposalNumber(ip.getProposalNumber());
        esDoc.setTitle(ip.getTitle());
        esDoc.setSponsorCode(ip.getSponsorCode());
        esDoc.setSponsorName(ip.getSponsorName());
        esDoc.setPrimeSponsorCode(ip.getPrimeSponsorCode());
        esDoc.setPrimeSponsorName(ip.getPrimeSponsorName());
        esDoc.setLeadUnitNumber(ip.getLeadUnitNumber());
        esDoc.setLeadUnitName(ip.getLeadUnitName());
        esDoc.setNsfSequenceNumber(ip.getNsfSequenceNumber());
        esDoc.setKeywords(ip.getKeywords().stream().map(keyword -> keyword.getScienceKeyword().getDescription()).collect(Collectors.toSet()));
        esDoc.setNotifications(ip.getInstitutionalProposalNotifications().stream().map(n -> new NotificationDocument(n.getSubject(), n.getMessage())).collect(Collectors.toList()));
        esDoc.setComments(ip.getProposalComments().stream().map(c -> c.getComments()).filter(StringUtils::isNotEmpty).collect(Collectors.toSet()));
        esDoc.setNotes(ip.getInstitutionalProposalNotepads().stream().map(n -> new NoteDocument(n.getNoteTopic(), n.getComments())).collect(Collectors.toList()));
        this.setInstitutionalProposalPersonFields(esDoc, ip);
        this.setPdSpecificFields(esDoc, this.getDevProposalsForIP(ip));
    }

    protected void setInstitutionalProposalPersonFields(GrantsSearchDocument esDoc, InstitutionalProposal ip) {
        Map<String, Long> personnelCriteria = Map.of("proposalId", ip.getProposalId());
        List projectPersons = this.businessObjectService.findMatching(InstitutionalProposalPersonBoLite.class, personnelCriteria);
        projectPersons.stream().filter(InstitutionalProposalPersonBoLite::isPrincipalInvestigator).findFirst().map(InstitutionalProposalPersonBoLite::getPersonId).map(arg_0 -> ((PersonService)this.personService).getPerson(arg_0)).ifPresent(person -> {
            esDoc.setPrincipalInvestigatorId(person.getPrincipalId());
            esDoc.setPrincipalInvestigatorName(person.getLastName() + ", " + person.getFirstName());
        });
        super.setPersonFields(esDoc, projectPersons);
    }

    protected Collection<DevelopmentProposal> getDevProposalsForIP(InstitutionalProposal ip) {
        return this.getDevProposalsForIPs(List.of(ip.getProposalNumber()));
    }

    protected Collection<DevelopmentProposal> getDevProposalsForIPs(Collection<String> ipProposalNumbers) {
        Set proposalIds;
        List proposalNumbers;
        if (CollectionUtils.isNotEmpty(ipProposalNumbers) && !(proposalNumbers = this.businessObjectService.findMatching(ProposalAdminDetails.class, Map.of("instProposalId", proposalIds = this.businessObjectService.findMatching(InstitutionalProposalBoLite.class, Map.of("proposalNumber", ipProposalNumbers)).stream().map(InstitutionalProposalBoLite::getProposalId).collect(Collectors.toSet()))).stream().map(ProposalAdminDetails::getDevProposalNumber).collect(Collectors.toList())).isEmpty()) {
            return this.dataObjectService.findMatching(DevelopmentProposal.class, QueryByCriteria.Builder.forAttribute((String)"proposalNumber", proposalNumbers).build()).getResults();
        }
        return Collections.emptyList();
    }

    @Override
    public String getNamespace() {
        return "KC-IP";
    }

    @Override
    public Set<String> getViewPermissions() {
        return Set.of("Open Institutional Proposal");
    }

    @Override
    public boolean supports(Object document) {
        return document instanceof InstitutionalProposalDocument;
    }
}

