/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.attachment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.OptionalInt;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.SystemAuthorizationService;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.propdev.impl.attachment.LegacyNarrativeService;
import org.kuali.coeus.propdev.impl.attachment.Narrative;
import org.kuali.coeus.propdev.impl.attachment.NarrativeAuthZService;
import org.kuali.coeus.propdev.impl.attachment.NarrativeRight;
import org.kuali.coeus.propdev.impl.attachment.NarrativeType;
import org.kuali.coeus.propdev.impl.attachment.NarrativeUserRights;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.person.ProposalPersonService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="legacyNarrativeService")
public class LegacyNarrativeServiceImpl
implements LegacyNarrativeService {
    public static final String NARRATIVE_TYPE = "narrativeType";
    public static final String NARRATIVE_STATUS = "narrativeStatus";
    @Autowired
    @Qualifier(value="narrativeAuthZService")
    private NarrativeAuthZService narrativeAuthZService;
    @Autowired
    @Qualifier(value="proposalPersonService")
    private ProposalPersonService proposalPersonService;
    @Autowired
    @Qualifier(value="systemAuthorizationService")
    private SystemAuthorizationService systemAuthorizationService;
    @Autowired
    @Qualifier(value="dateTimeService")
    private DateTimeService dateTimeService;
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;
    @Autowired
    @Qualifier(value="personService")
    private PersonService personService;
    @Autowired
    @Qualifier(value="kcAuthorizationService")
    private KcAuthorizationService kcAuthorizationService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;

    @Override
    public Integer getNextModuleNumber(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        List<Narrative> mergedNarrativeList = proposalDevelopmentDocument.getDevelopmentProposal().getMergedNarrativeList();
        if (mergedNarrativeList.isEmpty()) {
            return 1;
        }
        Collections.sort(mergedNarrativeList, new Comparator<Narrative>(){

            @Override
            public int compare(Narrative n1, Narrative n2) {
                return n1.getModuleNumber().compareTo(n2.getModuleNumber());
            }
        });
        return mergedNarrativeList.get(mergedNarrativeList.size() - 1).getModuleNumber() + 1;
    }

    @Override
    public Integer getNextModuleSequenceNumber(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        OptionalInt maxModuleSequenceNumber = proposalDevelopmentDocument.getDevelopmentProposal().getMergedNarrativesMaxModuleSequenceNumber();
        return maxModuleSequenceNumber.isPresent() ? maxModuleSequenceNumber.getAsInt() + 1 : 1;
    }

    protected void populateNarrativeUserRights(ProposalDevelopmentDocument proposalDevelopmentDocument, Narrative narrative) {
        List<KcPerson> persons = this.getPersons(proposalDevelopmentDocument);
        List<NarrativeUserRights> narrativeUserRights = narrative.getNarrativeUserRights();
        for (KcPerson person : persons) {
            if (this.isPersonInNarrativeRights(person, narrativeUserRights)) continue;
            NarrativeRight narrativeRight = this.getNarrativeAuthZService().getDefaultNarrativeRight(person.getPersonId(), proposalDevelopmentDocument);
            String personName = person.getFullName();
            NarrativeUserRights narrUserRight = new NarrativeUserRights();
            narrUserRight.setProposalNumber(narrative.getProposalNumber());
            narrUserRight.setModuleNumber(narrative.getModuleNumber());
            narrUserRight.setUserId(person.getPersonId());
            narrUserRight.setAccessType(narrativeRight.getAccessType());
            narrUserRight.setPersonName(personName);
            this.updateUserTimestamp(narrUserRight);
            narrativeUserRights.add(narrUserRight);
        }
    }

    protected boolean isPersonInNarrativeRights(KcPerson person, List<NarrativeUserRights> narrativeUserRights) {
        for (NarrativeUserRights right : narrativeUserRights) {
            if (!StringUtils.equals((CharSequence)right.getUserId(), (CharSequence)person.getPersonId())) continue;
            return true;
        }
        return false;
    }

    protected List<KcPerson> getPersons(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        List<Role> proposalRoles = this.getSystemAuthorizationService().getRoles("KC-PD");
        KcAuthorizationService kcAuthorizationService = this.getKcAuthorizationService();
        ArrayList<KcPerson> allPersons = new ArrayList<KcPerson>();
        for (Role proposalRole : proposalRoles) {
            List<String> users = kcAuthorizationService.getPrincipalsInRole(proposalRole.getName(), proposalDevelopmentDocument);
            ArrayList<KcPerson> persons = new ArrayList<KcPerson>();
            for (String userId : users) {
                KcPerson person = this.getKcPersonService().getKcPersonByPersonId(userId);
                if (person == null || !person.getActive().booleanValue()) continue;
                persons.add(person);
            }
            for (KcPerson person : persons) {
                if (this.isPersonInList(person, allPersons)) continue;
                allPersons.add(person);
            }
        }
        return allPersons;
    }

    protected boolean isPersonInList(KcPerson person, List<KcPerson> persons) {
        for (KcPerson p : persons) {
            if (!StringUtils.equals((CharSequence)p.getPersonId(), (CharSequence)person.getPersonId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void prepareNarrative(ProposalDevelopmentDocument document, Narrative narrative) {
        narrative.setDevelopmentProposal(document.getDevelopmentProposal());
        narrative.setModuleNumber(this.getNextModuleNumber(document));
        narrative.setModuleSequenceNumber(this.getNextModuleSequenceNumber(document));
        narrative.setUpdateUser(this.globalVariableService.getUserSession().getPrincipalName());
        narrative.setUpdateTimestamp(this.getDateTimeService().getCurrentTimestamp());
        OptionalInt minModuleSequenceNumber = document.getDevelopmentProposal().getNarrativesMinModuleSequenceNumber();
        OptionalInt maxModuleSequenceNumber = document.getDevelopmentProposal().getNarrativesMaxModuleSequenceNumber();
        narrative.setMoveUpAllowed(maxModuleSequenceNumber.isPresent() && narrative.getModuleSequenceNumber() < maxModuleSequenceNumber.getAsInt());
        narrative.setMoveDownAllowed(minModuleSequenceNumber.isPresent() && narrative.getModuleSequenceNumber() > minModuleSequenceNumber.getAsInt());
        this.getDataObjectService().wrap((Object)narrative).fetchRelationship(NARRATIVE_TYPE);
        this.getDataObjectService().wrap((Object)narrative).fetchRelationship(NARRATIVE_STATUS);
        this.populateNarrativeUserRights(document, narrative);
    }

    @Override
    public boolean doesProposalHaveNarrativeType(DevelopmentProposal proposal, NarrativeType narrativeType) {
        for (Narrative narrative : proposal.getNarratives()) {
            if (!StringUtils.equals((CharSequence)narrative.getNarrativeType().getCode(), (CharSequence)narrativeType.getCode())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void populatePersonNameForNarrativeUserRights(ProposalDevelopmentDocument proposaldevelopmentDocument, Narrative narrative) {
        List<NarrativeUserRights> narrativeUserRights = narrative.getNarrativeUserRights();
        for (NarrativeUserRights narrativeUserRight : narrativeUserRights) {
            String personName = this.getProposalPersonService().getPersonName(proposaldevelopmentDocument, narrativeUserRight.getUserId());
            narrativeUserRight.setPersonName(personName);
        }
    }

    @Override
    public void populateNarrativeRightsForLoggedinUser(ProposalDevelopmentDocument proposaldevelopmentDocument) {
        List<Narrative> narrativeList = proposaldevelopmentDocument.getDevelopmentProposal().getNarratives();
        for (Narrative narrative : narrativeList) {
            this.populateNarrativeUserRights(proposaldevelopmentDocument, narrative);
        }
        List<Narrative> instituteAttachmentList = proposaldevelopmentDocument.getDevelopmentProposal().getInstituteAttachments();
        for (Narrative instituteAttachment : instituteAttachmentList) {
            this.populateNarrativeUserRights(proposaldevelopmentDocument, instituteAttachment);
        }
    }

    protected void updateUserTimestamp(KcPersistableBusinessObjectBase bo) {
        bo.setUpdateUser(this.globalVariableService.getUserSession().getPrincipalName());
        bo.setUpdateTimestamp(this.getDateTimeService().getCurrentTimestamp());
    }

    @Override
    public void deletePerson(String userId, ProposalDevelopmentDocument proposalDevelopmentDocument) {
        List<Narrative> narratives = proposalDevelopmentDocument.getDevelopmentProposal().getNarratives();
        block0: for (Narrative narrative : narratives) {
            List<NarrativeUserRights> userRights = narrative.getNarrativeUserRights();
            for (NarrativeUserRights right : userRights) {
                if (!StringUtils.equals((CharSequence)right.getUserId(), (CharSequence)userId)) continue;
                userRights.remove(right);
                continue block0;
            }
        }
    }

    @Override
    public void readjustRights(String userId, ProposalDevelopmentDocument proposalDevelopmentDocument, List<String> roleNames) {
        List<Narrative> narratives = proposalDevelopmentDocument.getDevelopmentProposal().getNarratives();
        block0: for (Narrative narrative : narratives) {
            List<NarrativeUserRights> userRights = narrative.getNarrativeUserRights();
            for (NarrativeUserRights right : userRights) {
                String accessType;
                NarrativeRight narrativeRight;
                if (!StringUtils.equals((CharSequence)right.getUserId(), (CharSequence)userId)) continue;
                String currentAccessType = right.getAccessType();
                if (StringUtils.equals((CharSequence)currentAccessType, (CharSequence)NarrativeRight.MODIFY_NARRATIVE_RIGHT.getAccessType())) {
                    narrativeRight = this.getNarrativeAuthZService().getDefaultNarrativeRight(userId, proposalDevelopmentDocument);
                    accessType = narrativeRight.getAccessType();
                    if (StringUtils.equals((CharSequence)accessType, (CharSequence)NarrativeRight.VIEW_NARRATIVE_RIGHT.getAccessType())) {
                        right.setAccessType(NarrativeRight.VIEW_NARRATIVE_RIGHT.getAccessType());
                        continue block0;
                    }
                    if (!StringUtils.equals((CharSequence)accessType, (CharSequence)NarrativeRight.NO_NARRATIVE_RIGHT.getAccessType())) continue block0;
                    right.setAccessType(NarrativeRight.NO_NARRATIVE_RIGHT.getAccessType());
                    continue block0;
                }
                if (!StringUtils.equals((CharSequence)currentAccessType, (CharSequence)NarrativeRight.VIEW_NARRATIVE_RIGHT.getAccessType()) || !StringUtils.equals((CharSequence)(accessType = (narrativeRight = this.getNarrativeAuthZService().getDefaultNarrativeRight(userId, proposalDevelopmentDocument)).getAccessType()), (CharSequence)NarrativeRight.NO_NARRATIVE_RIGHT.getAccessType())) continue block0;
                right.setAccessType(NarrativeRight.NO_NARRATIVE_RIGHT.getAccessType());
                continue block0;
            }
        }
    }

    @Override
    public void addPerson(String userName, ProposalDevelopmentDocument proposalDevelopmentDocument, List<String> roleNames) {
        KcPerson person = this.getKcPersonService().getKcPersonByUserName(userName);
        List<Narrative> narratives = proposalDevelopmentDocument.getDevelopmentProposal().getNarratives();
        for (Narrative narrative : narratives) {
            List<NarrativeUserRights> userRights = narrative.getNarrativeUserRights();
            for (String roleName : roleNames) {
                NarrativeRight narrativeRight = this.getNarrativeAuthZService().getDefaultNarrativeRight(roleName);
                NarrativeUserRights narrUserRight = new NarrativeUserRights();
                narrUserRight.setProposalNumber(narrative.getProposalNumber());
                narrUserRight.setModuleNumber(narrative.getModuleNumber());
                narrUserRight.setUserId(person.getPersonId());
                narrUserRight.setAccessType(narrativeRight.getAccessType());
                narrUserRight.setPersonName(person.getFullName());
                this.updateUserTimestamp(narrUserRight);
                userRights.add(narrUserRight);
            }
        }
    }

    protected KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    protected KcAuthorizationService getKcAuthorizationService() {
        return this.kcAuthorizationService;
    }

    public void setKcAuthorizationService(KcAuthorizationService kcAuthorizationService) {
        this.kcAuthorizationService = kcAuthorizationService;
    }

    protected SystemAuthorizationService getSystemAuthorizationService() {
        return this.systemAuthorizationService;
    }

    public void setSystemAuthorizationService(SystemAuthorizationService systemAuthorizationService) {
        this.systemAuthorizationService = systemAuthorizationService;
    }

    protected PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public NarrativeAuthZService getNarrativeAuthZService() {
        return this.narrativeAuthZService;
    }

    public void setNarrativeAuthZService(NarrativeAuthZService narrativeAuthZService) {
        this.narrativeAuthZService = narrativeAuthZService;
    }

    public ProposalPersonService getProposalPersonService() {
        return this.proposalPersonService;
    }

    public void setProposalPersonService(ProposalPersonService proposalPersonService) {
        this.proposalPersonService = proposalPersonService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

