/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.calculator.BudgetCalculationService;
import org.kuali.coeus.common.budget.framework.core.Account;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.core.BudgetParentDocument;
import org.kuali.coeus.common.budget.framework.distribution.BudgetCostShare;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonService;
import org.kuali.coeus.common.budget.framework.summary.BudgetSummaryService;
import org.kuali.coeus.common.budget.impl.core.AbstractBudgetService;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRulesEngine;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.propdev.impl.budget.ProposalBudgetService;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.core.ProposalAddBudgetVersionEvent;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModularService;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardAttachment;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardFiles;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardPeriodDetail;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwards;
import org.kuali.coeus.propdev.impl.budget.subaward.PropDevBudgetSubAwardService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.kra.bo.DocumentNextvalue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.data.CopyOption;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="proposalBudgetService")
public class ProposalBudgetServiceImpl
extends AbstractBudgetService<DevelopmentProposal>
implements ProposalBudgetService {
    public static final String MODULAR_BUDGET_FLAG = "modularBudgetFlag";
    public static final String ADD_BUDGET_DTO = "addBudgetDto";
    public static final String COST_ELEMENT_BO = "costElementBO";
    public static final String BUDGET_CATEGORY = "budgetCategory";
    public static final String UNIT = "unit";
    private static final String COST_SHARE_TYPE = "costShareType";
    public static final String CODE = "code";
    public static final String ACCOUNT_NUMBER = "accountNumber";
    public static final String UNIT_NUMBER = "unitNumber";
    public static final String SOURCE_ACCOUNT = "sourceAccount";
    public static final String FISCAL_YEAR = "fiscalYear";
    public static final String ERROR = "E";
    @Autowired
    @Qualifier(value="budgetCalculationService")
    private BudgetCalculationService budgetCalculationService;
    @Autowired
    @Qualifier(value="propDevBudgetSubAwardService")
    private PropDevBudgetSubAwardService propDevBudgetSubAwardService;
    @Autowired
    @Qualifier(value="budgetPersonService")
    private BudgetPersonService budgetPersonService;
    @Autowired
    @Qualifier(value="budgetModularService")
    private BudgetModularService budgetModularService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="kcBusinessRulesEngine")
    private KcBusinessRulesEngine kcBusinessRulesEngine;
    @Autowired
    @Qualifier(value="budgetSummaryService")
    private BudgetSummaryService budgetSummaryService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="unitService")
    private UnitService unitService;

    public ProposalDevelopmentBudgetExt getNewBudgetVersion(BudgetParentDocument<DevelopmentProposal> parentDocument, String budgetName, Map<String, Object> options) {
        List<ProposalDevelopmentBudgetExt> budgets;
        Integer budgetVersionNumber = parentDocument.getNextBudgetVersionNumber();
        DevelopmentProposal budgetParent = parentDocument.getBudgetParent();
        ProposalDevelopmentBudgetExt budget = new ProposalDevelopmentBudgetExt();
        budget.setDevelopmentProposal(budgetParent);
        budget.setBudgetVersionNumber(budgetVersionNumber);
        budget.setName(budgetName);
        budget.setStartDate(budgetParent.getRequestedStartDateInitial());
        budget.setEndDate(budgetParent.getRequestedEndDateInitial());
        budget.setCreateTimestamp(new Timestamp(System.currentTimeMillis()));
        budget.setCreateUser(this.getGlobalVariableService().getUserSession().getLoggedInUserPrincipalName());
        budget.setOhRateTypeCode(this.getParameterService().getParameterValueAsString(Budget.class, "defaultOverheadRateTypeCode"));
        budget.setOhRateClassCode(this.getParameterService().getParameterValueAsString(Budget.class, "defaultOverheadRateClassCode"));
        budget.setUrRateClassCode(this.getParameterService().getParameterValueAsString(Budget.class, "defaultUnderrecoveryRateClassCode"));
        budget.setBudgetStatus(this.getParameterService().getParameterValueAsString(Budget.class, budgetParent.getDefaultBudgetStatusParameter()));
        if (options != null && options.containsKey(MODULAR_BUDGET_FLAG)) {
            budget.setModularBudgetFlag((Boolean)options.get(MODULAR_BUDGET_FLAG));
        } else {
            budget.setModularBudgetFlag(this.getParameterService().getParameterValueAsBoolean(Budget.class, "defaultModularFlag"));
        }
        budget.setExcludeSubconFAFromDirectCostSync(budget.getModularBudgetFlag());
        boolean success = this.isBudgetVersionNameValid(budgetParent, budgetName);
        if (!success) {
            return null;
        }
        budget.setRateClassTypesReloaded(true);
        budget.getRateClassTypes();
        this.getBudgetPersonService().synchBudgetPersonsToProposal(budget);
        if (budget.getStartDate() != null) {
            budget.setBudgetPeriods(this.getBudgetSummaryService().generateBudgetPeriods(budget));
        }
        if ((budget = this.saveBudget(budget)).getModularBudgetFlag().booleanValue()) {
            for (BudgetPeriod period : budget.getBudgetPeriods()) {
                this.getBudgetModularService().generateModularPeriod(period);
            }
            budget = this.saveBudget(budget);
        }
        if ((budgets = budgetParent.getBudgets()) == null) {
            budgets = new ArrayList<ProposalDevelopmentBudgetExt>();
            budgetParent.setBudgets(budgets);
        }
        budgets.add(budget);
        return budget;
    }

    @Override
    public boolean isBudgetVersionNameValid(BudgetParent parent, String name) {
        return this.getKcBusinessRulesEngine().applyRules(new ProposalAddBudgetVersionEvent(ADD_BUDGET_DTO, parent, name));
    }

    @Override
    public ProposalDevelopmentBudgetExt getFinalBudgetVersion(ProposalDevelopmentDocument parentDocument) {
        ProposalDevelopmentBudgetExt finalBudget = parentDocument.getDevelopmentProposal().getFinalBudget();
        if (finalBudget == null) {
            return parentDocument.getDevelopmentProposal().getBudgets().stream().sorted((b1, b2) -> ObjectUtils.compare((Comparable)b1.getBudgetVersionNumber(), (Comparable)b2.getBudgetVersionNumber()) * -1).findFirst().orElse(null);
        }
        return finalBudget;
    }

    @Override
    public boolean isRateOverridden(BudgetPeriod budgetPeriod) {
        return false;
    }

    protected ProposalDevelopmentBudgetExt saveBudget(ProposalDevelopmentBudgetExt budget) {
        return (ProposalDevelopmentBudgetExt)this.getDataObjectService().save((Object)budget, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    @Override
    public Budget copyBudgetVersion(Budget budget) {
        return this.copyBudgetVersion(budget, false);
    }

    @Override
    public void recalculateBudget(Budget budget) {
        this.budgetCalculationService.calculateBudget(budget);
    }

    @Override
    public void calculateBudgetOnSave(Budget budget) {
        for (BudgetSubAwards subAward : budget.getBudgetSubAwards()) {
            this.getPropDevBudgetSubAwardService().generateSubAwardLineItems(subAward, (ProposalDevelopmentBudgetExt)budget);
        }
        this.recalculateBudget(budget);
    }

    @Override
    public Budget copyBudgetVersion(Budget budget, boolean onlyOnePeriod) {
        return this.copyBudgetVersion((ProposalDevelopmentBudgetExt)budget, onlyOnePeriod, null, true);
    }

    @Override
    public ProposalDevelopmentBudgetExt copyBudgetVersion(ProposalDevelopmentBudgetExt budget, boolean onlyOnePeriod, DevelopmentProposal developmentProposal, Boolean saveAfterCopy) {
        ProposalDevelopmentBudgetExt newBudget = this.copyBudgetVersionInternal(budget, developmentProposal);
        if (onlyOnePeriod) {
            List<BudgetPeriod> oldBudgetPeriods = newBudget.getBudgetPeriods();
            for (int i = 1; i < oldBudgetPeriods.size(); ++i) {
                BudgetPeriod period = oldBudgetPeriods.get(i);
                period.getBudgetLineItems().clear();
                period.setCostSharingAmount(ScaleTwoDecimal.ZERO);
                period.setExpenseTotal(ScaleTwoDecimal.ZERO);
                period.setTotalCost(ScaleTwoDecimal.ZERO);
                period.setTotalCostLimit(ScaleTwoDecimal.ZERO);
                period.setTotalDirectCost(ScaleTwoDecimal.ZERO);
                period.setTotalDirectCostLessSubcontractorFA(ScaleTwoDecimal.ZERO);
                period.setDirectCostLimit(ScaleTwoDecimal.ZERO);
                period.setTotalIndirectCost(ScaleTwoDecimal.ZERO);
                period.setUnderrecoveryAmount(ScaleTwoDecimal.ZERO);
            }
            if (newBudget.getBudgetSubAwards() != null && newBudget.getBudgetSubAwards().size() > 0) {
                for (BudgetSubAwards budgetSubAwards : newBudget.getBudgetSubAwards()) {
                    List<BudgetSubAwardPeriodDetail> budetSubawardPeriodDetail = budgetSubAwards.getBudgetSubAwardPeriodDetails();
                    for (int i = 1; i < budetSubawardPeriodDetail.size(); ++i) {
                        BudgetSubAwardPeriodDetail period = budetSubawardPeriodDetail.get(i);
                        period.setAmountsModified(true);
                        period.setCostShare(ScaleTwoDecimal.ZERO);
                        period.setDirectCost(ScaleTwoDecimal.ZERO);
                        period.setIndirectCost(ScaleTwoDecimal.ZERO);
                        period.setTotalCost(ScaleTwoDecimal.ZERO);
                    }
                }
            }
        }
        newBudget.setBudgetVersionNumber(newBudget.getBudgetParent().getNextBudgetVersionNumber());
        this.copyLineItemToPersonnelDetails(newBudget);
        this.syncBudgetReferencesForCopy(newBudget);
        if (saveAfterCopy.booleanValue()) {
            newBudget = this.saveBudget(newBudget);
            this.syncBudgetReferencesForCopy(newBudget);
        }
        return newBudget;
    }

    @Override
    public void syncBudgetReferencesForCopy(ProposalDevelopmentBudgetExt budget) {
        Stream.concat(budget.getBudgetRates() != null ? budget.getBudgetRates().stream() : Stream.empty(), budget.getBudgetLaRates() != null ? budget.getBudgetLaRates().stream() : Stream.empty()).forEach(rate -> {
            rate.setBudgetId(budget.getBudgetId());
            rate.setBudget(budget);
        });
        if (budget.getBudgetProjectIncomes() != null) {
            budget.getBudgetProjectIncomes().forEach(income -> {
                income.setBudgetId(budget.getBudgetId());
                income.setBudgetPeriodId(income.getBudgetPeriod() != null ? income.getBudgetPeriod().getBudgetPeriodId() : null);
            });
        }
        if (budget.getBudgetCostShares() != null) {
            budget.getBudgetCostShares().forEach(costShare -> {
                costShare.setBudgetId(budget.getBudgetId());
                costShare.setBudget(budget);
            });
        }
        if (budget.getBudgetUnrecoveredFandAs() != null) {
            budget.getBudgetUnrecoveredFandAs().forEach(fAndA -> {
                fAndA.setBudgetId(budget.getBudgetId());
                fAndA.setBudget(budget);
            });
        }
        if (budget.getBudgetPersons() != null) {
            budget.getBudgetPersons().forEach(person -> {
                person.setBudgetId(budget.getBudgetId());
                person.setBudget(budget);
                if (person.getBudgetPersonSalaryDetails() != null) {
                    person.getBudgetPersonSalaryDetails().forEach(details -> details.setBudgetId(budget.getBudgetId()));
                }
            });
        }
        if (budget.getBudgetSubAwards() != null) {
            budget.getBudgetSubAwards().forEach(subaward -> {
                subaward.setBudgetId(budget.getBudgetId());
                subaward.setBudget(budget);
            });
        }
        if (budget.getBudgetPeriods() != null) {
            budget.getBudgetPeriods().forEach(period -> {
                if (period.getBudgetLineItems() != null) {
                    period.getBudgetLineItems().forEach(lineItem -> {
                        lineItem.setBudgetId(budget.getBudgetId());
                        lineItem.setBudget(budget);
                        lineItem.setBudgetPeriodId(period.getBudgetPeriodId());
                        lineItem.setBudgetPeriodBO((BudgetPeriod)period);
                        if (lineItem.getBudgetLineItemCalculatedAmounts() != null) {
                            lineItem.getBudgetLineItemCalculatedAmounts().forEach(calcAmount -> {
                                calcAmount.setBudgetId(budget.getBudgetId());
                                calcAmount.setBudgetPeriodId(period.getBudgetPeriodId());
                            });
                        }
                        if (lineItem.getBudgetPersonnelDetailsList() != null) {
                            lineItem.getBudgetPersonnelDetailsList().forEach(details -> {
                                details.setBudgetId(budget.getBudgetId());
                                details.setBudget(budget);
                                details.setBudgetPeriodId(period.getBudgetPeriodId());
                                details.setBudgetPeriodBO((BudgetPeriod)period);
                                if (details.getBudgetCalculatedAmounts() != null) {
                                    details.getBudgetCalculatedAmounts().forEach(amount -> {
                                        amount.setBudgetId(budget.getBudgetId());
                                        amount.setBudgetPeriodId(period.getBudgetPeriodId());
                                    });
                                }
                                if (details.getBudgetPersonnelRateAndBaseList() != null) {
                                    details.getBudgetPersonnelRateAndBaseList().forEach(amount -> {
                                        amount.setBudgetId(budget.getBudgetId());
                                        amount.setBudgetPeriodId(period.getBudgetPeriodId());
                                    });
                                }
                                if (budget.getBudgetPersons() != null) {
                                    budget.getBudgetPersons().stream().filter(person -> person.getPersonSequenceNumber().equals(details.getPersonSequenceNumber())).findFirst().ifPresent(details::setBudgetPerson);
                                }
                            });
                        }
                        if (lineItem.getBudgetRateAndBaseList() != null) {
                            lineItem.getBudgetRateAndBaseList().stream().forEach(rateAndBase -> {
                                rateAndBase.setBudgetId(budget.getBudgetId());
                                rateAndBase.setBudgetPeriodId(period.getBudgetPeriodId());
                            });
                        }
                        if (period.getBudgetModular() != null) {
                            period.getBudgetModular().setBudgetId(budget.getBudgetId());
                            period.getBudgetModular().setBudgetPeriodId(period.getBudgetPeriodId());
                            period.getBudgetModular().setBudgetPeriodObj((BudgetPeriod)period);
                            if (period.getBudgetModular().getBudgetModularIdcs() != null) {
                                period.getBudgetModular().getBudgetModularIdcs().forEach(idc -> idc.setBudgetId(budget.getBudgetId()));
                            }
                        }
                    });
                }
            });
        }
    }

    protected ProposalDevelopmentBudgetExt copyBudgetVersionInternal(ProposalDevelopmentBudgetExt budget, DevelopmentProposal developmentProposal) {
        for (BudgetSubAwards subAwards : budget.getBudgetSubAwards()) {
            subAwards.getSubAwardXmlFileData();
            for (BudgetSubAwardAttachment origAttachment : subAwards.getBudgetSubAwardAttachments()) {
                origAttachment.getData();
            }
            for (BudgetSubAwardFiles files : subAwards.getBudgetSubAwardFiles()) {
                files.getSubAwardXfdFileData();
                files.getSubAwardXmlFileData();
            }
        }
        DevelopmentProposal parent = budget.getDevelopmentProposal();
        budget.setDevelopmentProposal(null);
        ProposalDevelopmentBudgetExt doServiceCopy = (ProposalDevelopmentBudgetExt)this.getDataObjectService().copyInstance((Object)budget, new CopyOption[]{CopyOption.RESET_OBJECT_ID, CopyOption.RESET_PK_FIELDS, CopyOption.RESET_VERSION_NUMBER});
        if (StringUtils.isBlank((CharSequence)doServiceCopy.getObjectId())) {
            doServiceCopy.setObjectId(UUID.randomUUID().toString());
        }
        budget.setDevelopmentProposal(parent);
        if (developmentProposal != null) {
            doServiceCopy.setDevelopmentProposal(developmentProposal);
        } else {
            doServiceCopy.setDevelopmentProposal(parent);
        }
        List<DocumentNextvalue> nextValues = budget.getNextValues().stream().map(orig -> {
            DocumentNextvalue copy = new DocumentNextvalue();
            copy.setPropertyName(orig.getPropertyName());
            copy.setDocumentKey(doServiceCopy.getObjectId());
            copy.setNextValue(orig.getNextValue());
            return copy;
        }).collect(Collectors.toList());
        doServiceCopy.setNextValues(nextValues);
        return doServiceCopy;
    }

    @Override
    public boolean validateAddingNewBudget(BudgetParentDocument<DevelopmentProposal> parentDocument) {
        return true;
    }

    @Override
    public void recalculateBudgetPeriod(Budget budget, BudgetPeriod budgetPeriod) {
        this.budgetCalculationService.calculateBudget(budget);
    }

    @Override
    public boolean isBudgetMarkedForSubmission(Budget finalBudget, Budget currentBudget) {
        boolean budgetMarkedForSubmission = false;
        if (finalBudget != null && finalBudget.getBudgetId().equals(currentBudget.getBudgetId())) {
            budgetMarkedForSubmission = true;
        }
        return budgetMarkedForSubmission;
    }

    @Override
    public void populateNewBudgetLineItem(BudgetLineItem newBudgetLineItem, BudgetPeriod budgetPeriod) {
        List<String> formulatedCostElements;
        Budget budget = budgetPeriod.getBudget();
        newBudgetLineItem.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
        newBudgetLineItem.setBudgetPeriodBO(budgetPeriod);
        newBudgetLineItem.setBudgetPeriodId(budgetPeriod.getBudgetPeriodId());
        newBudgetLineItem.setStartDate(budgetPeriod.getStartDate());
        newBudgetLineItem.setEndDate(budgetPeriod.getEndDate());
        newBudgetLineItem.setBudgetId(budget.getBudgetId());
        newBudgetLineItem.setLineItemNumber(budget.getNextValue("budget.budgetLineItem.lineItemNumber"));
        newBudgetLineItem.setApplyInRateFlag(true);
        newBudgetLineItem.setSubmitCostSharingFlag(budget.getSubmitCostSharingFlag());
        this.refreshBudgetLineCostElement(newBudgetLineItem);
        String onOffCampusFlag = budget.getOnOffCampusFlag();
        if (onOffCampusFlag.equalsIgnoreCase("D")) {
            newBudgetLineItem.setOnOffCampusFlag(newBudgetLineItem.getCostElementBO().getOnOffCampusFlag());
        } else {
            newBudgetLineItem.setOnOffCampusFlag(onOffCampusFlag.equalsIgnoreCase("N"));
        }
        newBudgetLineItem.setBudgetCategoryCode(newBudgetLineItem.getCostElementBO().getBudgetCategoryCode());
        newBudgetLineItem.setLineItemSequence(newBudgetLineItem.getLineItemNumber());
        this.refreshBudgetLineBudgetCategory(newBudgetLineItem);
        if (this.isBudgetFormulatedCostEnabled() && (formulatedCostElements = this.getFormulatedCostElements()).contains(newBudgetLineItem.getCostElement())) {
            newBudgetLineItem.setFormulatedCostElementFlag(true);
        }
    }

    protected void refreshBudgetLineCostElement(BudgetLineItem newBudgetLineItem) {
        if (StringUtils.isNotEmpty((CharSequence)newBudgetLineItem.getCostElement())) {
            this.getDataObjectService().wrap((Object)newBudgetLineItem).fetchRelationship(COST_ELEMENT_BO);
        }
    }

    protected void refreshBudgetLineBudgetCategory(BudgetLineItem newBudgetLineItem) {
        if (StringUtils.isNotEmpty((CharSequence)newBudgetLineItem.getBudgetCategoryCode())) {
            this.getDataObjectService().wrap((Object)newBudgetLineItem).fetchRelationship(BUDGET_CATEGORY);
        }
    }

    protected PropDevBudgetSubAwardService getPropDevBudgetSubAwardService() {
        return this.propDevBudgetSubAwardService;
    }

    @Override
    public boolean validateCostShare(ProposalDevelopmentBudgetExt budget) {
        boolean valid = Boolean.TRUE;
        for (int i = 0; i < budget.getBudgetCostShares().size(); ++i) {
            BudgetCostShare budgetCostShare = budget.getBudgetCostShares().get(i);
            if (budgetCostShare.getUnitNumber() != null) {
                valid &= this.validateUnit(budgetCostShare.getUnitNumber(), UNIT_NUMBER);
            }
            if (!Objects.isNull(budgetCostShare.getSourceAccount()) && !Objects.isNull(budgetCostShare.getCostShareTypeCode())) {
                valid &= this.isValidSourceAccountCostShareType(ERROR, budgetCostShare, SOURCE_ACCOUNT);
            }
            if (Objects.isNull(budgetCostShare.getSourceAccount())) {
                valid &= this.addValidationMessage(ERROR, SOURCE_ACCOUNT, "error.budget.distribution.sourceMissing", String.format("Cost Sharing entry #%d", i + 1));
            }
            valid = this.isUniqueSourceAccountFiscalYear(budget, valid, budgetCostShare, this.isCostShareTypeEnabled());
        }
        if (this.isCostShareTypeEnabled()) {
            String validationMessageType = this.getValidationMessageType();
            boolean activeAccountsAbsent = this.getBusinessObjectService().countMatching(Account.class, Collections.singletonMap("active", Boolean.TRUE)) < 1;
            for (int i = 0; i < budget.getBudgetCostShares().size(); ++i) {
                BudgetCostShare budgetCostShare = budget.getBudgetCostShares().get(i);
                if (Objects.isNull(budgetCostShare.getUnit())) {
                    valid &= this.addValidationMessage(validationMessageType, UNIT, "error.budget.distribution.unitMissing", String.valueOf(i + 1));
                }
                if (Objects.isNull(budgetCostShare.getCostShareTypeCode())) {
                    valid &= this.addValidationMessage(validationMessageType, COST_SHARE_TYPE, "error.budget.distribution.costShareTypeMissing", new String[0]);
                }
                if (Objects.isNull(budgetCostShare.getSourceAccount())) continue;
                if (activeAccountsAbsent) {
                    return valid;
                }
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put(ACCOUNT_NUMBER, budgetCostShare.getSourceAccount());
                if (this.getBusinessObjectService().countMatching(Account.class, fieldValues) != 0) continue;
                valid &= this.addValidationMessage(validationMessageType, SOURCE_ACCOUNT, "error.budget.distribution.costShare.sourceAccount.invalid", budgetCostShare.getSourceAccount());
            }
        }
        return valid;
    }

    public boolean isUniqueSourceAccountFiscalYear(ProposalDevelopmentBudgetExt budget, boolean valid, BudgetCostShare budgetCostShare, boolean costShareTypeEnabled) {
        int thisFiscalYear = budgetCostShare.getProjectPeriod() == null ? Integer.MIN_VALUE : budgetCostShare.getProjectPeriod();
        long numberOfOccurrences = budget.getBudgetCostShares().stream().filter(costShare -> this.findMatchingCostShare((BudgetCostShare)costShare, budgetCostShare, thisFiscalYear, costShareTypeEnabled)).count();
        if (numberOfOccurrences > 1L) {
            this.addValidationMessage(ERROR, FISCAL_YEAR, "error.costSharing.duplicate", new String[0]);
            valid &= Boolean.FALSE.booleanValue();
        }
        return valid;
    }

    public boolean findMatchingCostShare(BudgetCostShare costShare, BudgetCostShare budgetCostShare, int thisFiscalYear, boolean costShareTypeEnabled) {
        boolean valid;
        boolean bl = StringUtils.equalsIgnoreCase((CharSequence)costShare.getSourceAccount(), (CharSequence)budgetCostShare.getSourceAccount()) && thisFiscalYear == (costShare.getProjectPeriod() == null ? Integer.MIN_VALUE : costShare.getProjectPeriod()) ? true : (valid = false);
        if (costShareTypeEnabled && valid) {
            return costShare.getCostShareTypeCode() == budgetCostShare.getCostShareTypeCode() && StringUtils.equalsIgnoreCase((CharSequence)costShare.getUnitNumber(), (CharSequence)budgetCostShare.getUnitNumber());
        }
        return valid;
    }

    public boolean validateUnit(String unitNumber, String field) {
        if (unitNumber != null && this.unitService.getActiveUnit(unitNumber) == null) {
            this.globalVariableService.getMessageMap().putError(field, "error.award.unitNumber", new String[]{unitNumber});
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public boolean isCostShareTypeEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-GEN", "All", "ENABLE_COST_SHARE_ACCOUNT_VALIDATION");
    }

    public String getValidationMessageType() {
        return this.parameterService.getParameterValueAsString("KC-GEN", "All", "Cost_Share_Account_Validation_Message");
    }

    public void setPropDevBudgetSubAwardService(PropDevBudgetSubAwardService propDevBudgetSubAwardService) {
        this.propDevBudgetSubAwardService = propDevBudgetSubAwardService;
    }

    @Override
    public boolean isBetaBudgetEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-B", "All", "Beta_Budget_Enabled", Boolean.valueOf(false));
    }

    public BudgetPersonService getBudgetPersonService() {
        return this.budgetPersonService;
    }

    public void setBudgetPersonService(BudgetPersonService budgetPersonService) {
        this.budgetPersonService = budgetPersonService;
    }

    public BudgetModularService getBudgetModularService() {
        return this.budgetModularService;
    }

    public void setBudgetModularService(BudgetModularService budgetModularService) {
        this.budgetModularService = budgetModularService;
    }

    public void setBudgetCalculationService(BudgetCalculationService budgetCalculationService) {
        this.budgetCalculationService = budgetCalculationService;
    }

    public BudgetCalculationService getBudgetCalculationService() {
        return this.budgetCalculationService;
    }

    @Override
    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public KcBusinessRulesEngine getKcBusinessRulesEngine() {
        return this.kcBusinessRulesEngine;
    }

    public void setKcBusinessRulesEngine(KcBusinessRulesEngine kcBusinessRulesEngine) {
        this.kcBusinessRulesEngine = kcBusinessRulesEngine;
    }

    public BudgetSummaryService getBudgetSummaryService() {
        return this.budgetSummaryService;
    }

    public void setBudgetSummaryService(BudgetSummaryService budgetSummaryService) {
        this.budgetSummaryService = budgetSummaryService;
    }
}

