/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.core;

import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditRuleEvent;
import org.kuali.coeus.common.budget.framework.distribution.BudgetCostShare;
import org.kuali.coeus.common.budget.framework.distribution.BudgetUnrecoveredFandA;
import org.kuali.coeus.common.budget.framework.income.BudgetProjectIncome;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.framework.auth.UnitAuthorizationService;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRulesEngine;
import org.kuali.coeus.common.impl.KcViewHelperServiceImpl;
import org.kuali.coeus.propdev.impl.budget.ProposalBudgetNavigationService;
import org.kuali.coeus.propdev.impl.budget.ProposalBudgetService;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetForm;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModular;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModularIdc;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwards;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyService;
import org.kuali.coeus.propdev.impl.state.ProposalState;
import org.kuali.coeus.sys.framework.model.ScaleTwoDecimalEditor;
import org.kuali.coeus.sys.impl.validation.DataValidationItem;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="proposalBudgetViewHelperService")
@Scope(value="prototype")
public class ProposalBudgetViewHelperServiceImpl
extends KcViewHelperServiceImpl {
    private static final String SALARY_RESTRICTED = "restricted";
    public static final String SINGLE_POINT_ENTRY_FLAG = "SINGLE_POINT_ENTRY_FLAG";
    public static final String ERROR_BUDGET_PERIOD_MINIMUM = "error.budget.period.minimum";
    @Autowired
    @Qualifier(value="sponsorHierarchyService")
    private SponsorHierarchyService sponsorHierarchyService;
    @Autowired
    @Qualifier(value="dateTimeService")
    private DateTimeService dateTimeService;
    @Autowired
    @Qualifier(value="kcBusinessRulesEngine")
    private KcBusinessRulesEngine kcBusinessRulesEngine;
    @Autowired
    @Qualifier(value="proposalBudgetService")
    private ProposalBudgetService proposalBudgetService;
    @Autowired
    @Qualifier(value="proposalHierarchyService")
    private ProposalHierarchyService proposalHierarchyService;
    @Autowired
    @Qualifier(value="proposalBudgetNavigationService")
    private ProposalBudgetNavigationService proposalBudgetNavigationService;
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="personService")
    private PersonService personService;
    @Autowired
    @Qualifier(value="unitAuthorizationService")
    private UnitAuthorizationService unitAuthorizationService;

    public String displayFullName(String userName) {
        if (ObjectUtils.isNull((Object)userName)) {
            return "";
        }
        Person person = this.getPersonService().getPersonByPrincipalName(userName);
        return person != null ? person.getName() : "";
    }

    public void finalizeNavigationLinks(Action action, Object model, String direction) {
        ProposalBudgetForm propBudgetForm = (ProposalBudgetForm)model;
        this.getProposalBudgetNavigationService().createNavigationLink(action, propBudgetForm, direction);
    }

    public boolean isBudgetLineItemEditable(String selectedCollectionPath, String index, HashMap<String, List<String>> editableBudgetLineItem) {
        boolean retVal = false;
        if (editableBudgetLineItem.containsKey(selectedCollectionPath) && editableBudgetLineItem.get(selectedCollectionPath).contains(index)) {
            retVal = true;
        }
        return retVal;
    }

    public void processBeforeAddLine(ViewModel model, Object addLine, String collectionId, String collectionPath) {
        if (addLine instanceof BudgetProjectIncome) {
            BudgetProjectIncome budgetProjectIncome = (BudgetProjectIncome)addLine;
            budgetProjectIncome.setBudgetId(((ProposalBudgetForm)model).getBudget().getBudgetId());
            budgetProjectIncome.setDocumentComponentId(((ProposalBudgetForm)model).getBudget().getNextValue(budgetProjectIncome.getDocumentComponentIdKey()));
            budgetProjectIncome.setBudgetPeriod(((ProposalBudgetForm)model).getBudget().getBudgetPeriod(budgetProjectIncome));
        }
        if (addLine instanceof BudgetUnrecoveredFandA) {
            BudgetUnrecoveredFandA budgetUnrecoveredFandA = (BudgetUnrecoveredFandA)addLine;
            budgetUnrecoveredFandA.setBudget(((ProposalBudgetForm)model).getBudget());
            budgetUnrecoveredFandA.setDocumentComponentId(((ProposalBudgetForm)model).getBudget().getNextValue(budgetUnrecoveredFandA.getDocumentComponentIdKey()));
        }
        if (addLine instanceof BudgetCostShare) {
            BudgetCostShare budgetCostShare = (BudgetCostShare)addLine;
            budgetCostShare.setBudget(((ProposalBudgetForm)model).getBudget());
            budgetCostShare.setDocumentComponentId(((ProposalBudgetForm)model).getBudget().getNextValue(budgetCostShare.getDocumentComponentIdKey()));
        }
        if (addLine instanceof BudgetModularIdc) {
            BudgetModularIdc budgetModularIdc = (BudgetModularIdc)addLine;
            try {
                budgetModularIdc.setBudgetModular((BudgetModular)PropertyUtils.getNestedProperty((Object)model, (String)StringUtils.replace((String)collectionPath, (String)".budgetModularIdcs", (String)"")));
            }
            catch (Exception e) {
                throw new RuntimeException("proposal budget modular cannot be retrieved from propdev budget", e);
            }
            budgetModularIdc.setBudgetPeriod(budgetModularIdc.getBudgetModular().getBudgetPeriod());
            budgetModularIdc.setBudgetId(budgetModularIdc.getBudgetModular().getBudgetId());
            budgetModularIdc.setBudgetPeriodId(budgetModularIdc.getBudgetModular().getBudgetPeriodId());
            budgetModularIdc.setRateNumber(((ProposalBudgetForm)model).getBudget().getNextValue("rateNumber"));
        }
    }

    public void processAfterSaveLine(ViewModel model, Object lineObject, String collectionId, String collectionPath) {
        this.getDataObjectService().save(lineObject, new PersistenceOption[0]);
    }

    protected boolean performDeleteLineValidation(ViewModel model, String collectionId, String collectionPath, Object deleteLine) {
        if (deleteLine instanceof BudgetSubAwards) {
            this.getDataObjectService().delete(deleteLine);
        } else if (deleteLine instanceof BudgetPeriod) {
            try {
                List periods = (List)PropertyUtils.getProperty((Object)model, (String)collectionPath);
                if (periods != null && periods.size() == 1) {
                    this.getGlobalVariableService().getMessageMap().putError(collectionPath, ERROR_BUDGET_PERIOD_MINIMUM, new String[0]);
                    return false;
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Problem reading the periods from Budget period collection", e);
            }
        }
        return super.performDeleteLineValidation(model, collectionId, collectionPath, deleteLine);
    }

    public boolean displayUnroundedModularFandA() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "Display_Unrounded_Modular_FNA");
    }

    public String getProposalStatusForDisplay(DevelopmentProposal proposal) {
        ProposalState state = proposal.getHierarchyAwareProposalStatus();
        return state != null ? state.getDescription() : "";
    }

    public boolean isCostShareTypeEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "ENABLE_COST_SHARE_ACCOUNT_VALIDATION");
    }

    public String getWizardMaxResults() {
        return this.getParameterService().getParameterValueAsString("KR-KRAD", "Lookup", "RESULTS_LIMIT");
    }

    public boolean lazyLoadBudgetPersonnel(Budget budget) {
        String limitStr = this.getParameterService().getParameterValueAsString("KC-B", "All", "Proposal_Budget_Period_Loading");
        int limit = Integer.parseInt(limitStr);
        boolean lazyLoad = budget.getBudgetPersonnelDetails().size() > limit;
        return lazyLoad;
    }

    public boolean syncRequiresEndDateExtension(DevelopmentProposal proposal) {
        DevelopmentProposal hierarchyProposal = this.getProposalHierarchyService().getDevelopmentProposal(proposal.getHierarchyParentProposalNumber());
        return this.getProposalHierarchyService().needToExtendProjectDate(hierarchyProposal, proposal);
    }

    public boolean syncAllRequiresEndDateExtension(DevelopmentProposal hierarchyProposal) {
        return this.getProposalHierarchyService().needToExtendProjectDate(hierarchyProposal);
    }

    public boolean canViewSalary(BudgetPerson person) {
        if (person == null || person.getBudget() == null) {
            return false;
        }
        DevelopmentProposal developmentProposal = ((ProposalDevelopmentBudgetExt)person.getBudget()).getDevelopmentProposal();
        HashMap<String, String> permissionQualifiers = new HashMap<String, String>();
        permissionQualifiers.put("documentNumber", developmentProposal.getProposalDocument().getDocumentNumber());
        permissionQualifiers.put("proposal", developmentProposal.getProposalNumber());
        permissionQualifiers.put("unitNumber", developmentProposal.getUnitNumber());
        permissionQualifiers.put("subunits", "Y");
        boolean userHasPermission = this.getPermissionService().isAuthorized(this.getGlobalVariableService().getUserSession().getPrincipalId(), "KC-B", "View Personnel Salaries", permissionQualifiers);
        if (!userHasPermission && StringUtils.isNotEmpty((CharSequence)developmentProposal.getUnitNumber())) {
            userHasPermission = this.getUnitAuthorizationService().hasPermission(this.getGlobalVariableService().getUserSession().getPrincipalId(), developmentProposal.getUnitNumber(), "KC-B", "View Personnel Salaries");
        }
        return userHasPermission;
    }

    public String getPersonSalaryForDisplay(BudgetPerson person) {
        ScaleTwoDecimalEditor salaryFormatter = new ScaleTwoDecimalEditor(new DecimalFormat("##0.00"), true);
        salaryFormatter.setValue(person.getCalculationBase());
        return this.canViewSalary(person) ? salaryFormatter.getAsText() : SALARY_RESTRICTED;
    }

    public SponsorHierarchyService getSponsorHierarchyService() {
        return this.sponsorHierarchyService;
    }

    public void setSponsorHierarchyService(SponsorHierarchyService sponsorHierarchyService) {
        this.sponsorHierarchyService = sponsorHierarchyService;
    }

    public boolean isShowModularBudgetQuestion(String sponsorCode) {
        return this.getSponsorHierarchyService().isSponsorNihMultiplePi(sponsorCode);
    }

    public boolean displayPersonSalaryByPeriod() {
        return this.getParameterService().getParameterValueAsBoolean(ProposalDevelopmentDocument.class, "enableBudgetCalculatedSalary");
    }

    public String getDateFromTimeStamp(Timestamp timestamp) {
        return ObjectUtils.isNull((Object)timestamp) ? "" : this.getDateTimeService().toDateString(new Date(timestamp.getTime()));
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public List<DataValidationItem> populateDataValidation(ProposalBudgetForm form) {
        this.getGlobalVariableService().getAuditErrorMap().clear();
        this.applyBudgetAuditRules(form);
        return this.populateDataValidation();
    }

    public boolean applyBudgetAuditRules(ProposalBudgetForm form) {
        return this.getKcBusinessRulesEngine().applyRules(new BudgetAuditRuleEvent(form.getBudget()));
    }

    public KcBusinessRulesEngine getKcBusinessRulesEngine() {
        return this.kcBusinessRulesEngine;
    }

    public void setKcBusinessRulesEngine(KcBusinessRulesEngine kcBusinessRulesEngine) {
        this.kcBusinessRulesEngine = kcBusinessRulesEngine;
    }

    public ProposalHierarchyService getProposalHierarchyService() {
        return this.proposalHierarchyService;
    }

    public void setProposalHierarchyService(ProposalHierarchyService proposalHierarchyService) {
        this.proposalHierarchyService = proposalHierarchyService;
    }

    public boolean isBudgetMarkedForSubmission(Budget finalBudget, Budget currentBudget) {
        return this.getProposalBudgetService().isBudgetMarkedForSubmission(finalBudget, currentBudget);
    }

    public ProposalBudgetService getProposalBudgetService() {
        return this.proposalBudgetService;
    }

    public void setProposalBudgetService(ProposalBudgetService proposalBudgetService) {
        this.proposalBudgetService = proposalBudgetService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public boolean displaySubawardPeriodWarning(Budget budget) {
        return this.hasMultiplePeriods(budget) && this.isEmptyBudgetLineItemExists(budget);
    }

    private boolean hasMultiplePeriods(Budget budget) {
        return budget.getBudgetPeriods().size() > 1;
    }

    private boolean isEmptyBudgetLineItemExists(Budget budget) {
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (!CollectionUtils.isEmpty(budgetPeriod.getBudgetLineItems())) continue;
            return true;
        }
        return false;
    }

    public boolean budgetLineItemsExistInLaterPeriods(List<BudgetPeriod> budgetPeriods) {
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            if (budgetPeriod.getBudgetPeriod() == 1 || budgetPeriod.getBudgetLineItems().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void prepareHierarchySummary(ProposalBudgetForm form) {
        if (form.getDevelopmentProposal().isInHierarchy()) {
            form.setHierarchyDevelopmentProposals(this.getProposalHierarchyService().getHierarchyProposals(form.getDevelopmentProposal()));
        }
    }

    public boolean isSinglePointEntry() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", SINGLE_POINT_ENTRY_FLAG);
    }

    public boolean isStandaloneBudgetEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-B", "All", "Standalone_Budget_Enabled", Boolean.valueOf(false));
    }

    public boolean isBetaBudgetEnabled() {
        return this.getProposalBudgetService().isBetaBudgetEnabled();
    }

    public String getBetaBudgetUrl(DevelopmentProposal proposal) {
        return this.getProposalBudgetNavigationService().getBetaBudgetUrl(proposal);
    }

    public ProposalBudgetNavigationService getProposalBudgetNavigationService() {
        return this.proposalBudgetNavigationService;
    }

    public void setProposalBudgetNavigationService(ProposalBudgetNavigationService proposalBudgetNavigationService) {
        this.proposalBudgetNavigationService = proposalBudgetNavigationService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public UnitAuthorizationService getUnitAuthorizationService() {
        return this.unitAuthorizationService;
    }

    public void setUnitAuthorizationService(UnitAuthorizationService unitAuthorizationService) {
        this.unitAuthorizationService = unitAuthorizationService;
    }

    @Override
    protected Class<?> getParameterClass() {
        return Budget.class;
    }
}

