/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.copy;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.impl.copy.CopyMode;
import org.kuali.coeus.propdev.impl.copy.ProposalCopyCriteria;
import org.kuali.coeus.propdev.impl.copy.ProposalCopyService;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentControllerBase;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentViewHelperServiceImpl;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalDevelopmentCopyController
extends ProposalDevelopmentControllerBase {
    private static final Logger LOG = LogManager.getLogger(ProposalDevelopmentCopyController.class);
    public static final String COPY_DIALOG = "PropDev-CopyDialog-Section";
    private static final String IS_COPIED_PROPOSAL = "isCopiedProposal";
    @Autowired
    @Qualifier(value="documentTypeService")
    private DocumentTypeService documentTypeService;
    @Autowired
    @Qualifier(value="proposalCopyService")
    private ProposalCopyService proposalCopyService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=copy"})
    public ModelAndView copy(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        ProposalCopyCriteria proposalCopyCriteria = form.getProposalCopyCriteria();
        if (StringUtils.isNotBlank((CharSequence)proposalCopyCriteria.getLeadUnitNumber()) || proposalCopyCriteria.isHierarchyCopy()) {
            ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
            this.releaseLocksForLoggedInUser(form);
            ProposalDevelopmentDocument newDoc = !proposalCopyCriteria.isHierarchyCopy() ? this.getProposalCopyService().copyProposal(proposalDevelopmentDocument, proposalCopyCriteria) : this.getProposalCopyService().copyProposalHierarchy(form.getProposalDevelopmentDocument(), proposalCopyCriteria);
            if (newDoc != null) {
                return this.returnToDocument(form, newDoc.getDocumentNumber());
            }
        }
        return null;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=displayCopyDialog"})
    public ModelAndView displayCopyDialog(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        if (form.getDevelopmentProposal().isInHierarchy()) {
            return this.getModelAndViewService().showDialog("PropDev-Copy-Hierarchy-Or-Single-Dialog", true, (UifFormBase)form);
        }
        return this.copySingleProposal(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=copyAllHierarchy"})
    public ModelAndView copyAllHierarchy(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        form.setProposalCopyCriteria(new ProposalCopyCriteria(form.getProposalDevelopmentDocument()));
        form.getProposalCopyCriteria().setCopyMode(CopyMode.HIERARCHY);
        form.getProposalCopyCriteria().setIncludeBudget(true);
        form.getProposalCopyCriteria().setIncludeAttachments(true);
        return this.displayCopyDialogDirect(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=copySingleProposal"})
    public ModelAndView copySingleProposal(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        form.setProposalCopyCriteria(new ProposalCopyCriteria(form.getProposalDevelopmentDocument()));
        form.getProposalCopyCriteria().setCopyMode(CopyMode.SINGLE);
        return this.displayCopyDialogDirect(form);
    }

    public ModelAndView displayCopyDialogDirect(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        ((ProposalDevelopmentViewHelperServiceImpl)form.getView().getViewHelperService()).populateQuestionnaires(form);
        return this.getModelAndViewService().showDialog(COPY_DIALOG, true, (UifFormBase)form);
    }

    protected ModelAndView returnToDocument(ProposalDevelopmentDocumentForm form, String newDocNum) {
        Properties props = new Properties();
        props.put("command", "displayDocSearchView");
        props.put("docId", newDocNum);
        props.put(IS_COPIED_PROPOSAL, "true");
        if (StringUtils.isNotBlank((CharSequence)form.getReturnFormKey())) {
            props.put("formKey", form.getReturnFormKey());
        }
        String docHandlerUrl = this.getDocHandlerUrl(form, props);
        return this.getModelAndViewService().performRedirect((UifFormBase)form, docHandlerUrl);
    }

    protected String getDocHandlerUrl(ProposalDevelopmentDocumentForm form, Properties props) {
        DocumentType docType = this.getDocumentTypeService().getDocumentTypeByName(form.getDocTypeName());
        String docHandlerUrl = docType.getResolvedDocumentHandlerUrl() + "&" + props.entrySet().stream().map(entry -> entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining("&"));
        if (this.isDashboardModeEnabled()) {
            String dashboardUrl = this.getConfigurationService().getPropertyValueAsString("dashboard.standalone.base.url");
            try {
                return dashboardUrl + "/dashboard/redir?to=" + URLEncoder.encode(docHandlerUrl, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn("Failed to encode docHandlerUrl when dashboard mode is enabled.", (Throwable)e);
                return docHandlerUrl;
            }
        }
        return docHandlerUrl;
    }

    private boolean isDashboardModeEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "Dashboard_Mode_Enabled", Boolean.valueOf(false));
    }

    public DocumentTypeService getDocumentTypeService() {
        return this.documentTypeService;
    }

    public void setDocumentTypeService(DocumentTypeService documentTypeService) {
        this.documentTypeService = documentTypeService;
    }

    public ProposalCopyService getProposalCopyService() {
        return this.proposalCopyService;
    }

    public void setProposalCopyService(ProposalCopyService proposalCopyService) {
        this.proposalCopyService = proposalCopyService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

