/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.custom;

import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.GroupBase;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.LifecycleElement;

@BeanTag(name="listEditor", parent="Uif-ListEditor")
public class ListEditor
extends GroupBase {
    private static final long serialVersionUID = -320809989690718457L;
    private String baseInputName;
    private List<?> values;
    private BiFunction<Object, Integer, Component> createComponentWithValue;
    private List<Component> elementComponents;
    private List<Action> removeElementActions;
    private Action addElementAction;
    private String actionParamListId;

    public String getBaseInputName() {
        return this.baseInputName;
    }

    public void setBaseInputName(String baseInputName) {
        this.baseInputName = baseInputName;
    }

    public List<?> getValues() {
        return this.values;
    }

    public void setValues(List<?> values) {
        this.values = values;
    }

    public BiFunction<Object, Integer, Component> getCreateComponentWithValue() {
        return this.createComponentWithValue;
    }

    public void setCreateComponentWithValue(BiFunction<Object, Integer, Component> createComponentWithValue) {
        this.createComponentWithValue = createComponentWithValue;
    }

    public List<Component> getElementComponents() {
        return this.elementComponents;
    }

    public void setElementComponents(List<Component> elementComponents) {
        this.elementComponents = elementComponents;
    }

    public Action getAddElementAction() {
        return this.addElementAction;
    }

    public List<Action> getRemoveElementActions() {
        return this.removeElementActions;
    }

    public String getActionParamListId() {
        return this.actionParamListId;
    }

    public void setActionParamListId(String actionParamListId) {
        this.actionParamListId = actionParamListId;
    }

    public void performApplyModel(Object model, LifecycleElement parent) {
        this.elementComponents = IntStream.range(0, this.values.size()).mapToObj(i -> this.createComponentWithValue.apply(this.values.get(i), i)).collect(Collectors.toList());
        this.addElementAction = this.createAddElementAction();
        this.removeElementActions = IntStream.range(0, this.values.size()).mapToObj(i -> this.createRemoveElementAction(i)).collect(Collectors.toList());
        super.performApplyModel(model, parent);
    }

    private Action createAddElementAction() {
        Action action = (Action)ComponentFactory.getNewComponentInstance((String)"Uif-Action");
        action.setMethodToCall("addElement");
        action.setActionLabel("+");
        action.addActionParameter("listId", this.actionParamListId);
        return action;
    }

    private Action createRemoveElementAction(int elementIndex) {
        Action action = (Action)ComponentFactory.getNewComponentInstance((String)"Uif-Action");
        action.setMethodToCall("removeElement");
        action.setActionLabel("-");
        action.addActionParameter("listId", this.actionParamListId);
        action.addActionParameter("elementIndex", String.valueOf(elementIndex));
        return action;
    }
}

