/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.person;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.PropAwardPersonRole;
import org.kuali.coeus.common.framework.person.PropAwardPersonRoleService;
import org.kuali.coeus.common.framework.person.UnitPopulationBehavior;
import org.kuali.coeus.common.framework.person.attr.PersonBiosketch;
import org.kuali.coeus.common.framework.person.attr.PersonDegree;
import org.kuali.coeus.common.framework.person.editable.PersonEditableService;
import org.kuali.coeus.common.framework.type.InvestigatorCreditType;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.ynq.YnqService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.person.KeyPersonnelService;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.ProposalPersonCertificationDetails;
import org.kuali.coeus.propdev.impl.person.ProposalPersonDegree;
import org.kuali.coeus.propdev.impl.person.ProposalPersonUnit;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiography;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiographyAttachment;
import org.kuali.coeus.propdev.impl.person.creditsplit.CreditSplit;
import org.kuali.coeus.propdev.impl.person.creditsplit.ProposalCreditSplitListDto;
import org.kuali.coeus.propdev.impl.person.creditsplit.ProposalPersonCreditSplit;
import org.kuali.coeus.propdev.impl.person.creditsplit.ProposalUnitCreditSplit;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="keyPersonnelService")
public class KeyPersonnelServiceImpl
implements KeyPersonnelService {
    private static final Logger LOG = LogManager.getLogger(KeyPersonnelServiceImpl.class);
    public static final String INVESTIGATOR = "investigator";
    public static final String UNIT = "unit";
    public static final String UNIT_TOTAL = "Unit Total:";
    public static final String UNIT_TOTAL_TYPE = "unit-total";
    public static final String INVESTIGATOR_TOTAL = "Investigator Total:";
    public static final String INVESTIGATOR_TOTAL_TYPE = "investigator-total";
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="ynqService")
    private YnqService ynqService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="personEditableService")
    private PersonEditableService personEditableService;
    @Autowired
    @Qualifier(value="propAwardPersonRoleService")
    private PropAwardPersonRoleService propAwardPersonRoleService;

    @Override
    public void populateDocument(ProposalDevelopmentDocument document) {
        this.populateCreditSplit(document);
        for (ProposalPerson person : document.getDevelopmentProposal().getProposalPersons()) {
            this.getYnqService().getPersonYNQ(person, document);
        }
    }

    @Override
    public void populateCreditSplit(ProposalDevelopmentDocument document) {
        if (this.hasBeenRoutedOrCanceled(document)) {
            Collection<InvestigatorCreditType> availableCreditTypes = this.getAllInvestigatorCreditTypes();
            HashSet<InvestigatorCreditType> usedCreditTypes = new HashSet<InvestigatorCreditType>();
            for (ProposalPerson person : document.getDevelopmentProposal().getInvestigators()) {
                for (ProposalPersonCreditSplit creditSplit : person.getCreditSplits()) {
                    for (InvestigatorCreditType currentCreditType : availableCreditTypes) {
                        if (!currentCreditType.getCode().equals(creditSplit.getInvCreditTypeCode())) continue;
                        usedCreditTypes.add(currentCreditType);
                    }
                }
            }
            document.getDevelopmentProposal().setInvestigatorCreditTypes(usedCreditTypes);
        } else {
            document.getDevelopmentProposal().setInvestigatorCreditTypes(this.getInvestigatorCreditTypes());
        }
        if (document.getDevelopmentProposal().getInvestigators().isEmpty() && !document.getDevelopmentProposal().getProposalPersons().isEmpty() && !document.getDocumentHeader().getWorkflowDocument().getStatus().getCode().equals("R")) {
            this.populateActiveCredittypesPerson(document);
        }
    }

    public void populateActiveCredittypesPerson(ProposalDevelopmentDocument document) {
        Collection<InvestigatorCreditType> invcrdttype = this.getInvestigatorCreditTypes();
        for (ProposalPerson person : document.getDevelopmentProposal().getInvestigators()) {
            for (InvestigatorCreditType invcredtype : invcrdttype) {
                boolean creditTypeFound = false;
                for (ProposalPersonCreditSplit proposalpersoncrdt : person.getCreditSplits()) {
                    if (!invcredtype.getCode().equals(proposalpersoncrdt.getInvCreditTypeCode())) continue;
                    creditTypeFound = true;
                    break;
                }
                if (creditTypeFound) continue;
                person.getCreditSplits().add(this.getProposalPersonCreditSplit(person, invcredtype.getCode()));
            }
            for (ProposalPersonUnit unitsplit : person.getUnits()) {
                for (InvestigatorCreditType invcrdtype : invcrdttype) {
                    boolean creditTypeFound = false;
                    for (ProposalUnitCreditSplit unitcreditsplit : unitsplit.getCreditSplits()) {
                        if (!invcrdtype.getCode().equals(unitcreditsplit.getInvCreditTypeCode())) continue;
                        creditTypeFound = true;
                        break;
                    }
                    if (creditTypeFound) continue;
                    unitsplit.getCreditSplits().add(this.getProposalUnitCreditSplit(unitsplit, invcrdtype.getCode()));
                }
            }
        }
    }

    @Override
    public void saveCertDetails(ProposalPerson person, String certifiedBy, Timestamp certifiedTime) {
        if (person.getCertificationDetails() == null) {
            person.setCertificationDetails(new ProposalPersonCertificationDetails(person.getProposalPersonNumber(), person.getProposalNumber()));
        }
        person.getCertificationDetails().setCertifiedBy(certifiedBy);
        person.getCertificationDetails().setCertifiedTime(certifiedTime);
        this.getDataObjectService().save((Object)person.getCertificationDetails(), new PersistenceOption[0]);
    }

    @Override
    public void addProposalPerson(ProposalPerson proposalPerson, ProposalDevelopmentDocument document) {
        this.getPersonEditableService().populateContactFields(proposalPerson);
        document.getDevelopmentProposal().addProposalPerson(proposalPerson);
        LOG.info("Added Proposal Person with proposalNumber = " + document.getDevelopmentProposal().getProposalNumber() + " and proposalPersonNumber = " + proposalPerson.getProposalPersonNumber());
        if (proposalPerson.isPrincipalInvestigator()) {
            this.assignLeadUnit(proposalPerson, document.getDevelopmentProposal().getOwnedByUnitNumber());
        } else {
            ProposalPersonUnit unit = proposalPerson.getUnit(document.getDevelopmentProposal().getOwnedByUnitNumber());
            if (unit != null) {
                unit.setLeadUnit(false);
            }
        }
        if (proposalPerson.getCitizenshipTypeCode() != null) {
            this.getDataObjectService().wrap((Object)proposalPerson).fetchRelationship("citizenshipType");
        }
        this.populatePersonUnits(document.getDevelopmentProposal(), proposalPerson);
        this.populateProposalPerson(proposalPerson, document);
    }

    public void populatePersonUnits(DevelopmentProposal proposal, ProposalPerson proposalPerson) {
        this.propAwardPersonRoleService.getRolesByHierarchy(proposal.getSponsorCode()).stream().filter(personRole -> personRole.getCode().equals(proposalPerson.getProposalPersonRoleId())).findFirst().map(personRole -> this.getUnitsForPerson(proposalPerson, (PropAwardPersonRole)personRole)).ifPresent(units -> units.forEach(unit -> this.addUnitToPerson(proposalPerson, this.createProposalPersonUnit((String)unit, proposalPerson))));
    }

    protected Set<String> getUnitsForPerson(ProposalPerson proposalPerson, PropAwardPersonRole personRole) {
        List<String> selectedCodes = StringUtils.isNotBlank((CharSequence)personRole.getSelectedUnitSources()) ? Arrays.asList(StringUtils.split((String)personRole.getSelectedUnitSources(), (String)",")) : Collections.emptyList();
        switch (UnitPopulationBehavior.fromCode(personRole.getAutoPopulateUnitsCode())) {
            case PRIMARY: {
                return StringUtils.isEmpty((CharSequence)proposalPerson.getHomeUnit()) ? Collections.emptySet() : Collections.singleton(proposalPerson.getHomeUnit());
            }
            case ALL: {
                return proposalPerson.getPerson() != null ? proposalPerson.getPerson().getAllUnits().stream().map(Unit::getUnitNumber).collect(Collectors.toSet()) : Collections.emptySet();
            }
            case SELECTED: {
                return proposalPerson.getPerson() != null ? proposalPerson.getPerson().getAllUnits(true, selectedCodes).stream().map(Unit::getUnitNumber).collect(Collectors.toSet()) : Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    @Override
    public void populateProposalPerson(ProposalPerson person, ProposalDevelopmentDocument document) {
        person = this.getYnqService().getPersonYNQ(person, document);
        if (person.isInvestigator()) {
            if (!document.getDevelopmentProposal().getInvestigators().contains(person)) {
                document.getDevelopmentProposal().getInvestigators().add(person);
            }
            this.populateCreditTypes(person);
        }
        person.setRoleChanged(false);
        try {
            if (person.getPersonId() != null && person.getPerson().getExtendedAttributes() != null) {
                KcPerson origPerson = person.getPerson();
                for (PersonDegree degree : origPerson.getExtendedAttributes().getPersonDegrees()) {
                    ProposalPersonDegree newDegree = new ProposalPersonDegree();
                    newDegree.setProposalPerson(person);
                    newDegree.setDegree(degree.getDegree());
                    newDegree.setDegreeCode(degree.getDegreeCode());
                    newDegree.setFieldOfStudy(degree.getFieldOfStudy());
                    newDegree.setGraduationYear(degree.getGraduationYear());
                    newDegree.setSchool(degree.getSchool());
                    newDegree.setSchoolId(degree.getSchoolId());
                    newDegree.setSchoolIdCode(degree.getSchoolIdCode());
                    newDegree.setDegreeSequenceNumber(document.getDocumentNextValue("proposalDevelopment.proposalPerson.degree.degreeSequenceNumber"));
                    person.addDegree(newDegree);
                }
                if (origPerson.getExtendedAttributes().getAttachments() != null) {
                    for (PersonBiosketch attachment : origPerson.getExtendedAttributes().getAttachments()) {
                        ProposalPersonBiography bio = new ProposalPersonBiography();
                        bio.setProposalPersonNumber(person.getProposalPersonNumber());
                        bio.setDocumentTypeCode(this.getDefaultPersonAttachmentDocType());
                        bio.setDescription(attachment.getDescription());
                        bio.setName(attachment.getFileName());
                        bio.setType(attachment.getContentType());
                        bio.setDevelopmentProposal(document.getDevelopmentProposal());
                        ProposalPersonBiographyAttachment personnelAttachment = new ProposalPersonBiographyAttachment();
                        personnelAttachment.setName(attachment.getFileName());
                        personnelAttachment.setProposalPersonBiography(bio);
                        personnelAttachment.setProposalNumber(document.getDevelopmentProposal().getProposalNumber());
                        personnelAttachment.setProposalPersonNumber(person.getProposalPersonNumber());
                        personnelAttachment.setData(attachment.getAttachmentContent());
                        personnelAttachment.setType(attachment.getContentType());
                        bio.setPersonnelAttachment(personnelAttachment);
                        document.getDevelopmentProposal().addProposalPersonBiography(bio);
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Object)e);
        }
    }

    protected void populateCreditTypes(ProposalPerson person) {
        if (!person.getCreditSplits().isEmpty()) {
            return;
        }
        for (InvestigatorCreditType creditType : this.getInvestigatorCreditTypes()) {
            ProposalPersonCreditSplit creditSplit = this.getProposalPersonCreditSplit(person, creditType.getCode());
            person.getCreditSplits().add(creditSplit);
        }
    }

    @Override
    public Collection<InvestigatorCreditType> getInvestigatorCreditTypes() {
        return this.getBusinessObjectService().findMatching(InvestigatorCreditType.class, Collections.singletonMap("active", "true"));
    }

    public Collection<InvestigatorCreditType> getAllInvestigatorCreditTypes() {
        return this.getBusinessObjectService().findAll(InvestigatorCreditType.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map calculateCreditSplitTotals(ProposalDevelopmentDocument document) {
        HashMap retval = new HashMap();
        if (document.getDevelopmentProposal().getInvestigatorCreditTypes() == null || document.getDevelopmentProposal().getInvestigatorCreditTypes().size() == 0) {
            document.getDevelopmentProposal().setInvestigatorCreditTypes(this.getInvestigatorCreditTypes());
        }
        Collection<InvestigatorCreditType> creditTypes = document.getDevelopmentProposal().getInvestigatorCreditTypes();
        for (ProposalPerson investigator : document.getDevelopmentProposal().getInvestigators()) {
            HashMap<String, ScaleTwoDecimal> creditTypeTotals = (HashMap<String, ScaleTwoDecimal>)retval.get(investigator.getProposalPersonNumber().toString());
            HashMap<String, ScaleTwoDecimal> investigatorCreditTypeTotals = (HashMap<String, ScaleTwoDecimal>)retval.get(INVESTIGATOR);
            if (creditTypeTotals == null) {
                creditTypeTotals = new HashMap<String, ScaleTwoDecimal>();
                retval.put(investigator.getProposalPersonNumber().toString(), creditTypeTotals);
            }
            if (investigatorCreditTypeTotals == null) {
                investigatorCreditTypeTotals = new HashMap<String, ScaleTwoDecimal>();
                retval.put(INVESTIGATOR, investigatorCreditTypeTotals);
            }
            for (InvestigatorCreditType creditType : creditTypes) {
                ScaleTwoDecimal scaleTwoDecimal;
                ScaleTwoDecimal totalCredit = (ScaleTwoDecimal)creditTypeTotals.get(creditType.getCode());
                if (totalCredit == null) {
                    totalCredit = ScaleTwoDecimal.ZERO;
                    creditTypeTotals.put(creditType.getCode(), totalCredit);
                }
                if ((scaleTwoDecimal = (ScaleTwoDecimal)investigatorCreditTypeTotals.get(creditType.getCode())) == null) {
                    ScaleTwoDecimal scaleTwoDecimal2 = ScaleTwoDecimal.ZERO;
                    investigatorCreditTypeTotals.put(creditType.getCode(), scaleTwoDecimal2);
                }
                for (CreditSplit creditSplit : investigator.getCreditSplits()) {
                    void var11_14;
                    if (!creditSplit.getInvCreditTypeCode().equals(creditType.getCode())) continue;
                    investigatorCreditTypeTotals.put(creditType.getCode(), (ScaleTwoDecimal)var11_14.add((AbstractDecimal)creditSplit.getCredit()));
                }
            }
            for (ProposalPersonUnit unit : investigator.getUnits()) {
                for (CreditSplit creditSplit : unit.getCreditSplits()) {
                    ScaleTwoDecimal totalCredit = (ScaleTwoDecimal)creditTypeTotals.get(creditSplit.getInvCreditTypeCode());
                    if (totalCredit == null) {
                        totalCredit = ScaleTwoDecimal.ZERO;
                        creditTypeTotals.put(creditSplit.getInvCreditTypeCode(), totalCredit);
                    }
                    creditTypeTotals.put(creditSplit.getInvCreditTypeCode(), (ScaleTwoDecimal)totalCredit.add((AbstractDecimal)creditSplit.getCredit()));
                }
            }
        }
        return retval;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService boservice) {
        this.businessObjectService = boservice;
    }

    @Override
    public void addUnitToPerson(ProposalPerson person, ProposalPersonUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Cannot add null units to a ProposalPerson instance");
        }
        if (!person.containsUnit(unit.getUnitNumber())) {
            unit.setProposalPerson(person);
            person.addUnit(unit);
            unit.refreshReferenceObject(UNIT);
        }
    }

    @Override
    public void assignLeadUnit(ProposalPerson person, String unitNumber) {
        if (person.containsUnit(unitNumber)) {
            person.getUnit(unitNumber).setLeadUnit(true);
            return;
        }
        ProposalPersonUnit unit = this.createProposalPersonUnit(unitNumber, person);
        unit.setLeadUnit(true);
        this.addUnitToPerson(person, unit);
    }

    @Override
    public ProposalPersonUnit createProposalPersonUnit(String unitId, ProposalPerson person) {
        ProposalPersonUnit retval = new ProposalPersonUnit();
        List units = this.getBusinessObjectService().findMatching(Unit.class, Collections.singletonMap("unitNumber", unitId));
        for (Unit found : units) {
            retval.setUnitNumber(found.getUnitNumber());
            retval.setUnit(found);
        }
        retval.getCreditSplits().addAll(this.createCreditSplits(retval));
        return retval;
    }

    @Override
    public List<ProposalUnitCreditSplit> createCreditSplits(ProposalPersonUnit unit) {
        ArrayList<ProposalUnitCreditSplit> retVal = new ArrayList<ProposalUnitCreditSplit>();
        for (InvestigatorCreditType creditType : this.getInvestigatorCreditTypes()) {
            retVal.add(this.getProposalUnitCreditSplit(unit, creditType.getCode()));
        }
        return retVal;
    }

    public void setYnqService(YnqService ynqService) {
        this.ynqService = ynqService;
    }

    public YnqService getYnqService() {
        return this.ynqService;
    }

    @Override
    public boolean isCreditSplitEnabled() {
        return this.getParameterService().getParameterValueAsBoolean(ProposalDevelopmentDocument.class, "proposaldevelopment.creditsplit.enabled");
    }

    public String getDefaultPersonAttachmentDocType() {
        return this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "DEFAULT_BIOGRAPHY_DOCUMENT_TYPE_CODE");
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    protected boolean hasBeenRoutedOrCanceled(ProposalDevelopmentDocument document) {
        WorkflowDocument workflowDoc = document.getDocumentHeader().getWorkflowDocument();
        return !workflowDoc.isInitiated() && !workflowDoc.isSaved();
    }

    protected PersonEditableService getPersonEditableService() {
        return this.personEditableService;
    }

    public void setPersonEditableService(PersonEditableService personEditableService) {
        this.personEditableService = personEditableService;
    }

    @Override
    public List<ProposalCreditSplitListDto> createCreditSplitListItems(ProposalDevelopmentDocument document) {
        List<ProposalPerson> investigators = document.getDevelopmentProposal().getPersonsSelectedForCreditSplit();
        if (!this.hasBeenRoutedOrCanceled(document)) {
            this.handleNewCreditTypes(investigators, this.getInvestigatorCreditTypes());
        }
        return this.createCreditSplitListDtos(investigators);
    }

    public void handleNewCreditTypes(List<ProposalPerson> investigators, Collection<InvestigatorCreditType> creditTypes) {
        investigators.forEach(person -> {
            List<InvestigatorCreditType> newCreditTypes = creditTypes.stream().filter(creditType -> person.getCreditSplits().stream().noneMatch(creditSplit -> creditSplit.getInvCreditTypeCode().equals(creditType.getCode()))).collect(Collectors.toList());
            newCreditTypes.forEach(newCreditType -> person.getCreditSplits().add(this.getProposalPersonCreditSplit((ProposalPerson)person, newCreditType.getCode())));
            person.getUnits().forEach(unit -> {
                List<InvestigatorCreditType> newUnitCreditTypes = creditTypes.stream().filter(creditType -> unit.getCreditSplits().stream().noneMatch(creditSplit -> creditSplit.getInvCreditTypeCode().equals(creditType.getCode()))).collect(Collectors.toList());
                newUnitCreditTypes.forEach(newUnitCreditType -> unit.getCreditSplits().add(this.getProposalUnitCreditSplit((ProposalPersonUnit)unit, newUnitCreditType.getCode())));
            });
        });
    }

    private ProposalPersonCreditSplit getProposalPersonCreditSplit(ProposalPerson person, String code) {
        ProposalPersonCreditSplit creditSplit = new ProposalPersonCreditSplit();
        creditSplit.setProposalPerson(person);
        creditSplit.setInvCreditTypeCode(code);
        creditSplit.setCredit(ScaleTwoDecimal.ZERO);
        return creditSplit;
    }

    private ProposalUnitCreditSplit getProposalUnitCreditSplit(ProposalPersonUnit unit, String code) {
        ProposalUnitCreditSplit creditSplit = new ProposalUnitCreditSplit();
        creditSplit.setProposalPersonUnit(unit);
        creditSplit.setInvCreditTypeCode(code);
        creditSplit.setCredit(ScaleTwoDecimal.ZERO);
        return creditSplit;
    }

    public List<ProposalCreditSplitListDto> createCreditSplitListDtos(List<ProposalPerson> investigators) {
        ArrayList<ProposalCreditSplitListDto> creditSplitListItems = new ArrayList<ProposalCreditSplitListDto>();
        HashMap<String, CreditSplit> totalInvestigatorSplits = new HashMap<String, CreditSplit>();
        for (ProposalPerson investigator : investigators) {
            this.populateInvestigatorLineItems(creditSplitListItems, totalInvestigatorSplits, investigator);
            this.populateUnitLineItems(creditSplitListItems, investigator, new HashMap<String, CreditSplit>());
        }
        this.populateInvestigatorTotalLineItem(investigators, creditSplitListItems, totalInvestigatorSplits);
        return creditSplitListItems;
    }

    protected void populateInvestigatorTotalLineItem(List<ProposalPerson> investigators, List<ProposalCreditSplitListDto> creditSplitListItems, Map<String, CreditSplit> totalInvestigatorSplits) {
        if (CollectionUtils.isNotEmpty(investigators)) {
            List<CreditSplit> totalInvestigatorCreditSplits = totalInvestigatorSplits.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
            ProposalCreditSplitListDto investigatorTotalLine = this.createProposalCreditSplitListDto(totalInvestigatorCreditSplits, INVESTIGATOR_TOTAL, INVESTIGATOR_TOTAL_TYPE);
            creditSplitListItems.add(investigatorTotalLine);
        }
    }

    protected void populateUnitLineItems(List<ProposalCreditSplitListDto> creditSplitListItems, ProposalPerson investigator, Map<String, CreditSplit> totalUnitSplits) {
        for (ProposalPersonUnit unit : investigator.getUnits()) {
            ArrayList<CreditSplit> unitCreditSplits = new ArrayList<CreditSplit>(unit.getCreditSplits());
            creditSplitListItems.add(this.createProposalCreditSplitListDto(unitCreditSplits, unit.getUnit().getUnitNumber() + " - " + unit.getUnit().getUnitName(), UNIT));
            for (ProposalUnitCreditSplit unitCreditSplit : unit.getCreditSplits()) {
                this.populateTotalsMap(totalUnitSplits, unitCreditSplit);
            }
        }
        if (totalUnitSplits.size() > 0) {
            List<CreditSplit> totalUnitCreditSplits = totalUnitSplits.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
            ProposalCreditSplitListDto unitTotalLine = this.createProposalCreditSplitListDto(totalUnitCreditSplits, UNIT_TOTAL, UNIT_TOTAL_TYPE);
            creditSplitListItems.add(unitTotalLine);
        }
    }

    protected void populateInvestigatorLineItems(List<ProposalCreditSplitListDto> creditSplitListItems, Map<String, CreditSplit> totalInvestigatorSplits, ProposalPerson investigator) {
        ArrayList<CreditSplit> creditSplits = new ArrayList<CreditSplit>(investigator.getCreditSplits());
        creditSplitListItems.add(this.createProposalCreditSplitListDto(creditSplits, investigator.getFullName(), INVESTIGATOR));
        for (CreditSplit investigatorCreditSplit : creditSplits) {
            this.populateTotalsMap(totalInvestigatorSplits, investigatorCreditSplit);
        }
    }

    protected void populateTotalsMap(Map<String, CreditSplit> totalsMap, CreditSplit creditSplitToAdd) {
        if (totalsMap.containsKey(creditSplitToAdd.getInvCreditTypeCode())) {
            CreditSplit creditSplit = totalsMap.get(creditSplitToAdd.getInvCreditTypeCode());
            creditSplit.setCredit((ScaleTwoDecimal)creditSplit.getCredit().add((AbstractDecimal)creditSplitToAdd.getCredit()));
        } else {
            ProposalPersonCreditSplit creditSplit = new ProposalPersonCreditSplit();
            creditSplit.setCredit(creditSplitToAdd.getCredit());
            creditSplit.setInvCreditTypeCode(creditSplitToAdd.getInvCreditTypeCode());
            totalsMap.put(creditSplitToAdd.getInvCreditTypeCode(), creditSplit);
        }
    }

    protected ProposalCreditSplitListDto createProposalCreditSplitListDto(List<CreditSplit> creditSplits, String description, String lineType) {
        ProposalCreditSplitListDto proposalCreditSplitListDto = new ProposalCreditSplitListDto();
        proposalCreditSplitListDto.setDescription(description);
        proposalCreditSplitListDto.setLineType(lineType);
        creditSplits.sort(new CreditSplitComparator());
        proposalCreditSplitListDto.getCreditSplits().addAll(creditSplits);
        return proposalCreditSplitListDto;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    private class CreditSplitComparator
    implements Comparator<CreditSplit> {
        private CreditSplitComparator() {
        }

        @Override
        public int compare(CreditSplit o1, CreditSplit o2) {
            return o1.getInvCreditTypeCode().compareTo(o2.getInvCreditTypeCode());
        }
    }
}

