/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.print;

import gov.nih.era.projectmgmt.sbir.cgap.commonNamespace.AssuranceType;
import gov.nih.era.projectmgmt.sbir.cgap.commonNamespace.ContactInfoType;
import gov.nih.era.projectmgmt.sbir.cgap.commonNamespace.PostalAddressType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.AbstractType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.ApplicantOrganizationType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.AuthorizedOrganizationalRepresentativeType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.BudgetPeriodType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.BudgetSummaryType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.FundingOpportunityDetailsType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.HumanSubjectsType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.KeyPersonBiosketchType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.KeyPersonType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.NSFOtherPersonnelType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.NSFSeniorPersonnelType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.OrgAssurancesType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.ProgramDirectorPrincipalInvestigatorDocument;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.ProjectDescriptionDocument;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.ResearchAndRelatedProjectDocument;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.ResearchCoverPageDocument;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.SalariesAndWagesType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.SignatureType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.DescriptionBlockType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.KeyPersonType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.OtherDirectCostsDocument;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.PersonFullNameType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ProjectRoleType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ProjectSiteType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ProposalPersonType;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlToken;
import org.kuali.coeus.common.api.org.OrganizationRepositoryService;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.category.BudgetCategoryMapping;
import org.kuali.coeus.common.budget.framework.income.BudgetProjectIncome;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetRateAndBase;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.framework.org.Organization;
import org.kuali.coeus.common.framework.org.OrganizationYnq;
import org.kuali.coeus.common.framework.org.type.OrganizationType;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.propdev.api.core.SubmissionInfoService;
import org.kuali.coeus.propdev.impl.abstrct.ProposalAbstract;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModular;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModularIdc;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalTypeService;
import org.kuali.coeus.propdev.impl.location.CongressionalDistrict;
import org.kuali.coeus.propdev.impl.location.ProposalSite;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.ProposalPersonDegree;
import org.kuali.coeus.propdev.impl.person.ProposalPersonUnit;
import org.kuali.coeus.propdev.impl.print.AbstractResearchAndRelatedStream;
import org.kuali.coeus.propdev.impl.print.KeyPersonInfo;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReview;
import org.kuali.coeus.propdev.impl.ynq.ProposalYnq;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.home.AwardService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="nihResearchAndRelatedXmlStream")
@Scope(value="prototype")
public class NIHResearchAndRelatedXmlStream
extends AbstractResearchAndRelatedStream<ResearchAndRelatedProjectDocument> {
    private static final Logger LOG = LogManager.getLogger(NIHResearchAndRelatedXmlStream.class);
    private static final String ORGANIZATION_QUESTION_ID_H5 = "H5";
    private static final String ORGANIZATION_QUESTION_ID_I8 = "I8";
    private static final String DEFAULT_VALUE_KEY_PERSON_FLAG_CODE = "true";
    private static final String KEY_PERSON_FLAG_DESCRIPTION_VALUE_KEY_PERSON = "Key Person";
    private static final String GENERAL_CERTIFICATION_QUESTION_ID = "H6";
    private static final String LOBBYING_QUESTION_ID = "H0";
    private static final String REFERENCES_BLOCK_TYPE = "references";
    private static final String EQUIPMENT_BLOCK_TYPE = "equipment";
    private static final String FACILITIES_BLOCK_TYPE = "facilities";
    private static final String PROJECT_SUMMARY_BLOCK_TYPE = "summary";
    private static final String SPECIAL_REVIEW_CODE_1 = "1";
    private static final String APPROVAL_TYPE_EXEMPT = "4";
    protected static final String PROPOSAL_YNQ_QUESTION_16 = "16";
    private static final String ACADEMIC_PERIOD = "2";
    private static final String CALENDAR_PERIOD = "3";
    private static final String PROJECT_ROLE_PI = "PI";
    private static final String PROJECT_ROLE_COI = "COI";
    private static final Object PROPOSAL_YNQ_QUESTION_17 = "17";
    private static final int BUDGET_PERIOD_5 = 5;
    private static final String BUDGET_PERIOD_TYPE_4 = "4";
    private static final String BUDGET_PERIOD_TYPE_2 = "2";
    private static final String BUDGET_PERIOD_TYPE_3 = "3";
    private static final BigDecimal POINT_ZERO_ONE = new ScaleTwoDecimal(0.01).bigDecimalValue();
    public static final String EB_ON_LA = "3";
    public static final String VACATION_ON_LA = "2";
    public static final String CATEGORY_PERSONNEL = "P";
    public static final String SENIOR_PERSONNEL_CATEGORY_CODE = "01";
    @Autowired
    @Qualifier(value="awardService")
    private AwardService awardService;
    @Autowired
    @Qualifier(value="parameterService")
    protected ParameterService parameterService;
    @Autowired
    @Qualifier(value="proposalTypeService")
    private ProposalTypeService proposalTypeService;
    @Autowired
    @Qualifier(value="organizationRepositoryService")
    private OrganizationRepositoryService organizationRepositoryService;
    @Autowired
    @Qualifier(value="submissionInfoService")
    private SubmissionInfoService submissionInfoService;
    @Autowired
    @Qualifier(value="unitService")
    private UnitService unitService;
    private ScaleTwoDecimal cumulativeCalendarMonthsFunded = ScaleTwoDecimal.ZERO;

    @Override
    public Class<ResearchAndRelatedProjectDocument> type() {
        return ResearchAndRelatedProjectDocument.class;
    }

    @Override
    public Map<String, ResearchAndRelatedProjectDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        DevelopmentProposal developmentProposal = (DevelopmentProposal)printableBusinessObject;
        Budget budget = this.getBudget(developmentProposal.getProposalDocument());
        ResearchAndRelatedProjectDocument researchAndRelatedProjectDocument = (ResearchAndRelatedProjectDocument)ResearchAndRelatedProjectDocument.Factory.newInstance();
        researchAndRelatedProjectDocument.setResearchAndRelatedProject(this.getResearchAndRelatedProject(developmentProposal, budget));
        LinkedHashMap<String, ResearchAndRelatedProjectDocument> xmlObjectList = new LinkedHashMap<String, ResearchAndRelatedProjectDocument>();
        xmlObjectList.put("Research and Related", researchAndRelatedProjectDocument);
        return xmlObjectList;
    }

    protected Award getAward(String currentAwardNumber) {
        List<Award> awards = this.getAwardService().findAwardsForAwardNumber(currentAwardNumber);
        return awards.isEmpty() ? null : awards.get(awards.size() - 1);
    }

    protected AwardAmountInfo getMaxAwardAmountInfo(Award award) {
        Integer highestSequenceNumber = 0;
        Long highestAwardAmountInfoId = 0L;
        AwardAmountInfo higeshSequenceAwarAmountInfo = null;
        for (AwardAmountInfo amountInfo : award.getAwardAmountInfos()) {
            if (highestSequenceNumber < amountInfo.getSequenceNumber()) {
                higeshSequenceAwarAmountInfo = amountInfo;
                highestSequenceNumber = amountInfo.getSequenceNumber();
                highestAwardAmountInfoId = amountInfo.getAwardAmountInfoId();
                continue;
            }
            if (!highestSequenceNumber.equals(amountInfo.getSequenceNumber()) || highestAwardAmountInfoId >= amountInfo.getAwardAmountInfoId()) continue;
            higeshSequenceAwarAmountInfo = amountInfo;
            highestSequenceNumber = amountInfo.getSequenceNumber();
            highestAwardAmountInfoId = amountInfo.getAwardAmountInfoId();
        }
        return higeshSequenceAwarAmountInfo;
    }

    private ResearchAndRelatedProjectDocument.ResearchAndRelatedProject getResearchAndRelatedProject(DevelopmentProposal developmentProposal, Budget budget) {
        AwardAmountInfo amountInfo;
        ResearchAndRelatedProjectDocument.ResearchAndRelatedProject researchAndRelatedProject = (ResearchAndRelatedProjectDocument.ResearchAndRelatedProject)ResearchAndRelatedProjectDocument.ResearchAndRelatedProject.Factory.newInstance();
        researchAndRelatedProject.setProjectDescription(this.getProjectDescription(developmentProposal));
        researchAndRelatedProject.setOrgAssurances(this.getOrgAssurances(developmentProposal));
        researchAndRelatedProject.setAbstractArray(this.getAbstractArray(developmentProposal));
        researchAndRelatedProject.setProposalPersonArray(this.getProposalPersonArray(developmentProposal, budget));
        researchAndRelatedProject.setKeyPersonArray(this.getKeyPersonArray(developmentProposal));
        researchAndRelatedProject.setNSFPreviousAwardNumber(this.getNSFPreviousAwardNumber(developmentProposal));
        researchAndRelatedProject.setNSFProjectDuration(this.getNSFProjectDuration(developmentProposal));
        researchAndRelatedProject.setNihInventions(this.getNihInventions(developmentProposal));
        Award award = null;
        if (developmentProposal.getCurrentAwardNumber() != null) {
            award = this.getAward(developmentProposal.getCurrentAwardNumber());
        }
        if (award != null && (amountInfo = this.getMaxAwardAmountInfo(award)) != null) {
            if (amountInfo.getCurrentFundEffectiveDate() != null) {
                Calendar totalProjectStartDate = Calendar.getInstance();
                totalProjectStartDate.setTime(amountInfo.getCurrentFundEffectiveDate());
                researchAndRelatedProject.setTotalProjectStartDt(totalProjectStartDate);
            }
            if (amountInfo.getFinalExpirationDate() != null) {
                Calendar totalProjectEndDate = Calendar.getInstance();
                totalProjectEndDate.setTime(amountInfo.getFinalExpirationDate());
                researchAndRelatedProject.setTotalProjectEndDt(totalProjectEndDate);
            }
        }
        this.setNIHDeatils(researchAndRelatedProject, developmentProposal);
        researchAndRelatedProject.setResearchCoverPage(this.getResearchCoverPage(developmentProposal, budget));
        researchAndRelatedProject.setBudgetSummary(this.getBudgetSummary(budget, developmentProposal));
        return researchAndRelatedProject;
    }

    protected boolean isProposalTypeRenewalRevisionContinuation(String proposalTypeCode) {
        return this.getProposalTypeService().isProposalTypeRenewalRevisionContinuation(proposalTypeCode);
    }

    private void setNIHDeatils(ResearchAndRelatedProjectDocument.ResearchAndRelatedProject researchAndRelatedProject, DevelopmentProposal developmentProposal) {
        String sponsorAwardNumber;
        String currentAwardNumber;
        Award award;
        String federalIdComesFromAwardStr;
        String proposalTypeCode = developmentProposal.getProposalTypeCode();
        String federalId = this.getSubmissionInfoService().getFederalId(developmentProposal.getProposalNumber());
        researchAndRelatedProject.setNihPriorGrantNumber(federalId);
        if (this.isProposalTypeRenewalRevisionContinuation(proposalTypeCode) && "Y".equalsIgnoreCase(federalIdComesFromAwardStr = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "FEDERAL_ID_COMES_FROM_CURRENT_AWARD")) && (award = this.getAward(currentAwardNumber = developmentProposal.getCurrentAwardNumber())) != null && (sponsorAwardNumber = award.getSponsorAwardNumber()) != null && sponsorAwardNumber.length() > 5) {
            String activityCode = sponsorAwardNumber.substring(2, 5);
            String awardType = sponsorAwardNumber.substring(0, 1);
            researchAndRelatedProject.setNihActivityCode(activityCode);
            researchAndRelatedProject.setNihApplicationTypeCode(awardType);
        }
    }

    private String getNihInventions(DevelopmentProposal developmentProposal) {
        String nihInventions = null;
        for (ProposalYnq proposalYnq : developmentProposal.getProposalYnqs()) {
            if (proposalYnq.getQuestionId() == null || !proposalYnq.getQuestionId().equals(PROPOSAL_YNQ_QUESTION_16)) continue;
            nihInventions = proposalYnq.getAnswer();
        }
        return nihInventions;
    }

    private BigInteger getNSFProjectDuration(DevelopmentProposal developmentProposal) {
        BigInteger projectDuration = null;
        if (developmentProposal.getRequestedEndDateInitial() != null && developmentProposal.getRequestedStartDateInitial() != null) {
            BigDecimal months = this.getMonthsBetweenDates(developmentProposal.getRequestedStartDateInitial(), developmentProposal.getRequestedEndDateInitial());
            projectDuration = months.toBigInteger();
        }
        return projectDuration;
    }

    private BigDecimal getMonthsBetweenDates(Date pFrom, Date pTo) {
        Calendar calendarStart = Calendar.getInstance();
        calendarStart.setTimeInMillis(pFrom.getTime());
        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.setTimeInMillis(pTo.getTime());
        int yd = 12 * (calendarEnd.get(1) - calendarStart.get(1));
        int md = calendarEnd.get(2) - calendarStart.get(2);
        int dd = calendarEnd.get(5) - calendarStart.get(5);
        if (dd >= 15) {
            ++md;
        }
        int result = yd + md;
        ScaleTwoDecimal projectDuration = new ScaleTwoDecimal(result);
        return projectDuration.bigDecimalValue().setScale(0);
    }

    private String getNSFPreviousAwardNumber(DevelopmentProposal developmentProposal) {
        String currentAwardNumber = developmentProposal.getCurrentAwardNumber();
        Award award = this.getAward(currentAwardNumber);
        if (award != null) {
            return award.getSponsorAwardNumber();
        }
        return null;
    }

    private AbstractType[] getAbstractArray(DevelopmentProposal developmentProposal) {
        ArrayList<AbstractType> abstractTypeList = new ArrayList<AbstractType>();
        for (ProposalAbstract proposalAbstract : developmentProposal.getProposalAbstracts()) {
            if (proposalAbstract.getAbstractType() == null) continue;
            try {
                AbstractType abstractType = (AbstractType)AbstractType.Factory.newInstance();
                abstractType.setAbstractText(proposalAbstract.getAbstractDetails());
                BigInteger abstractTypeCode = new BigInteger(proposalAbstract.getAbstractType().getCode());
                abstractType.setAbstractTypeCode(abstractTypeCode);
                abstractType.setAbstractTypeDesc(proposalAbstract.getAbstractType().getDescription());
                abstractTypeList.add(abstractType);
            }
            catch (NumberFormatException e) {
                LOG.info("abstractTypeCode is Not a Number for proposal :" + developmentProposal.getProposalNumber());
            }
        }
        return abstractTypeList.toArray(new AbstractType[0]);
    }

    private ProposalPersonType[] getProposalPersonArray(DevelopmentProposal developmentProposal, Budget budget) {
        ArrayList<ProposalPersonType> proposalPersonTypeList = new ArrayList<ProposalPersonType>();
        List<ProposalPerson> proposalPersons = developmentProposal.getProposalPersons();
        for (ProposalPerson proposalPerson : proposalPersons) {
            proposalPersonTypeList.add(this.getProposalPersonTypeWithValues(developmentProposal, proposalPerson, budget));
        }
        return proposalPersonTypeList.toArray(new ProposalPersonType[0]);
    }

    private ProposalPersonType getProposalPersonTypeWithValues(DevelopmentProposal developmentProposal, ProposalPerson proposalPerson, Budget budget) {
        ProposalPersonType proposalPersonType = (ProposalPersonType)ProposalPersonType.Factory.newInstance();
        String degree = this.getDegree(proposalPerson);
        proposalPersonType.setDegree(degree);
        proposalPersonType.setGraduationYear(this.getGraduationYear(proposalPerson));
        proposalPersonType.setEmail(proposalPerson.getEmailAddress());
        proposalPersonType.setName(this.getProposalPersonFullNameType(proposalPerson));
        proposalPersonType.setPhone(proposalPerson.getPhoneNumber());
        if (PROJECT_ROLE_PI.equals(proposalPerson.getProposalPersonRoleId())) {
            proposalPersonType.setProjectRole(ProjectRoleType.PI_PD);
        } else if (PROJECT_ROLE_COI.equals(proposalPerson.getProposalPersonRoleId())) {
            proposalPersonType.setProjectRole(ProjectRoleType.CO_PI_PD);
        } else {
            proposalPersonType.setProjectRole(ProjectRoleType.KEY_PERSON);
        }
        proposalPersonType.setSSN(proposalPerson.getSocialSecurityNumber());
        if (proposalPerson.getDateOfBirth() != null) {
            proposalPersonType.setDOB(this.getDateTimeService().toDateString((Date)proposalPerson.getDateOfBirth()));
        }
        BigDecimal calendarMonths = ScaleTwoDecimal.ZERO.bigDecimalValue();
        BigDecimal academicMonths = ScaleTwoDecimal.ZERO.bigDecimalValue();
        BigDecimal summerMonths = ScaleTwoDecimal.ZERO.bigDecimalValue();
        if (budget != null) {
            for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                if (budgetPeriod.getBudgetPeriod() != 1) continue;
                for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                    for (BudgetPersonnelDetails budgetPersonnelDetails : lineItem.getBudgetPersonnelDetailsList()) {
                        if ((proposalPerson.getPersonId() == null || !proposalPerson.getPersonId().equals(budgetPersonnelDetails.getPersonId())) && (proposalPerson.getRolodexId() == null || !proposalPerson.getRolodexId().toString().equals(budgetPersonnelDetails.getPersonId()))) continue;
                        proposalPersonType.setPercentEffort(budgetPersonnelDetails.getPercentEffort().bigDecimalValue());
                        proposalPersonType.setRequestedCost(budgetPersonnelDetails.getSalaryRequested().bigDecimalValue());
                        if ("2".equals(budgetPersonnelDetails.getPeriodTypeCode())) {
                            academicMonths = academicMonths.add(budgetPersonnelDetails.getPercentEffort().bigDecimalValue().multiply(POINT_ZERO_ONE).multiply(this.getNumberOfMonths(budgetPersonnelDetails.getStartDate(), budgetPersonnelDetails.getEndDate()).bigDecimalValue()));
                            continue;
                        }
                        if ("3".equals(budgetPersonnelDetails.getPeriodTypeCode())) {
                            calendarMonths = calendarMonths.add(budgetPersonnelDetails.getPercentEffort().bigDecimalValue().multiply(POINT_ZERO_ONE).multiply(this.getNumberOfMonths(budgetPersonnelDetails.getStartDate(), budgetPersonnelDetails.getEndDate()).bigDecimalValue()));
                            continue;
                        }
                        summerMonths = summerMonths.add(budgetPersonnelDetails.getPercentEffort().bigDecimalValue().multiply(POINT_ZERO_ONE).multiply(this.getNumberOfMonths(budgetPersonnelDetails.getStartDate(), budgetPersonnelDetails.getEndDate()).bigDecimalValue()));
                    }
                }
            }
        }
        proposalPersonType.setAcademicFundingMonths(academicMonths.setScale(2, RoundingMode.HALF_UP));
        proposalPersonType.setSummerFundingMonths(summerMonths.setScale(2, RoundingMode.HALF_UP));
        proposalPersonType.setFundingMonths(calendarMonths.setScale(2, RoundingMode.HALF_UP));
        return proposalPersonType;
    }

    private String getDegree(ProposalPerson proposalPerson) {
        List<ProposalPersonDegree> proposalPersonDegrees = proposalPerson.getProposalPersonDegrees();
        return proposalPersonDegrees.stream().map(ProposalPersonDegree::getDegree).collect(Collectors.joining(","));
    }

    private String getGraduationYear(ProposalPerson proposalPerson) {
        List<ProposalPersonDegree> proposalPersonDegrees = proposalPerson.getProposalPersonDegrees();
        return proposalPersonDegrees.stream().map(ProposalPersonDegree::getGraduationYear).collect(Collectors.joining(","));
    }

    private PersonFullNameType getProposalPersonFullNameType(ProposalPerson proposalPerson) {
        PersonFullNameType personFullNameType = (PersonFullNameType)PersonFullNameType.Factory.newInstance();
        personFullNameType.setFirstName(proposalPerson.getFirstName());
        personFullNameType.setLastName(proposalPerson.getLastName());
        personFullNameType.setMiddleName(proposalPerson.getMiddleName());
        return personFullNameType;
    }

    private KeyPersonType[] getKeyPersonArray(DevelopmentProposal developmentProposal) {
        ArrayList<ProposalPerson> propKeyPersons = new ArrayList<ProposalPerson>();
        ArrayList<ProposalPerson> propInvestigators = new ArrayList<ProposalPerson>();
        ArrayList<ProposalPerson> propPIs = new ArrayList<ProposalPerson>();
        for (ProposalPerson proposalPerson : developmentProposal.getProposalPersons()) {
            if (PROJECT_ROLE_PI.equals(proposalPerson.getProposalPersonRoleId())) {
                propPIs.add(proposalPerson);
                continue;
            }
            if ("KP".equals(proposalPerson.getProposalPersonRoleId())) {
                propKeyPersons.add(proposalPerson);
                continue;
            }
            propInvestigators.add(proposalPerson);
        }
        this.sortKeyPersonWithName(propPIs);
        this.sortKeyPersonWithName(propKeyPersons);
        this.sortKeyPersonWithName(propInvestigators);
        List<KeyPersonType> keyPersonPIList = this.getKeyPersonForPropInvestigator(developmentProposal, propPIs, true);
        List<KeyPersonType> keyPersonInvestigatorList = this.getKeyPersonForPropInvestigator(developmentProposal, propInvestigators, false);
        List<KeyPersonType> keyPersonKeyPersonList = this.getKeyPersonForPropKeyPerson(developmentProposal, propKeyPersons);
        ArrayList<KeyPersonType> allKeyPersonList = new ArrayList<KeyPersonType>();
        allKeyPersonList.addAll(keyPersonPIList);
        allKeyPersonList.addAll(keyPersonInvestigatorList);
        allKeyPersonList.addAll(keyPersonKeyPersonList);
        return allKeyPersonList.toArray(new KeyPersonType[0]);
    }

    private List<KeyPersonType> getKeyPersonForPropKeyPerson(DevelopmentProposal developmentProposal, List<ProposalPerson> proposalKeyPersons) {
        ArrayList<KeyPersonType> keyPersonlist = new ArrayList<KeyPersonType>();
        for (ProposalPerson proposalPerson : proposalKeyPersons) {
            KeyPersonType keyPersonType = (KeyPersonType)KeyPersonType.Factory.newInstance();
            PersonFullNameType personFullNameType = this.getPersonFullName(proposalPerson);
            keyPersonType.setName(personFullNameType);
            ContactInfoType contactInfoType = this.getContactInfoType(proposalPerson);
            keyPersonType.setContactInformation(contactInfoType);
            KeyPersonType.KeyPersonFlag keyPersonFlag = this.getKeyPersonFlag(proposalPerson);
            keyPersonType.setKeyPersonFlag(keyPersonFlag);
            keyPersonType.setSocialSecurityNumber(proposalPerson.getSocialSecurityNumber());
            String unitName = this.getUnitName(proposalPerson);
            if (unitName != null) {
                keyPersonType.setOrganizationDepartment(unitName);
            }
            keyPersonType.setOrganizationName(developmentProposal.getApplicantOrganization().getLocationName());
            if (proposalPerson.getPrimaryTitle() != null) {
                keyPersonType.setPositionTitle(proposalPerson.getPrimaryTitle());
            }
            this.setBiographicalSketch(proposalPerson, keyPersonType);
            keyPersonType.setOrganizationDivision(this.getMajorSubDivision(this.getLeadUnit(developmentProposal)));
            this.setDegree(proposalPerson, keyPersonType);
            if (proposalPerson.getEraCommonsUserName() == null) {
                keyPersonType.setAccountIdentifier("Unknown");
            } else {
                keyPersonType.setAccountIdentifier(proposalPerson.getEraCommonsUserName());
            }
            keyPersonlist.add(keyPersonType);
        }
        return keyPersonlist;
    }

    private void setBiographicalSketch(ProposalPerson proposalPerson, KeyPersonType keyPersonType) {
        KeyPersonBiosketchType keyPersonBioSketch = keyPersonType.addNewNIHBiographicalSketch();
        keyPersonBioSketch.setResearchSupportFileIdentifier("researchfilename");
        keyPersonBioSketch.setPositionsHonorsCitationsFileIdentifier("honorsfilename");
    }

    private void setDegree(ProposalPerson proposalPerson, KeyPersonType keyPersonType) {
        List<ProposalPersonDegree> proposalPersonDegrees = proposalPerson.getProposalPersonDegrees();
        for (ProposalPersonDegree proposalPersonDegree : proposalPersonDegrees) {
            keyPersonType.addDegree(proposalPersonDegree.getDegree());
        }
    }

    private String getMajorSubDivision(String leadUnit) {
        Unit unit = this.unitService.getUnit(leadUnit);
        if (unit != null) {
            return unit.getParentUnitNumber();
        }
        return leadUnit;
    }

    private String getLeadUnit(DevelopmentProposal developmentProposal) {
        return developmentProposal.getOwnedByUnit().getUnitNumber();
    }

    private List<KeyPersonType> getKeyPersonForPropInvestigator(DevelopmentProposal developmentProposal, List<ProposalPerson> proposalPersonList, boolean piFlag) {
        ArrayList<KeyPersonType> keyPersonTypeList = new ArrayList<KeyPersonType>();
        for (ProposalPerson proposalPerson : proposalPersonList) {
            KeyPersonType keyPersonType = (KeyPersonType)KeyPersonType.Factory.newInstance();
            PersonFullNameType personFullNameType = this.getPersonFullName(proposalPerson);
            keyPersonType.setName(personFullNameType);
            ContactInfoType contactInfoType = this.getContactInfoType(proposalPerson);
            keyPersonType.setContactInformation(contactInfoType);
            this.setBiographicalSketch(proposalPerson, keyPersonType);
            KeyPersonType.KeyPersonFlag keyPersonFlag = this.getKeyPersonFlag(proposalPerson);
            if (piFlag) {
                keyPersonFlag.setKeyPersonFlagDesc(PROJECT_ROLE_PI);
            }
            keyPersonType.setKeyPersonFlag(keyPersonFlag);
            keyPersonType.setSocialSecurityNumber(proposalPerson.getSocialSecurityNumber());
            String unitName = this.getUnitName(proposalPerson);
            if (unitName != null) {
                keyPersonType.setOrganizationDepartment(unitName);
            }
            keyPersonType.setOrganizationName(developmentProposal.getApplicantOrganization().getLocationName());
            keyPersonType.setOrganizationDivision(this.getMajorSubDivision(this.getLeadUnit(developmentProposal)));
            if (proposalPerson.getPrimaryTitle() != null) {
                keyPersonType.setPositionTitle(proposalPerson.getPrimaryTitle());
            }
            this.setBiographicalSketch(proposalPerson, keyPersonType);
            keyPersonType.setOrganizationDivision(this.getMajorSubDivision(this.getLeadUnit(developmentProposal)));
            this.setDegree(proposalPerson, keyPersonType);
            if (proposalPerson.getEraCommonsUserName() == null) {
                keyPersonType.setAccountIdentifier("Unknown");
            } else {
                keyPersonType.setAccountIdentifier(proposalPerson.getEraCommonsUserName());
            }
            keyPersonTypeList.add(keyPersonType);
        }
        return keyPersonTypeList;
    }

    private BudgetSummaryType getBudgetSummary(Budget budget, DevelopmentProposal developmentProposal) {
        BudgetSummaryType budgetSummaryType = (BudgetSummaryType)BudgetSummaryType.Factory.newInstance();
        if (budget != null) {
            BudgetPeriod budgetPeriod = budget.getBudgetPeriod(0);
            budgetSummaryType.setInitialBudgetTotals(this.getBudgetTotals(budgetPeriod.getTotalCost(), budgetPeriod.getCostSharingAmount()));
            budgetSummaryType.setAllBudgetTotals(this.getBudgetTotals(budget.getTotalCost(), budget.getCostSharingAmount()));
            budgetSummaryType.setBudgetIndirectCostsTotal(budget.getTotalIndirectCost().bigDecimalValue());
            budgetSummaryType.setBudgetPeriodArray(this.getBudgetPeriodArray(developmentProposal, budget.getBudgetPeriods()));
            budgetSummaryType.setBudgetJustification(this.getBudgetJustification(developmentProposal.getProposalNumber()));
            this.setAllSeniorPersonnel(developmentProposal, budget, budgetSummaryType);
            this.setAllPersonnelTotals(developmentProposal, budget, budgetSummaryType);
            budgetSummaryType.setIndirectCostRateDetails(this.getIndirectCostDetails(developmentProposal));
            budgetSummaryType.setModularBudgetQuestion(budget.getModularBudgetFlag());
            budgetSummaryType.setBudgetCostsTotal(budget.getTotalCost().bigDecimalValue());
            budgetSummaryType.setBudgetDirectCostsTotal(budget.getTotalDirectCost().bigDecimalValue());
        }
        return budgetSummaryType;
    }

    private void setAllSeniorPersonnel(DevelopmentProposal developmentProposal, Budget budget, BudgetSummaryType budgetSummaryType) {
        List<KeyPersonInfo> nsfSeniorPersons = this.getBudgetPersonsForCategoryMap(developmentProposal, budget, SENIOR_PERSONNEL_CATEGORY_CODE, this.getCategoryMappingName(developmentProposal));
        int rowNumber = 0;
        for (KeyPersonInfo keyPersonInfo : nsfSeniorPersons) {
            NSFSeniorPersonnelType nsfSeniorPersonnel = budgetSummaryType.addNewNSFSeniorPersonnel();
            this.setNSFSeniorPersonnel(keyPersonInfo, nsfSeniorPersonnel, rowNumber++);
        }
    }

    private String getCategoryMappingName(DevelopmentProposal developmentProposal) {
        boolean isNih = this.getSponsorHierarchyService().isSponsorNihOsc(developmentProposal.getSponsorCode()) || this.getSponsorHierarchyService().isSponsorNihMultiplePi(developmentProposal.getSponsorCode());
        return isNih ? "NIH_PRINTING" : "NSF_PRINTING";
    }

    private void setAllPersonnelTotals(DevelopmentProposal developmentProposal, Budget budget, BudgetSummaryType budgetSummaryType) {
        String mappingName = this.getCategoryMappingName(developmentProposal);
        ScaleTwoDecimal totalFringe = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalSalary = ScaleTwoDecimal.ZERO;
        HashMap<String, String> categoryMap = new HashMap<String, String>();
        categoryMap.put("mappingName", mappingName);
        List<BudgetCategoryMapping> budgetCategoryList = this.getBudgetCategoryMappings(categoryMap);
        List budgetPersonnelDetailsList = budget.getBudgetPeriods().stream().flatMap(budgetPeriod -> budgetPeriod.getBudgetLineItems().stream()).filter(budgetLineItem -> budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode().equalsIgnoreCase(CATEGORY_PERSONNEL)).filter(budgetLineItem -> budgetCategoryList.stream().anyMatch(categoryMapping -> categoryMapping.getBudgetCategoryCode().equals(budgetLineItem.getBudgetCategoryCode()))).flatMap(budgetLineItem -> budgetLineItem.getBudgetPersonnelDetailsList().stream()).collect(Collectors.toList());
        for (BudgetPersonnelDetails budgetPersonnelDetails : budgetPersonnelDetailsList) {
            totalFringe = (ScaleTwoDecimal)totalFringe.add((AbstractDecimal)budgetPersonnelDetails.getCalculatedFringe());
            totalSalary = (ScaleTwoDecimal)totalSalary.add((AbstractDecimal)budgetPersonnelDetails.getSalaryRequested());
        }
        budgetSummaryType.setTotalFringe(totalFringe.bigDecimalValue());
        budgetSummaryType.setTotalSalariesAndWages(totalSalary.bigDecimalValue());
        budgetSummaryType.setTotalSalariesWagesAndFringe(totalSalary.bigDecimalValue().add(totalFringe.bigDecimalValue()));
    }

    private BudgetSummaryType.IndirectCostRateDetails getIndirectCostDetails(DevelopmentProposal developmentProposal) {
        BudgetSummaryType.IndirectCostRateDetails indirectCost = (BudgetSummaryType.IndirectCostRateDetails)BudgetSummaryType.IndirectCostRateDetails.Factory.newInstance();
        String dhhsAgreementFlag = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "DHHS_AGREEMENT");
        Organization orgBean = developmentProposal.getApplicantOrganization().getOrganization();
        try {
            if (dhhsAgreementFlag.equals("0")) {
                BudgetSummaryType.IndirectCostRateDetails.NoDHHSAgreement noAgreement = (BudgetSummaryType.IndirectCostRateDetails.NoDHHSAgreement)BudgetSummaryType.IndirectCostRateDetails.NoDHHSAgreement.Factory.newInstance();
                noAgreement.setAgencyName(this.getCognizantFedAgency(developmentProposal));
                if (orgBean.getIndirectCostRateAgreement() == null) {
                    noAgreement.setAgreementDate(this.getDateTimeService().getCalendar(this.getDateTimeService().convertToDate("1900-01-01")));
                } else {
                    noAgreement.setAgreementDate(this.getDateTimeService().getCalendar(this.getDateTimeService().convertToDate(orgBean.getIndirectCostRateAgreement())));
                }
                indirectCost.setNoDHHSAgreement(noAgreement);
            } else if (orgBean.getIndirectCostRateAgreement() != null) {
                indirectCost.setDHHSAgreementDate(this.getDateTimeService().getCalendar(this.getDateTimeService().convertToDate(orgBean.getIndirectCostRateAgreement())));
            } else {
                indirectCost.setDHHSAgreementNegotiationOffice(this.getCognizantFedAgency(developmentProposal));
            }
        }
        catch (ParseException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return indirectCost;
    }

    private String getCognizantFedAgency(DevelopmentProposal developmentProposal) {
        StringBuilder fedAgency = new StringBuilder();
        ProposalSite applicantOrganization = developmentProposal.getApplicantOrganization();
        if (applicantOrganization != null && applicantOrganization.getOrganization() != null && applicantOrganization.getOrganization().getCognizantAuditor() != null) {
            fedAgency.append(this.organizationRepositoryService.getCognizantFedAgency(applicantOrganization.getOrganization()));
        }
        if (fedAgency.toString().length() == 0) {
            fedAgency.append("Unknown");
        }
        return fedAgency.toString();
    }

    private int setNSFSeniorPersonnels(DevelopmentProposal developmentProposal, BudgetPeriod budgetPeriod, BudgetSummaryType.BudgetPeriod BudgetPeriodType2) {
        List<KeyPersonInfo> nsfSeniorPersons = this.getBudgetPersonsForCategoryMap(developmentProposal, budgetPeriod, SENIOR_PERSONNEL_CATEGORY_CODE, this.getCategoryMappingName(developmentProposal));
        int rowNumber = 0;
        int period = budgetPeriod.getBudgetPeriod();
        for (KeyPersonInfo keyPersonInfo : nsfSeniorPersons) {
            this.setNSFSeniorPersonnel(keyPersonInfo, BudgetPeriodType2.addNewNSFSeniorPersonnel(), rowNumber++, period);
        }
        return rowNumber;
    }

    public void setNSFSeniorPersonnel(KeyPersonInfo seniorPersonnelBean, NSFSeniorPersonnelType nsfSeniorPersonnelType, int rowNumber, int period) {
        if (period <= 5) {
            this.cumulativeCalendarMonthsFunded = (ScaleTwoDecimal)this.cumulativeCalendarMonthsFunded.add((AbstractDecimal)seniorPersonnelBean.getCalendarMonths());
        }
        nsfSeniorPersonnelType.setFullName(this.getFullName(seniorPersonnelBean));
        nsfSeniorPersonnelType.setTitle(seniorPersonnelBean.getRole());
        nsfSeniorPersonnelType.setAcademicMonthsFunded(seniorPersonnelBean.getAcademicMonths().bigDecimalValue());
        nsfSeniorPersonnelType.setCalendarMonthsFunded(seniorPersonnelBean.getCalendarMonths().bigDecimalValue());
        nsfSeniorPersonnelType.setSummerMonthsFunded(seniorPersonnelBean.getSummerMonths().bigDecimalValue());
        nsfSeniorPersonnelType.setFundsRequested(seniorPersonnelBean.getRequestedSalary().bigDecimalValue());
        nsfSeniorPersonnelType.setPersonID(seniorPersonnelBean.getPersonId());
        nsfSeniorPersonnelType.setRownumber(BigInteger.valueOf(rowNumber));
    }

    public void setNSFSeniorPersonnel(KeyPersonInfo seniorPersonnelBean, NSFSeniorPersonnelType nsfSeniorPersonnelType, int rowNumber) {
        nsfSeniorPersonnelType.setFullName(this.getFullName(seniorPersonnelBean));
        nsfSeniorPersonnelType.setTitle(seniorPersonnelBean.getRole());
        nsfSeniorPersonnelType.setAcademicMonthsFunded(seniorPersonnelBean.getAcademicMonths().bigDecimalValue());
        nsfSeniorPersonnelType.setCalendarMonthsFunded(seniorPersonnelBean.getCalendarMonths().bigDecimalValue());
        nsfSeniorPersonnelType.setSummerMonthsFunded(seniorPersonnelBean.getSummerMonths().bigDecimalValue());
        nsfSeniorPersonnelType.setFundsRequested(seniorPersonnelBean.getRequestedSalary().bigDecimalValue());
        nsfSeniorPersonnelType.setPersonID(seniorPersonnelBean.getPersonId());
        nsfSeniorPersonnelType.setRownumber(BigInteger.valueOf(rowNumber));
        this.cumulativeCalendarMonthsFunded = ScaleTwoDecimal.ZERO;
    }

    private String getFullName(KeyPersonInfo seniorPersonnelBean) {
        return seniorPersonnelBean.getLastName() + ", " + seniorPersonnelBean.getFirstName();
    }

    private BudgetSummaryType.BudgetPeriod[] getBudgetPeriodArray(DevelopmentProposal developmentProposal, List<BudgetPeriod> budgetPeriodList) {
        ArrayList<BudgetSummaryType.BudgetPeriod> budgetPeriods = new ArrayList<BudgetSummaryType.BudgetPeriod>();
        for (BudgetPeriod budgetPeriod : budgetPeriodList) {
            Budget budget = budgetPeriod.getBudget();
            if (budgetPeriod.getBudgetPeriod() == null) continue;
            List<BudgetLineItem> budgetLineItems = budgetPeriod.getBudgetLineItems();
            BudgetSummaryType.BudgetPeriod budgetPeriodType = (BudgetSummaryType.BudgetPeriod)BudgetSummaryType.BudgetPeriod.Factory.newInstance();
            budgetPeriodType.setBudgetPeriodID(BigInteger.valueOf(budgetPeriod.getBudgetPeriod().intValue()));
            budgetPeriodType.setStartDate(this.getDateTimeService().getCalendar((Date)budgetPeriod.getStartDate()));
            budgetPeriodType.setEndDate(this.getDateTimeService().getCalendar((Date)budgetPeriod.getEndDate()));
            budgetPeriodType.setFee(new BigDecimal(0));
            this.setSalaryAndWages(developmentProposal, budget, budgetPeriod, budgetPeriodType);
            budgetPeriodType.setEquipmentTotal(this.getEquipmentTotal(budgetLineItems));
            budgetPeriodType.setEquipmentCostsArray(this.getEquipmentCosts(budgetLineItems));
            budgetPeriodType.setOtherDirectCostsArray(this.getOtherDirectCosts(developmentProposal, budgetLineItems));
            this.setNonPersonnelLACost(budgetLineItems, budgetPeriodType);
            budgetPeriodType.setOtherDirectTotal(this.getOtherDirectTotal(budgetLineItems));
            budgetPeriodType.setTravelCostsArray(this.getTravelCosts(budgetLineItems));
            budgetPeriodType.setTravelTotal(this.getTravelTotal(budgetLineItems));
            budgetPeriodType.setParticipantPatientCostsArray(this.getParticipantPatientCost(developmentProposal, budgetLineItems));
            budgetPeriodType.setParticipantPatientTotal(this.getParticipantPatientTotal(budgetLineItems));
            budgetPeriodType.setNumberOfParticipants(BigInteger.valueOf(budgetPeriod.getNumberOfParticipants() == null ? 0L : (long)budgetPeriod.getNumberOfParticipants().intValue()));
            budgetPeriodType.setPeriodDirectCostsTotal(budgetPeriod.getTotalDirectCost().bigDecimalValue());
            budgetPeriodType.setIndirectCostsTotal(budgetPeriod.getTotalIndirectCost().bigDecimalValue());
            this.setIndirectCostDetails(budgetPeriod, budgetPeriodType);
            budgetPeriodType.setPeriodCostsTotal(budgetPeriod.getTotalCost().bigDecimalValue());
            budgetPeriodType.setProgramIncome(new BigDecimal(0));
            budgetPeriodType.setConsortiumCosts(this.getConsortiumCosts(developmentProposal, budgetPeriod));
            int count = this.setNSFSeniorPersonnels(developmentProposal, budgetPeriod, budgetPeriodType);
            budgetPeriodType.setNSFTotalSeniorPersonnel(BigInteger.valueOf(count));
            this.setNSFOtherPersonnels(developmentProposal, budgetPeriod, budgetPeriodType);
            this.setSalarySubTotals(budgetPeriod, budgetPeriodType);
            this.setProgramIncome(budgetPeriod, budgetPeriodType);
            budgetPeriods.add(budgetPeriodType);
        }
        return budgetPeriods.toArray(new BudgetSummaryType.BudgetPeriod[0]);
    }

    private void setIndirectCostDetails(BudgetPeriod budgetPeriod, BudgetSummaryType.BudgetPeriod budgetPeriodType) {
        Budget budget = budgetPeriod.getBudget();
        HashMap<CallSite, IndirectCostDetailsBean> ohAmountsMap = new HashMap<CallSite, IndirectCostDetailsBean>();
        if (budget.getModularBudgetFlag().booleanValue()) {
            BudgetModular budgetModular = budgetPeriod.getBudgetModular();
            List<BudgetModularIdc> budgetModularIdcs = budgetModular.getBudgetModularIdcs();
            Iterator iterator = budgetModularIdcs.iterator();
            while (iterator.hasNext()) {
                IndirectCostDetailsBean indcost;
                BudgetModularIdc budgetModularIdc = (BudgetModularIdc)iterator.next();
                String key = budgetModularIdc.getDescription() + budgetModularIdc.getIdcRate();
                if (ohAmountsMap.get(key) == null) {
                    indcost = new IndirectCostDetailsBean();
                    indcost.rate = budgetModularIdc.getIdcRate();
                    indcost.baseAmount = budgetModularIdc.getIdcBase();
                    indcost.fund = budgetModularIdc.getFundsRequested();
                    indcost.rateTypeDescription = budgetModularIdc.getDescription();
                    ohAmountsMap.put((CallSite)((Object)key), indcost);
                    continue;
                }
                indcost = (IndirectCostDetailsBean)ohAmountsMap.get(key);
                indcost.rate = (ScaleTwoDecimal)indcost.rate.add((AbstractDecimal)budgetModularIdc.getIdcRate());
                indcost.baseAmount = (ScaleTwoDecimal)indcost.baseAmount.add((AbstractDecimal)budgetModularIdc.getIdcBase());
                indcost.fund = (ScaleTwoDecimal)indcost.fund.add((AbstractDecimal)budgetModularIdc.getFundsRequested());
                indcost.rateTypeDescription = budgetModularIdc.getDescription();
            }
        } else {
            List<BudgetLineItem> budgetLineItems = budgetPeriod.getBudgetLineItems();
            for (BudgetLineItem budgetLineItem : budgetLineItems) {
                List<BudgetRateAndBase> budgetRateAndBases = budgetLineItem.getBudgetRateAndBaseList();
                for (BudgetRateAndBase budgetRateAndBase : budgetRateAndBases) {
                    IndirectCostDetailsBean indcost;
                    String key = budgetRateAndBase.getRateClassCode() + budgetRateAndBase.getRateTypeCode();
                    if (!budgetRateAndBase.getRateClass().getRateClassTypeCode().equals(RateClassType.OVERHEAD.getRateClassType())) continue;
                    if (ohAmountsMap.get(key) == null) {
                        indcost = new IndirectCostDetailsBean();
                        indcost.rate = budgetRateAndBase.getAppliedRate();
                        indcost.baseAmount = (ScaleTwoDecimal)budgetRateAndBase.getBaseCost().add((AbstractDecimal)budgetRateAndBase.getBaseCostSharing());
                        indcost.fund = (ScaleTwoDecimal)budgetRateAndBase.getCalculatedCost().add((AbstractDecimal)budgetRateAndBase.getCalculatedCostSharing());
                        indcost.rateTypeDescription = budgetRateAndBase.getRateClass().getRateClassType().getDescription();
                        ohAmountsMap.put((CallSite)((Object)key), indcost);
                        continue;
                    }
                    indcost = (IndirectCostDetailsBean)ohAmountsMap.get(key);
                    indcost.baseAmount = (ScaleTwoDecimal)((ScaleTwoDecimal)indcost.baseAmount.add((AbstractDecimal)budgetRateAndBase.getBaseCost())).add((AbstractDecimal)budgetRateAndBase.getBaseCostSharing());
                    indcost.fund = (ScaleTwoDecimal)((ScaleTwoDecimal)indcost.fund.add((AbstractDecimal)budgetRateAndBase.getCalculatedCost())).add((AbstractDecimal)budgetRateAndBase.getCalculatedCostSharing());
                }
            }
        }
        for (String key : ohAmountsMap.keySet()) {
            IndirectCostDetailsBean indirectCostDetailBean = (IndirectCostDetailsBean)ohAmountsMap.get(key);
            BudgetSummaryType.BudgetPeriod.IndirectCostDetails indDetailsType = budgetPeriodType.addNewIndirectCostDetails();
            indDetailsType.setCostType(indirectCostDetailBean.rateTypeDescription == null ? "UNKNOWN" : indirectCostDetailBean.rateTypeDescription);
            indDetailsType.setBaseAmount(indirectCostDetailBean.baseAmount.bigDecimalValue());
            indDetailsType.setRate(indirectCostDetailBean.rate.bigDecimalValue());
            indDetailsType.setFundsRequested(indirectCostDetailBean.fund.bigDecimalValue());
        }
    }

    private void setProgramIncome(BudgetPeriod budgetPeriod, BudgetPeriodType budgetPeriodType) {
        Budget budget = budgetPeriod.getBudget();
        List<BudgetProjectIncome> programIncomes = budget.getBudgetProjectIncomes();
        ScaleTwoDecimal totalProgIncome = ScaleTwoDecimal.ZERO;
        for (BudgetProjectIncome budgetProjectIncome : programIncomes) {
            if (!budgetProjectIncome.getBudgetPeriodNumber().equals(budgetPeriod.getBudgetPeriod())) continue;
            BudgetPeriodType.ProgramIncomeDetails progIncDetailsType = budgetPeriodType.addNewProgramIncomeDetails();
            progIncDetailsType.setAnticipatedAmount(budgetProjectIncome.getProjectIncome().bigDecimalValue());
            totalProgIncome = (ScaleTwoDecimal)totalProgIncome.add((AbstractDecimal)budgetProjectIncome.getProjectIncome());
            progIncDetailsType.setSources(budgetProjectIncome.getDescription());
        }
        budgetPeriodType.setProgramIncome(totalProgIncome.bigDecimalValue());
    }

    private BudgetSummaryType.BudgetPeriod.ConsortiumCosts getConsortiumCosts(DevelopmentProposal developmentProposal, BudgetPeriod budgetPeriod) {
        ProposalDevelopmentBudgetExt budget = (ProposalDevelopmentBudgetExt)budgetPeriod.getBudget();
        ScaleTwoDecimal consortiumDirectCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal consortiumIndirectCosts = ScaleTwoDecimal.ZERO;
        BudgetSummaryType.BudgetPeriod.ConsortiumCosts consortiumCost = (BudgetSummaryType.BudgetPeriod.ConsortiumCosts)BudgetSummaryType.BudgetPeriod.ConsortiumCosts.Factory.newInstance();
        if (budget.getModularBudgetFlag().booleanValue()) {
            BudgetModular budgetModular = budgetPeriod.getBudgetModular();
            consortiumDirectCost = budgetModular.getConsortiumFna();
        } else {
            String fnaGt25KParamValue = this.getParameterService().getParameterValueAsString(Budget.class, "SUBCONTRACTOR_F_AND_A_GT_25K");
            String fnaLt25KParamValue = this.getParameterService().getParameterValueAsString(Budget.class, "SUBCONTRACTOR_F_AND_A_LT_25K");
            String fnaBroadParamValue = this.getParameterService().getParameterValueAsString(Budget.class, "BROAD_F_AND_A");
            HashMap<String, String> categoryMap = new HashMap<String, String>();
            categoryMap.put("targetCategoryCode", "04");
            categoryMap.put("mappingName", this.getCategoryMappingName(developmentProposal));
            List<BudgetCategoryMapping> budgetCategoryList = this.getBudgetCategoryMappings(categoryMap);
            for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                for (BudgetCategoryMapping categoryMapping : budgetCategoryList) {
                    if (categoryMapping.getBudgetCategoryCode().equals(lineItem.getBudgetCategoryCode())) {
                        consortiumDirectCost = (ScaleTwoDecimal)consortiumDirectCost.add((AbstractDecimal)lineItem.getLineItemCost());
                    }
                    if (!lineItem.getCostElement().equals(fnaGt25KParamValue) && !lineItem.getCostElement().equals(fnaLt25KParamValue) && !lineItem.getCostElement().equals(fnaBroadParamValue)) continue;
                    consortiumIndirectCosts = (ScaleTwoDecimal)consortiumIndirectCosts.add((AbstractDecimal)lineItem.getLineItemCost());
                }
            }
        }
        consortiumCost.setDirectCosts(((ScaleTwoDecimal)consortiumDirectCost.subtract((AbstractDecimal)consortiumIndirectCosts)).bigDecimalValue());
        consortiumCost.setIndirectCosts(consortiumIndirectCosts.bigDecimalValue());
        return consortiumCost;
    }

    private void setNonPersonnelLACost(List<BudgetLineItem> budgetLineItems, BudgetSummaryType.BudgetPeriod budgetPeriodType) {
        ScaleTwoDecimal amount = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            List<BudgetLineItemCalculatedAmount> calcAmounts = budgetLineItem.getBudgetCalculatedAmounts();
            for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : calcAmounts) {
                budgetLineItemCalculatedAmount.refreshNonUpdateableReferences();
                if (!budgetLineItemCalculatedAmount.getRateClass().getRateClassTypeCode().equals(RateClassType.LAB_ALLOCATION.getRateClassType())) continue;
                amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)budgetLineItemCalculatedAmount.getCalculatedCost());
            }
        }
        if (amount.isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            OtherDirectCostsDocument.OtherDirectCosts otherDirectCost = budgetPeriodType.addNewOtherDirectCosts();
            otherDirectCost.setCost(amount.bigDecimalValue());
            otherDirectCost.setDescription("LA M&S and Utilities");
            otherDirectCost.setType("Other Direct Costs");
        }
    }

    private void setSalarySubTotals(BudgetPeriod budgetPeriod, BudgetSummaryType.BudgetPeriod budgetPeriodType) {
        BudgetSummaryType.BudgetPeriod.SalarySubtotals salSubTotals = budgetPeriodType.addNewSalarySubtotals();
        salSubTotals.setFringeBenefits(this.getTotalFringe(budgetPeriod).bigDecimalValue());
        salSubTotals.setSalaryRequested(this.getTotalSalaryRequested(budgetPeriod).bigDecimalValue());
        budgetPeriodType.setSalarySubtotals(salSubTotals);
    }

    private void setNSFOtherPersonnels(DevelopmentProposal developmentProposal, BudgetPeriod budgetPeriod, BudgetSummaryType.BudgetPeriod budgetPeriodType) {
        NSFOtherPersonnelType otherPersonnelType = budgetPeriodType.addNewNSFOtherPersonnel();
        String mappingName = this.getCategoryMappingName(developmentProposal);
        OtherPersonInfo otherPersonInfo = this.getOtherPersonInfo(budgetPeriod, mappingName, "01-Secretarial");
        otherPersonnelType.setClericalCount(BigInteger.valueOf(otherPersonInfo.getCount()));
        otherPersonnelType.setClericalFunds(otherPersonInfo.getFund().bigDecimalValue());
        otherPersonInfo = this.getOtherPersonInfo(budgetPeriod, mappingName, "01-Graduates");
        otherPersonnelType.setGradCount(BigInteger.valueOf(otherPersonInfo.getCount()));
        otherPersonnelType.setGradFunds(otherPersonInfo.getFund().bigDecimalValue());
        otherPersonInfo = this.getOtherPersonInfo(budgetPeriod, mappingName, "01-Other Profs");
        otherPersonnelType.setOtherProfCount(BigInteger.valueOf(otherPersonInfo.getCount()));
        otherPersonnelType.setOtherProfFunds(otherPersonInfo.getFund().bigDecimalValue());
        otherPersonInfo = this.getOtherPersonInfo(budgetPeriod, mappingName, "01-Undergrads");
        otherPersonnelType.setUnderGradCount(BigInteger.valueOf(otherPersonInfo.getCount()));
        otherPersonnelType.setUnderGradFunds(otherPersonInfo.getFund().bigDecimalValue());
        otherPersonInfo = this.getOtherPersonInfo(budgetPeriod, mappingName, "01-Other");
        otherPersonnelType.setOtherCount(BigInteger.valueOf(otherPersonInfo.getCount()));
        otherPersonnelType.setOtherFunds(otherPersonInfo.getFund().bigDecimalValue());
        otherPersonInfo = this.getOtherPersonInfo(budgetPeriod, mappingName, "01-PostDocs");
        otherPersonnelType.setPostDocCount(BigInteger.valueOf(otherPersonInfo.getCount()));
        otherPersonnelType.setPostDocFunds(otherPersonInfo.getFund().bigDecimalValue());
        otherPersonnelType.setOtherLAFunds(this.getOtherLAFunds(budgetPeriod));
    }

    private BigDecimal getOtherLAFunds(BudgetPeriod budgetPeriod) {
        ScaleTwoDecimal laAmount = ScaleTwoDecimal.ZERO;
        List<BudgetLineItem> budgetLineItems = budgetPeriod.getBudgetLineItems();
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode(), (CharSequence)CATEGORY_PERSONNEL)) continue;
            List<BudgetLineItemCalculatedAmount> calcAmounts = budgetLineItem.getBudgetLineItemCalculatedAmounts();
            for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : calcAmounts) {
                budgetLineItemCalculatedAmount.refreshNonUpdateableReferences();
                this.isEBorVacationOnLA(budgetLineItemCalculatedAmount);
                if (!RateClassType.LA_SALARIES.getRateClassType().equals(budgetLineItemCalculatedAmount.getRateClass().getRateClassTypeCode()) && !this.isEBorVacationOnLA(budgetLineItemCalculatedAmount)) continue;
                laAmount = (ScaleTwoDecimal)laAmount.add((AbstractDecimal)budgetLineItemCalculatedAmount.getCalculatedCost());
            }
        }
        return laAmount.bigDecimalValue();
    }

    protected boolean isEBorVacationOnLA(BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount) {
        return RateClassType.EMPLOYEE_BENEFITS.getRateClassType().equals(budgetLineItemCalculatedAmount.getRateClass().getRateClassTypeCode()) && budgetLineItemCalculatedAmount.getRateTypeCode().equalsIgnoreCase("3") || RateClassType.VACATION.getRateClassType().equals(budgetLineItemCalculatedAmount.getRateClass().getRateClassTypeCode()) && budgetLineItemCalculatedAmount.getRateTypeCode().equalsIgnoreCase("2");
    }

    private OtherPersonInfo getOtherPersonInfo(BudgetPeriod budgetPeriod, String categoryMappingName, String categoryCode) {
        HashMap<String, String> categoryMap = new HashMap<String, String>();
        categoryMap.put("targetCategoryCode", categoryCode);
        categoryMap.put("mappingName", categoryMappingName);
        List<BudgetCategoryMapping> budgetCategoryList = this.getBudgetCategoryMappings(categoryMap);
        OtherPersonInfo otherPersonInfo = new OtherPersonInfo();
        block0: for (BudgetCategoryMapping categoryMapping : budgetCategoryList) {
            for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                if (!categoryMapping.getBudgetCategoryCode().equals(lineItem.getBudgetCategoryCode())) continue;
                this.addOtherPersonInfo(otherPersonInfo, lineItem);
                continue block0;
            }
        }
        return otherPersonInfo;
    }

    private void addOtherPersonInfo(OtherPersonInfo otherPersonInfo, BudgetLineItem lineItem) {
        List<BudgetPersonnelDetails> budgetPersonnelDetailsList = lineItem.getBudgetPersonnelDetailsList();
        if (!budgetPersonnelDetailsList.isEmpty()) {
            for (BudgetPersonnelDetails budgetPersonnelDetails : budgetPersonnelDetailsList) {
                otherPersonInfo.setFund((ScaleTwoDecimal)otherPersonInfo.getFund().add((AbstractDecimal)budgetPersonnelDetails.getSalaryRequested()));
                otherPersonInfo.setCount(otherPersonInfo.getCount() + 1);
            }
        } else {
            otherPersonInfo.setFund((ScaleTwoDecimal)otherPersonInfo.getFund().add((AbstractDecimal)lineItem.getLineItemCost()));
            otherPersonInfo.setCount(otherPersonInfo.getCount() + 1);
        }
    }

    private boolean personExistsInProposal(DevelopmentProposal developmentProposal, BudgetPersonnelDetails budgetPersonnelDetails) {
        List<ProposalPerson> proposalPersons = developmentProposal.getProposalPersons();
        for (ProposalPerson proposalPerson : proposalPersons) {
            if (!this.getBudgetPersonService().proposalPersonEqualsBudgetPerson(proposalPerson, budgetPersonnelDetails)) continue;
            return true;
        }
        return false;
    }

    private void setSalaryAndWages(DevelopmentProposal developmentProposal, Budget budget, BudgetPeriod budgetPeriod, BudgetSummaryType.BudgetPeriod budgetPeriodType) {
        ArrayList<SalariesAndWagesType> salariesAndWagesTypeList = new ArrayList<SalariesAndWagesType>();
        List<BudgetLineItem> budgetLineItems = budgetPeriod.getBudgetLineItems();
        ScaleTwoDecimal totalSalary = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            for (BudgetPersonnelDetails budgetPersDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                budgetPersDetails.refreshReferenceObject("budgetPerson");
                BudgetPerson budgetPerson = budgetPersDetails.getBudgetPerson();
                if (budgetPerson == null) continue;
                SalariesAndWagesType salariesAndWagesType = this.getSalariesAndWagesType(developmentProposal, budget, budgetPersDetails, budgetPerson);
                totalSalary = (ScaleTwoDecimal)totalSalary.add((AbstractDecimal)new ScaleTwoDecimal(salariesAndWagesType.getSalaryAndFringeTotal()));
                salariesAndWagesTypeList.add(salariesAndWagesType);
            }
        }
        SalariesAndWagesType laSalariesAndWagesType = this.getLAAmmountsAsSalaryRecord(developmentProposal, budget, budgetPeriod);
        if (laSalariesAndWagesType != null) {
            totalSalary = (ScaleTwoDecimal)totalSalary.add((AbstractDecimal)new ScaleTwoDecimal(laSalariesAndWagesType.getSalaryAndFringeTotal()));
            salariesAndWagesTypeList.add(laSalariesAndWagesType);
        }
        budgetPeriodType.setSalariesWagesTotal(totalSalary.bigDecimalValue());
        budgetPeriodType.setSalariesAndWagesArray(salariesAndWagesTypeList.toArray(new SalariesAndWagesType[0]));
    }

    private SalariesAndWagesType getLAAmmountsAsSalaryRecord(DevelopmentProposal developmentProposal, Budget budget, BudgetPeriod budgetPeriod) {
        List<BudgetLineItem> budgetLineItems = budgetPeriod.getBudgetLineItems();
        ScaleTwoDecimal salaryRequested = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal fringe = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            List<BudgetLineItemCalculatedAmount> budgetLineItemCalcAmounts = budgetLineItem.getBudgetCalculatedAmounts();
            for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : budgetLineItemCalcAmounts) {
                if (budgetLineItemCalculatedAmount.getRateClass().getRateClassTypeCode().equals(RateClassType.LA_SALARIES.getRateClassType())) {
                    salaryRequested = (ScaleTwoDecimal)salaryRequested.add((AbstractDecimal)budgetLineItemCalculatedAmount.getCalculatedCost());
                }
                if ((!budgetLineItemCalculatedAmount.getRateClass().getRateClassTypeCode().equals(RateClassType.EMPLOYEE_BENEFITS.getRateClassType()) || !budgetLineItemCalculatedAmount.getRateTypeCode().equals("3")) && (!budgetLineItemCalculatedAmount.getRateClass().getRateClassTypeCode().equals(RateClassType.VACATION.getRateClassType()) || !budgetLineItemCalculatedAmount.getRateTypeCode().equals("2"))) continue;
                fringe = (ScaleTwoDecimal)fringe.add((AbstractDecimal)budgetLineItemCalculatedAmount.getCalculatedCost());
            }
        }
        if (salaryRequested.isZero()) {
            return null;
        }
        SalariesAndWagesType salariesAndWagesType = (SalariesAndWagesType)SalariesAndWagesType.Factory.newInstance();
        salariesAndWagesType.setName(this.getContactPersonFullName("Lab Allocation", "", ""));
        salariesAndWagesType.setRequestedCost(salaryRequested.bigDecimalValue());
        salariesAndWagesType.setFringeCost(fringe.bigDecimalValue());
        salariesAndWagesType.setSalaryAndFringeTotal(((ScaleTwoDecimal)salaryRequested.add((AbstractDecimal)fringe)).bigDecimalValue());
        return salariesAndWagesType;
    }

    private SalariesAndWagesType getSalariesAndWagesType(DevelopmentProposal developmentProposal, Budget budget, BudgetPersonnelDetails budgetPersDetails, BudgetPerson budgetPerson) {
        SalariesAndWagesType salariesAndWagesType;
        block2: {
            salariesAndWagesType = (SalariesAndWagesType)SalariesAndWagesType.Factory.newInstance();
            salariesAndWagesType.setAppointmentType(budgetPerson.getAppointmentTypeCode() == null ? "" : budgetPerson.getAppointmentTypeCode());
            salariesAndWagesType.setAppointmentMonths(new BigDecimal(budgetPerson.getAppointmentTypeCode() == null ? "" : budgetPerson.getAppointmentTypeCode()));
            salariesAndWagesType.setSummerFundingMonths(this.calculateFundingMonths(developmentProposal, budgetPersDetails, "4"));
            salariesAndWagesType.setAcademicFundingMonths(this.calculateFundingMonths(developmentProposal, budgetPersDetails, "2"));
            salariesAndWagesType.setFundingMonths(this.calculateFundingMonths(developmentProposal, budgetPersDetails, "3"));
            try {
                KcPerson person = budgetPerson.getPerson();
                salariesAndWagesType.setName(this.getContactPersonFullName(person.getLastName(), person.getFirstName(), person.getMiddleName()));
            }
            catch (IllegalArgumentException ie) {
                Rolodex rolodex = budgetPerson.getRolodex();
                if (rolodex == null) break block2;
                salariesAndWagesType.setName(this.getContactPersonFullName(rolodex.getLastName(), rolodex.getFirstName(), rolodex.getMiddleName()));
            }
        }
        salariesAndWagesType.setProjectRole(this.getProjectRoleType(developmentProposal, budgetPerson));
        salariesAndWagesType.setProjectRoleDescription(budgetPerson.getRole());
        salariesAndWagesType.setSalariesTotal(budgetPersDetails.getSalaryRequested().bigDecimalValue());
        BigDecimal fringe = this.getFringeCost(budgetPersDetails).bigDecimalValue();
        salariesAndWagesType.setFringeCost(fringe);
        salariesAndWagesType.setRequestedCost(budgetPersDetails.getSalaryRequested().bigDecimalValue());
        salariesAndWagesType.setBaseSalary(budgetPerson.getCalculationBase().bigDecimalValue());
        salariesAndWagesType.setSalaryAndFringeTotal(budgetPersDetails.getSalaryRequested().bigDecimalValue().add(fringe));
        return salariesAndWagesType;
    }

    private ResearchCoverPageDocument.ResearchCoverPage getResearchCoverPage(DevelopmentProposal developmentProposal, Budget budget) {
        ResearchCoverPageDocument.ResearchCoverPage researchCoverPage = (ResearchCoverPageDocument.ResearchCoverPage)ResearchCoverPageDocument.ResearchCoverPage.Factory.newInstance();
        developmentProposal.refreshNonUpdateableReferences();
        researchCoverPage.setSubmissionCategory(this.getSubmissionCategoryForResearchCoverPage(developmentProposal.getActivityType().getDescription(), developmentProposal.getProposalStateTypeCode()));
        researchCoverPage.setApplicationCategory(this.getApplicationCategoryForResearchCoverPage(developmentProposal.getProposalType().getDescription()));
        this.setApplicantSubmissionQualifiersForResearchCoverPage(developmentProposal, researchCoverPage.addNewApplicantSubmissionQualifiers());
        this.setFederalAgencyReceiptQualifiersForResearchCoverPage(developmentProposal, researchCoverPage.addNewFederalAgencyReceiptQualifiers());
        this.setStateReceiptQualifiersForResearchCoverPage(developmentProposal, researchCoverPage.addNewStateReceiptQualifiers());
        this.setStateIntergovernmentalReviewForResearchCoverPage(developmentProposal, researchCoverPage.addNewStateIntergovernmentalReview());
        this.setFederalDebtDelinquencyQuestionForResearchCoverPage(developmentProposal, researchCoverPage.addNewFederalDebtDelinquencyQuestions());
        researchCoverPage.setProjectDates(this.getProjectDatesForResearchCoverPage(developmentProposal.getRequestedStartDateInitial(), developmentProposal.getRequestedEndDateInitial()));
        researchCoverPage.setBudgetTotals(this.getBudgetTotalsForResearchCoverPage(budget));
        researchCoverPage.setProjectTitle(developmentProposal.getTitle() == null ? "Unknown" : developmentProposal.getTitle());
        researchCoverPage.setOtherAgencyQuestions(this.getOtherAgencyQuestionsForResearchCoverPage(developmentProposal));
        researchCoverPage.setApplicantOrganization(this.getApplicantOrganizationForResearchCoverPage(developmentProposal));
        researchCoverPage.setPrimaryProjectSite(this.getProjectSiteForResearchCoverPage(developmentProposal));
        researchCoverPage.setProgramDirectorPrincipalInvestigator(this.getProgramDirectorPrincipalInvestigatorForResearchCoverPage(developmentProposal));
        researchCoverPage.setFundingOpportunityDetails(this.getFundingOpportunityDetailsForResearchCoverPage(developmentProposal));
        researchCoverPage.setAuthorizedOrganizationalRepresentative(this.getAuthorizedOrganizationalRepresentative(developmentProposal));
        this.setAlternateProjectSites(developmentProposal, researchCoverPage);
        return researchCoverPage;
    }

    private void setAlternateProjectSites(DevelopmentProposal developmentProposal, ResearchCoverPageDocument.ResearchCoverPage researchCoverPage) {
        List<ProposalSite> otherOrganizations = developmentProposal.getOtherOrganizations();
        this.setPerformanceSites(researchCoverPage, otherOrganizations);
        List<ProposalSite> proposalSites = developmentProposal.getPerformanceSites();
        this.setPerformanceSites(researchCoverPage, proposalSites);
    }

    private void setPerformanceSites(ResearchCoverPageDocument.ResearchCoverPage researchCoverPage, List<ProposalSite> proposalSites) {
        for (ProposalSite proposalSite : proposalSites) {
            ProjectSiteType projectSiteType = researchCoverPage.addNewAlternateProjectSites();
            projectSiteType.setOrganizationName(proposalSite.getLocationName());
            this.setPostalAddressInfo(proposalSite, projectSiteType);
            List<CongressionalDistrict> congressionalDistricts = proposalSite.getCongressionalDistricts();
            String congrDistName = null;
            for (CongressionalDistrict congressionalDistrict : congressionalDistricts) {
                congrDistName = congrDistName == null ? congressionalDistrict.getCongressionalDistrict() : congrDistName + "," + congressionalDistrict.getCongressionalDistrict();
            }
            projectSiteType.setCongressionalDistrict(congrDistName);
        }
    }

    private void setPostalAddressInfo(ProposalSite proposalSite, ProjectSiteType projectSiteType) {
        PostalAddressType postalAddressType = projectSiteType.addNewPostalAddress();
        postalAddressType.setCity(proposalSite.getCity() == null || proposalSite.getCity().trim().equals("") ? "Unknown" : proposalSite.getCity());
        postalAddressType.setPostalCode(proposalSite.getPostalCode() == null || proposalSite.getPostalCode().trim().equals("") ? "Unknown" : proposalSite.getPostalCode());
        postalAddressType.setCountry(proposalSite.getCountryCode() == null || proposalSite.getCountryCode().trim().equals("") ? "Unknown" : proposalSite.getCountryCode());
        if (proposalSite.getState() != null) {
            postalAddressType.setState(proposalSite.getState());
        }
        if (proposalSite.getAddressLine1() != null) {
            XmlToken street = postalAddressType.addNewStreet();
            street.setStringValue(proposalSite.getAddressLine1());
        }
        if (proposalSite.getAddressLine2() != null) {
            XmlToken street2 = postalAddressType.addNewStreet();
            street2.setStringValue(proposalSite.getAddressLine2());
        }
        if (proposalSite.getAddressLine3() != null) {
            XmlToken street3 = postalAddressType.addNewStreet();
            street3.setStringValue(proposalSite.getAddressLine3());
        }
    }

    private AuthorizedOrganizationalRepresentativeType getAuthorizedOrganizationalRepresentative(DevelopmentProposal developmentProposal) {
        ProposalSite proposalSite = developmentProposal.getApplicantOrganization();
        Organization authorizedOrg = proposalSite.getOrganization();
        Rolodex rolodex = authorizedOrg.getRolodex();
        AuthorizedOrganizationalRepresentativeType authOrgRepType = (AuthorizedOrganizationalRepresentativeType)AuthorizedOrganizationalRepresentativeType.Factory.newInstance();
        if (authorizedOrg != null) {
            authOrgRepType.setPositionTitle(rolodex.getTitle());
            authOrgRepType.setContactInformation(this.getPersonContactInformation(proposalSite));
            authOrgRepType.setName(this.getContactPersonFullName(rolodex.getLastName(), rolodex.getFirstName(), rolodex.getMiddleName()));
        } else {
            authOrgRepType.setName(this.getContactPersonFullName("Unknown", "Unknown", "Unknown"));
            authOrgRepType.setPositionTitle("Unknown");
            authOrgRepType.setContactInformation(this.getOrganizationPersonContactInformationWithDefaultValues());
        }
        return authOrgRepType;
    }

    private FundingOpportunityDetailsType getFundingOpportunityDetailsForResearchCoverPage(DevelopmentProposal developmentProposal) {
        FundingOpportunityDetailsType fundingOpportunityType = (FundingOpportunityDetailsType)FundingOpportunityDetailsType.Factory.newInstance();
        String programAnnouncementNumber = developmentProposal.getProgramAnnouncementNumber();
        String programAnnouncementTitle = developmentProposal.getProgramAnnouncementTitle();
        fundingOpportunityType.setFundingOpportunityNumber(programAnnouncementNumber == null ? " " : programAnnouncementNumber);
        fundingOpportunityType.setFundingOpportunityTitle(programAnnouncementTitle == null ? " " : programAnnouncementTitle);
        fundingOpportunityType.setFundingOpportunityResponseCode(developmentProposal.getS2sOpportunity() != null);
        return fundingOpportunityType;
    }

    private ProgramDirectorPrincipalInvestigatorDocument.ProgramDirectorPrincipalInvestigator getProgramDirectorPrincipalInvestigatorForResearchCoverPage(DevelopmentProposal developmentProposal) {
        ProgramDirectorPrincipalInvestigatorDocument.ProgramDirectorPrincipalInvestigator principalInvestigatorType = (ProgramDirectorPrincipalInvestigatorDocument.ProgramDirectorPrincipalInvestigator)ProgramDirectorPrincipalInvestigatorDocument.ProgramDirectorPrincipalInvestigator.Factory.newInstance();
        ProposalPerson principalInvestigator = developmentProposal.getPrincipalInvestigator();
        if (principalInvestigator != null) {
            principalInvestigatorType.setContactInformation(this.getPersonContactInformation(principalInvestigator));
            principalInvestigatorType.setName(this.getContactPersonFullName(principalInvestigator.getLastName(), principalInvestigator.getFirstName(), principalInvestigator.getMiddleName()));
            if (principalInvestigator.getEraCommonsUserName() == null) {
                principalInvestigatorType.setAccountIdentifier("Unknown");
            } else {
                principalInvestigatorType.setAccountIdentifier(principalInvestigator.getEraCommonsUserName());
            }
            principalInvestigatorType.setNewInvestigatorQuestion(this.getNewInvestQuestion(developmentProposal));
            this.setDegree(principalInvestigator, principalInvestigatorType);
            SignatureType signatureType = principalInvestigatorType.addNewDirectorInvestigatorSignature();
            signatureType.setSignatureAuthentication("unknown");
            signatureType.setSignatureDate(this.getDateTimeService().getCurrentCalendar());
        }
        return principalInvestigatorType;
    }

    private void setDegree(ProposalPerson principalInvestigator, ProgramDirectorPrincipalInvestigatorDocument.ProgramDirectorPrincipalInvestigator principalInvestigatorType) {
        List<ProposalPersonDegree> proposalPersonDegrees = principalInvestigator.getProposalPersonDegrees();
        for (ProposalPersonDegree proposalPersonDegree : proposalPersonDegrees) {
            principalInvestigatorType.addDegree(proposalPersonDegree.getDegree());
        }
    }

    private boolean getNewInvestQuestion(DevelopmentProposal developmentProposal) {
        List<ProposalYnq> vecYNQQuestions = developmentProposal.getProposalYnqs();
        for (ProposalYnq proposalYnq : vecYNQQuestions) {
            if (!proposalYnq.getQuestionId().equals("13") || proposalYnq.getAnswer() == null || !proposalYnq.getAnswer().equals("Y")) continue;
            return true;
        }
        return false;
    }

    private ApplicantOrganizationType getApplicantOrganizationForResearchCoverPage(DevelopmentProposal developmentProposal) {
        ProposalSite applicantOrganization = developmentProposal.getApplicantOrganization();
        Organization organization = applicantOrganization.getOrganization();
        OrganizationType organizationType = organization.getOrganizationType(0);
        ApplicantOrganizationType applicantOrganizationType = (ApplicantOrganizationType)ApplicantOrganizationType.Factory.newInstance();
        applicantOrganizationType.setOrganizationName(applicantOrganization.getLocationName() == null ? "Unknown" : applicantOrganization.getLocationName());
        applicantOrganizationType.setOrganizationDUNS(organization.getDunsNumber() == null ? "Unknown" : organization.getDunsNumber());
        applicantOrganizationType.setOrganizationEIN((String)(organization.getFederalEmployerId() == null ? "Unknown" : SPECIAL_REVIEW_CODE_1 + organization.getFederalEmployerId() + "A1"));
        if (organization.getPhsAccount() != null) {
            applicantOrganizationType.setPHSAccountID(organization.getPhsAccount());
        }
        applicantOrganizationType.setOrganizationCategoryCode(organizationType == null ? "Unknown" : organizationType.getOrganizationTypeCode().toString());
        applicantOrganizationType.setOrganizationCategoryDescription(organizationType == null ? "Unknown" : organizationType.getOrganizationTypeList().getDescription());
        applicantOrganizationType.setOrganizationCongressionalDistrict(applicantOrganization.getFirstCongressionalDistrictName() == null ? "Unknown" : applicantOrganization.getFirstCongressionalDistrictName());
        applicantOrganizationType.setOrganizationAddress(this.getOrganizationAddress(applicantOrganization));
        applicantOrganizationType.setOrganizationContactPerson(this.getOrganizationContactPerson(developmentProposal.getApplicantOrganization()));
        String cageNumber = organization.getCageNumber();
        if (cageNumber != null) {
            applicantOrganizationType.setCageNumber(cageNumber);
        }
        ApplicantOrganizationType.OrganizationClassification orgClassification = applicantOrganizationType.addNewOrganizationClassification();
        List<OrganizationType> organizationTypes = organization.getOrganizationTypes();
        if (!organizationTypes.isEmpty()) {
            orgClassification.setCategoryCode(organizationTypes.get(0).getOrganizationTypeCode().toString());
            orgClassification.setSubCategoryCode(organizationTypes.get(0).getOrganizationTypeList().getDescription());
        }
        return applicantOrganizationType;
    }

    private String getUnitName(ProposalPerson proposalPerson) {
        String unitName = null;
        for (ProposalPersonUnit proposalPersonUnit : proposalPerson.getUnits()) {
            if (!proposalPersonUnit.isLeadUnit()) continue;
            Unit unit = proposalPersonUnit.getUnit();
            if (unit == null || unit.getUnitName() == null) break;
            unitName = unit.getUnitName();
            break;
        }
        return unitName;
    }

    private KeyPersonType.KeyPersonFlag getKeyPersonFlag(ProposalPerson proposalPerson) {
        KeyPersonType.KeyPersonFlag keyPersonFlag = (KeyPersonType.KeyPersonFlag)KeyPersonType.KeyPersonFlag.Factory.newInstance();
        keyPersonFlag.setKeyPersonFlagCode(DEFAULT_VALUE_KEY_PERSON_FLAG_CODE);
        keyPersonFlag.setKeyPersonFlagDesc(KEY_PERSON_FLAG_DESCRIPTION_VALUE_KEY_PERSON);
        return keyPersonFlag;
    }

    private ContactInfoType getContactInfoType(ProposalPerson proposalPerson) {
        ContactInfoType contactInfoType = (ContactInfoType)ContactInfoType.Factory.newInstance();
        contactInfoType.setEmail(proposalPerson.getEmailAddress());
        contactInfoType.setFaxNumber(proposalPerson.getFaxNumber());
        contactInfoType.setPhoneNumber(proposalPerson.getPhoneNumber());
        PostalAddressType postalAddressType = this.getPostalAddressType(proposalPerson);
        contactInfoType.setPostalAddress(postalAddressType);
        return contactInfoType;
    }

    private PostalAddressType getPostalAddressType(ProposalPerson proposalPerson) {
        PostalAddressType postalAddressType = (PostalAddressType)PostalAddressType.Factory.newInstance();
        postalAddressType.setCity(proposalPerson.getCity());
        postalAddressType.setCountry(proposalPerson.getCounty());
        postalAddressType.setPostalCode(proposalPerson.getPostalCode());
        postalAddressType.setState(proposalPerson.getState());
        return postalAddressType;
    }

    private PersonFullNameType getPersonFullName(ProposalPerson proposalPerson) {
        PersonFullNameType personFullNameType = (PersonFullNameType)PersonFullNameType.Factory.newInstance();
        personFullNameType.setFirstName(proposalPerson.getFirstName());
        personFullNameType.setLastName(proposalPerson.getLastName());
        personFullNameType.setMiddleName(proposalPerson.getMiddleName());
        return personFullNameType;
    }

    private OrgAssurancesType getOrgAssurances(DevelopmentProposal developmentProposal) {
        OrgAssurancesType orgAssurancesType = (OrgAssurancesType)OrgAssurancesType.Factory.newInstance();
        List<OrganizationYnq> organizationYnqs = null;
        Organization organization = this.getOrganizationFromDevelopmentProposal(developmentProposal);
        if (organization != null && organization.getOrganizationId() != null) {
            organizationYnqs = this.getOrganizationYNQ(organization.getOrganizationId());
        }
        if (organizationYnqs != null) {
            for (OrganizationYnq organizationYnq : organizationYnqs) {
                if (organizationYnq.getQuestionId().equals(LOBBYING_QUESTION_ID)) {
                    orgAssurancesType.setLobbyingQuestion(this.getAnswerFromOrganizationYnq(organizationYnq));
                }
                if (!organizationYnq.getQuestionId().equals(GENERAL_CERTIFICATION_QUESTION_ID)) continue;
                orgAssurancesType.setGeneralCertificationQuestion(this.getAnswerFromOrganizationYnq(organizationYnq));
            }
            orgAssurancesType.setDebarmentAndSuspension(this.getAssuranceType(organizationYnqs, ORGANIZATION_QUESTION_ID_I8));
            orgAssurancesType.setDrugFreeWorkplace(this.getAssuranceType(organizationYnqs, ORGANIZATION_QUESTION_ID_H5));
        }
        return orgAssurancesType;
    }

    private AssuranceType getAssuranceType(List<OrganizationYnq> organizationYnqs, String questionId) {
        AssuranceType assuranceType = (AssuranceType)AssuranceType.Factory.newInstance();
        for (OrganizationYnq organizationYnq : organizationYnqs) {
            if (!organizationYnq.getQuestionId().equals(questionId)) continue;
            assuranceType.setYesNoAnswer(this.getAnswerFromOrganizationYnq(organizationYnq));
            assuranceType.setExplanation(this.getExplanationFromOrganizationYnq(organizationYnq));
        }
        return assuranceType;
    }

    private String getExplanationFromOrganizationYnq(OrganizationYnq organizationYnq) {
        return organizationYnq.getExplanation() == null ? " " : organizationYnq.getExplanation();
    }

    private ProjectDescriptionDocument.ProjectDescription getProjectDescription(DevelopmentProposal developmentProposal) {
        ProjectDescriptionDocument.ProjectDescription projectDescription = (ProjectDescriptionDocument.ProjectDescription)ProjectDescriptionDocument.ProjectDescription.Factory.newInstance();
        projectDescription.setHumanSubject(this.getHumanSubjectsType(developmentProposal));
        projectDescription.setAnimalSubject(this.getAnimalSubject(developmentProposal));
        projectDescription.setProjectSurvey(this.getProjectSurvey(developmentProposal));
        projectDescription.setProjectSummary(this.getDescriptionBlockType(developmentProposal, PROJECT_SUMMARY_BLOCK_TYPE, true));
        projectDescription.setFacilitiesDescription(this.getDescriptionBlockType(developmentProposal, FACILITIES_BLOCK_TYPE, false));
        projectDescription.setEquipmentDescription(this.getDescriptionBlockType(developmentProposal, EQUIPMENT_BLOCK_TYPE, false));
        projectDescription.setReferences(this.getDescriptionBlockType(developmentProposal, REFERENCES_BLOCK_TYPE, true));
        return projectDescription;
    }

    private DescriptionBlockType getDescriptionBlockType(DevelopmentProposal developmentProposal, String blockType, boolean isFile) {
        DescriptionBlockType descriptionBlockType = (DescriptionBlockType)DescriptionBlockType.Factory.newInstance();
        if (isFile) {
            descriptionBlockType.setFileIdentifier(developmentProposal.getProposalNumber() + blockType);
        } else {
            descriptionBlockType.setText(blockType);
        }
        return descriptionBlockType;
    }

    private HumanSubjectsType getHumanSubjectsType(DevelopmentProposal developmentProposal) {
        HumanSubjectsType humanSubjectsType = (HumanSubjectsType)HumanSubjectsType.Factory.newInstance();
        String[] exemptionNumber = new String[6];
        List<ProposalSpecialReview> specialReviewList = developmentProposal.getPropSpecialReviews();
        int arrayIndex = 0;
        if (specialReviewList != null) {
            for (ProposalSpecialReview proposalSpecialReview : specialReviewList) {
                String comments;
                boolean humanSubjectsUsedQuestion = this.getHumanSubjectsUsedQuestion(proposalSpecialReview);
                humanSubjectsType.setHumanSubjectsUsedQuestion(humanSubjectsUsedQuestion);
                if (!proposalSpecialReview.getApprovalTypeCode().equals("4") && proposalSpecialReview.getApprovalDate() != null) {
                    humanSubjectsType.setIRBApprovalDate(this.getDateTimeService().getCalendar((Date)proposalSpecialReview.getApprovalDate()));
                    break;
                }
                exemptionNumber[arrayIndex] = comments = this.getSpecialReviewComments(proposalSpecialReview);
                ++arrayIndex;
            }
        }
        this.setEXemptionNumber(developmentProposal, humanSubjectsType, exemptionNumber);
        this.setPhase3ClinicalTrialQuestion(developmentProposal, humanSubjectsType);
        return humanSubjectsType;
    }

    private void setPhase3ClinicalTrialQuestion(DevelopmentProposal developmentProposal, HumanSubjectsType humanSubjectsType) {
        humanSubjectsType.setPhase3ClinicalTrialQuestion(false);
        String strAnswer = this.getClinicalTrialQuestion(developmentProposal);
        if (strAnswer != null) {
            humanSubjectsType.setPhase3ClinicalTrialQuestion(strAnswer.equals("Y"));
        }
    }

    private String getClinicalTrialQuestion(DevelopmentProposal developmentProposal) {
        String clinicalAnswer = "N";
        for (ProposalYnq proposalYnq : developmentProposal.getProposalYnqs()) {
            if (proposalYnq.getQuestionId() == null || !proposalYnq.getQuestionId().equals(PROPOSAL_YNQ_QUESTION_17)) continue;
            clinicalAnswer = proposalYnq.getAnswer();
        }
        return clinicalAnswer == null ? "N" : clinicalAnswer;
    }

    private boolean getHumanSubjectsUsedQuestion(ProposalSpecialReview proposalSpecialReview) {
        boolean humanSubjectsUsedQuestion = false;
        if (proposalSpecialReview.getSpecialReviewTypeCode() != null && proposalSpecialReview.getSpecialReviewTypeCode().equals(SPECIAL_REVIEW_CODE_1)) {
            humanSubjectsUsedQuestion = true;
        }
        return humanSubjectsUsedQuestion;
    }

    private void setEXemptionNumber(DevelopmentProposal developmentProposal, HumanSubjectsType humanSubjectsType, String[] exemptionNumber) {
        if (humanSubjectsType.getHumanSubjectsUsedQuestion()) {
            String humanSubAssurance = this.getHumanAssuranceNumber(developmentProposal);
            if (humanSubAssurance != null) {
                humanSubjectsType.setAssuranceNumber(humanSubAssurance);
            }
        } else {
            humanSubjectsType.setExemptionNumberArray(exemptionNumber);
        }
    }

    private String getSpecialReviewComments(ProposalSpecialReview proposalSpecialReview) {
        String comments = proposalSpecialReview.getComments() == null ? "Unknown" : proposalSpecialReview.getComments();
        return comments;
    }

    private String getHumanAssuranceNumber(DevelopmentProposal developmentProposal) {
        String humanSubAssurance = null;
        Organization organization = this.getOrganizationFromDevelopmentProposal(developmentProposal);
        if (organization != null && organization.getHumanSubAssurance() != null) {
            humanSubAssurance = organization.getHumanSubAssurance();
        }
        return humanSubAssurance;
    }

    private BigDecimal calculateFundingMonths(DevelopmentProposal developmentProposal, BudgetPersonnelDetails budgetPersonnelDetails, String budgetPeriodType) {
        BigDecimal fundingMonths = ScaleTwoDecimal.ZERO.bigDecimalValue();
        if (this.personExistsInProposal(developmentProposal, budgetPersonnelDetails) && budgetPeriodType.equals(budgetPersonnelDetails.getPeriodTypeCode())) {
            BigDecimal totalMonths = this.getMonthsBetweenDates(budgetPersonnelDetails.getStartDate(), budgetPersonnelDetails.getEndDate());
            fundingMonths = budgetPersonnelDetails.getPercentEffort().bigDecimalValue().multiply(new ScaleTwoDecimal(totalMonths).bigDecimalValue());
            fundingMonths = fundingMonths.divide(new ScaleTwoDecimal(100).bigDecimalValue(), RoundingMode.HALF_UP);
        }
        return fundingMonths.setScale(0, RoundingMode.HALF_UP);
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ProposalTypeService getProposalTypeService() {
        return this.proposalTypeService;
    }

    public void setProposalTypeService(ProposalTypeService proposalTypeService) {
        this.proposalTypeService = proposalTypeService;
    }

    public OrganizationRepositoryService getOrganizationRepositoryService() {
        return this.organizationRepositoryService;
    }

    public void setOrganizationRepositoryService(OrganizationRepositoryService organizationRepositoryService) {
        this.organizationRepositoryService = organizationRepositoryService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public AwardService getAwardService() {
        return this.awardService;
    }

    public SubmissionInfoService getSubmissionInfoService() {
        return this.submissionInfoService;
    }

    public void setSubmissionInfoService(SubmissionInfoService submissionInfoService) {
        this.submissionInfoService = submissionInfoService;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    class OtherPersonInfo {
        ScaleTwoDecimal fund = ScaleTwoDecimal.ZERO;
        int count = 0;

        OtherPersonInfo() {
        }

        public ScaleTwoDecimal getFund() {
            return this.fund;
        }

        public void setFund(ScaleTwoDecimal fund) {
            this.fund = fund;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }

    class IndirectCostDetailsBean {
        private ScaleTwoDecimal baseAmount = ScaleTwoDecimal.ZERO;
        private ScaleTwoDecimal rate = ScaleTwoDecimal.ZERO;
        private ScaleTwoDecimal fund = ScaleTwoDecimal.ZERO;
        private String rateTypeDescription;

        IndirectCostDetailsBean() {
        }
    }
}

