/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.XfaForm;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.api.s2s.S2sFormConfigurationService;
import org.kuali.coeus.propdev.api.s2s.S2sUserAttachedFormFileContract;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.s2s.FormUtilityService;
import org.kuali.coeus.propdev.impl.s2s.S2sOppForms;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunity;
import org.kuali.coeus.propdev.impl.s2s.S2sUserAttachedForm;
import org.kuali.coeus.propdev.impl.s2s.S2sUserAttachedFormAtt;
import org.kuali.coeus.propdev.impl.s2s.S2sUserAttachedFormAttFile;
import org.kuali.coeus.propdev.impl.s2s.S2sUserAttachedFormFile;
import org.kuali.coeus.propdev.impl.s2s.S2sUserAttachedFormService;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReviewHumanSubjectsAttachmentService;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.FormGenerationResult;
import org.kuali.coeus.s2sgen.api.generate.FormGeneratorService;
import org.kuali.coeus.s2sgen.api.generate.FormMappingService;
import org.kuali.coeus.s2sgen.api.hash.GrantApplicationHashService;
import org.kuali.coeus.sys.api.model.KcFile;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Component(value="s2sUserAttachedFormService")
public class S2sUserAttachedFormServiceImpl
implements S2sUserAttachedFormService {
    private static final Logger LOG = LogManager.getLogger(S2sUserAttachedFormServiceImpl.class);
    private static final String XFA_NS = "http://www.xfa.org/schema/xfa-data/1.0/";
    private static final String USER_ATTACHED_FORMS_ERRORS = "userAttachedFormsErrors";
    private static final String UPLOADED_FILE_IS_EMPTY = "Uploaded file is empty";
    private static final String NOT_FILLABLE_FORM = "Uploaded file is not Grants.Gov fillable form";
    private static final String DATASETS = "datasets";
    private static final String DATA = "data";
    private static final String NOT_CONTAIN_ANY_DATA = "The pdf form does not contain any data.";
    private static final String HUMAN_SUBJECT_STUDY_V1_0_PDF_POPOUT_NAME = "HumanSubjectStudy-V1.0.pdf";
    private static final String HUMAN_SUBJECT_STUDY_V2_0_PDF_POPOUT_NAME = "HumanSubjectStudy_2_0-V2.0.pdf";
    private static final String HUMAN_SUBJECT_STUDY_V3_0_PDF_POPOUT_NAME = "HumanSubjectStudy_3_0-V3.0.pdf";
    private static final String HUMAN_SUBJECT_STUDY_V1_0_PDF_POPOUT_HASH = "rC1ImTK7IEQ3Usp3FmNf1HKuMDE=";
    private static final String HUMAN_SUBJECT_STUDY_V2_0_PDF_POPOUT_HASH = "bqBvcDllTDnUE/j0zVAzH4NLIC8=";
    private static final String HUMAN_SUBJECT_STUDY_V3_0_PDF_POPOUT_HASH = "+yE5fGO8l9G/xhhDUWHcsj7+P9k=";
    private static final String PHSHUMAN_SUBJECTS_AND_CLINICAL_TRIALS_INFO_V1_0 = "http://apply.grants.gov/forms/PHSHumanSubjectsAndClinicalTrialsInfo-V1.0";
    private static final String PHSHUMAN_SUBJECTS_AND_CLINICAL_TRIALS_INFO_V2_0 = "http://apply.grants.gov/forms/PHSHumanSubjectsAndClinicalTrialsInfo_2_0-V2.0";
    private static final String PHSHUMAN_SUBJECTS_AND_CLINICAL_TRIALS_INFO_V3_0 = "http://apply.grants.gov/forms/PHSHumanSubjectsAndClinicalTrialsInfo_3_0-V3.0";
    private static final String ATT = "ATT";
    private static final String HUMAN_SUBJECT_STUDY_V1_0 = "http://apply.grants.gov/forms/HumanSubjectStudy-V1.0";
    private static final String HUMAN_SUBJECT_STUDY_V2_0 = "http://apply.grants.gov/forms/HumanSubjectStudy_2_0-V2.0";
    private static final String HUMAN_SUBJECT_STUDY_V3_0 = "http://apply.grants.gov/forms/HumanSubjectStudy_3_0-V3.0";
    private static final String HUMAN_SUBJECT_STUDY_NODE_V1_0 = "HumanSubjectStudy";
    private static final String HUMAN_SUBJECT_STUDY_NODE_V2_0 = "HumanSubjectStudy_2_0";
    private static final String HUMAN_SUBJECT_STUDY_NODE_V3_0 = "HumanSubjectStudy_3_0";
    private static final String HUMAN_SUBJECT_STUDY_ATTACHMENT_NODE_V1_0 = "HumanSubjectStudyAttachment";
    private static final String HUMAN_SUBJECT_STUDY_ATTACHMENT_NODE_V2_0 = "HumanSubjectStudyAttachment";
    private static final String HUMAN_SUBJECT_STUDY_ATTACHMENT_NODE_V3_0 = "HumanSubjectStudyAttachment";
    private static final String HUMAN_SUBJECT_STUDY_CLINICAL_TRIALS_NODE_V1_0 = "PHSHumanSubjectsAndClinicalTrialsInfo";
    private static final String HUMAN_SUBJECT_STUDY_CLINICAL_TRIALS_NODE_V2_0 = "PHSHumanSubjectsAndClinicalTrialsInfo_2_0";
    private static final String HUMAN_SUBJECT_STUDY_CLINICAL_TRIALS_NODE_V3_0 = "PHSHumanSubjectsAndClinicalTrialsInfo_3_0";
    private static final String VERSION_1_0 = "1.0";
    private static final String VERSION_2_0 = "2.0";
    private static final String VERSION_3_0 = "3.0";
    @Autowired
    @Qualifier(value="formGeneratorService")
    private FormGeneratorService formGeneratorService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="s2sFormConfigurationService")
    private S2sFormConfigurationService s2sFormConfigurationService;
    @Autowired
    @Qualifier(value="formUtilityService")
    private FormUtilityService formUtilityService;
    @Autowired
    @Qualifier(value="formMappingService")
    private FormMappingService formMappingService;
    @Autowired
    @Qualifier(value="proposalSpecialReviewHumanSubjectsAttachmentService")
    private ProposalSpecialReviewHumanSubjectsAttachmentService proposalSpecialReviewHumanSubjectsAttachmentService;
    @Autowired
    @Qualifier(value="grantApplicationHashService")
    private GrantApplicationHashService grantApplicationHashService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<S2sUserAttachedForm> extractNSaveUserAttachedForms(ProposalDevelopmentDocument developmentProposal, S2sUserAttachedForm s2sUserAttachedForm) throws TransformerException, IOException, SAXException, ParserConfigurationException, XPathExpressionException {
        List<S2sUserAttachedForm> formBeans;
        try (PdfReader reader = null;){
            byte[] pdfFileContents = s2sUserAttachedForm.getNewFormFileBytes();
            if (pdfFileContents == null || pdfFileContents.length == 0) {
                S2SException s2sException = new S2SException("error.s2s.userattachedform.file.empty", UPLOADED_FILE_IS_EMPTY);
                s2sException.setTabErrorKey(USER_ATTACHED_FORMS_ERRORS);
                throw s2sException;
            }
            try {
                reader = new PdfReader(pdfFileContents);
            }
            catch (IOException ioex) {
                S2SException s2sException = new S2SException("error.s2s.userattachedform.not.pdf", NOT_FILLABLE_FORM, new String[]{ioex.getMessage()});
                s2sException.setTabErrorKey(USER_ATTACHED_FORMS_ERRORS);
                throw s2sException;
            }
            List<KcFile> attachments = this.doHumanStudiesAttachmentsWorkaroundV3(this.doHumanStudiesAttachmentsWorkaroundV2(this.doHumanStudiesAttachmentsWorkaroundV1(this.formUtilityService.extractAttachments(reader))));
            Collection<String> duplicates = CollectionUtils.findDuplicates(attachments, KcFile::getName);
            if (!duplicates.isEmpty()) {
                S2SException s2sException = new S2SException();
                s2sException.setErrorKey("error.s2s.form.dup.att");
                s2sException.setParams(new String[]{StringUtils.isNotBlank((CharSequence)s2sUserAttachedForm.getFormName()) ? s2sUserAttachedForm.getFormName() : "User Attached Form", String.join((CharSequence)", ", duplicates)});
                s2sException.setTabErrorKey(USER_ATTACHED_FORMS_ERRORS);
                throw s2sException;
            }
            formBeans = this.extractAndPopulateXml(developmentProposal, reader, s2sUserAttachedForm, attachments);
            this.setFormsAvailability(developmentProposal, formBeans);
        }
        return formBeans;
    }

    private void throwInvalidError() {
        S2SException s2sException = new S2SException("error.s2s.userattachedform.wrong.filetype", NOT_FILLABLE_FORM);
        s2sException.setTabErrorKey(USER_ATTACHED_FORMS_ERRORS);
        throw s2sException;
    }

    protected List<S2sUserAttachedForm> extractAndPopulateXml(ProposalDevelopmentDocument developmentProposal, PdfReader reader, S2sUserAttachedForm userAttachedForm, List<KcFile> attachments) throws TransformerException, IOException, SAXException, ParserConfigurationException, XPathExpressionException {
        Document document;
        Node grantApplicationElement;
        Element dataElement;
        Element datasetsElement;
        Element documentElement;
        ArrayList<S2sUserAttachedForm> formBeans = new ArrayList<S2sUserAttachedForm>();
        XfaForm xfaForm = reader.getAcroFields().getXfa();
        Document domDocument = xfaForm.getDomDocument();
        if (domDocument == null) {
            this.throwInvalidError();
        }
        if ((documentElement = domDocument.getDocumentElement()) == null) {
            this.throwInvalidError();
        }
        if ((datasetsElement = (Element)documentElement.getElementsByTagNameNS(XFA_NS, DATASETS).item(0)) == null) {
            this.throwInvalidError();
        }
        if ((dataElement = (Element)datasetsElement.getElementsByTagNameNS(XFA_NS, DATA).item(0)) == null) {
            this.throwInvalidError();
        }
        if ((grantApplicationElement = dataElement.getChildNodes().item(0)) == null) {
            S2SException s2sException = new S2SException("error.s2s.userattachedform.not.filled", NOT_CONTAIN_ANY_DATA);
            s2sException.setTabErrorKey(USER_ATTACHED_FORMS_ERRORS);
            throw s2sException;
        }
        byte[] serializedXML = XfaForm.serializeDoc((Node)grantApplicationElement);
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(serializedXML);){
            document = this.getFormUtilityService().createDomBuilder().parse(byteArrayInputStream);
        }
        if (document != null) {
            Element form;
            NodeList elements = document.getElementsByTagNameNS("http://apply.grants.gov/system/MetaGrantApplication", "Forms");
            Element element = (Element)elements.item(0);
            if (element != null) {
                NodeList formChildren = element.getChildNodes();
                int formsCount = formChildren.getLength();
                if (formsCount > 1) {
                    int selectedOptionalFormsCount;
                    NodeList selectedOptionalFormElements = document.getElementsByTagNameNS("http://apply.grants.gov/system/MetaGrantApplicationWrapper", "SelectedOptionalForms");
                    int n = selectedOptionalFormsCount = selectedOptionalFormElements == null ? 0 : selectedOptionalFormElements.getLength();
                    if (selectedOptionalFormsCount > 0) {
                        int selectedFormsCount;
                        Element selectedFormNode = (Element)selectedOptionalFormElements.item(0);
                        NodeList selectedForms = selectedFormNode.getElementsByTagNameNS("http://apply.grants.gov/system/MetaGrantApplicationWrapper", "FormTagName");
                        int n2 = selectedFormsCount = selectedForms == null ? 0 : selectedForms.getLength();
                        if (selectedFormsCount > 0) {
                            ArrayList<String> seletctedForms = new ArrayList<String>();
                            for (int j = 0; j < selectedFormsCount; ++j) {
                                Element selectedForm = (Element)selectedForms.item(j);
                                String formName = selectedForm.getTextContent();
                                seletctedForms.add(formName);
                            }
                            for (int i = 0; i < formsCount; ++i) {
                                form = (Element)formChildren.item(i);
                                String formNodeName = form.getLocalName();
                                if (!seletctedForms.contains(formNodeName)) continue;
                                this.addForm(developmentProposal, formBeans, form, userAttachedForm, attachments);
                            }
                        }
                    }
                } else {
                    form = (Element)formChildren.item(0);
                    this.addForm(developmentProposal, formBeans, form, userAttachedForm, attachments);
                }
            } else {
                form = document.getDocumentElement();
                this.addForm(developmentProposal, formBeans, form, userAttachedForm, attachments);
            }
        }
        return formBeans;
    }

    protected void addForm(ProposalDevelopmentDocument developmentProposal, List<S2sUserAttachedForm> formBeans, Element form, S2sUserAttachedForm userAttachedFormBean, List<KcFile> attachments) throws TransformerException, XPathExpressionException {
        S2sUserAttachedForm userAttachedForm = this.processForm(developmentProposal, form, userAttachedFormBean, attachments);
        if (userAttachedForm != null) {
            formBeans.add(userAttachedForm);
        }
    }

    private void validateForm(ProposalDevelopmentDocument developmentProposal, S2sUserAttachedForm userAttachedForm) throws S2SException {
        S2sOpportunity opportunity = developmentProposal.getDevelopmentProposal().getS2sOpportunity();
        if (opportunity != null) {
            List<S2sUserAttachedForm> userAttachedForms = developmentProposal.getDevelopmentProposal().getS2sUserAttachedForms();
            for (S2sUserAttachedForm s2sForm : userAttachedForms) {
                if (!userAttachedForm.getNamespace().equals(s2sForm.getNamespace())) continue;
                S2SException s2sException = new S2SException("error.s2s.userattachedform.namespace.duplicate", "The form is already available in the forms list", new String[]{userAttachedForm.getFormName()});
                s2sException.setTabErrorKey(USER_ATTACHED_FORMS_ERRORS);
                throw s2sException;
            }
        }
    }

    private S2sUserAttachedForm processForm(ProposalDevelopmentDocument developmentProposal, Element form, S2sUserAttachedForm userAttachedForm, List<KcFile> attachments) throws TransformerException, XPathExpressionException {
        String namespaceUri = form.getNamespaceURI();
        String formname = form.getLocalName();
        Document doc = this.formUtilityService.node2Dom(form);
        this.doHumanStudiesXmlWorkaroundV1(doc, attachments);
        this.doHumanStudiesXmlWorkaroundV2(doc, attachments);
        this.doHumanStudiesXmlWorkaroundV3(doc, attachments);
        this.doSF424AWorkaround(doc);
        this.formUtilityService.correctAttachmentXml(doc, attachments);
        String xpathEmptyNodes = "//*[not(node()) and local-name(.) != 'FileLocation' and local-name(.) != 'HashValue' and local-name(.) != 'FileName']";
        String xpathOtherPers = "//*[local-name(.)='ProjectRole' and local-name(../../.)='OtherPersonnel' and count(../*[local-name(.)='NumberOfPersonnel'])=0]";
        this.formUtilityService.removeAllEmptyNodes(doc, xpathEmptyNodes, 0);
        this.formUtilityService.removeAllEmptyNodes(doc, xpathOtherPers, 1);
        this.formUtilityService.removeAllEmptyNodes(doc, xpathEmptyNodes, 0);
        this.formUtilityService.reorderXmlElements(doc);
        S2sUserAttachedForm newUserAttachedForm = this.cloneUserAttachedForm(userAttachedForm);
        newUserAttachedForm.setNamespace(namespaceUri);
        newUserAttachedForm.setFormName(formname);
        this.updateAttachmentNodes(newUserAttachedForm, attachments);
        String formXML = this.formUtilityService.docToString(doc);
        S2sUserAttachedFormFile newUserAttachedFormFile = new S2sUserAttachedFormFile();
        newUserAttachedFormFile.setXmlFile(formXML);
        if (!this.validateUserAttachedFormFile(newUserAttachedFormFile, formname)) {
            return null;
        }
        this.validateForm(developmentProposal, newUserAttachedForm);
        for (S2sUserAttachedFormAtt attachment : newUserAttachedForm.getS2sUserAttachedFormAtts()) {
            attachment.setS2sUserAttachedForm(newUserAttachedForm);
            for (S2sUserAttachedFormAttFile file : attachment.getS2sUserAttachedFormAttFiles()) {
                file.setS2sUserAttachedFormAtt(attachment);
            }
        }
        newUserAttachedFormFile.setFormFile(userAttachedForm.getNewFormFileBytes());
        newUserAttachedFormFile.setS2sUserAttachedForm(newUserAttachedForm);
        newUserAttachedFormFile.setUpdateUser(userAttachedForm.getUpdateUser());
        newUserAttachedForm.getS2sUserAttachedFormFileList().add(newUserAttachedFormFile);
        return newUserAttachedForm;
    }

    private List<KcFile> doHumanStudiesAttachmentsWorkaroundV1(List<KcFile> attachments) {
        return this.doHumanStudiesAttachmentsWorkaround(attachments, HUMAN_SUBJECT_STUDY_V1_0_PDF_POPOUT_NAME, HUMAN_SUBJECT_STUDY_V1_0_PDF_POPOUT_HASH);
    }

    private List<KcFile> doHumanStudiesAttachmentsWorkaroundV2(List<KcFile> attachments) {
        return this.doHumanStudiesAttachmentsWorkaround(attachments, HUMAN_SUBJECT_STUDY_V2_0_PDF_POPOUT_NAME, HUMAN_SUBJECT_STUDY_V2_0_PDF_POPOUT_HASH);
    }

    private List<KcFile> doHumanStudiesAttachmentsWorkaroundV3(List<KcFile> attachments) {
        return this.doHumanStudiesAttachmentsWorkaround(attachments, HUMAN_SUBJECT_STUDY_V3_0_PDF_POPOUT_NAME, HUMAN_SUBJECT_STUDY_V3_0_PDF_POPOUT_HASH);
    }

    private List<KcFile> doHumanStudiesAttachmentsWorkaround(List<KcFile> attachments, String popoutName, String hash) {
        List<KcFile> filteredAttachments = attachments.stream().filter(attachment -> !popoutName.equals(attachment.getName()) || !hash.equals(this.getGrantApplicationHashService().computeAttachmentHash(attachment.getData()))).collect(Collectors.toList());
        if (LOG.isDebugEnabled() && filteredAttachments.size() != attachments.size()) {
            LOG.debug(popoutName + " popup attachment with SHA-1 hash " + hash + " detected on User Attached Form and removed.");
        }
        return filteredAttachments;
    }

    private void doHumanStudiesXmlWorkaroundV1(Document doc, List<KcFile> attachments) {
        this.doHumanStudiesXmlWorkaround(doc, attachments, PHSHUMAN_SUBJECTS_AND_CLINICAL_TRIALS_INFO_V1_0, "HumanSubjectStudyAttachment", HUMAN_SUBJECT_STUDY_V1_0, HUMAN_SUBJECT_STUDY_NODE_V1_0, HUMAN_SUBJECT_STUDY_CLINICAL_TRIALS_NODE_V1_0, VERSION_1_0);
    }

    private void doHumanStudiesXmlWorkaroundV2(Document doc, List<KcFile> attachments) {
        this.doHumanStudiesXmlWorkaround(doc, attachments, PHSHUMAN_SUBJECTS_AND_CLINICAL_TRIALS_INFO_V2_0, "HumanSubjectStudyAttachment", HUMAN_SUBJECT_STUDY_V2_0, HUMAN_SUBJECT_STUDY_NODE_V2_0, HUMAN_SUBJECT_STUDY_CLINICAL_TRIALS_NODE_V2_0, VERSION_2_0);
    }

    private void doHumanStudiesXmlWorkaroundV3(Document doc, List<KcFile> attachments) {
        this.doHumanStudiesXmlWorkaround(doc, attachments, PHSHUMAN_SUBJECTS_AND_CLINICAL_TRIALS_INFO_V3_0, "HumanSubjectStudyAttachment", HUMAN_SUBJECT_STUDY_V3_0, HUMAN_SUBJECT_STUDY_NODE_V3_0, HUMAN_SUBJECT_STUDY_CLINICAL_TRIALS_NODE_V3_0, VERSION_3_0);
    }

    private void doHumanStudiesXmlWorkaround(Document doc, List<KcFile> attachments, String hsctNs, String hsctAttName, String hssNs, String hsName, String hsctName, String formVersion) {
        NodeList hsct = doc.getElementsByTagNameNS(hsctNs, hsctName);
        if (hsct != null && hsct.getLength() > 0) {
            Attr formVersionAttr = doc.createAttributeNS(hsctNs, "FormVersion");
            formVersionAttr.setValue(formVersion);
            ((Element)hsct.item(0)).setAttributeNode(formVersionAttr);
        }
        ArrayList allHsAttachments = new ArrayList();
        NodeList hsAtt = doc.getElementsByTagNameNS(hsctNs, ATT);
        for (int i = 0; i < hsAtt.getLength(); ++i) {
            Node attachmentName = hsAtt.item(i);
            List<KcFile> hsAttPdfs = attachments.stream().filter(a -> attachmentName.getTextContent().equals(a.getName())).collect(Collectors.toList());
            attachments.removeAll(hsAttPdfs);
            hsAttPdfs.forEach(hsAttPdf -> {
                block12: {
                    try {
                        Map<String, Object> hsAttinfo = this.proposalSpecialReviewHumanSubjectsAttachmentService.getSpecialReviewAttachmentXmlFileData(hsAttPdf.getData());
                        if (hsAttinfo != null) {
                            List hsctAttachments;
                            String hsXml = (String)hsAttinfo.get("content");
                            if (StringUtils.isNotBlank((CharSequence)hsXml)) {
                                try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(hsXml.getBytes(StandardCharsets.UTF_8));){
                                    Document hsDocument = this.getFormUtilityService().createDomBuilder().parse(byteArrayInputStream);
                                    Node hsNode = hsDocument.getElementsByTagNameNS(hssNs, hsName).item(0);
                                    NodeList hsAttachment = doc.getElementsByTagNameNS(hsctNs, hsctAttName);
                                    Node hsAttachmentNode = hsAttachment.item(0);
                                    hsAttachmentNode.appendChild(doc.importNode(hsNode, true));
                                }
                            }
                            if ((hsctAttachments = (List)hsAttinfo.get("files")) != null) {
                                allHsAttachments.addAll(hsctAttachments);
                            }
                            break block12;
                        }
                        this.globalVariableService.getMessageMap().putError(USER_ATTACHED_FORMS_ERRORS, "error.s2s.userattachedform.invalid", new String[]{"The human studies attachment " + attachmentName.getTextContent() + " is invalid"});
                    }
                    catch (S2SException e) {
                        throw e;
                    }
                    catch (IOException | RuntimeException | ParserConfigurationException | SAXException e) {
                        this.globalVariableService.getMessageMap().putError(USER_ATTACHED_FORMS_ERRORS, "error.s2s.userattachedform.invalid", new String[]{"The human studies attachment " + attachmentName.getTextContent() + " is invalid"});
                    }
                }
            });
        }
        attachments.addAll(allHsAttachments);
    }

    private void doSF424AWorkaround(Document doc) {
        NodeList nodeList = doc.getElementsByTagNameNS("http://apply.grants.gov/forms/SF424A-V1.0", "BudgetInformation");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            Attr wrongAttr = element.getAttributeNodeNS("http://apply.grants.gov/forms/SF424A-V1.0", "coreSchemaVersion");
            Attr correctAttr = element.getAttributeNodeNS("http://apply.grants.gov/system/Global-V1.0", "coreSchemaVersion");
            if (wrongAttr == null) continue;
            element.removeAttributeNS("http://apply.grants.gov/forms/SF424A-V1.0", "coreSchemaVersion");
            if (correctAttr != null) continue;
            element.setAttributeNS("http://apply.grants.gov/system/Global-V1.0", "coreSchemaVersion", VERSION_1_0);
        }
    }

    private boolean validateUserAttachedFormFile(S2sUserAttachedFormFile userAttachedFormFile, String formName) {
        FormGenerationResult result = this.formGeneratorService.validateUserAttachedFormFile((S2sUserAttachedFormFileContract)userAttachedFormFile, formName);
        if (!result.isValid()) {
            this.setValidationErrorMessage(result);
            return false;
        }
        return true;
    }

    protected void setValidationErrorMessage(FormGenerationResult result) {
        result.getErrors().stream().filter(error -> error.getLevel() == AuditError.Level.WARNING).forEach(error -> this.globalVariableService.getMessageMap().putWarning(USER_ATTACHED_FORMS_ERRORS, "error.s2s.userattachedform.invalid", new String[]{error.getMessageKey()}));
        result.getErrors().stream().filter(error -> error.getLevel() != AuditError.Level.WARNING).forEach(error -> this.globalVariableService.getMessageMap().putError(USER_ATTACHED_FORMS_ERRORS, "error.s2s.userattachedform.invalid", new String[]{error.getMessageKey()}));
    }

    private S2sUserAttachedForm cloneUserAttachedForm(S2sUserAttachedForm userAttachedForm) {
        S2sUserAttachedForm newUserAttachedForm = new S2sUserAttachedForm();
        newUserAttachedForm.setDescription(userAttachedForm.getDescription());
        newUserAttachedForm.setFormFileName(userAttachedForm.getFormFileName());
        newUserAttachedForm.setNamespace(userAttachedForm.getNamespace());
        newUserAttachedForm.setFormName(userAttachedForm.getFormName());
        newUserAttachedForm.setS2sUserAttachedFormAtts(userAttachedForm.getS2sUserAttachedFormAtts());
        newUserAttachedForm.setProposalNumber(userAttachedForm.getProposalNumber());
        newUserAttachedForm.setUpdateUser(userAttachedForm.getUpdateUser());
        newUserAttachedForm.setUpdateTimestamp(userAttachedForm.getUpdateTimestamp());
        return newUserAttachedForm;
    }

    private void updateAttachmentNodes(S2sUserAttachedForm userAttachedFormBean, List<KcFile> attachments) {
        List<S2sUserAttachedFormAtt> attachmentList = attachments.stream().map(attachment -> {
            S2sUserAttachedFormAtt userAttachedFormAttachment = new S2sUserAttachedFormAtt();
            S2sUserAttachedFormAttFile userAttachedFormAttachmentFile = new S2sUserAttachedFormAttFile();
            userAttachedFormAttachmentFile.setAttachment(attachment.getData());
            userAttachedFormAttachment.getS2sUserAttachedFormAttFiles().add(userAttachedFormAttachmentFile);
            userAttachedFormAttachment.setContentId(attachment.getName());
            userAttachedFormAttachment.setName(attachment.getName());
            userAttachedFormAttachment.setType(attachment.getType());
            userAttachedFormAttachment.setProposalNumber(userAttachedFormBean.getProposalNumber());
            userAttachedFormAttachment.setS2sUserAttachedForm(userAttachedFormBean);
            return userAttachedFormAttachment;
        }).collect(Collectors.toList());
        userAttachedFormBean.setS2sUserAttachedFormAtts(attachmentList);
    }

    @Override
    public void resetFormAvailability(ProposalDevelopmentDocument developmentProposal, String namespace) {
        List<S2sOppForms> oppForms;
        S2sOpportunity opportunity = developmentProposal.getDevelopmentProposal().getS2sOpportunity();
        if (opportunity != null && (oppForms = opportunity.getS2sOppForms()) != null) {
            this.setS2sOppFormsAvailability(oppForms, namespace, false);
        }
    }

    protected void setFormsAvailability(ProposalDevelopmentDocument developmentProposal, List<S2sUserAttachedForm> savedFormBeans) {
        List<S2sOppForms> oppForms;
        S2sOpportunity opportunity = developmentProposal.getDevelopmentProposal().getS2sOpportunity();
        if (opportunity != null && (oppForms = opportunity.getS2sOppForms()) != null) {
            savedFormBeans.forEach(s2sUserAttachedForm -> this.setS2sOppFormsAvailability(oppForms, s2sUserAttachedForm.getNamespace(), true));
        }
    }

    protected void setS2sOppFormsAvailability(List<S2sOppForms> oppForms, String namespace, boolean uaf) {
        oppForms.stream().filter(s2sOppForms -> s2sOppForms.getS2sOppFormsId().getOppNameSpace().equals(namespace)).forEach(s2sOppForms -> {
            if (uaf) {
                s2sOppForms.setAvailable(true);
                s2sOppForms.setUserAttachedForm(true);
                s2sOppForms.setInclude(true);
            } else {
                boolean available = this.getFormMappingService().getFormInfo(namespace) != null;
                s2sOppForms.setAvailable(available);
                s2sOppForms.setUserAttachedForm(false);
                s2sOppForms.setInclude(s2sOppForms.getMandatory() != false && available);
            }
        });
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public FormGeneratorService getFormGeneratorService() {
        return this.formGeneratorService;
    }

    public void setFormGeneratorService(FormGeneratorService formGeneratorService) {
        this.formGeneratorService = formGeneratorService;
    }

    public FormUtilityService getFormUtilityService() {
        return this.formUtilityService;
    }

    public void setFormUtilityService(FormUtilityService formUtilityService) {
        this.formUtilityService = formUtilityService;
    }

    public FormMappingService getFormMappingService() {
        return this.formMappingService;
    }

    public void setFormMappingService(FormMappingService formMappingService) {
        this.formMappingService = formMappingService;
    }

    public S2sFormConfigurationService getS2sFormConfigurationService() {
        return this.s2sFormConfigurationService;
    }

    public void setS2sFormConfigurationService(S2sFormConfigurationService s2sFormConfigurationService) {
        this.s2sFormConfigurationService = s2sFormConfigurationService;
    }

    public ProposalSpecialReviewHumanSubjectsAttachmentService getProposalSpecialReviewHumanSubjectsAttachmentService() {
        return this.proposalSpecialReviewHumanSubjectsAttachmentService;
    }

    public void setProposalSpecialReviewHumanSubjectsAttachmentService(ProposalSpecialReviewHumanSubjectsAttachmentService proposalSpecialReviewHumanSubjectsAttachmentService) {
        this.proposalSpecialReviewHumanSubjectsAttachmentService = proposalSpecialReviewHumanSubjectsAttachmentService;
    }

    public GrantApplicationHashService getGrantApplicationHashService() {
        return this.grantApplicationHashService;
    }

    public void setGrantApplicationHashService(GrantApplicationHashService grantApplicationHashService) {
        this.grantApplicationHashService = grantApplicationHashService;
    }
}

