/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdevrest;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.document.service.CommonApiService;
import org.kuali.coeus.propdev.impl.auth.ProposalDevelopmentDocumentViewAuthorizer;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdevrest.Dto.DevelopmentProposalDto;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.NotImplementedException;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2"})
@RestController(value="DevelopmentProposalController")
public class DevelopmentProposalController
extends org.kuali.coeus.sys.framework.controller.rest.RestController {
    @Autowired
    @Qualifier(value="commonApiService")
    private CommonApiService commonApiService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="proposalDevelopmentDocumentViewAuthorizer")
    private ProposalDevelopmentDocumentViewAuthorizer proposalDevelopmentDocumentViewAuthorizer;

    @RequestMapping(method={RequestMethod.GET}, value={"/development-proposals/{devProposalNumber}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    DevelopmentProposalDto getDevelopmentProposal(@PathVariable String devProposalNumber) {
        this.getCommonApiService().clearErrors();
        if (StringUtils.isBlank((CharSequence)devProposalNumber)) {
            throw new NotImplementedException("GET all development proposals not yet implemented in.");
        }
        DevelopmentProposal developmentProposal = this.getByNumber(devProposalNumber);
        if (Objects.isNull(developmentProposal)) {
            throw new ResourceNotFoundException("The development proposal specified by " + devProposalNumber + " does not exist");
        }
        this.assertUserHasReadAccess(developmentProposal.getProposalDocument());
        DevelopmentProposalDto proposalDto = this.getCommonApiService().convertObject(developmentProposal, DevelopmentProposalDto.class);
        proposalDto.setDocNbr(developmentProposal.getProposalDocument().getDocumentNumber());
        return proposalDto;
    }

    public DevelopmentProposal getByNumber(String proposalNumber) {
        return (DevelopmentProposal)this.getDataObjectService().find(DevelopmentProposal.class, (Object)proposalNumber);
    }

    protected void assertUserHasReadAccess(Document document) {
        ProposalDevelopmentDocumentViewAuthorizer authorizer = this.getProposalDevelopmentDocumentViewAuthorizer();
        authorizer.initializeDocumentAuthorizerIfNecessary(document);
        if (this.getGlobalVariableService().getUserSession() == null || !authorizer.getDocumentAuthorizer().canOpen(document, this.getGlobalVariableService().getUserSession().getPerson())) {
            throw new UnauthorizedAccessException();
        }
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public ProposalDevelopmentDocumentViewAuthorizer getProposalDevelopmentDocumentViewAuthorizer() {
        return this.proposalDevelopmentDocumentViewAuthorizer;
    }

    public void setProposalDevelopmentDocumentViewAuthorizer(ProposalDevelopmentDocumentViewAuthorizer proposalDevelopmentDocumentViewAuthorizer) {
        this.proposalDevelopmentDocumentViewAuthorizer = proposalDevelopmentDocumentViewAuthorizer;
    }

    public CommonApiService getCommonApiService() {
        return this.commonApiService;
    }

    public void setCommonApiService(CommonApiService commonApiService) {
        this.commonApiService = commonApiService;
    }
}

