/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdevrest;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kuali.coeus.common.api.document.service.CommonApiService;
import org.kuali.coeus.common.budget.framework.calculator.BudgetCalculationService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.person.attr.KcPersonExtendedAttributes;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.auth.ProposalBudgetAuthorizer;
import org.kuali.coeus.propdevrest.Dto.ModularBudgetDto;
import org.kuali.coeus.propdevrest.Dto.PersonAppointmentDto;
import org.kuali.coeus.propdevrest.Dto.PersonBudgetInfoDto;
import org.kuali.coeus.propdevrest.Dto.ProposalDevelopmentBudgetExtDto;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v1"})
@RestController(value="proposalBudgetApiController")
public class ProposalBudgetApiController
extends org.kuali.coeus.sys.framework.controller.rest.RestController {
    @Autowired
    @Qualifier(value="budgetCalculationService")
    private BudgetCalculationService budgetCalculationService;
    @Autowired
    @Qualifier(value="commonApiService")
    private CommonApiService commonApiService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="proposalBudgetAuthorizer")
    private ProposalBudgetAuthorizer proposalBudgetAuthorizer;
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;

    @GetMapping(value={"/budgets/{id}/modular-budget/"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<ModularBudgetDto> getBudgets(@PathVariable Long id, @RequestParam(name="lastUpdated", required=false) Long lastUpdated) {
        ProposalDevelopmentBudgetExt budget = this.getBudget(id);
        if (!this.proposalBudgetAuthorizer.isAuthorizedToViewBudget(budget, this.globalVariableService.getUserSession().getPerson())) {
            throw new AuthorizationException(this.globalVariableService.getUserSession().getPrincipalName(), "open", "Proposal Budget");
        }
        Optional<LocalDateTime> lastFetched = Optional.ofNullable(lastUpdated).map(time -> LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()));
        if (lastFetched.isEmpty() || budget.getUpdateTimestamp().toLocalDateTime().isAfter(lastFetched.get())) {
            this.budgetCalculationService.calculateBudget(budget);
            return ResponseEntity.ok((Object)this.commonApiService.convertObject(budget, ModularBudgetDto.class));
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).build();
    }

    @GetMapping(value={"/budgets/{id}/modular-budget/permissions"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<BudgetPermissionsDto> getBudgetPermissions(@PathVariable Long id) {
        BudgetPermissionsDto permissions = new BudgetPermissionsDto();
        ProposalDevelopmentBudgetExt budget = this.getBudget(id);
        permissions.setView(this.proposalBudgetAuthorizer.isAuthorizedToViewBudget(budget, this.globalVariableService.getUserSession().getPerson()));
        if (permissions.isView()) {
            permissions.setEdit(this.proposalBudgetAuthorizer.canEditModularBudget(budget, this.globalVariableService.getUserSession().getPerson()));
        }
        return ResponseEntity.ok((Object)permissions);
    }

    @GetMapping(value={"/budgets/{id}"}, consumes={"application/json"}, produces={"application/json"})
    protected ProposalDevelopmentBudgetExtDto getFullBudgetById(@PathVariable Long id) {
        this.assertUserHasReadAccess();
        ProposalDevelopmentBudgetExt budget = this.getBudget(id);
        this.budgetCalculationService.calculateBudget(budget);
        ProposalDevelopmentBudgetExtDto response = this.commonApiService.convertObject(budget, ProposalDevelopmentBudgetExtDto.class);
        response.getProposal().setDocNbr(budget.getDevelopmentProposal().getProposalDocument().getDocumentNumber());
        return response;
    }

    @GetMapping(value={"/budgets/person/{id}"}, consumes={"application/json"}, produces={"application/json"})
    protected PersonBudgetInfoDto getPersonBudgetData(@PathVariable String id) {
        this.assertUserHasReadPersonsAccess();
        KcPerson person = this.kcPersonService.getKcPersonByPersonId(id);
        PersonBudgetInfoDto personInfo = new PersonBudgetInfoDto();
        if (person != null) {
            personInfo.setName(person.getFullName());
            personInfo.setPersonId(person.getPersonId());
            personInfo.setSalaryAnniversaryDate(person.getExtendedAttributes().getSalaryAnniversaryDate());
            personInfo.setAppointments(person.getExtendedAttributes().getPersonAppointments().stream().map(appointment -> this.commonApiService.convertObject(appointment, PersonAppointmentDto.class)).collect(Collectors.toList()));
        }
        return personInfo;
    }

    protected void assertUserHasReadAccess() {
        if (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Read Class", Collections.singletonMap("className", ProposalDevelopmentBudgetExt.class.getName()))) {
            throw new UnauthorizedAccessException();
        }
    }

    protected void assertUserHasReadPersonsAccess() {
        if (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Read Class", Collections.singletonMap("className", KcPersonExtendedAttributes.class.getName()))) {
            throw new UnauthorizedAccessException();
        }
    }

    protected ProposalDevelopmentBudgetExt getBudget(Long id) {
        ProposalDevelopmentBudgetExt budget = (ProposalDevelopmentBudgetExt)this.dataObjectService.find(ProposalDevelopmentBudgetExt.class, (Object)id);
        if (budget == null) {
            throw new ResourceNotFoundException("Budget with id " + id + " not found.");
        }
        return budget;
    }

    public static class BudgetPermissionsDto {
        private boolean edit = false;
        private boolean view = false;

        public boolean isEdit() {
            return this.edit;
        }

        public void setEdit(boolean edit) {
            this.edit = edit;
        }

        public boolean isView() {
            return this.view;
        }

        public void setView(boolean view) {
            this.view = view;
        }
    }
}

