/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdevrest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.propdevrest.Dto.RouteStopDto;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.BadRequestException;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowBo;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowDelegateBo;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowMemberBo;
import org.kuali.rice.kew.responsibility.service.ResponsibilityIdService;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.impl.repository.ActionAttributeBo;
import org.kuali.rice.krms.impl.repository.ActionBo;
import org.kuali.rice.krms.impl.repository.AgendaAttributeBo;
import org.kuali.rice.krms.impl.repository.AgendaBo;
import org.kuali.rice.krms.impl.repository.AgendaItemBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.RuleBo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2"})
@RestController(value="ProposalRoutingController")
@Transactional
public class ProposalRoutingController {
    private static final Logger LOG = LogManager.getLogger(ProposalRoutingController.class);
    private static final String ACTION_PEOPLE_FLOW_ATTR_ID = "1000";
    private static final String ACTION_PEOPLE_FLOW_NAME_ATTR_ID = "1006";
    private static final String KC_ADVANCED_PEOPLEFLOW_TYPE_ID = "KC10000";
    private static final String PD_ROUTE_STOP_ID_PREFIX = "PD-RS-";
    private static final String PD_ROUTE_STOP_SEQUENCE = "SEQ_PD_ROUTE_STOP_ID";
    private static final String PROP_DEV_AGENDA_NAME_PATTERN = "%s Approvers";
    private static final String PROP_DEV_PEOPLEFLOW_NAME_PATTERN = "Approvers for %s: %s";
    private static final String PROP_DEV_PEOPLEFLOW_DESC_PATTERN = "Proposal Development Standard Workflow for Unit %s";
    private static final String ROUTE_TO_PEOPLEFLOW_TYPE_ID = "1001";
    private static final String UNIT_AGENDA_TYPE_ID = "KC1000";
    private static final String UNIT_NUMBER_ATTR_DEFN_ID = "KC1000";
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="dataSource")
    private DataSource dataSource;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="groupService")
    private GroupService groupService;
    @Autowired
    @Qualifier(value="krmsAttributeDefinitionService")
    private KrmsAttributeDefinitionService krmsAttributeDefinitionService;
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="enResponsibilityIdService")
    private ResponsibilityIdService responsibilityIdService;
    @Autowired
    @Qualifier(value="unitService")
    private UnitService unitService;

    @PostMapping(value={"/route-stop"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public RouteStopDto createRouteStop(@RequestBody RouteStopDto routeStopDto) {
        this.assertUserHasWriteAccess();
        this.validateRouteStop(routeStopDto);
        routeStopDto.setId(PD_ROUTE_STOP_ID_PREFIX + MaxValueIncrementerFactory.getIncrementer((DataSource)this.getDataSource(), (String)PD_ROUTE_STOP_SEQUENCE).nextStringValue());
        PeopleFlowBo newPeopleFlow = this.createPeopleFlow(routeStopDto);
        AgendaBo newAgenda = this.createAgenda(routeStopDto, newPeopleFlow);
        routeStopDto.setPeopleFlowId(newPeopleFlow.getId());
        routeStopDto.setStopNumber(((PeopleFlowMemberBo)newPeopleFlow.getMembers().get(0)).getPriority());
        routeStopDto.setAgendaId(newAgenda.getId());
        return routeStopDto;
    }

    private void validateRouteStop(RouteStopDto routeStopDto) {
        this.validateUnitNumber(routeStopDto.getUnitNumber());
        this.validateGroupId(routeStopDto.getGroupId(), "Group ID", true);
        this.validateGroupId(routeStopDto.getDelegateGroupId(), "Delegate Group ID", false);
    }

    private void validateUnitNumber(String unitNumber) {
        if (StringUtils.isBlank((CharSequence)unitNumber)) {
            throw new BadRequestException("Unit number is required.");
        }
        if (this.getUnitService().getActiveUnit(unitNumber) == null) {
            throw new BadRequestException(String.format("Unit %s is inactive or does not exist.", unitNumber));
        }
    }

    private void validateGroupId(String groupId, String fieldName, boolean isRequired) {
        Group group;
        if (isRequired && StringUtils.isBlank((CharSequence)groupId)) {
            throw new BadRequestException(String.format("%s is required.", fieldName));
        }
        if (StringUtils.isNotBlank((CharSequence)groupId) && ((group = this.getGroupService().getGroup(groupId)) == null || !group.isActive())) {
            throw new BadRequestException(String.format("%s %s is inactive or does not exist.", fieldName, groupId));
        }
    }

    private PeopleFlowBo createPeopleFlow(RouteStopDto routeStopDto) {
        Unit unit = this.getUnitService().getUnit(routeStopDto.getUnitNumber());
        PeopleFlowDelegateBo newPeopleFlowDelegate = null;
        if (StringUtils.isNotBlank((CharSequence)routeStopDto.getDelegateGroupId())) {
            newPeopleFlowDelegate = new PeopleFlowDelegateBo();
            newPeopleFlowDelegate.setMemberTypeCode(MemberType.GROUP.getCode());
            newPeopleFlowDelegate.setMemberId(routeStopDto.getDelegateGroupId());
            newPeopleFlowDelegate.setActionRequestPolicyCode(ActionRequestPolicy.FIRST.getCode());
            newPeopleFlowDelegate.setDelegationTypeCode(DelegationType.SECONDARY.getCode());
            newPeopleFlowDelegate.setResponsibilityId(this.getResponsibilityIdService().getNewResponsibilityId());
        }
        PeopleFlowMemberBo newPeopleFlowMember = new PeopleFlowMemberBo();
        newPeopleFlowMember.setMemberTypeCode(MemberType.GROUP.getCode());
        newPeopleFlowMember.setMemberId(routeStopDto.getGroupId());
        newPeopleFlowMember.setActionRequestPolicyCode(ActionRequestPolicy.FIRST.getCode());
        newPeopleFlowMember.setPriority(this.getStopForUnit(routeStopDto.getUnitNumber()));
        newPeopleFlowMember.setResponsibilityId(this.getResponsibilityIdService().getNewResponsibilityId());
        PeopleFlowBo newPeopleFlow = new PeopleFlowBo();
        newPeopleFlow.setId(routeStopDto.getId());
        newPeopleFlow.setTypeId(KC_ADVANCED_PEOPLEFLOW_TYPE_ID);
        newPeopleFlow.setNamespaceCode("KC-PD");
        newPeopleFlow.setName(String.format(PROP_DEV_PEOPLEFLOW_NAME_PATTERN, unit.getUnitNumber(), unit.getUnitName()));
        newPeopleFlow.setDescription(String.format(PROP_DEV_PEOPLEFLOW_DESC_PATTERN, routeStopDto.getUnitNumber()));
        newPeopleFlow.getMembers().add(newPeopleFlowMember);
        newPeopleFlowMember.setPeopleFlow(newPeopleFlow);
        if (newPeopleFlowDelegate != null) {
            newPeopleFlowMember.getDelegates().add(newPeopleFlowDelegate);
            newPeopleFlowDelegate.setPeopleFlowMember(newPeopleFlowMember);
        }
        return (PeopleFlowBo)this.getDataObjectService().save((Object)newPeopleFlow, new PersistenceOption[0]);
    }

    private int getStopForUnit(String unitNumber) {
        ArrayList<Unit> subunits = new ArrayList<Unit>();
        subunits.add(this.getUnitService().getTopUnit());
        int depth = 0;
        int unitDepth = 0;
        while (!subunits.isEmpty()) {
            ArrayList<Unit> units = subunits;
            subunits = new ArrayList();
            for (Unit unit : units) {
                if (StringUtils.equals((CharSequence)unitNumber, (CharSequence)unit.getUnitNumber())) {
                    unitDepth = depth;
                }
                subunits.addAll(this.getUnitService().getSubUnits(unit.getUnitNumber()));
            }
            ++depth;
        }
        return (depth - unitDepth) * 100;
    }

    private AgendaBo createAgenda(RouteStopDto routeStopDto, PeopleFlowBo peopleFlow) {
        String name = String.format(PROP_DEV_AGENDA_NAME_PATTERN, routeStopDto.getUnitNumber());
        RuleBo newRule = new RuleBo();
        newRule.setNamespace("KC-PD");
        newRule.setName(name);
        newRule.setActive(true);
        ActionBo newAction = new ActionBo();
        newAction.setTypeId(ROUTE_TO_PEOPLEFLOW_TYPE_ID);
        newAction.setNamespace("KC-PD");
        newAction.setName(name);
        newAction.setAttributeBos(new ArrayList());
        newAction.setRule(newRule);
        newRule.getActions().add(newAction);
        ActionAttributeBo peopleFlowAttribute = this.createActionAttribute(ACTION_PEOPLE_FLOW_ATTR_ID, peopleFlow.getId());
        peopleFlowAttribute.setAction(newAction);
        newAction.getAttributeBos().add(peopleFlowAttribute);
        ActionAttributeBo peopleFlowNameAttribute = this.createActionAttribute(ACTION_PEOPLE_FLOW_NAME_ATTR_ID, peopleFlow.getName());
        peopleFlowNameAttribute.setAction(newAction);
        newAction.getAttributeBos().add(peopleFlowNameAttribute);
        AgendaBo newAgenda = new AgendaBo();
        newAgenda.setId(routeStopDto.getId());
        newAgenda.setTypeId("KC1000");
        newAgenda.setContextId("KC-PD-CONTEXT");
        newAgenda.setName(name);
        newAgenda.setActive(true);
        newAgenda.setAttributeBos(new HashSet());
        AgendaAttributeBo newAgendaAttribute = new AgendaAttributeBo();
        KrmsAttributeDefinition attributeDefinition = this.getKrmsAttributeDefinitionService().getAttributeDefinitionById("KC1000");
        newAgendaAttribute.setAttributeDefinition(KrmsAttributeDefinitionBo.from((KrmsAttributeDefinition)attributeDefinition));
        newAgendaAttribute.setValue(routeStopDto.getUnitNumber());
        newAgendaAttribute.setAgenda(newAgenda);
        newAgenda.getAttributeBos().add(newAgendaAttribute);
        AgendaBo savedAgenda = (AgendaBo)this.getDataObjectService().save((Object)newAgenda, new PersistenceOption[0]);
        RuleBo savedRule = (RuleBo)this.getDataObjectService().save((Object)newRule, new PersistenceOption[]{PersistenceOption.FLUSH});
        AgendaItemBo newAgendaItem = new AgendaItemBo();
        newAgendaItem.setAgendaId(savedAgenda.getId());
        newAgendaItem.setRule(savedRule);
        AgendaItemBo savedAgendaItem = (AgendaItemBo)this.getDataObjectService().save((Object)newAgendaItem, new PersistenceOption[0]);
        savedAgenda.setFirstItem(savedAgendaItem);
        return (AgendaBo)this.getDataObjectService().save((Object)savedAgenda, new PersistenceOption[0]);
    }

    private ActionAttributeBo createActionAttribute(String attributeDefinitionId, String value) {
        ActionAttributeBo newActionAttribute = new ActionAttributeBo();
        KrmsAttributeDefinition attributeDefinition = this.getKrmsAttributeDefinitionService().getAttributeDefinitionById(attributeDefinitionId);
        newActionAttribute.setAttributeDefinition(KrmsAttributeDefinitionBo.from((KrmsAttributeDefinition)attributeDefinition));
        newActionAttribute.setValue(value);
        return newActionAttribute;
    }

    @PatchMapping(value={"/route-stop/{id}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public RouteStopDto updateRouteStop(@PathVariable String id, @RequestBody RouteStopDto routeStopDto) {
        String unitNumber;
        this.assertUserHasWriteAccess();
        AgendaBo originalAgenda = (AgendaBo)this.getDataObjectService().find(AgendaBo.class, (Object)id);
        PeopleFlowBo originalPeopleFlow = (PeopleFlowBo)this.getDataObjectService().find(PeopleFlowBo.class, (Object)id);
        if (originalAgenda == null || originalPeopleFlow == null) {
            throw new ResourceNotFoundException(String.format("No agenda or people flow found for id %s", id));
        }
        this.validateRouteStop(routeStopDto);
        if (StringUtils.isNotBlank((CharSequence)routeStopDto.getGroupId())) {
            this.getFirstMember(originalPeopleFlow).ifPresent(member -> member.setMemberId(routeStopDto.getGroupId()));
        }
        if (StringUtils.isNotBlank((CharSequence)routeStopDto.getDelegateGroupId())) {
            this.getFirstDelegate(originalPeopleFlow).ifPresent(delegate -> delegate.setMemberId(routeStopDto.getDelegateGroupId()));
        }
        if (StringUtils.isNotBlank((CharSequence)(unitNumber = routeStopDto.getUnitNumber()))) {
            Unit unit = this.getUnitService().getUnit(unitNumber);
            String agendaName = String.format(PROP_DEV_AGENDA_NAME_PATTERN, routeStopDto.getUnitNumber());
            String peopleFlowName = String.format(PROP_DEV_PEOPLEFLOW_NAME_PATTERN, unitNumber, unit.getUnitName());
            originalAgenda.setName(agendaName);
            this.getUnitAttributeForAgenda(originalAgenda).ifPresent(attribute -> attribute.setValue(unitNumber));
            Optional<RuleBo> firstRule = this.getFirstRule(originalAgenda);
            firstRule.ifPresent(rule -> rule.setName(agendaName));
            firstRule.flatMap(this::getFirstAction).ifPresent(action -> action.setName(agendaName));
            originalPeopleFlow.setName(peopleFlowName);
            originalPeopleFlow.setDescription(String.format(PROP_DEV_PEOPLEFLOW_DESC_PATTERN, routeStopDto.getUnitNumber()));
            this.getFirstMember(originalPeopleFlow).ifPresent(member -> member.setPriority(this.getStopForUnit(unitNumber)));
        }
        AgendaBo savedAgenda = (AgendaBo)this.getDataObjectService().save((Object)originalAgenda, new PersistenceOption[0]);
        PeopleFlowBo savedPeopleFlow = (PeopleFlowBo)this.getDataObjectService().save((Object)originalPeopleFlow, new PersistenceOption[0]);
        return this.createRouteStopDto(id, savedAgenda, savedPeopleFlow);
    }

    @GetMapping(value={"/route-stop"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<RouteStopDto> getAllRouteStops(@RequestParam(value="unitNumber", required=false) String unitNumber, @RequestParam(value="groupId", required=false) String groupId, @RequestParam(value="delegateGroupId", required=false) String delegateGroupId) {
        this.assertUserHasReadAccess();
        ArrayList<Predicate> agendaPredicates = new ArrayList<Predicate>();
        agendaPredicates.add(PredicateFactory.like((String)"id", (CharSequence)"PD-RS-*"));
        ArrayList<Predicate> peopleFlowPredicates = new ArrayList<Predicate>(agendaPredicates);
        if (StringUtils.isNotBlank((CharSequence)unitNumber)) {
            agendaPredicates.add(PredicateFactory.equalIgnoreCase((String)"attributeBos.value", (CharSequence)unitNumber));
        }
        if (StringUtils.isNotBlank((CharSequence)groupId)) {
            peopleFlowPredicates.add(PredicateFactory.equal((String)"members.memberId", (Object)groupId));
        }
        if (StringUtils.isNotBlank((CharSequence)delegateGroupId)) {
            peopleFlowPredicates.add(PredicateFactory.equal((String)"members.delegates.memberId", (Object)delegateGroupId));
        }
        List agendas = this.getDataObjectService().findMatching(AgendaBo.class, QueryByCriteria.Builder.fromPredicates(agendaPredicates)).getResults();
        Map peopleFlows = this.getDataObjectService().findMatching(PeopleFlowBo.class, QueryByCriteria.Builder.fromPredicates(peopleFlowPredicates)).getResults().stream().collect(Collectors.toMap(PeopleFlowBo::getId, Function.identity()));
        return agendas.stream().map(agenda -> this.createRouteStopDto(agenda.getId(), (AgendaBo)agenda, (PeopleFlowBo)peopleFlows.get(agenda.getId()))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @GetMapping(value={"/route-stop/{id}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public RouteStopDto getRouteStop(@PathVariable String id) {
        this.assertUserHasReadAccess();
        AgendaBo agenda = (AgendaBo)this.getDataObjectService().find(AgendaBo.class, (Object)id);
        PeopleFlowBo peopleFlow = (PeopleFlowBo)this.getDataObjectService().find(PeopleFlowBo.class, (Object)id);
        if (agenda == null || peopleFlow == null) {
            throw new ResourceNotFoundException(String.format("No agenda or people flow found for id %s", id));
        }
        return this.createRouteStopDto(id, agenda, peopleFlow);
    }

    private RouteStopDto createRouteStopDto(String id, AgendaBo agenda, PeopleFlowBo peopleFlow) {
        if (agenda == null || peopleFlow == null) {
            return null;
        }
        RouteStopDto routeStopDto = new RouteStopDto();
        routeStopDto.setId(id);
        routeStopDto.setAgendaId(agenda.getId());
        routeStopDto.setPeopleFlowId(peopleFlow.getId());
        this.getUnitAttributeForAgenda(agenda).ifPresent(attribute -> routeStopDto.setUnitNumber(attribute.getValue()));
        this.getFirstMember(peopleFlow).ifPresent(member -> {
            routeStopDto.setGroupId(member.getMemberId());
            routeStopDto.setStopNumber(member.getPriority());
        });
        this.getFirstDelegate(peopleFlow).ifPresent(delegate -> routeStopDto.setDelegateGroupId(delegate.getMemberId()));
        return routeStopDto;
    }

    private Optional<PeopleFlowMemberBo> getFirstMember(PeopleFlowBo peopleFlow) {
        return CollectionUtils.isEmpty((Collection)peopleFlow.getMembers()) ? Optional.empty() : Optional.of((PeopleFlowMemberBo)peopleFlow.getMembers().get(0));
    }

    private Optional<PeopleFlowDelegateBo> getFirstDelegate(PeopleFlowBo peopleFlow) {
        return this.getFirstMember(peopleFlow).map(member -> CollectionUtils.isEmpty((Collection)member.getDelegates()) ? null : (PeopleFlowDelegateBo)member.getDelegates().get(0));
    }

    private Optional<AgendaAttributeBo> getUnitAttributeForAgenda(AgendaBo agenda) {
        return agenda.getAttributeBos().stream().filter(attribute -> "KC1000".equals(attribute.getAttributeDefinitionId())).findFirst();
    }

    private Optional<RuleBo> getFirstRule(AgendaBo agenda) {
        return Optional.ofNullable(agenda.getFirstItem()).map(AgendaItemBo::getRule);
    }

    private Optional<ActionBo> getFirstAction(RuleBo rule) {
        return CollectionUtils.isEmpty((Collection)rule.getActions()) ? Optional.empty() : Optional.of((ActionBo)rule.getActions().get(0));
    }

    @DeleteMapping(value={"/route-stop/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteRouteStop(@PathVariable String id) {
        AgendaBo agenda = (AgendaBo)this.getDataObjectService().find(AgendaBo.class, (Object)id);
        PeopleFlowBo peopleFlow = (PeopleFlowBo)this.getDataObjectService().find(PeopleFlowBo.class, (Object)id);
        if (agenda == null || peopleFlow == null) {
            throw new ResourceNotFoundException(String.format("No agenda or people flow found for id %s", id));
        }
        String firstItemId = agenda.getFirstItemId();
        agenda.setFirstItem(null);
        this.getDataObjectService().save((Object)agenda, new PersistenceOption[0]);
        this.getDataObjectService().delete(this.getDataObjectService().find(AgendaItemBo.class, (Object)firstItemId));
        this.getDataObjectService().flush(AgendaBo.class);
        this.getDataObjectService().delete((Object)agenda);
        this.getDataObjectService().delete((Object)peopleFlow);
    }

    protected void assertUserHasReadAccess() {
        if (this.getGlobalVariableService().getUserSession() == null) {
            throw new UnauthorizedAccessException();
        }
        boolean canReadAgendas = this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Read Class", Map.of("className", AgendaBo.class.getName()));
        boolean canReadPeopleFlows = this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Read Class", Map.of("className", PeopleFlowBo.class.getName()));
        if (!canReadAgendas || !canReadPeopleFlows) {
            throw new UnauthorizedAccessException();
        }
    }

    protected void assertUserHasWriteAccess() {
        if (this.getGlobalVariableService().getUserSession() == null) {
            throw new UnauthorizedAccessException();
        }
        boolean canWriteAgendas = this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Write Class", Map.of("className", AgendaBo.class.getName()));
        boolean canWritePeopleFlows = this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Write Class", Map.of("className", PeopleFlowBo.class.getName()));
        if (!canWriteAgendas || !canWritePeopleFlows) {
            throw new UnauthorizedAccessException();
        }
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public GroupService getGroupService() {
        return this.groupService;
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    public KrmsAttributeDefinitionService getKrmsAttributeDefinitionService() {
        return this.krmsAttributeDefinitionService;
    }

    public void setKrmsAttributeDefinitionService(KrmsAttributeDefinitionService krmsAttributeDefinitionService) {
        this.krmsAttributeDefinitionService = krmsAttributeDefinitionService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public ResponsibilityIdService getResponsibilityIdService() {
        return this.responsibilityIdService;
    }

    public void setResponsibilityIdService(ResponsibilityIdService responsibilityIdService) {
        this.responsibilityIdService = responsibilityIdService;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }
}

