/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.controller;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.kuali.coeus.common.framework.auth.KcTransactionalDocumentAuthorizerBase;
import org.kuali.coeus.common.framework.auth.task.Task;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.common.framework.auth.task.WebAuthorizationService;
import org.kuali.coeus.common.framework.custom.CustomDataDocumentForm;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.api.model.KcFile;
import org.kuali.coeus.sys.framework.controller.DocHandlerService;
import org.kuali.coeus.sys.framework.controller.StrutsConfirmation;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentFormBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.institutionalproposal.web.struts.form.InstitutionalProposalForm;
import org.kuali.kra.subaward.SubAwardForm;
import org.kuali.kra.timeandmoney.TimeAndMoneyForm;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.authorization.DocumentAuthorizer;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.util.MessageList;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.struts.action.KualiTransactionalDocumentActionBase;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.util.UrlFactory;

public class KcTransactionalDocumentActionBase
extends KualiTransactionalDocumentActionBase {
    private static final Logger LOG = LogManager.getLogger(KcTransactionalDocumentActionBase.class);
    private static final String ONE_ADHOC_REQUIRED_ERROR_KEY = "error.adhoc.oneAdHocRequired";
    private static final String DOCUMENT_RELOAD_QUESTION = "DocReload";
    public static final String KRAD_PORTAL_URL = "/kc-krad/landingPage?viewId=Kc-LandingPage-RedirectView";
    private KcPersonService kcPersonService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MessageList messageList;
        KcTransactionalDocumentFormBase kcForm = (KcTransactionalDocumentFormBase)form;
        String commandParam = request.getParameter("command");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.equals("displayDocSearchView") && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)request.getParameter("viewDocument")) && request.getParameter("viewDocument").equals("true")) {
            kcForm.setViewOnly(true);
            ((KcTransactionalDocumentBase)kcForm.getDocument()).setViewOnly(kcForm.isViewOnly());
        }
        if ((messageList = (MessageList)GlobalVariables.getUserSession().retrieveObject("holdingPageMessages")) != null) {
            KNSGlobalVariables.getMessageList().addAll((Collection)messageList);
            GlobalVariables.getUserSession().removeObject("holdingPageMessages");
        }
        ActionForward returnForward = super.execute(mapping, form, request, response);
        return returnForward;
    }

    protected ActionForward dispatchMethod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String methodName) throws Exception {
        ActionForward actionForward = null;
        actionForward = !this.isTaskAuthorized(methodName, form, request) ? this.processAuthorizationViolation(methodName, mapping, form, request, response) : super.dispatchMethod(mapping, form, request, response, methodName);
        return actionForward;
    }

    public ActionForward headerTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (form instanceof KcTransactionalDocumentFormBase) {
            ((KcTransactionalDocumentFormBase)form).setNavigateTo(this.getHeaderTabNavigateTo(request));
        }
        ((KualiForm)form).setTabStates(new HashMap());
        return super.headerTab(mapping, form, request, response);
    }

    public ActionForward confirm(StrutsConfirmation question, String yesMethodName, String noMethodName) throws Exception {
        question.setCaller(((KualiForm)question.getForm()).getMethodToCall());
        if (question.hasQuestionInstAttributeName()) {
            String buttonClicked = question.getRequest().getParameter("buttonClicked");
            if ("0".equals(buttonClicked) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)yesMethodName)) {
                return this.dispatchMethod(question.getMapping(), question.getForm(), question.getRequest(), question.getResponse(), yesMethodName);
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)noMethodName)) {
                return this.dispatchMethod(question.getMapping(), question.getForm(), question.getRequest(), question.getResponse(), noMethodName);
            }
        } else {
            return this.performQuestionWithoutInput(question, "");
        }
        return question.getMapping().findForward("basic");
    }

    protected StrutsConfirmation buildParameterizedConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String questionId, String configurationId, String ... params) throws Exception {
        StrutsConfirmation retval = new StrutsConfirmation();
        retval.setMapping(mapping);
        retval.setForm(form);
        retval.setRequest(request);
        retval.setResponse(response);
        retval.setQuestionId(questionId);
        retval.setQuestionType("confirmationQuestion");
        ConfigurationService kualiConfiguration = CoreApiServiceLocator.getKualiConfigurationService();
        String questionText = kualiConfiguration.getPropertyValueAsString(configurationId);
        for (int i = 0; i < params.length; ++i) {
            questionText = org.apache.commons.lang3.StringUtils.replace((String)questionText, (String)("{" + i + "}"), (String)params[i]);
        }
        retval.setQuestionText(questionText);
        return retval;
    }

    protected ActionForward performQuestionWithoutInput(StrutsConfirmation question, String context) throws Exception {
        return this.performQuestionWithoutInput(question.getMapping(), question.getForm(), question.getRequest(), question.getResponse(), question.getQuestionId(), question.getQuestionText(), question.getQuestionType(), question.getCaller(), context);
    }

    protected String buildForwardUrl(String routeHeaderId) {
        String baseURL = this.getDocHandlerService().getDocHandlerUrl(routeHeaderId);
        Properties parameters = new Properties();
        parameters.put("docId", routeHeaderId);
        parameters.put("command", "displayDocSearchView");
        if (GlobalVariables.getUserSession().isBackdoorInUse()) {
            parameters.put("backdoorId", this.getGlobalVariableService().getUserSession().getPrincipalName());
        }
        return UrlFactory.parameterizeUrl((String)baseURL, (Properties)parameters);
    }

    private GlobalVariableService getGlobalVariableService() {
        return KcServiceLocator.getService(GlobalVariableService.class);
    }

    private DocHandlerService getDocHandlerService() {
        return KcServiceLocator.getService(DocHandlerService.class);
    }

    protected String buildActionUrl(String routeHeaderId, String actionTabName, String documentTypeName) {
        Object returnLocation = this.buildForwardUrl(routeHeaderId);
        returnLocation = ((String)returnLocation).replaceFirst("displayDocSearchView", actionTabName);
        returnLocation = (String)returnLocation + "&docTypeName=" + documentTypeName;
        returnLocation = (String)returnLocation + "&viewDocument=false";
        return returnLocation;
    }

    private boolean isTaskAuthorized(String methodName, ActionForm form, HttpServletRequest request) {
        WebAuthorizationService webAuthorizationService = KcServiceLocator.getService(WebAuthorizationService.class);
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        ((KcTransactionalDocumentFormBase)form).setActionName(((Object)((Object)this)).getClass().getSimpleName());
        boolean isAuthorized = webAuthorizationService.isAuthorized(userId, ((Object)((Object)this)).getClass(), methodName, form, request);
        if (!isAuthorized) {
            LOG.error("User not authorized to perform " + methodName + " for document: " + ((KualiDocumentFormBase)form).getDocument().getClass().getName());
        }
        return isAuthorized;
    }

    protected boolean isAuthorized(Task task) {
        String currentUser = GlobalVariables.getUserSession().getPrincipalId();
        TaskAuthorizationService authorizationService = KcServiceLocator.getService(TaskAuthorizationService.class);
        boolean isAuthorized = authorizationService.isAuthorized(currentUser, task);
        if (!isAuthorized) {
            LOG.error("User not authorized to perform " + task.getTaskName());
            MessageMap errorMap = GlobalVariables.getMessageMap();
            errorMap.putErrorWithoutFullErrorPath("taskAuthorization", "error.authorization.violation", new String[0]);
        }
        return isAuthorized;
    }

    public ActionForward processAuthorizationViolation(String taskName, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        errorMap.putErrorWithoutFullErrorPath("taskAuthorization", "error.authorization.violation", new String[0]);
        return mapping.findForward("basic");
    }

    protected String generatePessimisticLockMessage(PessimisticLock lock) {
        KcPerson lockPerson;
        String descriptor = lock.getLockDescriptor() != null ? lock.getLockDescriptor() : "";
        String message = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("locked.document.message");
        Object lockedBy = lock.getOwnedByUser().getPrincipalName();
        if (this.isShowFullNameEnabled() && (lockPerson = this.getKcPersonService().getKcPersonByPersonId(lock.getOwnedByUser().getPrincipalId())) != null) {
            lockedBy = lockPerson.getFullName() + " (" + lock.getOwnedByUser().getPrincipalName() + ")";
        }
        descriptor = this.getDocumentType(descriptor);
        message = message.replace("{DOCUMENT_TYPE}", descriptor);
        message = message.replace("{LOCKED_BY}", (CharSequence)lockedBy);
        message = message.replace("{TIMESTAMP}", RiceConstants.getDefaultTimeFormat().format(lock.getGeneratedTimestamp()));
        message = message.replace("{DATESTAMP}", RiceConstants.getDefaultDateFormat().format(lock.getGeneratedTimestamp()));
        return message;
    }

    private String getDocumentType(String descriptor) {
        String[] resultArray;
        String result = "document";
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)descriptor) && (resultArray = descriptor.split("-")).length > 2) {
            if (resultArray.length > 3 && org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)resultArray[2], (CharSequence)"award")) {
                result = "Award";
            } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)result, (CharSequence)"subaward")) {
                result = "Subaward";
            } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)result, (CharSequence)"negotiation")) {
                result = "Negotiation";
            } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)result, (CharSequence)"proposal development")) {
                result = "Proposal";
            }
        }
        return result;
    }

    private List<PessimisticLock> findMatchingLocksWithGivenDescriptor(String lockDescriptor) {
        DataObjectService dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("lockDescriptor", lockDescriptor);
        List matchingLocks = dataObjectService.findMatching(PessimisticLock.class, QueryByCriteria.Builder.andAttributes(fieldValues).build()).getResults();
        return matchingLocks;
    }

    protected void releaseLocks(Document document, String methodToCall) {
        String activeLockRegion = (String)GlobalVariables.getUserSession().retrieveObject("ACTIVE_LOCK_REGION");
        GlobalVariables.getUserSession().removeObject("ACTIVE_LOCK_REGION");
        PessimisticLockService lockService = KRADServiceLocatorWeb.getPessimisticLockService();
        Person loggedInUser = GlobalVariables.getUserSession().getPerson();
        String budgetLockDescriptor = null;
        for (PessimisticLock lock : document.getPessimisticLocks()) {
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)lock.getLockDescriptor()) || !lock.getLockDescriptor().contains("BUDGET")) continue;
            budgetLockDescriptor = lock.getLockDescriptor();
            break;
        }
        if (document.getLockClearningMethodNames().contains(methodToCall) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)activeLockRegion)) {
            lockService.releaseAllLocksForUser(document.getPessimisticLocks(), loggedInUser);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)activeLockRegion) && activeLockRegion.contains("BUDGET")) {
                List<PessimisticLock> otherBudgetLocks = this.findMatchingLocksWithGivenDescriptor(budgetLockDescriptor);
                lockService.releaseAllLocksForUser(otherBudgetLocks, loggedInUser, budgetLockDescriptor);
            }
        }
        for (PessimisticLock lock : document.getPessimisticLocks()) {
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)lock.getLockDescriptor()) || !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)activeLockRegion) || lock.getLockDescriptor().contains(activeLockRegion)) continue;
            List<PessimisticLock> otherLocks = this.findMatchingLocksWithGivenDescriptor(lock.getLockDescriptor());
            lockService.releaseAllLocksForUser(otherLocks, loggedInUser, lock.getLockDescriptor());
        }
    }

    protected void populateAuthorizationFields(KualiDocumentFormBase formBase) {
        if (formBase.isFormDocumentInitialized()) {
            KcTransactionalDocumentFormBase kcFormBase = (KcTransactionalDocumentFormBase)formBase;
            KcTransactionalDocumentBase document = (KcTransactionalDocumentBase)formBase.getDocument();
            Person user = GlobalVariables.getUserSession().getPerson();
            KcTransactionalDocumentAuthorizerBase documentAuthorizer = (KcTransactionalDocumentAuthorizerBase)this.getDocumentHelperService().getDocumentAuthorizer((Document)document);
            Set<String> editModes = new HashSet<String>();
            KcTransactionalDocumentFormBase kraFormBase = (KcTransactionalDocumentFormBase)formBase;
            kraFormBase.setupLockRegions();
            String activeLockRegion = (String)GlobalVariables.getUserSession().retrieveObject("ACTIVE_LOCK_REGION");
            if (!documentAuthorizer.canOpen((Document)document, user)) {
                editModes.add("unviewable");
            } else {
                document.setViewOnly(kcFormBase.isViewOnly());
                if (this.requiresLock((Document)document) && documentAuthorizer.canEdit((Document)document, user)) {
                    editModes.add("fullEntry");
                    Map editMode = this.convertSetToMap(editModes);
                    document.refreshPessimisticLocks();
                    HashSet<String> handledLockDescriptors = new HashSet<String>();
                    for (PessimisticLock lock : document.getPessimisticLocks()) {
                        if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)lock.getLockDescriptor()) || !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)activeLockRegion) || lock.getLockDescriptor().contains(activeLockRegion) || handledLockDescriptors.contains(lock.getLockDescriptor())) continue;
                        this.getPessimisticLockService().releaseAllLocksForUser(document.getPessimisticLocks(), user, lock.getLockDescriptor());
                        handledLockDescriptors.add(lock.getLockDescriptor());
                    }
                    if (!document.getDocumentHeader().getWorkflowDocument().isInitiated()) {
                        editMode = this.getPessimisticLockService().establishLocks((Document)document, editMode, user);
                    }
                    document.refreshPessimisticLocks();
                    if (editMode.containsKey("viewOnly")) {
                        document.setViewOnly(true);
                        if (document instanceof AwardBudgetDocument) {
                            AwardBudgetDocument budgetDoc = (AwardBudgetDocument)document;
                            budgetDoc.getBudget().getBudgetParent().getDocument().setViewOnly(true);
                        }
                    }
                }
                editModes = documentAuthorizer.getEditModes((Document)document, user, null);
                Set<String> documentActions = documentAuthorizer.getDocumentActions((Document)document, user, null);
                formBase.setDocumentActions(this.convertSetToMap(documentActions));
            }
            formBase.setEditingMode(this.convertSetToMap(editModes));
        }
    }

    private boolean requiresLock(Document document) {
        return this.getDataDictionaryService().getDataDictionary().getDocumentEntry(document.getClass().getName()).getUsePessimisticLocking();
    }

    protected boolean canSave(ActionForm form) {
        boolean authorizerCanSave = true;
        Document document = ((KcTransactionalDocumentFormBase)form).getDocument();
        DocumentAuthorizer documentAuthorizer = this.getDocumentHelperService().getDocumentAuthorizer(document);
        if (documentAuthorizer != null) {
            authorizerCanSave = documentAuthorizer.canSave(document, GlobalVariables.getUserSession().getPerson());
        }
        return super.canSave(form) && authorizerCanSave;
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase docForm = (KualiDocumentFormBase)form;
        this.preDocumentSave(docForm);
        String originalStatus = this.getDocumentStatus(docForm.getDocument());
        ActionForward actionForward = super.save(mapping, form, request, response);
        if (this.isInitialSave(originalStatus)) {
            this.initialDocumentSave(docForm);
        }
        this.postDocumentSave(docForm);
        return actionForward;
    }

    protected void preDocumentSave(KualiDocumentFormBase form) throws Exception {
    }

    protected void postDocumentSave(KualiDocumentFormBase form) throws Exception {
    }

    protected void initialDocumentSave(KualiDocumentFormBase form) throws Exception {
    }

    private String getDocumentStatus(Document doc) {
        try {
            return doc.getDocumentHeader().getWorkflowDocument().getStatus().getLabel();
        }
        catch (RiceRuntimeException e) {
            LOG.error("Could not find doc.getDocumentNumber(): " + doc.getDocumentNumber() + ":" + doc.getDocumentHeader().getDocumentNumber() + ":" + doc.getDocumentHeader().getOrganizationDocumentNumber(), (Throwable)e);
            return "NOT FOUND";
        }
    }

    private boolean isInitialSave(String status) {
        return GlobalVariables.getMessageMap().hasNoErrors() && org.apache.commons.lang3.StringUtils.equals((CharSequence)"INITIATED", (CharSequence)status);
    }

    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        KualiDocumentFormBase docForm = (KualiDocumentFormBase)form;
        if (this.canSave((ActionForm)docForm)) {
            Object question = this.getQuestion(request);
            if (question == null) {
                this.saveUnconvertedValuesToSession(request, docForm);
                forward = this.performQuestionWithoutInput(mapping, form, request, response, "DocSaveBeforeClose", this.getKualiConfigurationService().getPropertyValueAsString("document.question.saveBeforeClose.text"), "kcConfirmationQuestion", "close", "");
            } else {
                String buttonClicked = request.getParameter("buttonClicked");
                Map<String, Object> unconvertedValues = this.restoreUnconvertedValuesFromSession(request, docForm);
                if (("DocSaveBeforeClose".equals(question) || "changePendingActivitiesKey".equals(question)) && "0".equals(buttonClicked)) {
                    if (MapUtils.isNotEmpty(unconvertedValues)) {
                        for (Map.Entry<String, Object> entry : unconvertedValues.entrySet()) {
                            docForm.populateForProperty(entry.getKey(), entry.getValue(), unconvertedValues);
                        }
                    }
                    forward = this.saveOnClose(mapping, form, request, response);
                } else {
                    forward = "DocSaveBeforeClose".equals(question) && "2".equals(buttonClicked) ? mapping.findForward("basic") : super.close(mapping, (ActionForm)docForm, request, response);
                }
            }
        } else {
            forward = this.returnToSender(request, mapping, docForm);
        }
        return forward;
    }

    private void saveUnconvertedValuesToSession(HttpServletRequest request, KualiDocumentFormBase docForm) {
        if (MapUtils.isNotEmpty((Map)docForm.getUnconvertedValues())) {
            request.getSession().setAttribute(this.getUnconvertedValuesSessionAttributeKey(docForm), new HashMap(docForm.getUnconvertedValues()));
        }
    }

    private Map<String, Object> restoreUnconvertedValuesFromSession(HttpServletRequest request, KualiDocumentFormBase docForm) {
        Map unconvertedValues = (Map)request.getSession().getAttribute(this.getUnconvertedValuesSessionAttributeKey(docForm));
        if (MapUtils.isNotEmpty((Map)unconvertedValues)) {
            request.getSession().removeAttribute(this.getUnconvertedValuesSessionAttributeKey(docForm));
            docForm.setUnconvertedValues(unconvertedValues);
        }
        return unconvertedValues;
    }

    private String getUnconvertedValuesSessionAttributeKey(KualiDocumentFormBase docForm) {
        return "preCloseUnconvertedValues." + docForm.getDocId();
    }

    protected ActionForward saveOnClose(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase documentForm = (KualiDocumentFormBase)form;
        if (this.isInitialSave(this.getDocumentStatus(documentForm.getDocument()))) {
            this.initialDocumentSave(documentForm);
        }
        return super.close(mapping, form, request, response);
    }

    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.route(mapping, form, request, response);
        if (form instanceof InstitutionalProposalForm || form instanceof AwardForm || form instanceof TimeAndMoneyForm || form instanceof SubAwardForm) {
            ActionForward basicForward = mapping.findForward("basic");
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)forward.getPath(), (CharSequence)basicForward.getPath())) {
                this.setupDocumentExit();
                forward = mapping.findForward("portal");
            }
        }
        return forward;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void streamToResponse(KcFile attachmentDataSource, HttpServletResponse response) throws Exception {
        byte[] xbts = attachmentDataSource.getData();
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream(xbts.length);
            baos.write(xbts);
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)attachmentDataSource.getType(), (ByteArrayOutputStream)baos, (String)attachmentDataSource.getName());
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                    baos = null;
                }
            }
            catch (IOException iOException) {}
        }
    }

    private DocumentService getKraDocumentService() {
        return KcServiceLocator.getService(DocumentService.class);
    }

    protected ActionForward returnToSender(HttpServletRequest request, ActionMapping mapping, KualiDocumentFormBase form) {
        KcTransactionalDocumentFormBase kraForm;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)form.getBackLocation())) {
            form.setBackLocation(KRAD_PORTAL_URL);
        }
        ActionForward superForward = super.returnToSender(request, mapping, form);
        if (form instanceof KcTransactionalDocumentFormBase && (kraForm = (KcTransactionalDocumentFormBase)form).isMedusaOpenedDoc()) {
            return mapping.findForward("closePage");
        }
        if (form.isReturnToActionList()) {
            GlobalVariables.getUserSession().addObject("forceHoldingForActionList", (Object)true);
            return this.routeActionListToHoldingPage(mapping, superForward, form.getDocument().getDocumentNumber());
        }
        return superForward;
    }

    private ActionForward routeActionListToHoldingPage(ActionMapping mapping, ActionForward actionForward, String documentId) {
        String returnLocation = actionForward.getPath();
        ActionForward basicForward = mapping.findForward("portal");
        ActionRedirect holdingPageForward = new ActionRedirect((ForwardConfig)mapping.findForward("kraHoldingPage"));
        holdingPageForward.addParameter("holdingPageDocumentId", (Object)documentId);
        return this.routeToHoldingPage(basicForward, basicForward, holdingPageForward, returnLocation, documentId);
    }

    protected ActionForward routeToHoldingPage(ActionForward forward, ActionForward returnForward, ActionRedirect holdingPageForward, String returnLocation, String documentId) {
        return this.routeToHoldingPage(Collections.singletonList(forward), returnForward, holdingPageForward, returnLocation, documentId);
    }

    protected ActionForward routeToHoldingPage(List<ActionForward> forwards, ActionForward returnForward, ActionRedirect holdingPageForward, String returnLocation, String documentId) {
        boolean knownForward = false;
        for (ActionForward forward : forwards) {
            if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)forward.getPath(), (CharSequence)returnForward.getPath())) continue;
            knownForward = true;
        }
        if (!knownForward) {
            return returnForward;
        }
        GlobalVariables.getUserSession().addObject("holdingPageMessages", (Object)KNSGlobalVariables.getMessageList());
        holdingPageForward.addParameter("holdingPageReturnLocation", (Object)returnLocation);
        GlobalVariables.getUserSession().addObject("holdingPageReturnLocation", (Object)returnLocation);
        if (!URLEncodedUtils.parse((String)holdingPageForward.getParameterString(), (Charset)StandardCharsets.UTF_8).stream().anyMatch(pair -> "holdingPageDocumentId".equals(pair.getName()))) {
            holdingPageForward.addParameter("holdingPageDocumentId", (Object)documentId);
        }
        return holdingPageForward;
    }

    public ActionForward sendAdHocRequests(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KcTransactionalDocumentFormBase dform = (KcTransactionalDocumentFormBase)form;
        Document document = dform.getDocument();
        if (dform.getAdHocRoutePersons().size() > 0 || dform.getAdHocRouteWorkgroups().size() > 0) {
            document.prepareForSave();
            return super.sendAdHocRequests(mapping, (ActionForm)dform, request, response);
        }
        GlobalVariables.getMessageMap().putError("newAdHocRoutePerson.id", ONE_ADHOC_REQUIRED_ERROR_KEY, new String[0]);
        return mapping.findForward("basic");
    }

    protected static String getValidHeaderString(String s) {
        return MimeUtility.quote((String)s, (String)"()<>@,;:\\\"\t []/?=");
    }

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KcTransactionalDocumentFormBase docForm = (KcTransactionalDocumentFormBase)form;
        ActionForward forward = mapping.findForward("basic");
        String methodToCall = ((KualiForm)form).getMethodToCall();
        if (this.canSave((ActionForm)docForm) && !docForm.isViewOnly()) {
            Object question = this.getQuestion(request);
            if (question == null) {
                return this.performQuestionWithoutInput(mapping, form, request, response, DOCUMENT_RELOAD_QUESTION, this.getKualiConfigurationService().getPropertyValueAsString("warning.document.reload.confirmation"), "confirmationQuestion", methodToCall, "");
            }
            String buttonClicked = request.getParameter("buttonClicked");
            if (DOCUMENT_RELOAD_QUESTION.equals(question) && "0".equals(buttonClicked)) {
                forward = super.reload(mapping, (ActionForm)docForm, request, response);
            }
        } else {
            forward = super.reload(mapping, (ActionForm)docForm, request, response);
        }
        return forward;
    }

    public ActionForward reloadWithoutWarning(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.reload(mapping, form, request, response);
    }

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.docHandler(mapping, form, request, response);
        if (form instanceof CustomDataDocumentForm) {
            ((CustomDataDocumentForm)form).getCustomDataHelper().prepareCustomData();
        }
        return forward;
    }

    private KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    protected boolean isShowFullNameEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "Show_Full_Name_In_Pessimistic_Lock", Boolean.valueOf(false));
    }

    public static String getMethodToCallAttributeParameterValue(HttpServletRequest request, String parameterName) {
        String methodToCallAttribute = (String)request.getAttribute("methodToCallAttribute");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)methodToCallAttribute)) {
            return null;
        }
        return KcTransactionalDocumentActionBase.getMethodToCallAttributeParameterValue(methodToCallAttribute, parameterName);
    }

    public static String getMethodToCallAttributeParameterValue(String methodToCallAttribute, String parameterName) {
        return org.apache.commons.lang3.StringUtils.substringBefore((String)StringUtils.substringAfter((String)methodToCallAttribute, (String)("." + parameterName)), (String)".");
    }
}

