/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.controller.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.CaseFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.xml.namespace.QName;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.api.document.service.CommonApiService;
import org.kuali.coeus.sys.framework.config.KcConfigurer;
import org.kuali.coeus.sys.framework.controller.rest.RestBeanWrapperFactory;
import org.kuali.coeus.sys.framework.controller.rest.RestController;
import org.kuali.coeus.sys.framework.controller.rest.SimpleCrudRestSimpleUrlHandlerMapping;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLogger;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLoggerFactory;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.persistence.PersistenceVerificationService;
import org.kuali.coeus.sys.framework.rest.BadRequestException;
import org.kuali.coeus.sys.framework.rest.DataDictionaryValidationException;
import org.kuali.coeus.sys.framework.rest.NotImplementedException;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.coeus.sys.framework.rest.UnprocessableEntityException;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorHandlingUtilService;
import org.kuali.rice.core.api.criteria.CountFlag;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.util.io.SerializationUtils;
import org.kuali.rice.core.framework.config.module.ModuleConfigurer;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.data.CompoundKey;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.DictionaryValidationService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.util.QueryPagingRequest;
import org.kuali.rice.krad.util.QueryPagingResults;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

public abstract class SimpleCrudRestControllerBase<T, R>
extends RestController
implements InitializingBean,
BeanNameAware {
    private static final Logger LOG = LogManager.getLogger(SimpleCrudRestControllerBase.class);
    private static final java.util.function.Predicate<Class<?>> ALWAYS_TRUE = o -> true;
    private static final String REST_ENDPOINT_LIMIT_PREFIX = "REST_ENDPOINT_LIMIT_";
    private static final String DEFAULT_LIMIT_PARAMETER_NAME = "REST_ENDPOINT_LIMIT_DEFAULT";
    protected static final String START_INDEX_PARM = "_startIndex";
    protected static final String START_INDEX_DEFAULT = "0";
    protected static final String LIMIT_PARM = "_limit";
    private static final String X_KUALI_PAGING_START_INDEX = "X-Kuali-Paging-Start-Index";
    private static final String X_KUALI_PAGING_LIMIT = "X-Kuali-Paging-Limit";
    private static final String X_KUALI_PAGING_TOTAL = "X-Kuali-Paging-Total";
    private static final String DELIMETER = ":";
    private static final String ALLOW_MULTI_PARM = "_allowMulti";
    private static final String SCHEMA_PARM = "_schema";
    private static final String BLUEPRINT_PARM = "_blueprint";
    protected static final String SYNTHETIC_FIELD_PK = "_primaryKey";
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="legacyDataAdapter")
    private LegacyDataAdapter legacyDataAdapter;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="globalCacheManager")
    private CacheManager globalCacheManager;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="dictionaryValidationService")
    private DictionaryValidationService dictionaryValidationService;
    @Autowired
    @Qualifier(value="errorHandlingUtilService")
    private ErrorHandlingUtilService errorHandlingUtilService;
    @Autowired
    @Qualifier(value="persistenceVerificationService")
    private PersistenceVerificationService persistenceVerificationService;
    @Autowired
    @Qualifier(value="restAuditLoggerFactory")
    private RestAuditLoggerFactory restAuditLoggerFactory;
    @Autowired
    @Qualifier(value="autoRegisterMapping")
    private SimpleCrudRestSimpleUrlHandlerMapping autoRegisterMapping;
    @Autowired
    @Qualifier(value="dataDictionaryService")
    private DataDictionaryService dataDictionaryService;
    @Autowired
    @Qualifier(value="restBeanWrapperFactory")
    private RestBeanWrapperFactory restBeanWrapperFactory;
    @Autowired
    @Qualifier(value="restObjectMapper")
    private ObjectMapper restObjectMapper;
    @Autowired
    @Qualifier(value="maintenanceDocumentDictionaryService")
    private MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    private CommonApiService commonApiService;
    @Value(value="classpath:org/kuali/coeus/sys/framework/controller/rest/SimpleCrudRestControllerBlueprintTemplateGet.md")
    private Resource blueprintTemplateGet;
    @Value(value="classpath:org/kuali/coeus/sys/framework/controller/rest/SimpleCrudRestControllerBlueprintTemplatePut.md")
    private Resource blueprintTemplatePut;
    @Value(value="classpath:org/kuali/coeus/sys/framework/controller/rest/SimpleCrudRestControllerBlueprintTemplatePatch.md")
    private Resource blueprintTemplatePatch;
    @Value(value="classpath:org/kuali/coeus/sys/framework/controller/rest/SimpleCrudRestControllerBlueprintTemplatePost.md")
    private Resource blueprintTemplatePost;
    @Value(value="classpath:org/kuali/coeus/sys/framework/controller/rest/SimpleCrudRestControllerBlueprintTemplateDelete.md")
    private Resource blueprintTemplateDelete;
    @Autowired
    @Qualifier(value="moduleConfigurers")
    private Collection<ModuleConfigurer> moduleConfigurers;
    private String beanName;
    private boolean registerMapping = true;
    private BeanWrapper beanWrapper;
    private Class<T> dataObjectClazz;
    private Set<String> primaryKeys;
    private Set<String> sequencedPrimaryKeys;
    private String primaryKeyColumn;
    private String defaultLimitParameterName;
    private String defaultLimitParameterNamespace;
    private String defaultLimitParameterComponent;
    private String limitParameterNamePrefix;
    private String limitParameterName;
    private String limitParameterNamespace;
    private String limitParameterComponent;
    private String writePermissionTemplateNamespace;
    private String writePermissionTemplateName;
    private Map<String, String> writePermissionTemplateQualifiers;
    private String readPermissionTemplateNamespace;
    private String readPermissionTemplateName;
    private Map<String, String> readPermissionTemplateQualifiers;
    private String camelCasePluralName;
    private Set<RequestMethod> supportedMethods = Stream.of(RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE, RequestMethod.PATCH).collect(Collectors.toSet());
    private Set<String> cacheNamesToFlush;
    private Set<String> defaultSearchFields;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public Collection<R> getAll(@RequestParam(required=false) Map<String, String> parameters, @RequestParam(name="_startIndex", required=false, defaultValue="0") Integer startIndex, @RequestParam(name="_limit", required=false) Integer requestedLimit, HttpServletResponse response) {
        return this.getAll(parameters, startIndex, requestedLimit, response, this::translateAllDataObjects);
    }

    protected <ResultType> Collection<ResultType> getAll(Map<String, String> parameters, Integer startIndex, Integer requestedLimit, HttpServletResponse response, Function<Collection<T>, Collection<ResultType>> translateAllDataObjects) {
        this.assertMethodSupported(RequestMethod.GET);
        this.assertUserHasReadAccess();
        int systemLimit = this.getSystemLimit();
        this.assertValidPaging(startIndex, requestedLimit, systemLimit);
        int calculatedLimit = this.calculateLimit(requestedLimit, systemLimit);
        QueryPagingResults<T> results = this.doGetAllPaged(parameters, startIndex, calculatedLimit);
        Collection<ResultType> translatedResults = translateAllDataObjects.apply(results.getResults());
        this.addPagingHeaders(response, results);
        return translatedResults;
    }

    protected <ResultType> void addPagingHeaders(HttpServletResponse response, QueryPagingResults<ResultType> results) {
        response.addHeader(X_KUALI_PAGING_START_INDEX, String.valueOf(results.getPagingRequest().getStartAtIndex()));
        response.addHeader(X_KUALI_PAGING_LIMIT, String.valueOf(results.getPagingRequest().getMaxResults()));
        response.addHeader(X_KUALI_PAGING_TOTAL, String.valueOf(results.getTotal()));
    }

    @RequestMapping(method={RequestMethod.GET}, params={"_schema"})
    @ResponseBody
    public Map<String, Object> getSchema() {
        this.assertMethodSupported(RequestMethod.GET);
        return this.getSchemaMap();
    }

    public Map<String, Object> getSchemaMap() {
        HashMap<String, Object> schema = new HashMap<String, Object>();
        schema.put("primaryKey", this.getPrimaryKeyColumn());
        schema.put("columns", this.getExposedProperties());
        return schema;
    }

    @RequestMapping(value={"/{code}"}, method={RequestMethod.GET})
    @ResponseBody
    public R get(@PathVariable String code) {
        this.assertMethodSupported(RequestMethod.GET);
        this.assertUserHasReadAccess();
        T dataObject = this.getFromDataStore(code);
        if (dataObject == null) {
            throw new ResourceNotFoundException("not found for key " + code);
        }
        return this.convertDataObjectToDto(dataObject);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"_blueprint"})
    @ResponseBody
    public Resource getBlueprint(HttpServletResponse response) {
        this.assertMethodSupported(RequestMethod.GET);
        response.setContentType("text/markdown");
        response.setHeader("Content-Disposition", "attachment;filename=" + (String)CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_HYPHEN).convert((Object)this.getCamelCasePluralName()) + ".md");
        return this.getBlueprintResource();
    }

    protected Resource getBlueprintResource() {
        Object templateText = "";
        if (this.isMethodSupported(RequestMethod.GET)) {
            templateText = (String)templateText + this.getTemplateAsString(this.getBlueprintTemplateGet());
        }
        if (this.isMethodSupported(RequestMethod.PUT)) {
            templateText = (String)templateText + this.getTemplateAsString(this.getBlueprintTemplatePut());
        }
        if (this.isMethodSupported(RequestMethod.PATCH)) {
            templateText = (String)templateText + this.getTemplateAsString(this.getBlueprintTemplatePatch());
        }
        if (this.isMethodSupported(RequestMethod.POST)) {
            templateText = (String)templateText + this.getTemplateAsString(this.getBlueprintTemplatePost());
        }
        if (this.isMethodSupported(RequestMethod.DELETE)) {
            templateText = (String)templateText + this.getTemplateAsString(this.getBlueprintTemplateDelete());
        }
        templateText = ((String)templateText).replace("${resourceName}", WordUtils.capitalizeFully((String)Objects.requireNonNull((String)CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_HYPHEN).convert((Object)this.getCamelCasePluralName())).replaceAll("-", " ")));
        templateText = ((String)templateText).replace("${endpoint}", "/" + this.getModuleMapping() + this.getPath() + "/");
        templateText = ((String)templateText).replace("${sampleKey}", "(key)");
        templateText = ((String)templateText).replace("${sampleMatchCriteria}", this.getListOfTrackedProperties().stream().map(prop -> "+ " + prop + " (optional) - " + this.getPropertyDescription((String)prop)).collect(Collectors.joining("\n    ", "", "\n")));
        templateText = ((String)templateText).replace("${sampleResource1}", Stream.concat(this.getExposedProperties().stream(), Stream.of(SYNTHETIC_FIELD_PK)).collect(Collectors.joining("\": \"(val)\",\"", "{\"", "\": \"(val)\"}")));
        templateText = ((String)templateText).replace("${sampleResource2}", Stream.concat(this.getExposedProperties().stream(), Stream.of(SYNTHETIC_FIELD_PK)).collect(Collectors.joining("\": \"(val)\",\"", "{\"", "\": \"(val)\"}")));
        try {
            templateText = ((String)templateText).replace("${sampleSchema}", this.getRestObjectMapper().writeValueAsString(this.getSchemaMap()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ByteArrayResource(((String)templateText).getBytes(StandardCharsets.UTF_8));
    }

    protected String getTemplateAsString(Resource source) {
        try {
            return IOUtils.toString((InputStream)source.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"search"})
    @ResponseBody
    public List<R> search(@RequestParam(value="query", required=true) String query, @RequestParam(name="_startIndex", required=false, defaultValue="0") Integer startIndex, @RequestParam(name="_limit", required=false) Integer requestedLimit, @RequestParam(name="fields", required=false) String[] fields, HttpServletResponse response) {
        if (!this.isSearchEndpointEnabled()) {
            response.setStatus(404);
            return null;
        }
        if (fields == null || fields.length == 0) {
            fields = this.defaultSearchFields.toArray(new String[0]);
        }
        return this.searchInternal(query, startIndex, requestedLimit, fields, response);
    }

    public List<R> searchInternal(String query, Integer startIndex, Integer requestedLimit, String[] fields, HttpServletResponse response) {
        this.assertMethodSupported(RequestMethod.GET);
        this.assertUserHasReadAccess();
        int systemLimit = this.getSystemLimit();
        this.assertValidPaging(startIndex, requestedLimit, systemLimit);
        int calculatedLimit = this.calculateLimit(requestedLimit, systemLimit);
        QueryByCriteria.Builder queryBuilder = QueryByCriteria.Builder.create();
        if (!StringUtils.isEmpty((CharSequence)query)) {
            String wildcardQuery = "*" + query + "*";
            queryBuilder.setPredicates(new Predicate[]{PredicateFactory.or((Predicate[])Arrays.stream(fields).map(f -> PredicateFactory.likeIgnoreCase((String)f, (CharSequence)wildcardQuery)).collect(Collectors.toList()).toArray(new Predicate[0]))});
        }
        queryBuilder.setCountFlag(CountFlag.INCLUDE);
        queryBuilder.setStartAtIndex(startIndex);
        queryBuilder.setMaxResults(Integer.valueOf(calculatedLimit));
        QueryResults results = this.dataObjectService.findMatching(this.getDataObjectClazz(), queryBuilder.build());
        List<R> dtos = this.translateAllDataObjects(results.getResults());
        this.addPagingHeaders(response, new QueryPagingResults(new QueryPagingRequest(startIndex.intValue(), calculatedLimit), dtos, results.getTotalRowCount().intValue()));
        return dtos;
    }

    @RequestMapping(value={"/{code}"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void update(@PathVariable String code, @Valid @RequestBody R dto) {
        this.assertMethodSupported(RequestMethod.PUT);
        this.assertUserHasWriteAccess();
        T dataObjectOriginal = this.getFromDataStore(code);
        T dataObjectToModify = this.getFromDataStore(code);
        if (dataObjectOriginal == null) {
            throw new ResourceNotFoundException("not found for key " + code);
        }
        RestAuditLogger logger = this.getAuditLogger();
        this.logUpdateToObjectDto(dataObjectOriginal, dto, logger);
        this.updateDataObjectFromDto(dataObjectToModify, dto);
        this.validateBusinessObject(dataObjectToModify);
        this.validateUpdateDataObject(dataObjectToModify);
        if (this.isCompoundPrimaryKey() && this.hasPrimaryKeyChanged(code, dataObjectOriginal)) {
            this.delete(dataObjectOriginal);
        }
        this.save(dataObjectToModify);
        logger.saveAuditLog();
        this.flushCaches();
    }

    @RequestMapping(value={"/{code}"}, method={RequestMethod.PATCH})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void patch(@PathVariable String code, @Valid @RequestBody R dto) {
        this.patchInternal(code, dto, null);
    }

    @RequestMapping(value={"/{code}"}, method={RequestMethod.PATCH}, params={"createMaintenanceDocument=true"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void patchWithMaintDoc(@PathVariable String code, @Valid @RequestBody Map<String, Object> requestBody) {
        MaintenanceDocDto maintenanceDocDto = this.getMaintDocFromRequestBody(requestBody);
        Map<String, Object> data = this.getDataFromRequestBody(requestBody);
        Object dto = this.getRestObjectMapper().convertValue(data, new TypeReference<R>(){});
        this.patchInternal(code, dto, maintenanceDocDto);
    }

    protected void patchInternal(String code, R dto, MaintenanceDocDto maintenanceDocDto) {
        boolean createMaintenanceDoc;
        this.assertMethodSupported(RequestMethod.PATCH);
        this.assertUserHasWriteAccess();
        T dataObjectOriginal = this.getFromDataStore(code);
        T dataObjectToModify = this.getFromDataStore(code);
        if (dataObjectOriginal == null) {
            throw new ResourceNotFoundException("not found for key " + code);
        }
        this.mergeDataObjectFromDto(dataObjectToModify, dto);
        this.validateBusinessObject(dataObjectToModify);
        this.validateUpdateDataObject(dataObjectToModify);
        RestAuditLogger logger = this.getAuditLogger();
        this.logUpdateToObjectObject(dataObjectOriginal, dataObjectToModify, logger);
        boolean deleteOriginal = this.isCompoundPrimaryKey() && this.hasPrimaryKeyChanged(code, dataObjectToModify);
        boolean bl = createMaintenanceDoc = maintenanceDocDto != null;
        if (deleteOriginal) {
            if (createMaintenanceDoc) {
                try {
                    Serializable newDataObject = SerializationUtils.deepCopy((Serializable)((Serializable)dataObjectOriginal));
                    this.createAndRouteMaintenanceDoc(dataObjectOriginal, newDataObject, "Delete", maintenanceDocDto.getDescription(), maintenanceDocDto.getOrgDocNum(), maintenanceDocDto.getExplanation());
                }
                catch (WorkflowException e) {
                    throw new RuntimeException("Failed to create maintenance document.", e);
                }
            } else {
                this.delete(dataObjectOriginal);
            }
        }
        if (createMaintenanceDoc) {
            try {
                this.createAndRouteMaintenanceDoc(!deleteOriginal ? dataObjectOriginal : null, dataObjectToModify, !deleteOriginal ? "Edit" : "New", maintenanceDocDto.getDescription(), maintenanceDocDto.getOrgDocNum(), maintenanceDocDto.getExplanation());
            }
            catch (WorkflowException e) {
                throw new RuntimeException("Failed to create maintenance document.", e);
            }
        } else {
            this.save(dataObjectToModify);
        }
        logger.saveAuditLog();
        this.flushCaches();
    }

    @RequestMapping(method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void update(@Valid @RequestBody Object dto) {
        this.assertMethodSupported(RequestMethod.PUT);
        this.assertUserHasWriteAccess();
        if (dto instanceof List) {
            ((List)dto).stream().map(this::convertObjectToDto).forEach(this::doUpdate);
        } else {
            this.doUpdate(this.convertObjectToDto(dto));
        }
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public Object add(@Valid @RequestBody Object dto, @RequestParam(required=false) Map<String, String> parameters) {
        return this.addInternal(dto, parameters);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"createMaintenanceDocument=true"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public Object addWithMaintDoc(@Valid @RequestBody Map<String, Object> requestBody, @RequestParam(required=false) Map<String, String> parameters) {
        MaintenanceDocDto maintenanceDocDto = this.getMaintDocFromRequestBody(requestBody);
        Object dto = requestBody.get("data");
        return this.addInternal(dto, parameters, maintenanceDocDto);
    }

    public Object addInternal(Object dto, Map<String, String> parameters) {
        return this.addInternal(dto, parameters, null);
    }

    public Object addInternal(Object dto, Map<String, String> parameters, MaintenanceDocDto maintenanceDocDto) {
        this.assertMethodSupported(RequestMethod.POST);
        this.assertUserHasWriteAccess();
        if (dto instanceof List) {
            return ((List)dto).stream().map(this::convertObjectToDto).map(obj -> this.doAdd(obj, parameters, maintenanceDocDto)).collect(Collectors.toList());
        }
        return this.doAdd(this.convertObjectToDto(dto), parameters, maintenanceDocDto);
    }

    @RequestMapping(value={"/{code}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(@PathVariable String code, @RequestParam(required=false) Map<String, String> parameters) {
        this.deleteInternal(code, parameters, null);
    }

    @RequestMapping(value={"/{code}"}, method={RequestMethod.DELETE}, params={"createMaintenanceDocument=true"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteWithMaintDoc(@PathVariable String code, @RequestParam(required=false) Map<String, String> parameters, @Valid @RequestBody Map<String, Object> requestBody) {
        MaintenanceDocDto maintenanceDocDto = this.getMaintDocFromRequestBody(requestBody);
        this.deleteInternal(code, parameters, maintenanceDocDto);
    }

    public void deleteInternal(String code, Map<String, String> parameters, MaintenanceDocDto maintenanceDocDto) {
        this.assertMethodSupported(RequestMethod.DELETE);
        this.assertUserHasWriteAccess();
        this.doDelete(this.getFromDataStore(code), parameters, maintenanceDocDto);
    }

    @RequestMapping(method={RequestMethod.DELETE}, params={"_allowMulti"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAll(@RequestParam(required=false) Map<String, String> parameters, @RequestParam(name="_startIndex", required=false, defaultValue="0") Integer startIndex, @RequestParam(name="_limit", required=false) Integer requestedLimit, HttpServletResponse response) {
        this.assertMethodSupported(RequestMethod.DELETE);
        this.assertUserHasWriteAccess();
        int systemLimit = this.getSystemLimit();
        this.assertValidPaging(startIndex, requestedLimit, systemLimit);
        QueryPagingResults<T> results = this.doGetAllPaged(parameters, startIndex, this.calculateLimit(requestedLimit, systemLimit));
        results.getResults().forEach(obj -> this.doDelete(obj, parameters));
        this.addPagingHeaders(response, results);
    }

    protected void assertMethodSupported(RequestMethod method) {
        if (!this.isMethodSupported(method)) {
            throw new NotImplementedException(method + " not supported");
        }
    }

    protected void assertValidPaging(Integer startIndex, Integer requestedLimit, Integer systemLimit) {
        if (systemLimit == null) {
            throw new IllegalArgumentException("systemLimit is null");
        }
        if (startIndex < 0) {
            throw new BadRequestException("_startIndex(" + startIndex + ") less than 0");
        }
        if (requestedLimit != null && requestedLimit < 1) {
            throw new BadRequestException("_limit(" + requestedLimit + ") less than 1");
        }
        if (requestedLimit != null && requestedLimit > systemLimit) {
            throw new BadRequestException("_limit(" + requestedLimit + ") greater than system limit (" + systemLimit + ")");
        }
    }

    protected boolean isMethodSupported(RequestMethod method) {
        return this.supportedMethods.contains(method);
    }

    protected abstract R convertDataObjectToDto(T var1);

    protected abstract R convertObjectToDto(Object var1);

    protected abstract T convertDtoToDataObject(R var1);

    protected abstract Object getPropertyValueFromDto(String var1, R var2);

    protected abstract void setPropertyValueOnDto(String var1, Object var2, R var3);

    protected abstract void updateDataObjectFromDto(T var1, R var2);

    protected abstract void mergeDataObjectFromDto(T var1, R var2);

    protected abstract List<String> getExposedProperties();

    protected abstract List<String> getListOfTrackedProperties();

    protected Map.Entry<String, String> getWritePermission() {
        return org.kuali.coeus.sys.framework.util.CollectionUtils.entry(this.writePermissionTemplateNamespace, this.writePermissionTemplateName);
    }

    protected Map.Entry<String, String> getReadPermission() {
        return org.kuali.coeus.sys.framework.util.CollectionUtils.entry(this.readPermissionTemplateNamespace, this.readPermissionTemplateName);
    }

    protected T getNewDataObject() {
        try {
            return this.getDataObjectClazz().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("cannot create new data object", e);
        }
    }

    protected Object getPrimaryKeyIncomingObject(R dto, boolean allowNull) {
        return this.getPrimaryKeyWithPropertyResolver(name -> this.getPropertyValueFromDto((String)name, dto), allowNull);
    }

    protected Object getPrimaryKeyDataObject(T dataObject) {
        BeanWrapper beanWrapper = this.getRestBeanWrapperFactory().newInstance(dataObject);
        return this.getPrimaryKeyWithPropertyResolver(arg_0 -> ((BeanWrapper)beanWrapper).getPropertyValue(arg_0), false);
    }

    private Object getPrimaryKeyWithPropertyResolver(Function<String, Object> propertyResolver, boolean allowNull) {
        if (this.isCompoundPrimaryKey()) {
            List<String> pkColumns = Arrays.asList(this.getPrimaryKeyColumn().split(DELIMETER));
            Map pks = pkColumns.stream().map(pk -> org.kuali.coeus.sys.framework.util.CollectionUtils.entry(pk, this.getPrimaryKeyValueAndVerify((String)pk, propertyResolver, allowNull))).collect(org.kuali.coeus.sys.framework.util.CollectionUtils.nullSafeEntriesToMap());
            return pks.containsValue(null) ? null : new CompoundKey(pks);
        }
        return this.getPrimaryKeyValueAndVerify(this.getPrimaryKeyColumn(), propertyResolver, allowNull);
    }

    private Object getPrimaryKeyValueAndVerify(String pk, Function<String, Object> propertyResolver, boolean allowNull) {
        Object val = propertyResolver.apply(pk);
        if (val instanceof String && StringUtils.isBlank((CharSequence)((String)val))) {
            throw new ResourceNotFoundException(pk + " is blank.");
        }
        if (val == null && !allowNull) {
            throw new ResourceNotFoundException(pk + " is not present.");
        }
        return val;
    }

    protected String getPropertyDescription(String propertyName) {
        if (this.isAttrDefined(propertyName)) {
            String desc = this.dataDictionaryService.getAttributeDescription(this.getDataObjectClazz(), propertyName);
            String summary = this.dataDictionaryService.getAttributeSummary(this.getDataObjectClazz(), propertyName);
            String label = this.dataDictionaryService.getAttributeLabel(this.getDataObjectClazz(), propertyName);
            String shortLabel = this.dataDictionaryService.getAttributeLabel(this.getDataObjectClazz(), propertyName);
            Integer max = this.dataDictionaryService.getAttributeMaxLength(this.getDataObjectClazz().getName(), propertyName);
            Integer min = this.dataDictionaryService.getAttributeMinLength(this.getDataObjectClazz().getName(), propertyName);
            String maxInclusive = this.dataDictionaryService.getAttributeInclusiveMax(this.getDataObjectClazz().getName(), propertyName);
            String minExclusive = this.dataDictionaryService.getAttributeExclusiveMin(this.getDataObjectClazz().getName(), propertyName);
            Pattern validatingExpression = this.dataDictionaryService.getAttributeValidatingExpression(this.getDataObjectClazz().getName(), propertyName);
            String description = this.appendPeriod(StringUtils.isNotBlank((CharSequence)desc) ? desc : (StringUtils.isNotBlank((CharSequence)summary) ? summary : (StringUtils.isNotBlank((CharSequence)label) ? label : (StringUtils.isNotBlank((CharSequence)shortLabel) ? shortLabel : ""))));
            String maxLengthDescription = this.appendPeriod((String)(max != null ? "Maximum length is " + max : ""));
            String maxValueDescription = this.appendPeriod((String)(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{maxInclusive}) ? "Maximum inclusive value is " + maxInclusive : ""));
            String minLengthDescription = this.appendPeriod((String)(min != null ? "Minimum length is " + min : ""));
            String minValueDescription = this.appendPeriod((String)(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{minExclusive}) ? "Minimum exclusive value is " + minExclusive : ""));
            String patternDescription = this.appendPeriod((String)(validatingExpression != null ? "Validating pattern is " + validatingExpression.pattern() : ""));
            return description + this.prependSpace(maxLengthDescription) + this.prependSpace(minLengthDescription) + this.prependSpace(maxValueDescription) + this.prependSpace(minValueDescription) + this.prependSpace(patternDescription);
        }
        return "";
    }

    protected boolean isAttrDefined(String propertyName) {
        try {
            return this.dataDictionaryService.isAttributeDefined(this.getDataObjectClazz(), propertyName);
        }
        catch (RuntimeException e) {
            LOG.info(this.getDataObjectClazz().getName() + "." + propertyName + " not defined in the data dictionary because of an exception.", (Throwable)e);
            return false;
        }
    }

    protected String appendPeriod(String s) {
        if (StringUtils.isNotBlank((CharSequence)s) && !StringUtils.endsWith((CharSequence)StringUtils.trim((String)s), (CharSequence)".")) {
            return StringUtils.trim((String)s) + ".";
        }
        return s;
    }

    protected String prependSpace(String s) {
        if (StringUtils.isNotBlank((CharSequence)s)) {
            return " " + StringUtils.trim((String)s);
        }
        return s;
    }

    protected String primaryKeyToString(Object pkValues) {
        String key;
        if (pkValues == null) {
            throw new IllegalArgumentException("the primary key value cannot be null");
        }
        if (pkValues instanceof CompoundKey) {
            String keyNamesStr = this.getPrimaryKeyColumn();
            List<String> keyNames = Arrays.asList(keyNamesStr.split(DELIMETER));
            Map keys = ((CompoundKey)pkValues).getKeys();
            if (keyNames.size() != keys.size()) {
                throw new IllegalArgumentException("compoundKey value does not contain the same number key elements in format: " + keyNamesStr);
            }
            key = keyNames.stream().map(name -> keys.get(name).toString()).reduce((t, u) -> t + DELIMETER + u).get();
        } else {
            key = pkValues.toString();
        }
        return key;
    }

    protected boolean hasPrimaryKeyChanged(String newPk, T dataObject) {
        return !StringUtils.equals((CharSequence)newPk, (CharSequence)this.primaryKeyToString(this.getPrimaryKeyDataObject(dataObject)));
    }

    protected boolean isPrimitive(String name) {
        return this.beanWrapper.getPropertyType(name).isPrimitive();
    }

    protected Object translateValue(String name, String value) {
        return this.beanWrapper.convertIfNecessary((Object)value, this.beanWrapper.getPropertyType(name));
    }

    protected List<R> translateAllDataObjects(Collection<T> dataObjects) {
        return dataObjects.stream().map(this::convertDataObjectToDto).collect(Collectors.toList());
    }

    protected void doUpdate(R dto) {
        Object pk = this.getPrimaryKeyIncomingObject(dto, false);
        T dataObject = this.getFromDataStore(pk);
        if (dataObject == null) {
            throw new ResourceNotFoundException("not found for key " + pk);
        }
        RestAuditLogger logger = this.getAuditLogger();
        this.logUpdateToObjectDto(dataObject, dto, logger);
        this.updateDataObjectFromDto(dataObject, dto);
        this.validateBusinessObject(dataObject);
        this.validateUpdateDataObject(dataObject);
        this.save(dataObject);
        logger.saveAuditLog();
        this.flushCaches();
    }

    protected void flushCaches() {
        if (!org.springframework.util.CollectionUtils.isEmpty(this.getCacheNamesToFlush())) {
            this.getCacheNamesToFlush().forEach(name -> Optional.ofNullable(this.getGlobalCacheManager().getCache(name)).ifPresent(Cache::clear));
        }
    }

    protected RestAuditLogger getAuditLogger() {
        return this.restAuditLoggerFactory.getNewAuditLogger(this.dataObjectClazz, this.getListOfTrackedProperties());
    }

    protected void logUpdateToObjectDto(T currentObject, R newObject, RestAuditLogger logger) {
        T newDataObject = this.convertDtoToDataObject(newObject);
        logger.addModifiedItem(currentObject, newDataObject);
    }

    protected void logUpdateToObjectObject(T currentObject, T newObject, RestAuditLogger logger) {
        logger.addModifiedItem(currentObject, newObject);
    }

    protected void doAddSequenceHandling(R dto) {
        boolean legacy = this.restLegacySequenceHandling();
        if (legacy) {
            this.checkForDuplicate(dto);
        } else {
            Set<String> sequencedPks = this.getSequencedPrimaryKeys();
            if (sequencedPks.isEmpty()) {
                this.checkForDuplicate(dto);
            } else {
                sequencedPks.forEach(pk -> this.setPropertyValueOnDto((String)pk, null, dto));
            }
        }
    }

    protected R doAdd(R dto, Map<String, String> parameters, MaintenanceDocDto maintenanceDocDto) {
        Object savedDataObject;
        boolean createMaintenanceDoc;
        this.doAddSequenceHandling(dto);
        RestAuditLogger logger = this.getAuditLogger();
        T newDataObject = this.convertDtoToDataObject(dto);
        boolean bl = createMaintenanceDoc = maintenanceDocDto != null;
        if (createMaintenanceDoc) {
            try {
                MaintenanceDocument savedDocument = this.createAndRouteMaintenanceDoc(this.getNewDataObject(), newDataObject, "New", maintenanceDocDto.getDescription(), maintenanceDocDto.getOrgDocNum(), maintenanceDocDto.getExplanation());
                savedDataObject = savedDocument.getNewMaintainableObject().getBusinessObject();
            }
            catch (WorkflowException e) {
                throw new RuntimeException("Failed to create maintenance document.", e);
            }
        } else {
            savedDataObject = this.doAddDataObject(newDataObject, parameters);
        }
        logger.addNewItem(newDataObject);
        logger.saveAuditLog();
        this.flushCaches();
        return this.convertDataObjectToDto(savedDataObject);
    }

    protected boolean restLegacySequenceHandling() {
        return this.getParameterService().getParameterValueAsBoolean("KC-SYS", "All", "REST_LEGACY_SEQUENCE_HANDLING");
    }

    protected void checkForDuplicate(R dto) {
        T existingDataObject;
        Object code = this.getPrimaryKeyIncomingObject(dto, true);
        if (code != null && (existingDataObject = this.getFromDataStore(code)) != null) {
            throw new UnprocessableEntityException("duplicate item");
        }
    }

    protected T doAddDataObject(T newDataObject, Map<String, String> parameters) {
        this.validateBusinessObject(newDataObject);
        this.validateInsertDataObject(newDataObject);
        return this.save(newDataObject);
    }

    protected void doDelete(T existingDataObject, Map<String, String> parameters) {
        this.doDelete(existingDataObject, parameters, null);
    }

    protected void doDelete(T existingDataObject, Map<String, String> parameters, MaintenanceDocDto maintenanceDocDto) {
        boolean createMaintenanceDoc;
        if (existingDataObject == null) {
            throw new ResourceNotFoundException("not found");
        }
        RestAuditLogger logger = this.getAuditLogger();
        this.validateDeleteDataObject(existingDataObject);
        boolean bl = createMaintenanceDoc = maintenanceDocDto != null;
        if (createMaintenanceDoc) {
            try {
                Serializable newDataObject = SerializationUtils.deepCopy((Serializable)((Serializable)existingDataObject));
                this.createAndRouteMaintenanceDoc(existingDataObject, newDataObject, "Delete", maintenanceDocDto.getDescription(), maintenanceDocDto.getOrgDocNum(), maintenanceDocDto.getExplanation());
            }
            catch (WorkflowException e) {
                throw new RuntimeException("Failed to create maintenance document.", e);
            }
        } else {
            this.delete(existingDataObject);
        }
        logger.addDeletedItem(existingDataObject);
        logger.saveAuditLog();
        this.flushCaches();
    }

    private MaintenanceDocument createAndRouteMaintenanceDoc(T existingDataObject, T newDataObject, String maintenanceAction, String maintenanceDocDescription, String maintenanceDocOrgDocNum, String maintenanceDocExplanation) throws WorkflowException {
        MaintenanceDocument savedDocument;
        String maintDocName = this.maintenanceDocumentDictionaryService.getDocumentTypeName(this.getDataObjectClazz());
        MaintenanceDocument document = (MaintenanceDocument)this.getDocumentService().getNewDocument(maintDocName);
        document.getOldMaintainableObject().setMaintenanceAction(maintenanceAction);
        document.getOldMaintainableObject().setDataObject(existingDataObject);
        document.getNewMaintainableObject().setMaintenanceAction(maintenanceAction);
        document.getNewMaintainableObject().setDataObject(newDataObject);
        document.getDocumentHeader().setDocumentDescription(!StringUtils.isBlank((CharSequence)maintenanceDocDescription) ? maintenanceDocDescription : "Created via REST API");
        if (!StringUtils.isBlank((CharSequence)maintenanceDocOrgDocNum)) {
            document.getDocumentHeader().setOrganizationDocumentNumber(maintenanceDocOrgDocNum);
        }
        if (!StringUtils.isBlank((CharSequence)maintenanceDocExplanation)) {
            document.getDocumentHeader().setExplanation(maintenanceDocExplanation);
        }
        if ((savedDocument = (MaintenanceDocument)this.getDocumentService().saveDocument((Document)document)) != null) {
            this.getCommonApiService().routeDocument((Document)savedDocument);
        }
        return savedDocument;
    }

    protected QueryPagingResults<T> doGetAllPaged(Map<String, String> parameters, Integer startIndex, Integer limit) {
        Map searchCriteria = parameters != null ? parameters.entrySet().stream().filter(e -> this.getExposedProperties().contains(e.getKey())).map(entry -> {
            try {
                Object val = this.translateValue((String)entry.getKey(), (String)entry.getValue());
                return org.kuali.coeus.sys.framework.util.CollectionUtils.entry((String)entry.getKey(), val);
            }
            catch (TypeMismatchException e) {
                throw new ResourceNotFoundException(e.getMessage(), e);
            }
        }).collect(org.kuali.coeus.sys.framework.util.CollectionUtils.entriesToMap()) : Collections.emptyMap();
        QueryPagingResults<T> dataObjects = !org.springframework.util.CollectionUtils.isEmpty(searchCriteria) ? this.getMatchingFromDataStorePaged(searchCriteria, startIndex, limit) : this.getAllFromDataStorePaged(startIndex, limit);
        if (dataObjects == null || dataObjects.getResults() != null && dataObjects.getResults().isEmpty()) {
            throw new ResourceNotFoundException("not found" + (String)(searchCriteria.isEmpty() ? "" : " for search criteria " + searchCriteria));
        }
        return dataObjects;
    }

    protected void validateDeleteDataObject(T dataObject) {
        this.throwIfErrorMessages(this.persistenceVerificationService.verifyRelationshipsForDelete(dataObject, Collections.emptyList()));
    }

    protected void validateUpdateDataObject(T dataObject) {
        this.throwIfErrorMessages(this.persistenceVerificationService.verifyRelationshipsForUpdate(dataObject, Collections.emptyList()));
    }

    protected void validateInsertDataObject(T dataObject) {
        this.throwIfErrorMessages(this.persistenceVerificationService.verifyRelationshipsForInsert(dataObject, Collections.emptyList()));
    }

    protected void validateBusinessObject(T dataObject) {
        if (!this.dictionaryValidationService.isBusinessObjectValid(dataObject)) {
            this.throwIfErrorMessages(this.getGlobalVariableService().getMessageMap());
        }
    }

    protected void throwIfErrorMessages(MessageMap messageMap) {
        Map<String, List<String>> errors;
        if (messageMap != null && messageMap.hasErrors() && (errors = this.errorHandlingUtilService.extractErrorMessages(messageMap)) != null && !errors.isEmpty()) {
            throw new DataDictionaryValidationException(errors);
        }
    }

    protected QueryPagingResults<T> getAllFromDataStorePaged(Integer startIndex, Integer limit) {
        return this.getLegacyDataAdapter().findAll(this.getDataObjectClazz(), new QueryPagingRequest(startIndex.intValue(), limit.intValue()));
    }

    protected QueryPagingResults<T> getMatchingFromDataStorePaged(Map<String, ?> criteria, Integer startIndex, Integer limit) {
        return this.getLegacyDataAdapter().findMatching(this.getDataObjectClazz(), criteria, new QueryPagingRequest(startIndex.intValue(), limit.intValue()));
    }

    protected T getFromDataStore(Object code) {
        if (this.isCompoundPrimaryKey() && code instanceof CompoundKey) {
            return (T)this.getLegacyDataAdapter().findByPrimaryKey(this.getDataObjectClazz(), ((CompoundKey)code).getKeys());
        }
        if (this.isCompoundPrimaryKey() && code instanceof String) {
            return (T)this.getLegacyDataAdapter().findByPrimaryKey(this.getDataObjectClazz(), this.getCompoundKeyMap((String)code));
        }
        if (code instanceof String) {
            if (StringUtils.isBlank((CharSequence)((String)code))) {
                throw new ResourceNotFoundException(this.getPrimaryKeyColumn() + " is blank.");
            }
            return (T)this.getLegacyDataAdapter().findBySinglePrimaryKey(this.getDataObjectClazz(), this.translateValue(this.getPrimaryKeyColumn(), (String)code));
        }
        if (code == null) {
            throw new ResourceNotFoundException(this.getPrimaryKeyColumn() + " is not present.");
        }
        return (T)this.getLegacyDataAdapter().findBySinglePrimaryKey(this.getDataObjectClazz(), code);
    }

    protected Map<String, Object> getCompoundKeyMap(String compoundKey) {
        if (compoundKey.contains(DELIMETER)) {
            String[] keyValues;
            String[] keyNames = this.getPrimaryKeyColumn().split(DELIMETER);
            if (keyNames.length != (keyValues = compoundKey.split(DELIMETER)).length) {
                throw new ResourceNotFoundException("compoundKey value does not contain the same number key elements in format: " + this.getPrimaryKeyColumn());
            }
            return org.kuali.coeus.sys.framework.util.CollectionUtils.zipMap(keyNames, keyValues).entrySet().stream().map(e -> org.kuali.coeus.sys.framework.util.CollectionUtils.entry((String)e.getKey(), this.translateValue((String)e.getKey(), (String)e.getValue()))).collect(org.kuali.coeus.sys.framework.util.CollectionUtils.entriesToMap());
        }
        throw new ResourceNotFoundException("compoundKey value does not contain the same number key elements in format: " + this.getPrimaryKeyColumn());
    }

    protected T save(T dataObject) {
        if (this.useDataObjectService()) {
            return (T)this.getDataObjectService().save(dataObject, new PersistenceOption[]{PersistenceOption.FLUSH, PersistenceOption.LINK_KEYS});
        }
        return (T)this.getBusinessObjectService().save((PersistableBusinessObject)dataObject);
    }

    protected void delete(T dataObject) {
        this.getLegacyDataAdapter().delete(dataObject);
    }

    protected boolean useDataObjectService() {
        return this.getDataObjectService().supports(this.getDataObjectClazz());
    }

    protected void assertUserHasWriteAccess() {
        if (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), this.getWritePermission().getKey(), this.getWritePermission().getValue(), this.getWritePermissionTemplateQualifiers())) {
            throw new UnauthorizedAccessException();
        }
    }

    protected void assertUserHasReadAccess() {
        if (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), this.getReadPermission().getKey(), this.getReadPermission().getValue(), this.getReadPermissionTemplateQualifiers())) {
            throw new UnauthorizedAccessException();
        }
    }

    String toPlural(String singular) {
        if (singular.endsWith("Bo") || singular.endsWith("BO")) {
            singular = singular.substring(0, singular.length() - 2);
        }
        if (!(!singular.endsWith("y") || singular.endsWith("ay") || singular.endsWith("ey") || singular.endsWith("iy") || singular.endsWith("oy") || singular.endsWith("uy"))) {
            return singular.substring(0, singular.length() - 1) + "ies";
        }
        if (singular.endsWith("s") || singular.endsWith("x") || singular.endsWith("z") || singular.endsWith("ch") || singular.endsWith("sh")) {
            return singular + "es";
        }
        return singular + "s";
    }

    private String getModuleMapping() {
        KcConfigurer configurer = this.getModuleConfigurers().stream().filter(mc -> mc instanceof KcConfigurer).map(mc -> (KcConfigurer)((Object)mc)).filter(mc -> {
            SimpleCrudRestControllerBase controller = (SimpleCrudRestControllerBase)mc.getRootResourceLoader().getService(new QName(this.getBeanName()));
            return controller != null && controller.getDataObjectClazz().equals(this.getDataObjectClazz());
        }).findFirst().get();
        return configurer.getDispatchServletMappings().stream().filter(mapping -> !mapping.contains("krad")).findFirst().get();
    }

    private String getPath() {
        return "/api/v1/" + (String)CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_HYPHEN).convert((Object)this.getCamelCasePluralName());
    }

    protected int getSystemLimit() {
        return Integer.parseInt(this.parameterService.getParameterValueAsString(this.limitParameterNamespace, this.limitParameterComponent, this.limitParameterName, this.parameterService.getParameterValueAsString(this.defaultLimitParameterNamespace, this.defaultLimitParameterComponent, this.defaultLimitParameterName)));
    }

    protected int calculateLimit(Integer requestedLimit, Integer systemLimit) {
        return requestedLimit != null && requestedLimit < systemLimit ? requestedLimit : systemLimit;
    }

    public void afterPropertiesSet() {
        if (this.dataObjectClazz == null) {
            throw new IllegalStateException("dataObjectClazz is required");
        }
        if (Modifier.isAbstract(this.dataObjectClazz.getModifiers())) {
            throw new IllegalStateException("dataObjectClazz must not be abstract: " + this.dataObjectClazz.getName());
        }
        if (StringUtils.isBlank((CharSequence)this.camelCasePluralName)) {
            this.setCamelCasePluralName(this.toPlural(this.dataObjectClazz.getSimpleName()));
        }
        if (StringUtils.isBlank((CharSequence)this.writePermissionTemplateName)) {
            this.setWritePermissionTemplateName("Write Class");
        }
        if (StringUtils.isBlank((CharSequence)this.writePermissionTemplateNamespace)) {
            this.setWritePermissionTemplateNamespace("KC-SYS");
        }
        if (org.springframework.util.CollectionUtils.isEmpty(this.writePermissionTemplateQualifiers)) {
            this.setWritePermissionTemplateQualifiers(Collections.singletonMap("className", this.getDataObjectClazz().getName()));
        }
        if (StringUtils.isBlank((CharSequence)this.readPermissionTemplateName)) {
            this.setReadPermissionTemplateName("Read Class");
        }
        if (StringUtils.isBlank((CharSequence)this.readPermissionTemplateNamespace)) {
            this.setReadPermissionTemplateNamespace("KC-SYS");
        }
        if (org.springframework.util.CollectionUtils.isEmpty(this.readPermissionTemplateQualifiers)) {
            this.setReadPermissionTemplateQualifiers(Collections.singletonMap("className", this.getDataObjectClazz().getName()));
        }
        if (StringUtils.isBlank((CharSequence)this.defaultLimitParameterName)) {
            this.setDefaultLimitParameterName(DEFAULT_LIMIT_PARAMETER_NAME);
        }
        if (StringUtils.isBlank((CharSequence)this.defaultLimitParameterNamespace)) {
            this.setDefaultLimitParameterNamespace("KC-SYS");
        }
        if (StringUtils.isBlank((CharSequence)this.defaultLimitParameterComponent)) {
            this.setDefaultLimitParameterComponent("All");
        }
        if (StringUtils.isBlank((CharSequence)this.limitParameterName) && StringUtils.isBlank((CharSequence)this.limitParameterNamePrefix)) {
            this.setLimitParameterNamePrefix(REST_ENDPOINT_LIMIT_PREFIX);
        }
        if (StringUtils.isBlank((CharSequence)this.limitParameterName)) {
            this.setLimitParameterName(this.limitParameterNamePrefix + this.getDataObjectClazz().getName());
        }
        if (StringUtils.isBlank((CharSequence)this.limitParameterNamespace)) {
            this.setLimitParameterNamespace("KC-SYS");
        }
        if (StringUtils.isBlank((CharSequence)this.limitParameterComponent)) {
            this.setLimitParameterComponent("All");
        }
        if (this.isRegisterMapping() && this.autoRegisterMapping != null) {
            this.autoRegisterMapping.setPathPrefixes(Collections.singletonMap(this.getPath(), ALWAYS_TRUE));
            this.autoRegisterMapping.detectHandlerMethods(this);
        }
        this.beanWrapper = this.getRestBeanWrapperFactory().newInstance(this.dataObjectClazz);
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public CacheManager getGlobalCacheManager() {
        return this.globalCacheManager;
    }

    public void setGlobalCacheManager(CacheManager globalCacheManager) {
        this.globalCacheManager = globalCacheManager;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public DictionaryValidationService getDictionaryValidationService() {
        return this.dictionaryValidationService;
    }

    public void setDictionaryValidationService(DictionaryValidationService dictionaryValidationService) {
        this.dictionaryValidationService = dictionaryValidationService;
    }

    public LegacyDataAdapter getLegacyDataAdapter() {
        return this.legacyDataAdapter;
    }

    public void setLegacyDataAdapter(LegacyDataAdapter legacyDataAdapter) {
        this.legacyDataAdapter = legacyDataAdapter;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public PersistenceVerificationService getPersistenceVerificationService() {
        return this.persistenceVerificationService;
    }

    public void setPersistenceVerificationService(PersistenceVerificationService persistenceVerificationService) {
        this.persistenceVerificationService = persistenceVerificationService;
    }

    public Class<T> getDataObjectClazz() {
        return this.dataObjectClazz;
    }

    public void setDataObjectClazz(Class<T> dataObjectClazz) {
        this.dataObjectClazz = dataObjectClazz;
    }

    public String getWritePermissionTemplateNamespace() {
        return this.writePermissionTemplateNamespace;
    }

    public void setWritePermissionTemplateNamespace(String writePermissionTemplateNamespace) {
        this.writePermissionTemplateNamespace = writePermissionTemplateNamespace;
    }

    public String getWritePermissionTemplateName() {
        return this.writePermissionTemplateName;
    }

    public void setWritePermissionTemplateName(String writePermissionTemplateName) {
        this.writePermissionTemplateName = writePermissionTemplateName;
    }

    public Map<String, String> getWritePermissionTemplateQualifiers() {
        return this.writePermissionTemplateQualifiers;
    }

    public void setWritePermissionTemplateQualifiers(Map<String, String> writePermissionTemplateQualifiers) {
        this.writePermissionTemplateQualifiers = writePermissionTemplateQualifiers;
    }

    public String getReadPermissionTemplateNamespace() {
        return this.readPermissionTemplateNamespace;
    }

    public void setReadPermissionTemplateNamespace(String readPermissionTemplateNamespace) {
        this.readPermissionTemplateNamespace = readPermissionTemplateNamespace;
    }

    public String getReadPermissionTemplateName() {
        return this.readPermissionTemplateName;
    }

    public void setReadPermissionTemplateName(String readPermissionTemplateName) {
        this.readPermissionTemplateName = readPermissionTemplateName;
    }

    public Map<String, String> getReadPermissionTemplateQualifiers() {
        return this.readPermissionTemplateQualifiers;
    }

    public void setReadPermissionTemplateQualifiers(Map<String, String> readPermissionTemplateQualifiers) {
        this.readPermissionTemplateQualifiers = readPermissionTemplateQualifiers;
    }

    public ErrorHandlingUtilService getErrorHandlingUtilService() {
        return this.errorHandlingUtilService;
    }

    public void setErrorHandlingUtilService(ErrorHandlingUtilService errorHandlingUtilService) {
        this.errorHandlingUtilService = errorHandlingUtilService;
    }

    public String getPrimaryKeyColumn() {
        if (StringUtils.isBlank((CharSequence)this.primaryKeyColumn)) {
            this.primaryKeyColumn = (String)this.getPrimaryKeys().stream().sorted().reduce((t, u) -> t + DELIMETER + u).get();
        }
        return this.primaryKeyColumn;
    }

    protected Set<String> getPrimaryKeys() {
        if (CollectionUtils.isEmpty(this.primaryKeys)) {
            this.primaryKeys = Set.copyOf(this.persistenceVerificationService.pkFields(this.dataObjectClazz));
        }
        return this.primaryKeys;
    }

    protected Set<String> getSequencedPrimaryKeys() {
        if (CollectionUtils.isEmpty(this.sequencedPrimaryKeys)) {
            this.sequencedPrimaryKeys = Set.copyOf(this.getPersistenceVerificationService().getSequencedPrimaryKeys(this.dataObjectClazz));
        }
        return this.sequencedPrimaryKeys;
    }

    private Map<String, Object> getDataFromRequestBody(Map<String, Object> requestBody) {
        return (Map)requestBody.get("data");
    }

    private MaintenanceDocDto getMaintDocFromRequestBody(Map<String, Object> requestBody) {
        return this.getMaintDocDtoFromMap((Map)requestBody.get("maintDoc"));
    }

    private MaintenanceDocDto getMaintDocDtoFromMap(Map<String, Object> map) {
        String description = null;
        String orgDocNum = null;
        String explanation = null;
        if (map != null) {
            description = (String)map.get("description");
            orgDocNum = (String)map.get("orgDocNum");
            explanation = (String)map.get("explanation");
        }
        return new MaintenanceDocDto(description, orgDocNum, explanation);
    }

    public boolean isCompoundPrimaryKey() {
        return this.getPrimaryKeyColumn().contains(DELIMETER);
    }

    public void setPrimaryKeyColumn(String primaryKeyColumn) {
        this.primaryKeyColumn = primaryKeyColumn;
    }

    public String getCamelCasePluralName() {
        return this.camelCasePluralName;
    }

    public void setCamelCasePluralName(String camelCasePluralName) {
        this.camelCasePluralName = camelCasePluralName;
    }

    public RestAuditLoggerFactory getRestAuditLoggerFactory() {
        return this.restAuditLoggerFactory;
    }

    public void setRestAuditLoggerFactory(RestAuditLoggerFactory restAuditLoggerFactory) {
        this.restAuditLoggerFactory = restAuditLoggerFactory;
    }

    public boolean isRegisterMapping() {
        return this.registerMapping;
    }

    public void setRegisterMapping(boolean registerMapping) {
        this.registerMapping = registerMapping;
    }

    public SimpleCrudRestSimpleUrlHandlerMapping getAutoRegisterMapping() {
        return this.autoRegisterMapping;
    }

    public void setAutoRegisterMapping(SimpleCrudRestSimpleUrlHandlerMapping autoRegisterMapping) {
        this.autoRegisterMapping = autoRegisterMapping;
    }

    public Collection<ModuleConfigurer> getModuleConfigurers() {
        return this.moduleConfigurers;
    }

    public void setModuleConfigurers(Collection<ModuleConfigurer> moduleConfigurers) {
        this.moduleConfigurers = moduleConfigurers;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public RestBeanWrapperFactory getRestBeanWrapperFactory() {
        return this.restBeanWrapperFactory;
    }

    public void setRestBeanWrapperFactory(RestBeanWrapperFactory restBeanWrapperFactory) {
        this.restBeanWrapperFactory = restBeanWrapperFactory;
    }

    public Set<RequestMethod> getSupportedMethods() {
        return this.supportedMethods;
    }

    public void setSupportedMethods(Set<RequestMethod> supportedMethods) {
        this.supportedMethods = supportedMethods;
    }

    public Set<String> getCacheNamesToFlush() {
        return this.cacheNamesToFlush;
    }

    public void setCacheNamesToFlush(Set<String> cacheNamesToFlush) {
        this.cacheNamesToFlush = cacheNamesToFlush;
    }

    public Set<String> getDefaultSearchFields() {
        return this.defaultSearchFields;
    }

    public void setDefaultSearchFields(Set<String> defaultSearchFields) {
        this.defaultSearchFields = defaultSearchFields;
    }

    public boolean isSearchEndpointEnabled() {
        return this.defaultSearchFields != null && !this.defaultSearchFields.isEmpty();
    }

    public Resource getBlueprintTemplateGet() {
        return this.blueprintTemplateGet;
    }

    public void setBlueprintTemplateGet(Resource blueprintTemplateGet) {
        this.blueprintTemplateGet = blueprintTemplateGet;
    }

    public Resource getBlueprintTemplatePut() {
        return this.blueprintTemplatePut;
    }

    public void setBlueprintTemplatePut(Resource blueprintTemplatePut) {
        this.blueprintTemplatePut = blueprintTemplatePut;
    }

    public Resource getBlueprintTemplatePatch() {
        return this.blueprintTemplatePatch;
    }

    public void setBlueprintTemplatePatch(Resource blueprintTemplatePatch) {
        this.blueprintTemplatePatch = blueprintTemplatePatch;
    }

    public Resource getBlueprintTemplatePost() {
        return this.blueprintTemplatePost;
    }

    public void setBlueprintTemplatePost(Resource blueprintTemplatePost) {
        this.blueprintTemplatePost = blueprintTemplatePost;
    }

    public Resource getBlueprintTemplateDelete() {
        return this.blueprintTemplateDelete;
    }

    public void setBlueprintTemplateDelete(Resource blueprintTemplateDelete) {
        this.blueprintTemplateDelete = blueprintTemplateDelete;
    }

    public String getDefaultLimitParameterName() {
        return this.defaultLimitParameterName;
    }

    public void setDefaultLimitParameterName(String defaultLimitParameterName) {
        this.defaultLimitParameterName = defaultLimitParameterName;
    }

    public String getDefaultLimitParameterNamespace() {
        return this.defaultLimitParameterNamespace;
    }

    public void setDefaultLimitParameterNamespace(String defaultLimitParameterNamespace) {
        this.defaultLimitParameterNamespace = defaultLimitParameterNamespace;
    }

    public String getDefaultLimitParameterComponent() {
        return this.defaultLimitParameterComponent;
    }

    public void setDefaultLimitParameterComponent(String defaultLimitParameterComponent) {
        this.defaultLimitParameterComponent = defaultLimitParameterComponent;
    }

    public String getLimitParameterNamePrefix() {
        return this.limitParameterNamePrefix;
    }

    public void setLimitParameterNamePrefix(String limitParameterNamePrefix) {
        this.limitParameterNamePrefix = limitParameterNamePrefix;
    }

    public String getLimitParameterName() {
        return this.limitParameterName;
    }

    public void setLimitParameterName(String limitParameterName) {
        this.limitParameterName = limitParameterName;
    }

    public String getLimitParameterNamespace() {
        return this.limitParameterNamespace;
    }

    public void setLimitParameterNamespace(String limitParameterNamespace) {
        this.limitParameterNamespace = limitParameterNamespace;
    }

    public String getLimitParameterComponent() {
        return this.limitParameterComponent;
    }

    public void setLimitParameterComponent(String limitParameterComponent) {
        this.limitParameterComponent = limitParameterComponent;
    }

    public MaintenanceDocumentDictionaryService getMaintenanceDocumentDictionaryService() {
        return this.maintenanceDocumentDictionaryService;
    }

    public void setMaintenanceDocumentDictionaryService(MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService) {
        this.maintenanceDocumentDictionaryService = maintenanceDocumentDictionaryService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public CommonApiService getCommonApiService() {
        if (this.commonApiService == null) {
            this.commonApiService = KcServiceLocator.getService(CommonApiService.class);
        }
        return this.commonApiService;
    }

    public void setCommonApiService(CommonApiService commonApiService) {
        this.commonApiService = commonApiService;
    }

    public ObjectMapper getRestObjectMapper() {
        return this.restObjectMapper;
    }

    public void setRestObjectMapper(ObjectMapper restObjectMapper) {
        this.restObjectMapper = restObjectMapper;
    }

    public BeanWrapper getBeanWrapper() {
        return this.beanWrapper;
    }

    public void setBeanWrapper(BeanWrapper beanWrapper) {
        this.beanWrapper = beanWrapper;
    }

    public static final class MaintenanceDocDto
    implements Serializable {
        private final String description;
        private final String orgDocNum;
        private final String explanation;

        public MaintenanceDocDto(String description, String orgDocNum, String explanation) {
            this.description = description;
            this.orgDocNum = orgDocNum;
            this.explanation = explanation;
        }

        public String getDescription() {
            return this.description;
        }

        public String getOrgDocNum() {
            return this.orgDocNum;
        }

        public String getExplanation() {
            return this.explanation;
        }
    }
}

