/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.rule;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.keyvalue.DefaultMapEntry;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.coeus.sys.framework.validation.SoftError;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.TransactionalDocument;
import org.kuali.rice.krad.rules.DocumentRuleBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class KcTransactionalDocumentRuleBase
extends DocumentRuleBase {
    public static final String DOCUMENT_ERROR_PATH = "document";
    public static final boolean VALIDATION_REQUIRED = true;
    public static final boolean CHOMP_LAST_LETTER_S_FROM_COLLECTION_NAME = false;
    private ErrorReporter errorReporter;
    private DataObjectService dataObjectService;
    private BusinessObjectService businessObjectService;
    private DictionaryValidationService knsDictionaryValidationService;

    protected void reportError(String propertyName, String errorKey, String ... errorParams) {
        this.getErrorReporter().reportError(propertyName, errorKey, errorParams);
    }

    protected void reportWarning(String propertyName, String errorKey, String ... errorParams) {
        this.getErrorReporter().reportWarning(propertyName, errorKey, errorParams);
    }

    protected void addAuditError(AuditError error, String errorKey, String clusterLabel, String clusterCategory) {
        this.getErrorReporter().reportAuditError(error, errorKey, clusterLabel, clusterCategory);
    }

    protected void reportSoftError(String propertyName, String errorKey, String ... errorParams) {
        this.getErrorReporter().reportSoftError(propertyName, errorKey, errorParams);
    }

    public Map<String, Collection<SoftError>> getSoftErrors() {
        return this.getErrorReporter().getSoftErrors();
    }

    protected Map.Entry<String, String> keyValue(String key, Object value) {
        return value == null ? new DefaultMapEntry((Object)key, (Object)"") : new DefaultMapEntry((Object)key, (Object)value.toString());
    }

    protected boolean isInvalid(Class<? extends PersistableBusinessObject> boClass, Map.Entry<String, String> ... entries) {
        return !this.isValid(boClass, entries);
    }

    protected boolean isValid(Class<? extends PersistableBusinessObject> boClass, Map.Entry<String, String> ... entries) {
        boolean retval = false;
        if (entries != null && entries.length > 0) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : entries) {
                fieldValues.put(entry.getKey(), entry.getValue());
            }
            if (this.getBusinessObjectService().countMatching(boClass, fieldValues) > 0) {
                retval = true;
            }
        }
        return retval;
    }

    public boolean processSaveDocument(Document document) {
        boolean isValid = true;
        isValid = this.isDocumentOverviewValid(document);
        GlobalVariables.getMessageMap().addToErrorPath(DOCUMENT_ERROR_PATH);
        this.getKnsDictionaryValidationService().validateDocumentAndUpdatableReferencesRecursively(document, this.getMaxDictionaryValidationDepth(), true, false);
        this.getDictionaryValidationService().validateDefaultExistenceChecksForTransDoc((TransactionalDocument)document);
        GlobalVariables.getMessageMap().removeFromErrorPath(DOCUMENT_ERROR_PATH);
        isValid &= GlobalVariables.getMessageMap().hasNoErrors();
        return isValid &= this.processCustomSaveDocumentBusinessRules(document);
    }

    public boolean isDocumentOverviewValid(Document document) {
        GlobalVariables.getMessageMap().addToErrorPath(DOCUMENT_ERROR_PATH);
        GlobalVariables.getMessageMap().addToErrorPath("documentHeader");
        this.validateSensitiveDataValue("explanation", document.getDocumentHeader().getExplanation(), this.getDataDictionaryService().getAttributeLabel(DocumentHeader.class, "explanation"));
        this.validateSensitiveDataValue("documentDescription", document.getDocumentHeader().getDocumentDescription(), this.getDataDictionaryService().getAttributeLabel(DocumentHeader.class, "documentDescription"));
        GlobalVariables.getMessageMap().removeFromErrorPath("documentHeader");
        GlobalVariables.getMessageMap().removeFromErrorPath(DOCUMENT_ERROR_PATH);
        return GlobalVariables.getMessageMap().hasNoErrors();
    }

    protected final BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ErrorReporter getErrorReporter() {
        if (this.errorReporter == null) {
            this.errorReporter = KcServiceLocator.getService(ErrorReporter.class);
        }
        return this.errorReporter;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    protected DictionaryValidationService getKnsDictionaryValidationService() {
        if (this.knsDictionaryValidationService == null) {
            this.knsDictionaryValidationService = KNSServiceLocator.getKNSDictionaryValidationService();
        }
        return this.knsDictionaryValidationService;
    }

    public void setKnsDictionaryValidationService(DictionaryValidationService knsDictionaryValidationService) {
        this.knsDictionaryValidationService = knsDictionaryValidationService;
    }

    protected DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }

    protected void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

