/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.util;

import java.io.IOException;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;

public final class PdfBoxUtils {
    private PdfBoxUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static boolean isValidPdf(byte[] pdfBytes) {
        boolean bl;
        block9: {
            if (ArrayUtils.isEmpty((byte[])pdfBytes)) {
                return false;
            }
            PDDocument ignored = PDDocument.load((byte[])pdfBytes);
            try {
                bl = true;
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException e) {
                    return false;
                }
            }
            ignored.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidAcroPdf(byte[] pdfBytes) {
        if (ArrayUtils.isEmpty((byte[])pdfBytes)) {
            return false;
        }
        try (PDDocument pdf = PDDocument.load((byte[])pdfBytes);){
            PDDocumentCatalog catalog = pdf.getDocumentCatalog();
            if (catalog != null) {
                PDAcroForm acroForm = catalog.getAcroForm();
                boolean bl2 = acroForm != null && CollectionUtils.isNotEmpty((Collection)acroForm.getFields());
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException | RuntimeException e) {
            return false;
        }
    }
}

