/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.model;

import java.sql.Timestamp;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.model.KcDataObject;
import org.kuali.coeus.sys.framework.model.KcDataObjectService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="kcDataObjectService")
public class KcDataObjectServiceImpl
implements KcDataObjectService {
    @Autowired
    @Qualifier(value="identityService")
    private IdentityService identityService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    @Override
    public void initVersionNumberForPersist(KcDataObject kcDataObject) {
        kcDataObject.setVersionNumber(0L);
    }

    @Override
    public void initUpdateFieldsForPersist(KcDataObject kcDataObject) {
        this.setUpdateFields(kcDataObject);
    }

    @Override
    public void initObjectIdForPersist(KcDataObject kcDataObject) {
        if (StringUtils.isBlank((CharSequence)kcDataObject.getObjectId())) {
            kcDataObject.setObjectId(UUID.randomUUID().toString());
        }
    }

    @Override
    public void initVersionNumberForUpdate(KcDataObject kcDataObject) {
        if (kcDataObject.getVersionNumber() == null) {
            kcDataObject.setVersionNumber(0L);
        }
    }

    @Override
    public void initUpdateFieldsForUpdate(KcDataObject kcDataObject) {
        this.setUpdateFields(kcDataObject);
    }

    @Override
    public void initObjectIdForUpdate(KcDataObject kcDataObject) {
        if (StringUtils.isBlank((CharSequence)kcDataObject.getObjectId())) {
            kcDataObject.setObjectId(UUID.randomUUID().toString());
        }
    }

    private void setUpdateFields(KcDataObject kcDataObject) {
        if (!kcDataObject.isUpdateUserSet() && this.globalVariableService.getUserSession() != null) {
            kcDataObject.setUpdateUser(this.globalVariableService.getUserSession().getPrincipalName());
        }
        kcDataObject.setUpdateTimestamp(new Timestamp(new Date().getTime()));
        if (kcDataObject.getUpdateUser() != null) {
            kcDataObject.setUpdateUser(StringUtils.substring((String)kcDataObject.getUpdateUser(), (int)0, (int)60));
        }
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

