/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.SortedMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.CostElement;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.rate.RateType;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.award.budget.AwardBudgetLimit;
import org.kuali.kra.award.budget.AwardBudgetLineItemExt;
import org.kuali.kra.award.budget.AwardBudgetPeriodExt;
import org.kuali.kra.award.budget.AwardBudgetPeriodSummaryCalculatedAmount;
import org.kuali.kra.award.budget.AwardBudgetPersonnelDetailsExt;
import org.kuali.kra.award.budget.AwardBudgetStatus;
import org.kuali.kra.award.budget.AwardBudgetType;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.DocumentNextvalue;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;

public class AwardBudgetExt
extends Budget {
    private static final long serialVersionUID = 1L;
    private Award award;
    private Long awardId;
    private String awardBudgetStatusCode;
    private String awardBudgetTypeCode;
    private ScaleTwoDecimal obligatedTotal;
    private ScaleTwoDecimal obligatedAmount = ScaleTwoDecimal.ZERO;
    private AwardBudgetStatus awardBudgetStatus;
    private AwardBudgetType awardBudgetType;
    private String description;
    private String budgetInitiator;
    private AwardBudgetExt prevBudget;
    private List<ScaleTwoDecimal> budgetsTotals;
    private List<AwardBudgetLimit> awardBudgetLimits;
    private AwardBudgetExt firstBudget;
    private SortedMap<CostElement, ScaleTwoDecimal> objectCodeBudgetTotals;
    private SortedMap<RateType, ScaleTwoDecimal> calculatedExpenseBudgetTotals;
    private SortedMap<String, ScaleTwoDecimal> totalBudgetSummaryTotals;
    private SortedMap<String, ScaleTwoDecimal> objectCodePersonnelFringeBudgetTotals;
    private SortedMap<RateType, ScaleTwoDecimal> personnelCalculatedExpenseBudgetTotals;
    private SortedMap<RateType, ScaleTwoDecimal> nonPersonnelCalculatedExpenseBudgetTotals;
    private AwardBudgetDocument awardBudgetDocument;
    private ScaleTwoDecimal totalDirectCostInclPrev;
    private ScaleTwoDecimal totalIndirectCostInclPrev;
    private ScaleTwoDecimal totalCostInclPrev;
    private String postStatus;
    private String postDetails;

    public AwardBudgetExt() {
        this.setParentDocumentTypeCode("AWRD");
        this.awardBudgetLimits = new ArrayList<AwardBudgetLimit>();
    }

    @Override
    public AwardBudgetPeriodExt getNewBudgetPeriod() {
        return new AwardBudgetPeriodExt();
    }

    @Override
    public BudgetLineItem getNewBudgetLineItem() {
        return new AwardBudgetLineItemExt();
    }

    @Override
    public BudgetPersonnelDetails getNewBudgetPersonnelLineItem() {
        return new AwardBudgetPersonnelDetailsExt();
    }

    public String getAwardBudgetStatusCode() {
        return this.awardBudgetStatusCode;
    }

    public void setAwardBudgetStatusCode(String awardBudgetStatusCode) {
        this.awardBudgetStatusCode = awardBudgetStatusCode;
    }

    public String getAwardBudgetTypeCode() {
        return this.awardBudgetTypeCode;
    }

    public void setAwardBudgetTypeCode(String awardBudgetTypeCode) {
        this.awardBudgetTypeCode = awardBudgetTypeCode;
    }

    public AwardBudgetStatus getAwardBudgetStatus() {
        return this.awardBudgetStatus;
    }

    public void setAwardBudgetStatus(AwardBudgetStatus awardBudgetStatus) {
        this.awardBudgetStatus = awardBudgetStatus;
    }

    public AwardBudgetType getAwardBudgetType() {
        return this.awardBudgetType;
    }

    public void setAwardBudgetType(AwardBudgetType awardBudgetType) {
        this.awardBudgetType = awardBudgetType;
    }

    @Override
    public boolean getOhRatesNonEditable() {
        Award award = this.getBudgetDocument().getBudget().getBudgetParent();
        return !award.getAwardFandaRate().isEmpty();
    }

    @Override
    public boolean getEbRatesNonEditable() {
        Award award = this.getBudgetDocument().getBudget().getBudgetParent();
        return award.getSpecialEbRateOffCampus() != null && award.getSpecialEbRateOffCampus().isPositive() || award.getSpecialEbRateOnCampus() != null && award.getSpecialEbRateOnCampus().isPositive();
    }

    public ScaleTwoDecimal getObligatedTotal() {
        return this.obligatedTotal == null ? ScaleTwoDecimal.ZERO : this.obligatedTotal;
    }

    public void setObligatedTotal(ScaleTwoDecimal obligatedAmount) {
        this.obligatedTotal = obligatedAmount;
    }

    public ScaleTwoDecimal getObligatedAmount() {
        return this.obligatedAmount == null ? ScaleTwoDecimal.ZERO : this.obligatedAmount;
    }

    public void setObligatedAmount(ScaleTwoDecimal obligatedAmount) {
        this.obligatedAmount = obligatedAmount;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBudgetInitiator() {
        return this.budgetInitiator;
    }

    public void setBudgetInitiator(String budgetInitiator) {
        this.budgetInitiator = budgetInitiator;
    }

    public AwardBudgetExt getPrevBudget() {
        if (this.prevBudget == null && this.getBudgetDocument() != null) {
            Integer version = 0;
            for (AwardBudgetExt budgetVersion : this.getBudgetParent().getBudgets()) {
                if (budgetVersion == null || budgetVersion.getBudgetVersionNumber() <= version || !this.getParameterValue("awardBudgetStatusPosted").equals(budgetVersion.getAwardBudgetStatusCode()) || budgetVersion.getBudgetVersionNumber() >= this.getBudgetVersionNumber()) continue;
                version = budgetVersion.getBudgetVersionNumber();
                this.prevBudget = budgetVersion;
            }
            if (this.prevBudget == null) {
                this.prevBudget = new AwardBudgetExt();
                this.prevBudget.setCostSharingAmount(ScaleTwoDecimal.ZERO);
                this.prevBudget.setTotalCost(ScaleTwoDecimal.ZERO);
                this.prevBudget.setTotalCostLimit(ScaleTwoDecimal.ZERO);
                this.prevBudget.setTotalDirectCost(ScaleTwoDecimal.ZERO);
                this.prevBudget.setTotalIndirectCost(ScaleTwoDecimal.ZERO);
                this.prevBudget.setUnderrecoveryAmount(ScaleTwoDecimal.ZERO);
            }
        }
        return this.prevBudget;
    }

    public AwardBudgetExt getFirstBudget() {
        if (this.firstBudget == null && this.getBudgetDocument() != null) {
            for (AwardBudgetExt budgetVersion : this.getBudgetParent().getBudgets()) {
                if (budgetVersion == null || !this.getParameterValue("awardBudgetStatusPosted").equals(budgetVersion.getAwardBudgetStatusCode())) continue;
                this.firstBudget = budgetVersion;
                return this.firstBudget;
            }
            if (this.firstBudget == null) {
                this.firstBudget = new AwardBudgetExt();
                this.firstBudget.setCostSharingAmount(this.getCostSharingAmount());
                this.firstBudget.setTotalCost(this.getTotalCost());
                this.firstBudget.setTotalCostLimit(this.getTotalCostLimit());
                this.firstBudget.setTotalDirectCost(this.getTotalDirectCost());
                this.firstBudget.setTotalIndirectCost(this.getTotalIndirectCost());
                this.firstBudget.setUnderrecoveryAmount(this.getUnderrecoveryAmount());
            }
        }
        return this.firstBudget;
    }

    public void setPrevBudget(AwardBudgetExt prevBudget) {
        this.prevBudget = prevBudget;
    }

    public List<ScaleTwoDecimal> getBudgetsTotals() {
        this.addBudgetTotals();
        return this.budgetsTotals;
    }

    public void setBudgetsTotals(List<ScaleTwoDecimal> budgetsTotals) {
        this.budgetsTotals = budgetsTotals;
    }

    private void addBudgetTotals() {
        ArrayList<ScaleTwoDecimal> totals = new ArrayList<ScaleTwoDecimal>();
        totals.add((ScaleTwoDecimal)this.getTotalCost().add((AbstractDecimal)this.getPrevBudget().getTotalCost()));
        totals.add((ScaleTwoDecimal)this.getTotalDirectCost().add((AbstractDecimal)this.getPrevBudget().getTotalDirectCost()));
        totals.add((ScaleTwoDecimal)this.getTotalIndirectCost().add((AbstractDecimal)this.getPrevBudget().getTotalIndirectCost()));
        totals.add((ScaleTwoDecimal)this.getUnderrecoveryAmount().add((AbstractDecimal)this.getPrevBudget().getUnderrecoveryAmount()));
        totals.add((ScaleTwoDecimal)this.getCostSharingAmount().add((AbstractDecimal)this.getPrevBudget().getCostSharingAmount()));
        this.setBudgetsTotals(totals);
    }

    public boolean isRebudget() {
        return StringUtils.equals((CharSequence)this.getAwardBudgetTypeCode(), (CharSequence)this.getParameterValue("awardBudgetTypeRebudget"));
    }

    private String getParameterValue(String parameter) {
        return CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString(AwardBudgetDocument.class, parameter);
    }

    public List<AwardBudgetLimit> getAwardBudgetLimits() {
        return this.awardBudgetLimits;
    }

    public void setAwardBudgetLimits(List<AwardBudgetLimit> awardBudgetLimits) {
        this.awardBudgetLimits = awardBudgetLimits;
    }

    public SortedMap<CostElement, ScaleTwoDecimal> getObjectCodeBudgetTotals() {
        return this.objectCodeBudgetTotals;
    }

    public void setObjectCodeBudgetTotals(SortedMap<CostElement, ScaleTwoDecimal> objectCodeBudgetTotals) {
        this.objectCodeBudgetTotals = objectCodeBudgetTotals;
    }

    public SortedMap<RateType, ScaleTwoDecimal> getCalculatedExpenseBudgetTotals() {
        return this.calculatedExpenseBudgetTotals;
    }

    public void setCalculatedExpenseBudgetTotals(SortedMap<RateType, ScaleTwoDecimal> calculatedExpenseBudgetTotals) {
        this.calculatedExpenseBudgetTotals = calculatedExpenseBudgetTotals;
    }

    public SortedMap<String, ScaleTwoDecimal> getTotalBudgetSummaryTotals() {
        return this.totalBudgetSummaryTotals;
    }

    public void setTotalBudgetSummaryTotals(SortedMap<String, ScaleTwoDecimal> totalBudgetSummaryTotals) {
        this.totalBudgetSummaryTotals = totalBudgetSummaryTotals;
    }

    public SortedMap<String, ScaleTwoDecimal> getObjectCodePersonnelFringeBudgetTotals() {
        return this.objectCodePersonnelFringeBudgetTotals;
    }

    public void setObjectCodePersonnelFringeBudgetTotals(SortedMap<String, ScaleTwoDecimal> objectCodePersonnelFringeBudgetTotals) {
        this.objectCodePersonnelFringeBudgetTotals = objectCodePersonnelFringeBudgetTotals;
    }

    public SortedMap<RateType, ScaleTwoDecimal> getPersonnelCalculatedExpenseBudgetTotals() {
        return this.personnelCalculatedExpenseBudgetTotals;
    }

    public void setPersonnelCalculatedExpenseBudgetTotals(SortedMap<RateType, ScaleTwoDecimal> personnelCalculatedExpenseBudgetTotals) {
        this.personnelCalculatedExpenseBudgetTotals = personnelCalculatedExpenseBudgetTotals;
    }

    public SortedMap<RateType, ScaleTwoDecimal> getNonPersonnelCalculatedExpenseBudgetTotals() {
        return this.nonPersonnelCalculatedExpenseBudgetTotals;
    }

    public void setNonPersonnelCalculatedExpenseBudgetTotals(SortedMap<RateType, ScaleTwoDecimal> nonPersonnelCalculatedExpenseBudgetTotals) {
        this.nonPersonnelCalculatedExpenseBudgetTotals = nonPersonnelCalculatedExpenseBudgetTotals;
    }

    @Override
    public List buildListOfDeletionAwareLists() {
        ArrayList<AwardBudgetPeriodSummaryCalculatedAmount> awardBudgetPeriodSummaryCalculatedAmounts = new ArrayList<AwardBudgetPeriodSummaryCalculatedAmount>();
        for (BudgetPeriod persistableBusinessObject : this.getBudgetPeriods()) {
            awardBudgetPeriodSummaryCalculatedAmounts.addAll(((AwardBudgetPeriodExt)persistableBusinessObject).getAwardBudgetPeriodFringeAmounts());
            awardBudgetPeriodSummaryCalculatedAmounts.addAll(((AwardBudgetPeriodExt)persistableBusinessObject).getAwardBudgetPeriodFnAAmounts());
        }
        List deletionAwareList = super.buildListOfDeletionAwareLists();
        deletionAwareList.add(awardBudgetPeriodSummaryCalculatedAmounts);
        deletionAwareList.add(this.awardBudgetLimits);
        return deletionAwareList;
    }

    @Override
    public ScaleTwoDecimal getSumDirectCostAmountFromPeriods() {
        ScaleTwoDecimal amount = ScaleTwoDecimal.ZERO;
        for (BudgetPeriod period : this.getBudgetPeriods()) {
            amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)period.getTotalDirectCost());
        }
        return amount;
    }

    public AwardBudgetDocument getBudgetDocument() {
        return this.awardBudgetDocument;
    }

    public void setBudgetDocument(AwardBudgetDocument budgetDocument) {
        this.awardBudgetDocument = budgetDocument;
    }

    public Award getAward() {
        return this.award;
    }

    public void setAward(Award award) {
        this.award = award;
    }

    @Override
    public Award getBudgetParent() {
        return this.award;
    }

    @Override
    public String getParentDocumentKey() {
        return this.awardId.toString();
    }

    public Long getAwardId() {
        return this.awardId;
    }

    public void setAwardId(Long awardId) {
        this.awardId = awardId;
    }

    @Override
    public Date getBudgetStartDate() {
        return this.getAward().getAwardAmountInfos().get(this.getAward().getAwardAmountInfos().size() - 1).getCurrentFundEffectiveDate();
    }

    @Override
    public Date getBudgetEndDate() {
        return this.getAward().getAwardAmountInfos().get(this.getAward().getAwardAmountInfos().size() - 1).getObligationExpirationDate();
    }

    @Override
    public List<DocumentNextvalue> getNextValues() {
        return this.getBudgetDocument().getDocumentNextvalues();
    }

    @Override
    public DocumentNextvalue getNewNextValue() {
        return new DocumentNextvalue();
    }

    @Override
    public void add(DocumentNextvalue nextValue) {
        this.getBudgetDocument().getDocumentNextvalues().add(nextValue);
    }

    public void initInclPreviousTotals() {
        AwardBudgetExt prevBudget = this.getPrevBudget();
        if (prevBudget != null) {
            prevBudget.initInclPreviousTotals();
            this.setTotalCostInclPrev((ScaleTwoDecimal)this.getTotalCost().add((AbstractDecimal)prevBudget.getTotalCostInclPrev()));
            this.setTotalDirectCostInclPrev((ScaleTwoDecimal)this.getTotalDirectCost().add((AbstractDecimal)prevBudget.getTotalDirectCostInclPrev()));
            this.setTotalIndirectCostInclPrev((ScaleTwoDecimal)this.getTotalIndirectCost().add((AbstractDecimal)prevBudget.getTotalIndirectCostInclPrev()));
        } else {
            this.setTotalCostInclPrev(this.getTotalCost());
            this.setTotalDirectCostInclPrev(this.getTotalDirectCost());
            this.setTotalIndirectCostInclPrev(this.getTotalIndirectCost());
        }
    }

    public ScaleTwoDecimal getTotalDirectCostInclPrev() {
        if (this.totalDirectCostInclPrev == null) {
            this.initInclPreviousTotals();
        }
        return this.totalDirectCostInclPrev;
    }

    public void setTotalDirectCostInclPrev(ScaleTwoDecimal totalDirectCostInclPrev) {
        this.totalDirectCostInclPrev = totalDirectCostInclPrev;
    }

    public ScaleTwoDecimal getTotalIndirectCostInclPrev() {
        if (this.totalIndirectCostInclPrev == null) {
            this.initInclPreviousTotals();
        }
        return this.totalIndirectCostInclPrev;
    }

    public void setTotalIndirectCostInclPrev(ScaleTwoDecimal totalIndirectCostInclPrev) {
        this.totalIndirectCostInclPrev = totalIndirectCostInclPrev;
    }

    public ScaleTwoDecimal getTotalCostInclPrev() {
        if (this.totalCostInclPrev == null) {
            this.initInclPreviousTotals();
        }
        return this.totalCostInclPrev;
    }

    public void setTotalCostInclPrev(ScaleTwoDecimal totalCostInclPrev) {
        this.totalCostInclPrev = totalCostInclPrev;
    }

    public String getPostStatus() {
        return this.postStatus;
    }

    public void setPostStatus(String postStatus) {
        this.postStatus = postStatus;
    }

    public String getPostDetails() {
        return this.postDetails;
    }

    public void setPostDetails(String postDetails) {
        this.postDetails = postDetails;
    }
}

