/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.printing.xmlstream;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.costshare.CostShareService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.print.stream.xml.XmlStream;
import org.kuali.coeus.common.framework.rolodex.NonOrganizationalRolodex;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.common.framework.sponsor.term.SponsorTermType;
import org.kuali.coeus.common.framework.type.ActivityType;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.commitments.AwardCostShare;
import org.kuali.kra.award.contacts.AwardContact;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.contacts.AwardSponsorContact;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.home.AwardCfda;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.home.AwardSponsorTerm;
import org.kuali.kra.award.home.AwardTransferringSponsor;
import org.kuali.kra.award.home.AwardType;
import org.kuali.kra.award.home.approvedsubawards.AwardApprovedSubaward;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.award.home.keywords.AwardScienceKeyword;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRecipient;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseout;
import org.kuali.kra.award.paymentreports.paymentschedule.AwardPaymentSchedule;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.AwardApprovedEquipment;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AwardApprovedForeignTravel;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.kuali.kra.bo.AccountType;
import org.kuali.kra.bo.CommentType;
import org.kuali.kra.printing.schema.AmountInfoType;
import org.kuali.kra.printing.schema.AwardHeaderType;
import org.kuali.kra.printing.schema.AwardNoticeDocument;
import org.kuali.kra.printing.schema.AwardTransactionType;
import org.kuali.kra.printing.schema.AwardType;
import org.kuali.kra.printing.schema.CommentDetailsType;
import org.kuali.kra.printing.schema.CommentType2;
import org.kuali.kra.printing.schema.InvestigatorType;
import org.kuali.kra.printing.schema.InvestigatorUnitsType;
import org.kuali.kra.printing.schema.KeyPersonType;
import org.kuali.kra.printing.schema.ReportTermDetailsType2;
import org.kuali.kra.printing.schema.ReportTermType2;
import org.kuali.kra.printing.schema.RolodexDetailsType2;
import org.kuali.kra.printing.schema.SchoolInfoType2;
import org.kuali.kra.printing.schema.ScienceCodeDetailType;
import org.kuali.kra.printing.schema.SpecialReviewType;
import org.kuali.kra.printing.schema.TermDetailsType2;
import org.kuali.kra.printing.schema.TermType2;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryService;
import org.kuali.rice.location.api.state.State;
import org.kuali.rice.location.api.state.StateService;

public abstract class AwardBaseStream
implements XmlStream<AwardNoticeDocument> {
    private static final String INVOICE_INSTRUCTIONS_COMMENT_TYPE_CODE = "1";
    private static final String NOT_PRESENT_INDICATOR = "N";
    private static final String PRESENT_INDICATOR = "P";
    protected static final String OBLIGATED_DIRECT_INDIRECT_COST_CONSTANT = "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST";
    private static final String ON_CAMPUS_FLAG_SET = "N";
    private static final Logger LOG = LogManager.getLogger(AwardBaseStream.class);
    private static final String STRING_SEPARATER = ",";
    protected static final String OTHER_DATA = "otherData";
    protected static final String SIGNATURE_REQUIRED = "signatureRequired";
    protected static final String COMMENT_TYPE_CODE_PARAMETER = "commentTypeCode";
    protected static final String ACTIVITY_TYPE_CODE_PARAMETER = "code";
    protected static final String ACCOUNT_TYPE_CODE_PARAMETER = "accountTypeCode";
    protected static final String REQUIRED = "1";
    protected static final String NOT_REQUIRED = "0";
    protected static final String START_ASTERISK_SPACE_INDICATOR = "* ";
    protected static final String END_ASTERISK_SPACE_INDICATOR = " *";
    protected static final String FELLOWSHIP_ADMIN_NAME = "FELLOWSHIP_OSP_ADMIN";
    private static final String SCHOOL_NAME = "SCHOOL_NAME";
    private static final String SCHOOL_ACRONYM = "SCHOOL_ACRONYM";
    protected static final String EMPTY_STRING = "";
    protected static final String INDICATOR_CONSTANT = "1";
    protected static final String SPONSOR_CODE_DELETED_INDICATOR = "DELETED - ";
    protected static final String SPONSOR_CODE_ADDED_INDICATOR = "ADDED - ";
    protected static final String SEQUENCE_NUMBER_PARAMETER = "sequenceNumber";
    protected static final String AWARD_NUMBER_PARAMETER = "awardNumber";
    protected static final String ROOT_AWARD_NUMBER_PARAMETER = "rootAwardNumber";
    protected static final String COST_SHARING_COMMENT = "9";
    protected static final String IDC_COMMENT = "8";
    protected static final String CURRENT_ACTION_COMMENT = "21";
    protected static final String COMMA_STRING = ", ";
    protected static final String EMPTY_SPACE = " ";
    protected static final String DOCUMENT_NUMBER = "documentNumber";
    protected AwardDocument awardDocument = null;
    protected Award award = null;
    protected AwardAmountInfo awardAmountInfo = null;
    protected Award prevAward = null;
    protected AwardAmountInfo prevAwardAmountInfo = null;
    protected BusinessObjectService businessObjectService = null;
    protected DataObjectService dataObjectService = null;
    private DocumentService documentService = null;
    protected DateTimeService dateTimeService = null;
    private ParameterService parameterService;
    private CostShareService costShareService;
    private StateService stateService;
    private CountryService countryService;
    private AwardHierarchyService awardHierarchyService;

    @Override
    public Class<AwardNoticeDocument> type() {
        return AwardNoticeDocument.class;
    }

    protected abstract AwardNoticeDocument.AwardNotice.PrintRequirement getPrintRequirement(Map<String, Object> var1);

    protected org.kuali.kra.printing.schema.AwardType getAward() {
        org.kuali.kra.printing.schema.AwardType awardType = (org.kuali.kra.printing.schema.AwardType)org.kuali.kra.printing.schema.AwardType.Factory.newInstance();
        awardType.setAwardDetails(this.getAwardDetails());
        awardType.setAwardInvestigators(this.getAwardInvestigators());
        awardType.setAwardKeyPersons(this.getKeyPersons());
        awardType.setAwardComments(this.getAwardComments());
        awardType.setAwardAmountInfo(this.getAwardAmountInfo());
        awardType.setAwardTransactionInfo(this.getAwardTransactionInfo());
        awardType.setAwardScienceCodes(this.getAwardScienceCodes());
        awardType.setAwardTermsDetails(this.getAwardTermsDetails());
        awardType.setAwardReportingDetails(this.getAwardReportingDetails());
        awardType.setAwardSpecialItems(this.getAwardSpecialItems());
        awardType.setAwardCostSharing(this.getAwardCostSharing());
        awardType.setAwardIndirectCosts(this.getAwardIndirectCosts());
        awardType.setAwardCloseOutDeadlines(this.getAwardCloseOutDeadlines());
        awardType.setAwardContacts(this.getAwardContacts());
        awardType.setAwardFundingProposals(this.getAwardFundingProposals());
        return awardType;
    }

    protected AwardNoticeDocument.AwardNotice getAwardNotice(Map<String, Object> reportParameters) {
        AwardNoticeDocument.AwardNotice awardNotice = (AwardNoticeDocument.AwardNotice)AwardNoticeDocument.AwardNotice.Factory.newInstance();
        awardNotice.setSchoolInfo(this.getSchoolInfoType());
        awardNotice.setAward(this.getAward());
        awardNotice.setAODetails(this.getAODetailsType());
        awardNotice.setPrintRequirement(this.getPrintRequirement(reportParameters));
        return awardNotice;
    }

    protected SchoolInfoType2 getSchoolInfoType() {
        SchoolInfoType2 schoolInfoType = (SchoolInfoType2)SchoolInfoType2.Factory.newInstance();
        try {
            String schoolName = this.getProposalParameterValue(SCHOOL_NAME);
            String schoolAcronym = this.getProposalParameterValue(SCHOOL_ACRONYM);
            if (schoolName != null) {
                schoolInfoType.setSchoolName(schoolName);
            }
            if (schoolAcronym != null) {
                schoolInfoType.setAcronym(schoolAcronym);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return schoolInfoType;
    }

    private String getProposalParameterValue(String param) {
        return this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, param);
    }

    protected AwardType.AwardPaymentSchedules.PaymentSchedule getAwardPaymentSchedule(AwardPaymentSchedule awardPaymentSchedule) {
        Calendar submitDate;
        Calendar dueDate;
        AwardType.AwardPaymentSchedules.PaymentSchedule paymentSchedule = (AwardType.AwardPaymentSchedules.PaymentSchedule)AwardType.AwardPaymentSchedules.PaymentSchedule.Factory.newInstance();
        if (awardPaymentSchedule.getAwardNumber() != null) {
            paymentSchedule.setAwardNumber(awardPaymentSchedule.getAwardNumber());
        }
        if (awardPaymentSchedule.getSequenceNumber() != null) {
            paymentSchedule.setSequenceNumber(awardPaymentSchedule.getSequenceNumber());
        }
        if ((dueDate = this.getDueDate(awardPaymentSchedule)) != null) {
            paymentSchedule.setDueDate(dueDate);
        }
        if (awardPaymentSchedule.getAmount() != null) {
            paymentSchedule.setAmount(awardPaymentSchedule.getAmount().bigDecimalValue());
        }
        if ((submitDate = this.getSubmitDate(awardPaymentSchedule)) != null) {
            paymentSchedule.setSubmitDate(submitDate);
        }
        if (awardPaymentSchedule.getSubmittedBy() != null) {
            paymentSchedule.setSubmittedBy(awardPaymentSchedule.getSubmittedBy());
        }
        if (awardPaymentSchedule.getInvoiceNumber() != null) {
            paymentSchedule.setInvoiceNumber(awardPaymentSchedule.getInvoiceNumber());
        }
        if (awardPaymentSchedule.getStatusDescription() != null) {
            paymentSchedule.setStatusDescription(awardPaymentSchedule.getStatusDescription());
        }
        return paymentSchedule;
    }

    protected AwardType.AwardTransferringSponsors.TransferringSponsor getAwardTransferringSponsor(AwardTransferringSponsor awardTransferringSponsor) {
        Sponsor sponsor;
        AwardType.AwardTransferringSponsors.TransferringSponsor transferringSponsor = (AwardType.AwardTransferringSponsors.TransferringSponsor)AwardType.AwardTransferringSponsors.TransferringSponsor.Factory.newInstance();
        if (awardTransferringSponsor.getAwardNumber() != null) {
            transferringSponsor.setAwardNumber(awardTransferringSponsor.getAwardNumber());
        }
        if (awardTransferringSponsor.getSequenceNumber() != null) {
            transferringSponsor.setSequenceNumber(awardTransferringSponsor.getSequenceNumber());
        }
        if (awardTransferringSponsor.getSponsorCode() != null) {
            transferringSponsor.setSponsorCode(awardTransferringSponsor.getSponsorCode());
        }
        if ((sponsor = awardTransferringSponsor.getSponsor()) != null && sponsor.getSponsorName() != null) {
            transferringSponsor.setSponsorDescription(sponsor.getSponsorName());
        }
        return transferringSponsor;
    }

    protected SpecialReviewType getAwardSpecialReview(AwardSpecialReview awardSpecialReview) {
        Calendar approvalDate;
        Calendar applicationDate;
        SpecialReviewType specialReviewType = (SpecialReviewType)SpecialReviewType.Factory.newInstance();
        if (this.award.getAwardNumber() != null) {
            specialReviewType.setAwardNumber(this.award.getAwardNumber());
        }
        if (awardSpecialReview.getSequenceNumber() != null) {
            specialReviewType.setSequenceNumber(awardSpecialReview.getSequenceNumber());
        }
        if (awardSpecialReview.getSpecialReviewTypeCode() != null) {
            specialReviewType.setReviewType(Integer.valueOf(awardSpecialReview.getSpecialReviewTypeCode()));
        }
        if (awardSpecialReview.getApprovalTypeCode() != null) {
            specialReviewType.setApprovalType(Integer.parseInt(awardSpecialReview.getApprovalTypeCode()));
            awardSpecialReview.refreshReferenceObject("specialReviewApprovalType");
            if (awardSpecialReview.getApprovalType() != null) {
                specialReviewType.setApprovalTypeDesc(awardSpecialReview.getApprovalType().getDescription());
            }
        }
        if (awardSpecialReview.getApprovalTypeCode() != null) {
            specialReviewType.setApprovalType(Integer.valueOf(awardSpecialReview.getApprovalTypeCode()));
        }
        if (awardSpecialReview.getComments() != null) {
            specialReviewType.setComments(awardSpecialReview.getComments());
        }
        if (awardSpecialReview.getProtocolNumber() != null) {
            specialReviewType.setProtocolNumber(awardSpecialReview.getProtocolNumber());
        }
        awardSpecialReview.refreshReferenceObject("specialReview");
        if (awardSpecialReview.getSpecialReviewType() != null && awardSpecialReview.getSpecialReviewType().getDescription() != null) {
            specialReviewType.setReviewTypeDesc(awardSpecialReview.getSpecialReviewType().getDescription());
        }
        if ((applicationDate = this.getApplicationDate(awardSpecialReview)) != null) {
            specialReviewType.setApplicationDate(applicationDate);
        }
        if ((approvalDate = this.getApprovalDate(awardSpecialReview)) != null) {
            specialReviewType.setApprovalDate(approvalDate);
        }
        return specialReviewType;
    }

    protected AwardHeaderType getAwardHeaderType() {
        String sponosorAwardnumber;
        String sponsorDesc;
        AwardHeaderType awardHeaderType = (AwardHeaderType)AwardHeaderType.Factory.newInstance();
        if (this.award.getAwardNumber() != null) {
            awardHeaderType.setAwardNumber(this.award.getAwardNumber());
        }
        if (this.award.getSequenceNumber() != null) {
            awardHeaderType.setSequenceNumber(this.award.getSequenceNumber());
        }
        if (this.award.getAccountNumber() != null) {
            awardHeaderType.setAccountNumber(this.award.getAccountNumber());
        }
        if (this.award.getStatusCode() != null) {
            awardHeaderType.setStatusCode(String.valueOf(this.award.getStatusCode()));
        }
        if (this.award.getStatusDescription() != null) {
            if (this.prevAward != null && this.prevAward.getStatusDescription() != null) {
                String prevAwardStatus;
                String CurrAwardStatus = this.award.getStatusDescription();
                String awardStatusMod = this.getModAwardStatus(CurrAwardStatus, prevAwardStatus = this.prevAward.getStatusDescription());
                if (awardStatusMod != null) {
                    awardHeaderType.setStatusDescription(awardStatusMod);
                }
            } else {
                awardHeaderType.setStatusDescription(this.award.getStatusDescription());
            }
        }
        if (this.award.getSponsorCode() != null) {
            awardHeaderType.setSponsorCode(this.award.getSponsorCode());
        }
        if ((sponsorDesc = this.getSponsorDescription()) != null) {
            awardHeaderType.setSponsorDescription(sponsorDesc);
        }
        if ((sponosorAwardnumber = this.getSponsorAwardNumber()) != null) {
            awardHeaderType.setSponsorAwardNumber(sponosorAwardnumber);
        }
        if (this.award.getModificationNumber() != null) {
            awardHeaderType.setModificationNumber(this.award.getModificationNumber());
        }
        if (this.award.getNsfSequenceNumber() != null && this.award.getNsfCodeBo() != null) {
            awardHeaderType.setNSFCode(this.award.getNsfCodeBo().getNsfCode());
            String nsfDescription = this.award.getNsfCodeBo().getDescription();
            if (nsfDescription != null) {
                awardHeaderType.setNSFDescription(nsfDescription);
            }
        }
        if (this.award.getPrincipalInvestigatorName() != null) {
            awardHeaderType.setPIName(this.award.getPrincipalInvestigatorName());
        }
        if (this.award.getTitle() != null) {
            if (this.prevAward != null && this.prevAward.getTitle() != null) {
                String prevAwardTitle;
                String awardTitle = this.award.getTitle();
                String awardTitleMod = this.getModAwardTitle(awardTitle, prevAwardTitle = this.prevAward.getTitle());
                if (awardTitleMod != null) {
                    awardHeaderType.setTitle(awardTitleMod);
                }
            } else {
                awardHeaderType.setTitle(this.award.getTitle());
            }
        }
        return awardHeaderType;
    }

    private String getModAwardTitle(String awardTitle, String prevAwardTitle) {
        String awardTitleMod = null;
        if (awardTitle != null) {
            awardTitleMod = prevAwardTitle == null || !awardTitle.equals(prevAwardTitle) ? awardTitle + END_ASTERISK_SPACE_INDICATOR : awardTitle;
        } else if (prevAwardTitle != null) {
            awardTitleMod = START_ASTERISK_SPACE_INDICATOR;
        }
        return awardTitleMod;
    }

    private String getModAwardStatus(String CurrAwardStatus, String prevAwardStatus) {
        String awardStatusMod = null;
        if (CurrAwardStatus != null) {
            awardStatusMod = !CurrAwardStatus.equals(prevAwardStatus) ? CurrAwardStatus + END_ASTERISK_SPACE_INDICATOR : CurrAwardStatus;
        } else if (prevAwardStatus != null) {
            awardStatusMod = START_ASTERISK_SPACE_INDICATOR;
        }
        return awardStatusMod;
    }

    protected AwardType.AwardReportingDetails getAwardReportingDetails() {
        AwardType.AwardReportingDetails awardReportingDetails = (AwardType.AwardReportingDetails)AwardType.AwardReportingDetails.Factory.newInstance();
        String reportClassCode = null;
        ReportTermType2 reportTermType = null;
        for (AwardReportTerm awardReportTerm : this.award.getAwardReportTermItems()) {
            String reportTermTypeDescription;
            if (reportClassCode == null || !reportClassCode.equals(awardReportTerm.getReportClassCode())) {
                reportTermType = awardReportingDetails.addNewReportDetails();
            }
            reportClassCode = awardReportTerm.getReportClassCode();
            this.getAwardReportTermBean(awardReportTerm, reportTermType);
            if (awardReportTerm.getReportClass() == null || (reportTermTypeDescription = awardReportTerm.getReportClass().getDescription()) == null) continue;
            reportTermType.setDescription(reportTermTypeDescription);
        }
        return awardReportingDetails;
    }

    protected AwardNoticeDocument.AwardNotice.AODetails getAODetailsType() {
        Optional<KcPerson> person = this.award.getAwardCentralAdminContacts().stream().filter(contact -> contact.getUnitAdministratorType().getCode().equals("1")).map(AwardContact::getPerson).findAny();
        AwardNoticeDocument.AwardNotice.AODetails aODetailsType = (AwardNoticeDocument.AwardNotice.AODetails)AwardNoticeDocument.AwardNotice.AODetails.Factory.newInstance();
        if (person.isPresent()) {
            if (person.get().getOfficeLocation() != null) {
                aODetailsType.setAOAddress(person.get().getOfficeLocation());
            }
            if (person.get().getFullName() != null) {
                aODetailsType.setAOName(person.get().getFullName());
            }
        }
        return aODetailsType;
    }

    protected AwardType.AwardFundingProposals getAwardFundingProposals() {
        AwardType.AwardFundingProposals awardFundingProposals = (AwardType.AwardFundingProposals)AwardType.AwardFundingProposals.Factory.newInstance();
        ArrayList<AwardType.AwardFundingProposals.FundingProposal> fundingProposals = new ArrayList<AwardType.AwardFundingProposals.FundingProposal>();
        for (AwardFundingProposal awardFundingProposal : this.award.getFundingProposals()) {
            AwardType.AwardFundingProposals.FundingProposal fundingProposal = (AwardType.AwardFundingProposals.FundingProposal)AwardType.AwardFundingProposals.FundingProposal.Factory.newInstance();
            fundingProposal.setAwardNumber(this.award.getAwardNumber());
            fundingProposal.setSequenceNumber(this.award.getSequenceNumber());
            if (awardFundingProposal.getProposal() != null) {
                fundingProposal.setProposalNumber(awardFundingProposal.getProposal().getProposalNumber());
                fundingProposal.setProposalSequenceNumber(awardFundingProposal.getProposal().getSequenceNumber());
                fundingProposal.setProopsalTypeCode(awardFundingProposal.getProposal().getProposalTypeCode());
                if (awardFundingProposal.getProposal().getProposalType() != null) {
                    fundingProposal.setProposalTypeDescription(awardFundingProposal.getProposal().getProposalType().getDescription());
                }
                fundingProposal.setProposalStatusCode(awardFundingProposal.getProposal().getStatusCode());
                if (awardFundingProposal.getProposal().getRequestedStartDateTotal() != null) {
                    fundingProposal.setRequestedStartDateTotal(this.dateTimeService.getCalendar((Date)awardFundingProposal.getProposal().getRequestedStartDateTotal()));
                }
                if (awardFundingProposal.getProposal().getRequestedEndDateTotal() != null) {
                    fundingProposal.setRequestedEndDateTotal(this.dateTimeService.getCalendar((Date)awardFundingProposal.getProposal().getRequestedEndDateTotal()));
                }
                if (awardFundingProposal.getProposal().getTotalDirectCostTotal() != null) {
                    fundingProposal.setDirectCostTotal(awardFundingProposal.getProposal().getTotalDirectCostTotal().bigDecimalValue());
                }
                if (awardFundingProposal.getProposal().getTotalIndirectCostTotal() != null) {
                    fundingProposal.setIndirectCostTotal(awardFundingProposal.getProposal().getTotalIndirectCostTotal().bigDecimalValue());
                }
            }
            fundingProposals.add(fundingProposal);
        }
        awardFundingProposals.setFundingProposalArray(fundingProposals.toArray(new AwardType.AwardFundingProposals.FundingProposal[0]));
        return awardFundingProposals;
    }

    protected AwardType.AwardContacts getAwardContacts() {
        AwardType.AwardContacts awardContacts = (AwardType.AwardContacts)AwardType.AwardContacts.Factory.newInstance();
        List<AwardSponsorContact> awardSponsorContacts = this.award.getSponsorContacts();
        for (AwardSponsorContact awardSponsorContact : awardSponsorContacts) {
            AwardType.AwardContacts.ContactDetails contactDetails = awardContacts.addNewContactDetails();
            if (this.award.getAwardNumber() != null) {
                contactDetails.setAwardNumber(this.award.getAwardNumber());
            }
            if (this.award.getSequenceNumber() != null) {
                contactDetails.setSequenceNumber(this.award.getSequenceNumber());
            }
            if (awardSponsorContact.getContactRoleCode() != null) {
                contactDetails.setContactType(Integer.valueOf(awardSponsorContact.getContactRoleCode()));
            }
            if (awardSponsorContact.getContactOrganizationName() != null) {
                contactDetails.setContactTypeDesc(awardSponsorContact.getContactRole().getRoleDescription());
            }
            contactDetails.setRolodexDetails(this.getRolodexDetails(awardSponsorContact));
        }
        return awardContacts;
    }

    protected Calendar getApprovalDate(AwardSpecialReview awardSpecialReview) {
        Calendar approvalDate = null;
        if (awardSpecialReview.getApprovalDate() != null) {
            approvalDate = this.dateTimeService.getCalendar((Date)awardSpecialReview.getApprovalDate());
        }
        return approvalDate;
    }

    protected Calendar getApplicationDate(AwardSpecialReview awardSpecialReview) {
        Calendar applicationDate = null;
        if (awardSpecialReview.getApplicationDate() != null) {
            applicationDate = this.dateTimeService.getCalendar((Date)awardSpecialReview.getApplicationDate());
        }
        return applicationDate;
    }

    protected AwardType.AwardCloseOutDeadlines getAwardCloseOutDeadlines() {
        AwardType.AwardCloseOutDeadlines awardcloseOutDeadlines = (AwardType.AwardCloseOutDeadlines)AwardType.AwardCloseOutDeadlines.Factory.newInstance();
        List<AwardCloseout> awardCloseoutItems = this.award.getAwardCloseoutItems();
        AwardCloseout preAwardCloseout = null;
        if (this.prevAward != null && !this.prevAward.getAwardCloseoutItems().isEmpty()) {
            preAwardCloseout = this.prevAward.getAwardCloseoutItems().get(0);
        }
        ArrayList<AwardType.AwardCloseOutDeadlines.CloseOutDeadlines> closeOutDeadlines = new ArrayList<AwardType.AwardCloseOutDeadlines.CloseOutDeadlines>();
        if (awardCloseoutItems != null && !awardCloseoutItems.isEmpty()) {
            if (awardCloseoutItems.get(0).getSequenceNumber() != null) {
                awardcloseOutDeadlines.setSequenceNumber(awardCloseoutItems.get(0).getSequenceNumber());
            }
            if (awardCloseoutItems.get(0).getAwardNumber() != null) {
                awardcloseOutDeadlines.setAwardNumber(awardCloseoutItems.get(0).getAwardNumber());
            }
            if (this.award.getArchiveLocation() != null) {
                awardcloseOutDeadlines.setArchiveLocation(this.award.getArchiveLocation());
            }
            if (this.award.getCloseoutDate() != null) {
                awardcloseOutDeadlines.setArchiveDate(this.dateTimeService.getCalendar((Date)this.award.getCloseoutDate()));
            }
            for (AwardCloseout awardCloseout : awardCloseoutItems) {
                AwardType.AwardCloseOutDeadlines.CloseOutDeadlines closeOutDeadline = (AwardType.AwardCloseOutDeadlines.CloseOutDeadlines)AwardType.AwardCloseOutDeadlines.CloseOutDeadlines.Factory.newInstance();
                if (awardCloseout.getCloseoutReportName() != null) {
                    closeOutDeadline.setFinalReportType(awardCloseout.getCloseoutReportName());
                }
                if (awardCloseout.getDueDate() != null) {
                    Calendar closeoutDate = this.dateTimeService.getCalendar((Date)awardCloseout.getDueDate());
                    closeOutDeadline.setFinalDueDate(closeoutDate);
                }
                if (preAwardCloseout != null) {
                    String closeOutDateModified = this.getCloseOutDateModified(awardCloseout, preAwardCloseout);
                    if (closeOutDateModified != null) {
                        closeOutDeadline.setFinalDueDateModified(closeOutDateModified);
                    }
                } else if (awardCloseout.getDueDate() != null) {
                    closeOutDeadline.setFinalDueDateModified(String.valueOf(awardCloseout.getDueDate()));
                }
                if (awardCloseout.getFinalSubmissionDate() != null) {
                    Calendar finalSubmissionDate = this.dateTimeService.getCalendar((Date)awardCloseout.getFinalSubmissionDate());
                    closeOutDeadline.setFinalSubDate(finalSubmissionDate);
                }
                if (preAwardCloseout != null) {
                    String finalPropSubDateModified = this.getFinalProbSubDateModified(awardCloseout, preAwardCloseout);
                    if (finalPropSubDateModified != null) {
                        closeOutDeadline.setFinalSubDateModified(finalPropSubDateModified);
                    }
                } else if (awardCloseout.getFinalSubmissionDate() != null) {
                    closeOutDeadline.setFinalSubDateModified(String.valueOf(awardCloseout.getFinalSubmissionDate()));
                }
                closeOutDeadlines.add(closeOutDeadline);
            }
        }
        awardcloseOutDeadlines.setCloseOutDeadlinesArray(closeOutDeadlines.toArray(new AwardType.AwardCloseOutDeadlines.CloseOutDeadlines[0]));
        return awardcloseOutDeadlines;
    }

    protected AwardType.AwardIndirectCosts getAwardIndirectCosts() {
        AwardType.AwardIndirectCosts awardIndirectCost = (AwardType.AwardIndirectCosts)AwardType.AwardIndirectCosts.Factory.newInstance();
        String comemnts = this.getIndirectCostComments();
        if (comemnts != null) {
            awardIndirectCost.setComments(comemnts);
        }
        ArrayList indirectCostSharingItems = new ArrayList();
        this.award.getAwardFandaRate().forEach(awardFandaRate -> {
            if (awardFandaRate != null) {
                AwardType.AwardIndirectCosts.IndirectCostSharingItem indirectCostSharingItem = (AwardType.AwardIndirectCosts.IndirectCostSharingItem)AwardType.AwardIndirectCosts.IndirectCostSharingItem.Factory.newInstance();
                indirectCostSharingItem.setSequenceNumber(this.award.getSequenceNumber());
                if (awardFandaRate.getFiscalYear() != null) {
                    indirectCostSharingItem.setFiscalYear(awardFandaRate.getFiscalYear());
                }
                if (awardFandaRate.getApplicableFandaRate() != null) {
                    indirectCostSharingItem.setApplicableRate(awardFandaRate.getApplicableFandaRate().bigDecimalValue());
                } else {
                    indirectCostSharingItem.setApplicableRate(ScaleTwoDecimal.ZERO.bigDecimalValue());
                }
                boolean campus = awardFandaRate.getOnCampusFlag() != null && awardFandaRate.getOnCampusFlag().equals("N");
                indirectCostSharingItem.setCampus(campus);
                if (awardFandaRate.getSourceAccount() != null) {
                    indirectCostSharingItem.setSourceAccount(awardFandaRate.getSourceAccount());
                }
                if (awardFandaRate.getUnderrecoveryOfIndirectCost() != null) {
                    indirectCostSharingItem.setUnderRecoveryAmount(awardFandaRate.getUnderrecoveryOfIndirectCost().bigDecimalValue());
                } else {
                    indirectCostSharingItem.setUnderRecoveryAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());
                }
                if (awardFandaRate.getDestinationAccount() != null) {
                    indirectCostSharingItem.setDestinationAccount(awardFandaRate.getDestinationAccount());
                }
                if (awardFandaRate.getStartDate() != null) {
                    indirectCostSharingItem.setStartDate(this.dateTimeService.getCalendar((Date)awardFandaRate.getStartDate()));
                }
                if (awardFandaRate.getEndDate() != null) {
                    indirectCostSharingItem.setEndDate(this.dateTimeService.getCalendar((Date)awardFandaRate.getEndDate()));
                }
                if (awardFandaRate.getFandaRateType() != null && awardFandaRate.getFandaRateType().getDescription() != null) {
                    indirectCostSharingItem.setIDCRateDescription(awardFandaRate.getFandaRateType().getDescription());
                }
                indirectCostSharingItems.add(indirectCostSharingItem);
            }
        });
        awardIndirectCost.setIndirectCostSharingItemArray(indirectCostSharingItems.toArray(new AwardType.AwardIndirectCosts.IndirectCostSharingItem[0]));
        return awardIndirectCost;
    }

    protected AwardBudgetDocument getBudgetDocument() {
        AwardBudgetDocument awardBudgetDocument = null;
        try {
            if (!this.awardDocument.getBudgetDocumentVersions().isEmpty()) {
                awardBudgetDocument = (AwardBudgetDocument)this.documentService.getByDocumentHeaderId(this.awardDocument.getBudgetDocumentVersion(0).getDocumentNumber());
            }
        }
        catch (WorkflowException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return awardBudgetDocument;
    }

    protected AwardType.AwardCostSharing getAwardCostSharing() {
        AwardType.AwardCostSharing awardCostSharing = (AwardType.AwardCostSharing)AwardType.AwardCostSharing.Factory.newInstance();
        String comments = this.getCostSharingComments();
        if (comments != null) {
            awardCostSharing.setComments(comments);
        }
        awardCostSharing.setCostSharingItemArray(this.getCostSharingItemDetails());
        return awardCostSharing;
    }

    protected AwardType.AwardSpecialItems getAwardSpecialItems() {
        AwardType.AwardSpecialItems awardSpecialItem = (AwardType.AwardSpecialItems)AwardType.AwardSpecialItems.Factory.newInstance();
        awardSpecialItem.setEquipmentArray(this.getEquipmentType());
        awardSpecialItem.setForeignTravelArray(this.getForeignTravel());
        this.setSubcontracts(awardSpecialItem);
        return awardSpecialItem;
    }

    private void setSubcontracts(AwardType.AwardSpecialItems awardSpecialItem) {
        List<AwardApprovedSubaward> awardApprovedSubawards = this.award.getAwardApprovedSubawards();
        for (AwardApprovedSubaward awardApprovedSubcontractBean : awardApprovedSubawards) {
            AwardType.AwardSpecialItems.Subcontract subcontractType = awardSpecialItem.addNewSubcontract();
            BigDecimal bdecAmount = awardApprovedSubcontractBean.getAmount().bigDecimalValue();
            subcontractType.setAmount(bdecAmount.setScale(2, 5));
            subcontractType.setAwardNumber(awardApprovedSubcontractBean.getAwardNumber());
            subcontractType.setSequenceNumber(awardApprovedSubcontractBean.getSequenceNumber());
            subcontractType.setSubcontractorName(awardApprovedSubcontractBean.getOrganizationName());
        }
    }

    protected AwardType.AwardComments getAwardComments() {
        AwardType.AwardComments awardComments = (AwardType.AwardComments)AwardType.AwardComments.Factory.newInstance();
        for (AwardComment awardComment : this.award.getAwardComments()) {
            CommentType2 commentType = awardComments.addNewComment();
            CommentDetailsType commentDetailsType = commentType.addNewCommentDetails();
            if (awardComment.getAwardNumber() != null) {
                commentDetailsType.setAwardNumber(this.award.getAwardNumber());
            }
            if (awardComment.getSequenceNumber() != null) {
                commentDetailsType.setSequenceNumber(awardComment.getSequenceNumber());
            }
            if (awardComment.getCommentTypeCode() != null) {
                commentDetailsType.setCommentCode(awardComment.getCommentTypeCode());
                commentType.setDescription(this.getCommentTypeDesc(awardComment.getCommentTypeCode()));
            }
            if (awardComment.getComments() != null) {
                String newComment = awardComment.getComments();
                String oldComment = this.prevAward == null ? EMPTY_STRING : this.prevAward.getAwardComments().stream().filter(awardComment1 -> awardComment.getCommentTypeCode().equals(awardComment1.getCommentTypeCode())).findFirst().map(AwardComment::getComments).orElse(EMPTY_STRING);
                commentDetailsType.setComments(newComment);
                commentDetailsType.setCommentsModified(oldComment.equals(newComment) ? EMPTY_STRING : END_ASTERISK_SPACE_INDICATOR);
            }
            if (awardComment.getChecklistPrintFlag() != null) {
                commentDetailsType.setPrintChecklist(awardComment.getChecklistPrintFlag());
            }
            commentType.setCommentDetails(commentDetailsType);
        }
        return awardComments;
    }

    protected AwardType.AwardTransactionInfo getAwardTransactionInfo() {
        AwardType.AwardTransactionInfo awardTransactionInfo = (AwardType.AwardTransactionInfo)AwardType.AwardTransactionInfo.Factory.newInstance();
        AwardTransactionType awardTransactionType = awardTransactionInfo.addNewTransactionInfo();
        if (this.award.getAwardNumber() != null) {
            awardTransactionType.setAwardNumber(this.award.getAwardNumber());
        }
        if (this.award.getSequenceNumber() != null) {
            awardTransactionType.setSequenceNumber(this.award.getSequenceNumber());
        }
        if (this.awardAmountInfo != null && this.awardAmountInfo.getSequenceNumber() != null) {
            awardTransactionType.setAmountSequenceNumber(this.awardAmountInfo.getSequenceNumber());
        }
        if (this.award.getNoticeDate() != null) {
            awardTransactionType.setNoticeDate(this.dateTimeService.getCalendar((Date)this.award.getNoticeDate()));
        }
        this.award.getAwardComments().forEach(awardComments -> {
            if (awardComments.getCommentTypeCode().equals(CURRENT_ACTION_COMMENT)) {
                awardTransactionType.setComments(awardComments.getComments());
            }
        });
        if (this.award.getAwardTransactionTypeCode() != null) {
            this.award.refreshReferenceObject("awardTransactionType");
            awardTransactionType.setTransactionTypeCode(this.award.getAwardTransactionTypeCode());
            if (this.award.getAwardTransactionType() != null) {
                awardTransactionType.setTransactionTypeDesc(this.award.getAwardTransactionType().getDescription());
            }
        }
        return awardTransactionInfo;
    }

    protected AwardType.AwardKeyPersons getKeyPersons() {
        ArrayList<KeyPersonType> keyPersonTypes = new ArrayList<KeyPersonType>();
        for (AwardPerson awardPerson : this.award.getProjectPersons()) {
            if (!awardPerson.isKeyPerson()) continue;
            KeyPersonType keyPersonType = (KeyPersonType)KeyPersonType.Factory.newInstance();
            if (this.award.getAwardNumber() != null) {
                keyPersonType.setAwardNumber(this.award.getAwardNumber());
            }
            if (this.award.getSequenceNumber() != null) {
                keyPersonType.setSequenceNumber(awardPerson.getSequenceNumber());
            }
            if (awardPerson.getPersonId() != null) {
                keyPersonType.setPersonId(awardPerson.getPersonId());
            }
            if (awardPerson.getFullName() != null) {
                keyPersonType.setPersonName(awardPerson.getFullName());
            }
            keyPersonType.setFaculty(awardPerson.isFaculty());
            if (awardPerson.getRoleCode() != null) {
                keyPersonType.setRoleName(awardPerson.getRoleCode());
            }
            if (awardPerson.getPerson() != null && awardPerson.getPerson().getOfficeLocation() != null) {
                keyPersonType.setPersonAddress(awardPerson.getPerson().getOfficeLocation());
            }
            keyPersonType.setNonEmployee(!awardPerson.isEmployee());
            BigDecimal percentageEffort = this.getPercentageEffort(awardPerson);
            if (percentageEffort != null) {
                keyPersonType.setPercentEffort(percentageEffort);
            }
            keyPersonTypes.add(keyPersonType);
        }
        AwardType.AwardKeyPersons awardKeyPersons = (AwardType.AwardKeyPersons)AwardType.AwardKeyPersons.Factory.newInstance();
        awardKeyPersons.setKeyPersonArray(keyPersonTypes.toArray(new KeyPersonType[0]));
        return awardKeyPersons;
    }

    protected AwardType.AwardInvestigators getAwardInvestigators() {
        AwardType.AwardInvestigators awardInvestigators = (AwardType.AwardInvestigators)AwardType.AwardInvestigators.Factory.newInstance();
        ArrayList investigatorTypes = new ArrayList();
        this.award.getProjectPersons().stream().filter(awardPerson -> awardPerson.isPrincipalInvestigator() || awardPerson.isMultiplePi() || awardPerson.isCoInvestigator()).forEach(awardPerson -> {
            InvestigatorType investigatorType = this.getInvestigatorType((AwardPerson)awardPerson);
            investigatorTypes.add(investigatorType);
        });
        awardInvestigators.setInvestigatorArray(investigatorTypes.toArray(new InvestigatorType[0]));
        return awardInvestigators;
    }

    protected AwardType.AwardScienceCodes getAwardScienceCodes() {
        AwardType.AwardScienceCodes awardScienceCodes = (AwardType.AwardScienceCodes)AwardType.AwardScienceCodes.Factory.newInstance();
        ArrayList<ScienceCodeDetailType> scienceCodeDetailTypes = new ArrayList<ScienceCodeDetailType>();
        for (AwardScienceKeyword awardScienceKeyword : this.award.getKeywords()) {
            ScienceCodeDetailType scienceCodeDetailType = (ScienceCodeDetailType)ScienceCodeDetailType.Factory.newInstance();
            if (this.award.getAwardNumber() != null) {
                scienceCodeDetailType.setAwardNumber(this.award.getAwardNumber());
            }
            if (this.award.getSequenceNumber() != null) {
                scienceCodeDetailType.setSequenceNumber(this.award.getSequenceNumber());
            }
            if (awardScienceKeyword.getScienceKeywordCode() != null) {
                scienceCodeDetailType.setCode(awardScienceKeyword.getScienceKeywordCode());
            }
            if (awardScienceKeyword.getScienceKeyword().getDescription() != null) {
                scienceCodeDetailType.setDescription(awardScienceKeyword.getScienceKeyword().getDescription());
            }
            scienceCodeDetailTypes.add(scienceCodeDetailType);
        }
        awardScienceCodes.setScienceCodeDetailArray(scienceCodeDetailTypes.toArray(new ScienceCodeDetailType[0]));
        return awardScienceCodes;
    }

    protected AwardType.AwardTermsDetails getAwardTermsDetails() {
        AwardType.AwardTermsDetails awardTermsDetails = (AwardType.AwardTermsDetails)AwardType.AwardTermsDetails.Factory.newInstance();
        String sponsorTermTypeCode = null;
        TermType2 termType = null;
        for (AwardSponsorTerm awardSponsorTerm : this.award.getAwardSponsorTerms()) {
            if (sponsorTermTypeCode == null || !sponsorTermTypeCode.equals(awardSponsorTerm.getSponsorTermTypeCode())) {
                termType = awardTermsDetails.addNewTerm();
            }
            sponsorTermTypeCode = awardSponsorTerm.getSponsorTermTypeCode();
            String sponsorTermTypeDescription = this.getSponsorTermTypeDescription(awardSponsorTerm.getSponsorTermTypeCode());
            if (sponsorTermTypeDescription != null) {
                termType.setDescription(sponsorTermTypeDescription);
            }
            TermDetailsType2 detailsType = termType.addNewTermDetails();
            if (this.award.getAwardNumber() != null) {
                detailsType.setAwardNumber(this.award.getAwardNumber());
            }
            if (awardSponsorTerm.getSequenceNumber() != null) {
                detailsType.setSequenceNumber(awardSponsorTerm.getSequenceNumber());
            }
            if (awardSponsorTerm.getSponsorTerm() != null && awardSponsorTerm.getSponsorTerm().getSponsorTermCode() != null) {
                detailsType.setTermCode(Integer.valueOf(awardSponsorTerm.getSponsorTerm().getSponsorTermCode()));
            }
            if (awardSponsorTerm.getSponsorTerm() == null || awardSponsorTerm.getSponsorTerm().getDescription() == null) continue;
            detailsType.setTermDescription(awardSponsorTerm.getSponsorTerm().getDescription());
        }
        return awardTermsDetails;
    }

    private String getSponsorTermTypeDescription(String sponsorTermTypeCode) {
        SponsorTermType sponsorTermType = (SponsorTermType)this.getBusinessObjectService().findBySinglePrimaryKey(SponsorTermType.class, (Object)sponsorTermTypeCode);
        return sponsorTermType == null ? null : sponsorTermType.getDescription();
    }

    protected AwardType.AwardDetails getAwardDetails() {
        Calendar effectiveDate;
        Calendar executionDate;
        Calendar beginDate;
        AwardType.AwardDetails awardDetailsType = (AwardType.AwardDetails)AwardType.AwardDetails.Factory.newInstance();
        AwardHeaderType awardHeaderType = this.getAwardHeaderType();
        awardDetailsType.setAwardHeader(awardHeaderType);
        awardDetailsType.setOtherHeaderDetails(this.getOtherHeaderDetails());
        if (this.prevAward != null) {
            String effectiveDateModified;
            String executionDateModified;
            String beginDateModified = this.getBeginDateModified();
            if (beginDateModified != null) {
                awardDetailsType.setBeginDateModified(beginDateModified);
            }
            if ((executionDateModified = this.getExecutionDateModified()) != null) {
                awardDetailsType.setExecutionDateModified(executionDateModified);
            }
            if ((effectiveDateModified = this.getEffectiveDateModified()) != null) {
                awardDetailsType.setEffectiveDateModified(effectiveDateModified);
            }
        }
        if ((beginDate = this.getBeginDate()) != null) {
            awardDetailsType.setBeginDate(beginDate);
        }
        if ((executionDate = this.getExecutionDate()) != null) {
            awardDetailsType.setExecutionDate(executionDate);
        }
        if ((effectiveDate = this.getEffectiveDate()) != null) {
            awardDetailsType.setEffectiveDate(effectiveDate);
        }
        awardDetailsType.setApprvdEquipmentIndicator(this.getIndicator(this.award.getApprovedEquipmentItems()));
        awardDetailsType.setApprvdForeginTripIndicator(this.getIndicator(this.award.getApprovedForeignTravelTrips()));
        awardDetailsType.setApprvdSubcontractIndicator(this.getIndicator(this.award.getAwardApprovedSubawards()));
        awardDetailsType.setPaymentScheduleIndicator(this.getIndicator(this.award.getPaymentScheduleItems()));
        awardDetailsType.setIDCIndicator(this.getIndicator(this.award.getAwardFandaRate()));
        awardDetailsType.setTransferSponsorIndicator(this.getIndicator(this.award.getAwardTransferringSponsors()));
        awardDetailsType.setCostSharingIndicator(this.getIndicator(this.award.getAwardCostShares()));
        awardDetailsType.setCostSharingProjectPeriodFieldDescription(this.getProjectPeriodFieldDescription());
        awardDetailsType.setSpecialReviewIndicator(this.getIndicator(this.award.getSpecialReviews()));
        awardDetailsType.setScienceCodeIndicator(this.getIndicator(this.award.getKeywords()));
        return awardDetailsType;
    }

    private String getProjectPeriodFieldDescription() {
        return this.costShareService.getCostShareLabel();
    }

    private String getIndicator(List list) {
        return list.isEmpty() ? "N" : PRESENT_INDICATOR;
    }

    protected AwardType.AwardAmountInfo getAwardAmountInfo() {
        AwardType.AwardAmountInfo awardAmountInfoType = (AwardType.AwardAmountInfo)AwardType.AwardAmountInfo.Factory.newInstance();
        if (this.awardAmountInfo != null) {
            String enableAwdAntOblDirectIndirectCost;
            BigDecimal obligatedTotalIndirect;
            BigDecimal obligatedTotalDirect;
            BigDecimal anticipatedTotalIndirect;
            BigDecimal anticipatedTotalDirect;
            ScaleTwoDecimal anticipatedChangeIndirect;
            ScaleTwoDecimal anticipatedChangeDirect;
            ScaleTwoDecimal obligatedChangeIndirect;
            ScaleTwoDecimal obligatedChangeDirect;
            Calendar totalEndDate;
            Calendar totalStartDate;
            BigDecimal obligatedChange;
            BigDecimal anticipatedChange;
            Calendar obligationExpirationDate;
            BigDecimal obligatedDistributableAmount;
            BigDecimal amountObligatedToDate;
            Calendar currentFundEffectiveDate;
            Calendar finalExpirationDate;
            BigDecimal antDistributableAmount;
            BigDecimal anticipatedTotalAmount;
            AmountInfoType amountInfoType = (AmountInfoType)AmountInfoType.Factory.newInstance();
            if (this.award.getAwardNumber() != null) {
                amountInfoType.setAwardNumber(this.award.getAwardNumber());
            }
            if (this.award.getSequenceNumber() != null) {
                amountInfoType.setSequenceNumber(this.awardAmountInfo.getSequenceNumber());
            }
            if (this.awardAmountInfo.getSequenceNumber() != null) {
                amountInfoType.setAmountSequenceNumber(this.awardAmountInfo.getSequenceNumber());
            }
            if ((anticipatedTotalAmount = this.getAnticipatedTotalAmount()) != null) {
                amountInfoType.setAnticipatedTotalAmt(anticipatedTotalAmount);
            }
            if ((antDistributableAmount = this.getAntDistributableAmount()) != null) {
                amountInfoType.setAnticipatedDistributableAmt(antDistributableAmount);
            }
            if ((finalExpirationDate = this.getFinalExpirationDate()) != null) {
                amountInfoType.setFinalExpirationDate(finalExpirationDate);
            }
            if ((currentFundEffectiveDate = this.getCurrentFundEffectiveDate()) != null) {
                amountInfoType.setCurrentFundEffectiveDate(currentFundEffectiveDate);
            }
            if (this.prevAwardAmountInfo != null) {
                String obligationExpirationDateModified;
                String obligatedDistributableAmtModified;
                String currentFundEffectiveDateModified;
                String finalExpirationDateModified = this.getFinalExpirationDateModified();
                if (finalExpirationDateModified != null) {
                    amountInfoType.setFinalExpDateModified(finalExpirationDateModified);
                }
                if ((currentFundEffectiveDateModified = this.getCurrentFundEffectiveDateModified()) != null) {
                    amountInfoType.setCurrentFundEffectiveDateModified(currentFundEffectiveDateModified);
                }
                if ((obligatedDistributableAmtModified = this.getObligatedDistributableAmtModified()) != null) {
                    amountInfoType.setObligatedDistributableAmtModified(obligatedDistributableAmtModified);
                }
                if ((obligationExpirationDateModified = this.getObligationExpirationDateModified()) != null) {
                    amountInfoType.setObligationExpDateModified(obligationExpirationDateModified);
                }
            }
            if ((amountObligatedToDate = this.getAmtObligatedToDate()) != null) {
                amountInfoType.setAmtObligatedToDate(amountObligatedToDate);
            }
            if ((obligatedDistributableAmount = this.getObligatedDistributableAmt()) != null) {
                amountInfoType.setObligatedDistributableAmt(obligatedDistributableAmount);
            }
            if ((obligationExpirationDate = this.getObligationExpirationDate()) != null) {
                amountInfoType.setObligationExpirationDate(obligationExpirationDate);
            }
            if (this.awardAmountInfo.getTransactionId() != null) {
                amountInfoType.setTransactionId(String.valueOf(this.awardAmountInfo.getTransactionId()));
            }
            if ((anticipatedChange = this.getAnticipatedChange()) != null) {
                amountInfoType.setAnticipatedChange(anticipatedChange);
            }
            if ((obligatedChange = this.getObligatedChange()) != null) {
                amountInfoType.setObligatedChange(obligatedChange);
            }
            amountInfoType.setEntryType(String.valueOf(this.awardAmountInfo.getEntryType()));
            amountInfoType.setEOMProcess(true);
            if (this.award.getAwardEffectiveDate() != null && (totalStartDate = this.dateTimeService.getCalendar((Date)this.award.getAwardEffectiveDate())) != null) {
                amountInfoType.setTotalStartDate(totalStartDate);
            }
            if (this.award.getProjectEndDate() != null && (totalEndDate = this.dateTimeService.getCalendar((Date)this.award.getProjectEndDate())) != null) {
                amountInfoType.setTotalEndDate(totalEndDate);
            }
            if ((obligatedChangeDirect = this.getObligatedChangeDirect()) != null) {
                amountInfoType.setObligatedChangeDirect(obligatedChangeDirect.bigDecimalValue());
            }
            if ((obligatedChangeIndirect = this.getObligatedChangeIndirect()) != null) {
                amountInfoType.setObligatedChangeIndirect(obligatedChangeIndirect.bigDecimalValue());
            }
            if ((anticipatedChangeDirect = this.getAnticipatedChangeDirect()) != null) {
                amountInfoType.setAnticipatedChangeDirect(anticipatedChangeDirect.bigDecimalValue());
            }
            if ((anticipatedChangeIndirect = this.getAnticipatedChangeIndirect()) != null) {
                amountInfoType.setAnticipatedChangeIndirect(anticipatedChangeIndirect.bigDecimalValue());
            }
            if ((anticipatedTotalDirect = this.getAnticipatedTotalDirect()) != null) {
                amountInfoType.setAnticipatedTotalDirect(anticipatedTotalDirect);
            }
            if ((anticipatedTotalIndirect = this.getAnticipatedTotalIndirect()) != null) {
                amountInfoType.setAnticipatedTotalIndirect(anticipatedTotalIndirect);
            }
            if ((obligatedTotalDirect = this.getObligatedTotalDirect()) != null) {
                amountInfoType.setObligatedTotalDirect(obligatedTotalDirect);
            }
            if ((obligatedTotalIndirect = this.getObligatedTotalIndirect()) != null) {
                amountInfoType.setObligatedTotalIndirect(obligatedTotalIndirect);
            }
            if ((enableAwdAntOblDirectIndirectCost = this.getAwardParameterValue(OBLIGATED_DIRECT_INDIRECT_COST_CONSTANT)) != null) {
                amountInfoType.setEnableAwdAntOblDirectIndirectCost(enableAwdAntOblDirectIndirectCost);
            }
            AmountInfoType[] amountInfoTypes = new AmountInfoType[]{amountInfoType};
            awardAmountInfoType.setAmountInfoArray(amountInfoTypes);
        }
        return awardAmountInfoType;
    }

    private String getSponsorAwardNumber() {
        String sponsorAwardNumber = null;
        if (this.prevAward != null) {
            if (this.award.getSponsorAwardNumber() != null) {
                sponsorAwardNumber = this.prevAward.getSponsorAwardNumber() == null || !this.award.getSponsorAwardNumber().equals(this.prevAward.getSponsorAwardNumber()) ? this.award.getSponsorAwardNumber() + END_ASTERISK_SPACE_INDICATOR : this.award.getSponsorAwardNumber();
            } else if (this.prevAward.getSponsorAwardNumber() != null) {
                sponsorAwardNumber = START_ASTERISK_SPACE_INDICATOR;
            }
        } else {
            sponsorAwardNumber = this.award.getSponsorAwardNumber();
        }
        return sponsorAwardNumber;
    }

    private String getSponsorDescription() {
        String sponsordescription = null;
        if (this.prevAward != null) {
            if (this.award.getSponsorCode() != null) {
                sponsordescription = this.prevAward.getSponsorCode() == null || !this.award.getSponsorCode().equals(this.prevAward.getSponsorCode()) ? this.award.getSponsorName() + END_ASTERISK_SPACE_INDICATOR : this.award.getSponsorName();
            } else if (this.prevAward.getSponsorCode() != null) {
                sponsordescription = START_ASTERISK_SPACE_INDICATOR;
            }
        } else {
            sponsordescription = this.award.getSponsorName();
        }
        return sponsordescription;
    }

    private ReportTermDetailsType2 getAwardReportTermBean(AwardReportTerm awardReportTerm, ReportTermType2 reportTermType) {
        Calendar dueDate;
        ReportTermDetailsType2 reportTermDetailsType = reportTermType.addNewReportTermDetails();
        if (this.award.getAwardNumber() != null) {
            reportTermDetailsType.setAwardNumber(this.award.getAwardNumber());
        }
        if (this.award.getSequenceNumber() != null) {
            reportTermDetailsType.setSequenceNumber(this.award.getSequenceNumber());
        }
        if (awardReportTerm.getReportClassCode() != null) {
            reportTermDetailsType.setReportClassCode(Integer.valueOf(awardReportTerm.getReportClassCode()));
        }
        if (awardReportTerm.getReportClass() != null && awardReportTerm.getReportClass().getDescription() != null) {
            reportTermDetailsType.setReportClassDesc(awardReportTerm.getReportClass().getDescription());
        }
        if (awardReportTerm.getReportCode() != null) {
            reportTermDetailsType.setReportCode(Integer.valueOf(awardReportTerm.getReportCode()));
        }
        if (awardReportTerm.getReport() != null && awardReportTerm.getReport().getDescription() != null) {
            reportTermDetailsType.setReportCodeDesc(awardReportTerm.getReport().getDescription());
        }
        if (awardReportTerm.getFrequencyCode() != null) {
            reportTermDetailsType.setFrequencyCode(Integer.valueOf(awardReportTerm.getFrequencyCode()));
        }
        if (awardReportTerm.getFrequency() != null && awardReportTerm.getFrequency().getDescription() != null) {
            reportTermDetailsType.setFrequencyCodeDesc(awardReportTerm.getFrequency().getDescription());
        }
        if (awardReportTerm.getFrequencyBaseCode() != null) {
            reportTermDetailsType.setFrequencyBaseCode(Integer.valueOf(awardReportTerm.getFrequencyBaseCode()));
        }
        if (awardReportTerm.getFrequencyBase() != null && awardReportTerm.getFrequencyBase().getDescription() != null) {
            reportTermDetailsType.setFrequencyBaseDesc(awardReportTerm.getFrequencyBase().getDescription());
        }
        if (awardReportTerm.getOspDistributionCode() != null) {
            reportTermDetailsType.setOSPDistributionCode(Integer.valueOf(awardReportTerm.getOspDistributionCode()));
        }
        if (awardReportTerm.getDistribution() != null && awardReportTerm.getDistribution().getDescription() != null) {
            reportTermDetailsType.setOSPDistributionDesc(awardReportTerm.getDistribution().getDescription());
        }
        if ((dueDate = this.getDueDate(awardReportTerm)) != null) {
            reportTermDetailsType.setDueDate(dueDate);
        }
        List<ReportTermDetailsType2.MailCopies> mailCopiesList = this.getMailCopiesList(awardReportTerm);
        reportTermDetailsType.setMailCopiesArray(mailCopiesList.toArray(new ReportTermDetailsType2.MailCopies[0]));
        return reportTermDetailsType;
    }

    private List<ReportTermDetailsType2.MailCopies> getMailCopiesList(AwardReportTerm awardReportTerm) {
        ArrayList<ReportTermDetailsType2.MailCopies> mailCopiesList = new ArrayList<ReportTermDetailsType2.MailCopies>();
        for (AwardReportTermRecipient awardReportTermRecipient : awardReportTerm.getAwardReportTermRecipients()) {
            ReportTermDetailsType2.MailCopies mailCopies = (ReportTermDetailsType2.MailCopies)ReportTermDetailsType2.MailCopies.Factory.newInstance();
            mailCopies.setContactTypeCode(Integer.parseInt(awardReportTermRecipient.getContactTypeCode()));
            mailCopies.setContactTypeDesc(awardReportTermRecipient.getContactType().getDescription());
            mailCopies.setNumberOfCopies(String.valueOf(awardReportTermRecipient.getNumberOfCopies()));
            mailCopies.setRolodexId(String.valueOf(awardReportTermRecipient.getRolodexId()));
            mailCopies.setRolodexName(awardReportTermRecipient.getRolodex().getFullName());
            mailCopies.setRolodexOrganization(awardReportTermRecipient.getRolodex().getOrganization());
            mailCopiesList.add(mailCopies);
        }
        return mailCopiesList;
    }

    private Calendar getDueDate(AwardReportTerm awardReportTerm) {
        Calendar dueDate = null;
        if (awardReportTerm.getDueDate() != null) {
            dueDate = this.dateTimeService.getCalendar((Date)awardReportTerm.getDueDate());
        }
        return dueDate;
    }

    private RolodexDetailsType2 getRolodexDetails(AwardSponsorContact awardSponsorContact) {
        RolodexDetailsType2 rolodexDetailsType = (RolodexDetailsType2)RolodexDetailsType2.Factory.newInstance();
        if (awardSponsorContact.getRolodex() != null) {
            String stateDesc;
            String name;
            String countryDesc;
            NonOrganizationalRolodex rolodex = awardSponsorContact.getRolodex();
            if (rolodex.getAddressLine1() != null) {
                rolodexDetailsType.setAddress1(rolodex.getAddressLine1());
            }
            if (rolodex.getAddressLine2() != null) {
                rolodexDetailsType.setAddress2(rolodex.getAddressLine2());
            }
            if (rolodex.getAddressLine3() != null) {
                rolodexDetailsType.setAddress3(rolodex.getAddressLine3());
            }
            if (rolodex.getCity() != null) {
                rolodexDetailsType.setCity(rolodex.getCity());
            }
            if (rolodex.getComments() != null) {
                rolodexDetailsType.setComments(rolodex.getComments());
            }
            if (rolodex.getCountryCode() != null) {
                rolodexDetailsType.setCountryCode(rolodex.getCountryCode());
            }
            if ((countryDesc = this.getCountryDescription(rolodex)) != null) {
                rolodexDetailsType.setCountryDescription(countryDesc);
            }
            if (rolodex.getCounty() != null) {
                rolodexDetailsType.setCounty(rolodex.getCounty());
            }
            if (rolodex.getEmailAddress() != null) {
                rolodexDetailsType.setEmail(rolodex.getEmailAddress());
            }
            if (rolodex.getFaxNumber() != null) {
                rolodexDetailsType.setFax(rolodex.getFaxNumber());
            }
            if (rolodex.getFirstName() != null) {
                rolodexDetailsType.setFirstName(rolodex.getFirstName());
            }
            if (rolodex.getMiddleName() != null) {
                rolodexDetailsType.setMiddleName(rolodex.getMiddleName());
            }
            if (!(name = this.getName(rolodex)).equals(EMPTY_SPACE)) {
                rolodexDetailsType.setLastName(name);
            }
            if (rolodex.getOrganization() != null) {
                rolodexDetailsType.setOrganization(rolodex.getOrganization());
            }
            if (rolodex.getPhoneNumber() != null) {
                rolodexDetailsType.setPhoneNumber(rolodex.getPhoneNumber());
            }
            if (rolodex.getPostalCode() != null) {
                rolodexDetailsType.setPincode(rolodex.getPostalCode());
            }
            if (rolodex.getPrefix() != null) {
                rolodexDetailsType.setPrefix(rolodex.getPrefix());
            }
            if (rolodex.getRolodexId() != null) {
                rolodexDetailsType.setRolodexId(String.valueOf(rolodex.getRolodexId()));
            }
            if (rolodex.getSponsorCode() != null) {
                rolodexDetailsType.setSponsorCode(rolodex.getSponsorCode());
            }
            if (rolodex.getSponsor() != null && rolodex.getSponsor().getSponsorName() != null) {
                rolodexDetailsType.setSponsorName(rolodex.getSponsor().getSponsorName());
            }
            if (rolodex.getState() != null) {
                rolodexDetailsType.setStateCode(rolodex.getState());
            }
            if ((stateDesc = this.getState(rolodex)) != null) {
                rolodexDetailsType.setStateDescription(stateDesc);
            }
            if (rolodex.getSuffix() != null) {
                rolodexDetailsType.setSuffix(rolodex.getSuffix());
            }
            if (rolodex.getTitle() != null) {
                rolodexDetailsType.setTitle(rolodex.getTitle());
            }
            if (rolodex.getOwnedByUnit() != null) {
                rolodexDetailsType.setOwnedByUnit(rolodex.getOwnedByUnit());
            }
            if (rolodex.getUnit() != null && rolodex.getUnit().getUnitName() != null) {
                rolodexDetailsType.setOwnedByUnit(rolodex.getUnit().getUnitName());
            }
        }
        return rolodexDetailsType;
    }

    private String getState(Rolodex rolodex) {
        String stateDesc = null;
        if (StringUtils.isNotBlank((CharSequence)rolodex.getState()) && StringUtils.isNotBlank((CharSequence)rolodex.getCountryCode())) {
            Country country = this.getCountryService().getCountryByAlternateCode(rolodex.getCountryCode());
            State state = this.getStateService().getState(country.getCode(), rolodex.getState());
            if (state != null) {
                stateDesc = state.getName();
            }
        } else if (StringUtils.isNotBlank((CharSequence)rolodex.getState())) {
            return rolodex.getState();
        }
        return stateDesc;
    }

    private String getName(Rolodex rolodex) {
        StringBuilder name = new StringBuilder();
        if (rolodex.getLastName() != null) {
            name.append(rolodex.getLastName());
        }
        if (rolodex.getSuffix() != null) {
            name.append(EMPTY_SPACE).append(rolodex.getSuffix());
        }
        if (rolodex.getPrefix() != null) {
            name.append(COMMA_STRING).append(rolodex.getPrefix());
            if (rolodex.getFirstName() != null) {
                name.append(EMPTY_SPACE).append(rolodex.getFirstName());
            }
        } else if (rolodex.getFirstName() != null) {
            name.append(COMMA_STRING).append(rolodex.getFirstName());
        }
        if (rolodex.getMiddleName() != null) {
            name.append(EMPTY_SPACE).append(rolodex.getMiddleName());
        }
        return name.toString();
    }

    private String getCountryDescription(Rolodex rolodex) {
        Country country;
        String countryDesc = null;
        if (StringUtils.isNotBlank((CharSequence)rolodex.getCountryCode()) && (country = this.getCountryService().getCountryByAlternateCode(rolodex.getCountryCode())) != null) {
            countryDesc = country.getName();
        }
        return countryDesc;
    }

    private String getFinalProbSubDateModified(AwardCloseout awardCloseout, AwardCloseout preAwardCloseout) {
        return this.getIndicatorIfDatesChanged(preAwardCloseout.getFinalSubmissionDate(), awardCloseout.getFinalSubmissionDate());
    }

    private String getCloseOutDateModified(AwardCloseout awardCloseout, AwardCloseout preAwardCloseout) {
        return this.getIndicatorIfDatesChanged(preAwardCloseout.getDueDate(), awardCloseout.getDueDate());
    }

    private String getIndicatorIfDatesChanged(Date preAwardDate, Date awardDate) {
        String finalPropSubDateModified = null;
        if (preAwardDate == null && awardDate != null) {
            finalPropSubDateModified = END_ASTERISK_SPACE_INDICATOR;
        } else if (preAwardDate != null && !preAwardDate.equals(awardDate)) {
            finalPropSubDateModified = END_ASTERISK_SPACE_INDICATOR;
        }
        return finalPropSubDateModified;
    }

    private String getIndirectCostComments() {
        String comments = null;
        for (AwardComment awardComment : this.award.getAwardComments()) {
            if (awardComment.getCommentTypeCode() == null || !awardComment.getCommentTypeCode().equals(IDC_COMMENT)) continue;
            comments = awardComment.getComments();
            break;
        }
        return comments;
    }

    private AwardType.AwardCostSharing.CostSharingItem[] getCostSharingItemDetails() {
        ArrayList<AwardType.AwardCostSharing.CostSharingItem> costSharingItems = new ArrayList<AwardType.AwardCostSharing.CostSharingItem>();
        for (AwardCostShare awardCostShare : this.award.getAwardCostShares()) {
            String sourceAccount;
            AwardType.AwardCostSharing.CostSharingItem costSharingItem = (AwardType.AwardCostSharing.CostSharingItem)AwardType.AwardCostSharing.CostSharingItem.Factory.newInstance();
            if (awardCostShare.getAwardNumber() != null) {
                costSharingItem.setAwardNumber(awardCostShare.getAwardNumber());
            }
            if (awardCostShare.getSequenceNumber() != null) {
                costSharingItem.setSequenceNumber(awardCostShare.getSequenceNumber());
            }
            if (awardCostShare.getProjectPeriod() != null) {
                costSharingItem.setFiscalYear(awardCostShare.getProjectPeriod());
            }
            if (awardCostShare.getCostSharePercentage() != null) {
                costSharingItem.setPercentage(awardCostShare.getCostSharePercentage().doubleValue());
            }
            if (awardCostShare.getCostShareTypeCode() != null) {
                costSharingItem.setCostSharingType(awardCostShare.getCostShareTypeCode());
            }
            if (awardCostShare.getCostShareType() != null && awardCostShare.getCostShareType().getDescription() != null) {
                costSharingItem.setCostSharingDescription(awardCostShare.getCostShareType().getDescription());
            }
            if ((sourceAccount = awardCostShare.getSource()) != null) {
                costSharingItem.setSourceAccount(sourceAccount);
            }
            if (awardCostShare.getDestination() != null) {
                costSharingItem.setDestinationAccount(awardCostShare.getDestination());
            }
            if (awardCostShare.getAmount() != null) {
                costSharingItem.setAmount(awardCostShare.getAmount().bigDecimalValue());
            }
            costSharingItems.add(costSharingItem);
        }
        return costSharingItems.toArray(new AwardType.AwardCostSharing.CostSharingItem[0]);
    }

    private String getCostSharingComments() {
        String comments = null;
        for (AwardComment awardComment : this.award.getAwardComments()) {
            if (awardComment.getCommentTypeCode() == null || !awardComment.getCommentTypeCode().equals(COST_SHARING_COMMENT)) continue;
            comments = awardComment.getComments();
            break;
        }
        return comments;
    }

    private AwardType.AwardSpecialItems.ForeignTravel[] getForeignTravel() {
        ArrayList<AwardType.AwardSpecialItems.ForeignTravel> foreignTravels = new ArrayList<AwardType.AwardSpecialItems.ForeignTravel>();
        for (AwardApprovedForeignTravel approvedForeignTravel : this.award.getApprovedForeignTravelTrips()) {
            AwardType.AwardSpecialItems.ForeignTravel foreignTravel = (AwardType.AwardSpecialItems.ForeignTravel)AwardType.AwardSpecialItems.ForeignTravel.Factory.newInstance();
            if (approvedForeignTravel.getAwardNumber() != null) {
                foreignTravel.setAwardNumber(approvedForeignTravel.getAwardNumber());
            }
            if (approvedForeignTravel.getSequenceNumber() != null) {
                foreignTravel.setSequenceNumber(approvedForeignTravel.getSequenceNumber());
            }
            if (approvedForeignTravel.getContactId() != null) {
                foreignTravel.setPersonId(approvedForeignTravel.getContactId().toString());
            }
            if (approvedForeignTravel.getTravelerName() != null) {
                foreignTravel.setPersonName(approvedForeignTravel.getTravelerName());
            }
            if (approvedForeignTravel.getDestination() != null) {
                foreignTravel.setDestination(approvedForeignTravel.getDestination());
            }
            if (approvedForeignTravel.getStartDate() != null) {
                Calendar startDate = this.dateTimeService.getCalendar((Date)approvedForeignTravel.getStartDate());
                foreignTravel.setDateFrom(startDate);
            }
            if (approvedForeignTravel.getEndDate() != null) {
                Calendar endDate = this.dateTimeService.getCalendar((Date)approvedForeignTravel.getEndDate());
                foreignTravel.setDateTo(endDate);
            }
            if (approvedForeignTravel.getAmount() != null) {
                foreignTravel.setAmount(approvedForeignTravel.getAmount().bigDecimalValue());
            }
            foreignTravels.add(foreignTravel);
        }
        return foreignTravels.toArray(new AwardType.AwardSpecialItems.ForeignTravel[0]);
    }

    private AwardType.AwardSpecialItems.Equipment[] getEquipmentType() {
        ArrayList<AwardType.AwardSpecialItems.Equipment> equipments = new ArrayList<AwardType.AwardSpecialItems.Equipment>();
        for (AwardApprovedEquipment approvedEquipment : this.award.getApprovedEquipmentItems()) {
            AwardType.AwardSpecialItems.Equipment equipment = (AwardType.AwardSpecialItems.Equipment)AwardType.AwardSpecialItems.Equipment.Factory.newInstance();
            if (approvedEquipment.getAwardNumber() != null) {
                equipment.setAwardNumber(approvedEquipment.getAwardNumber());
            }
            if (approvedEquipment.getSequenceNumber() != null) {
                equipment.setSequenceNumber(approvedEquipment.getSequenceNumber());
            }
            if (approvedEquipment.getItem() != null) {
                equipment.setItem(approvedEquipment.getItem());
            }
            if (approvedEquipment.getVendor() != null) {
                equipment.setVendor(approvedEquipment.getVendor());
            }
            if (approvedEquipment.getModel() != null) {
                equipment.setModel(approvedEquipment.getModel());
            }
            if (approvedEquipment.getAmount() != null) {
                equipment.setAmount(approvedEquipment.getAmount().bigDecimalValue());
            }
            equipments.add(equipment);
        }
        return equipments.toArray(new AwardType.AwardSpecialItems.Equipment[0]);
    }

    private BigDecimal getPercentageEffort(AwardPerson awardPerson) {
        BigDecimal percentageEffort = null;
        if (awardPerson.getTotalEffort() != null) {
            BigDecimal bdecAmount = new BigDecimal(awardPerson.getTotalEffort().doubleValue());
            percentageEffort = bdecAmount.setScale(2, 5);
        }
        return percentageEffort;
    }

    private InvestigatorType getInvestigatorType(AwardPerson awardPerson) {
        InvestigatorType investigatorType = (InvestigatorType)InvestigatorType.Factory.newInstance();
        if (this.award.getAwardNumber() != null) {
            investigatorType.setAwardNumber(this.award.getAwardNumber());
        }
        if (this.award.getSequenceNumber() != null) {
            investigatorType.setSequenceNumber(awardPerson.getSequenceNumber());
        }
        if (awardPerson.getPersonId() != null) {
            investigatorType.setPersonId(awardPerson.getPersonId());
        }
        if (awardPerson.getPerson() != null && awardPerson.getPerson().getFullName() != null) {
            investigatorType.setPersonName(awardPerson.getPerson().getFullName());
        }
        investigatorType.setPrincipalInvestigator(awardPerson.isPrincipalInvestigator());
        if (awardPerson.getPerson() != null && awardPerson.getPerson().getOfficeLocation() != null) {
            investigatorType.setPersonAddress(awardPerson.getPerson().getOfficeLocation());
        }
        investigatorType.setNonEmployee(!awardPerson.isEmployee());
        investigatorType.setFaculty(awardPerson.isFaculty());
        investigatorType.setCOIFlag(true);
        if (awardPerson.getTotalEffort() != null) {
            investigatorType.setPercentEffort(awardPerson.getTotalEffort().bigDecimalValue());
        }
        investigatorType.setInvestigatorUnitArray(this.getInvestigatorUnitsTypes(awardPerson).toArray(new InvestigatorUnitsType[0]));
        return investigatorType;
    }

    private List<InvestigatorUnitsType> getInvestigatorUnitsTypes(AwardPerson awardPerson) {
        ArrayList<InvestigatorUnitsType> investigatorUnitsTypes = new ArrayList<InvestigatorUnitsType>();
        for (AwardPersonUnit awardPersonUnit : awardPerson.getUnits()) {
            InvestigatorUnitsType investigatorUnitsType = (InvestigatorUnitsType)InvestigatorUnitsType.Factory.newInstance();
            if (this.award.getAwardNumber() != null) {
                investigatorUnitsType.setAwardNumber(this.award.getAwardNumber());
            }
            if (this.award.getSequenceNumber() != null) {
                investigatorUnitsType.setSequenceNumber(awardPerson.getSequenceNumber());
            }
            if (awardPerson.getPersonId() != null) {
                investigatorUnitsType.setPersonId(awardPerson.getPersonId());
            }
            if (awardPersonUnit.getUnitNumber() != null) {
                investigatorUnitsType.setUnitNumber(awardPersonUnit.getUnitNumber());
            }
            if (awardPersonUnit.getUnitName() != null) {
                investigatorUnitsType.setUnitName(awardPersonUnit.getUnitName());
            }
            investigatorUnitsType.setLeadUnit(awardPersonUnit.isLeadUnit());
            if (awardPerson.getAward() != null && awardPerson.getAward().getOspAdministratorName() != null) {
                investigatorUnitsType.setOSPAdminName(awardPerson.getAward().getOspAdministratorName());
            }
            investigatorUnitsType.setUnitAdministratorArray(this.getUnitAdministratorList(awardPersonUnit).toArray(new InvestigatorUnitsType.UnitAdministrator[0]));
            investigatorUnitsTypes.add(investigatorUnitsType);
        }
        return investigatorUnitsTypes;
    }

    private List<InvestigatorUnitsType.UnitAdministrator> getUnitAdministratorList(AwardPersonUnit awardPersonUnit) {
        ArrayList<InvestigatorUnitsType.UnitAdministrator> unitAdministratorList = new ArrayList<InvestigatorUnitsType.UnitAdministrator>();
        for (UnitAdministrator unitAdministrator : awardPersonUnit.getUnit().getUnitAdministrators()) {
            InvestigatorUnitsType.UnitAdministrator unitAdministratorElement = (InvestigatorUnitsType.UnitAdministrator)InvestigatorUnitsType.UnitAdministrator.Factory.newInstance();
            if (unitAdministrator.getUnitAdministratorTypeCode() != null) {
                unitAdministratorElement.setUnitAdministratorTypeCode(Integer.parseInt(unitAdministrator.getUnitAdministratorTypeCode()));
            }
            if (unitAdministrator.getPersonId() != null) {
                unitAdministratorElement.setAdministrator(unitAdministrator.getPersonId());
            }
            if (unitAdministrator.getPerson() != null && unitAdministrator.getPerson().getFullName() != null) {
                unitAdministratorElement.setAdministratorName(unitAdministrator.getPerson().getFullName());
            }
            unitAdministratorList.add(unitAdministratorElement);
        }
        return unitAdministratorList;
    }

    private BigDecimal getAnticipatedTotalIndirect() {
        BigDecimal anticipatedTotalIndirect = null;
        if (this.awardAmountInfo.getAnticipatedTotalIndirect() != null) {
            BigDecimal bdecAnticipatedTotalIndirect = new BigDecimal(this.awardAmountInfo.getAnticipatedTotalIndirect().doubleValue());
            anticipatedTotalIndirect = bdecAnticipatedTotalIndirect.setScale(2, 5);
        }
        return anticipatedTotalIndirect;
    }

    private BigDecimal getAnticipatedTotalDirect() {
        BigDecimal anticipatedTotalDirect = null;
        if (this.awardAmountInfo.getAnticipatedTotalDirect() != null) {
            anticipatedTotalDirect = new BigDecimal(this.awardAmountInfo.getAnticipatedTotalDirect().doubleValue());
            anticipatedTotalDirect = anticipatedTotalDirect.setScale(2, 5);
        }
        return anticipatedTotalDirect;
    }

    private ScaleTwoDecimal getAnticipatedChangeIndirect() {
        ScaleTwoDecimal anticipatedChangeIndirect = null;
        if (this.awardAmountInfo.getAnticipatedChangeIndirect() != null) {
            anticipatedChangeIndirect = this.awardAmountInfo.getAnticipatedChangeIndirect();
        }
        return anticipatedChangeIndirect;
    }

    private ScaleTwoDecimal getAnticipatedChangeDirect() {
        ScaleTwoDecimal anticipatedChangeDirect = null;
        if (this.awardAmountInfo.getAnticipatedChangeDirect() != null) {
            anticipatedChangeDirect = this.awardAmountInfo.getAnticipatedChangeDirect();
        }
        return anticipatedChangeDirect;
    }

    private BigDecimal getObligatedTotalIndirect() {
        BigDecimal obligatedTotalIndirect = null;
        if (this.awardAmountInfo.getObligatedTotalIndirect() != null) {
            obligatedTotalIndirect = new BigDecimal(this.awardAmountInfo.getObligatedTotalIndirect().doubleValue());
            obligatedTotalIndirect = obligatedTotalIndirect.setScale(2, 5);
        }
        return obligatedTotalIndirect;
    }

    private BigDecimal getObligatedTotalDirect() {
        BigDecimal obligatedTotalDirect = null;
        if (this.awardAmountInfo.getObligatedTotalDirect() != null) {
            obligatedTotalDirect = new BigDecimal(this.awardAmountInfo.getObligatedTotalDirect().doubleValue());
            obligatedTotalDirect = obligatedTotalDirect.setScale(2, 5);
        }
        return obligatedTotalDirect;
    }

    private ScaleTwoDecimal getObligatedChangeIndirect() {
        ScaleTwoDecimal obligatedChangeIndirect = null;
        if (this.awardAmountInfo.getObligatedChangeIndirect() != null) {
            obligatedChangeIndirect = this.awardAmountInfo.getObligatedChangeIndirect();
        }
        return obligatedChangeIndirect;
    }

    private ScaleTwoDecimal getObligatedChangeDirect() {
        ScaleTwoDecimal obligatedChangeDirect = null;
        if (this.awardAmountInfo.getObligatedChangeDirect() != null) {
            obligatedChangeDirect = this.awardAmountInfo.getObligatedChangeDirect();
        }
        return obligatedChangeDirect;
    }

    private BigDecimal getObligatedChange() {
        BigDecimal obligatedChange = null;
        if (this.awardAmountInfo.getObligatedChange() != null) {
            obligatedChange = this.awardAmountInfo.getObligatedChange().bigDecimalValue();
            obligatedChange = obligatedChange.setScale(2, 5);
        }
        return obligatedChange;
    }

    private BigDecimal getAnticipatedChange() {
        BigDecimal anticipatedChange = null;
        if (this.awardAmountInfo.getAnticipatedChange() != null) {
            anticipatedChange = this.awardAmountInfo.getAnticipatedChange().bigDecimalValue();
            anticipatedChange = anticipatedChange.setScale(2, 5);
        }
        return anticipatedChange;
    }

    private Calendar getObligationExpirationDate() {
        Calendar obligationExpirationDate = null;
        if (this.awardAmountInfo.getObligationExpirationDate() != null) {
            obligationExpirationDate = this.dateTimeService.getCalendar((Date)this.awardAmountInfo.getObligationExpirationDate());
        }
        return obligationExpirationDate;
    }

    private String getObligationExpirationDateModified() {
        String obligationExpirationDateModified = null;
        if (this.awardAmountInfo.getObligationExpirationDate() != null) {
            if (this.prevAwardAmountInfo != null && this.prevAwardAmountInfo.getObligationExpirationDate() != null && !this.prevAwardAmountInfo.getObligationExpirationDate().equals(this.awardAmountInfo.getObligationExpirationDate())) {
                obligationExpirationDateModified = END_ASTERISK_SPACE_INDICATOR;
            }
        } else if (this.prevAwardAmountInfo != null && this.prevAwardAmountInfo.getObligationExpirationDate() != null) {
            obligationExpirationDateModified = END_ASTERISK_SPACE_INDICATOR;
        }
        return obligationExpirationDateModified;
    }

    private BigDecimal getObligatedDistributableAmt() {
        BigDecimal obligatedDistributableAmt = null;
        if (this.awardAmountInfo.getObliDistributableAmount() != null) {
            obligatedDistributableAmt = this.awardAmountInfo.getObliDistributableAmount().bigDecimalValue();
            obligatedDistributableAmt = obligatedDistributableAmt.setScale(2, 5);
        }
        return obligatedDistributableAmt;
    }

    private String getObligatedDistributableAmtModified() {
        double prevObligatedDistributableAmt;
        String obligatedDistributableAmtModified = null;
        if (this.prevAwardAmountInfo != null && this.prevAwardAmountInfo.getObliDistributableAmount() != null && (prevObligatedDistributableAmt = this.prevAwardAmountInfo.getObliDistributableAmount().doubleValue()) != this.awardAmountInfo.getObliDistributableAmount().doubleValue()) {
            obligatedDistributableAmtModified = END_ASTERISK_SPACE_INDICATOR;
        }
        return obligatedDistributableAmtModified;
    }

    private BigDecimal getAmtObligatedToDate() {
        BigDecimal amtObligatedToDate = null;
        if (this.awardAmountInfo.getAmountObligatedToDate() != null) {
            amtObligatedToDate = this.awardAmountInfo.getAmountObligatedToDate().bigDecimalValue();
            amtObligatedToDate = amtObligatedToDate.setScale(2, 5);
        }
        return amtObligatedToDate;
    }

    private Calendar getCurrentFundEffectiveDate() {
        Calendar currentFundEffectiveDate = null;
        if (this.awardAmountInfo.getCurrentFundEffectiveDate() != null) {
            currentFundEffectiveDate = this.dateTimeService.getCalendar((Date)this.awardAmountInfo.getCurrentFundEffectiveDate());
        }
        return currentFundEffectiveDate;
    }

    private String getCurrentFundEffectiveDateModified() {
        String currentFundEffectiveDateModified = null;
        if (this.awardAmountInfo.getCurrentFundEffectiveDate() != null) {
            if (!(this.prevAwardAmountInfo == null || this.prevAwardAmountInfo.getCurrentFundEffectiveDate() != null && this.prevAwardAmountInfo.getCurrentFundEffectiveDate().equals(this.awardAmountInfo.getCurrentFundEffectiveDate()))) {
                currentFundEffectiveDateModified = END_ASTERISK_SPACE_INDICATOR;
            }
        } else if (this.prevAwardAmountInfo != null && this.prevAwardAmountInfo.getCurrentFundEffectiveDate() != null) {
            currentFundEffectiveDateModified = END_ASTERISK_SPACE_INDICATOR;
        }
        return currentFundEffectiveDateModified;
    }

    private Calendar getFinalExpirationDate() {
        Calendar finalExpirationDate = null;
        if (this.awardAmountInfo.getFinalExpirationDate() != null) {
            java.sql.Date finalExp = this.awardAmountInfo.getFinalExpirationDate();
            finalExpirationDate = this.dateTimeService.getCalendar((Date)finalExp);
        }
        return finalExpirationDate;
    }

    private String getFinalExpirationDateModified() {
        String finalExpirationDateModified = null;
        if (this.awardAmountInfo.getFinalExpirationDate() != null) {
            if (!(this.prevAwardAmountInfo == null || this.prevAwardAmountInfo.getFinalExpirationDate() != null && this.prevAwardAmountInfo.getFinalExpirationDate().equals(this.awardAmountInfo.getFinalExpirationDate()))) {
                finalExpirationDateModified = END_ASTERISK_SPACE_INDICATOR;
            }
        } else if (this.prevAwardAmountInfo != null && this.prevAwardAmountInfo.getFinalExpirationDate() != null) {
            finalExpirationDateModified = END_ASTERISK_SPACE_INDICATOR;
        }
        return finalExpirationDateModified;
    }

    private BigDecimal getAntDistributableAmount() {
        BigDecimal anticipatedDistributableAmt = null;
        if (this.awardAmountInfo.getAntDistributableAmount() != null) {
            anticipatedDistributableAmt = this.awardAmountInfo.getAntDistributableAmount().bigDecimalValue();
            anticipatedDistributableAmt = anticipatedDistributableAmt.setScale(2, 5);
        }
        return anticipatedDistributableAmt;
    }

    private BigDecimal getAnticipatedTotalAmount() {
        BigDecimal anticipatedTotalAmt = null;
        if (this.awardAmountInfo.getAnticipatedTotalAmount() != null) {
            anticipatedTotalAmt = this.awardAmountInfo.getAnticipatedTotalAmount().bigDecimalValue();
            anticipatedTotalAmt = anticipatedTotalAmt.setScale(2, 5);
        }
        return anticipatedTotalAmt;
    }

    private Calendar getEffectiveDate() {
        Calendar effectiveDate = null;
        if (this.award.getAwardEffectiveDate() != null) {
            effectiveDate = this.dateTimeService.getCalendar((Date)this.award.getAwardEffectiveDate());
        }
        return effectiveDate;
    }

    private String getEffectiveDateModified() {
        String effectiveDateModified = null;
        if (this.award.getAwardEffectiveDate() != null) {
            if (this.prevAward.getAwardEffectiveDate() == null || !this.award.getAwardEffectiveDate().equals(this.prevAward.getAwardEffectiveDate())) {
                effectiveDateModified = END_ASTERISK_SPACE_INDICATOR;
            }
        } else if (this.prevAward.getAwardEffectiveDate() != null) {
            effectiveDateModified = END_ASTERISK_SPACE_INDICATOR;
        }
        return effectiveDateModified;
    }

    private Calendar getExecutionDate() {
        Calendar executionDate = null;
        if (this.award.getAwardExecutionDate() != null) {
            executionDate = this.dateTimeService.getCalendar((Date)this.award.getAwardExecutionDate());
        }
        return executionDate;
    }

    private Calendar getBeginDate() {
        Calendar beginDate = null;
        if (this.award.getBeginDate() != null) {
            beginDate = this.dateTimeService.getCalendar((Date)this.award.getBeginDate());
        }
        return beginDate;
    }

    private String getBeginDateModified() {
        String beginDateModified = null;
        if (this.award.getBeginDate() != null) {
            if (this.prevAward.getBeginDate() == null || !this.award.getBeginDate().equals(this.prevAward.getBeginDate())) {
                beginDateModified = END_ASTERISK_SPACE_INDICATOR;
            }
        } else if (this.prevAward.getBeginDate() != null) {
            beginDateModified = END_ASTERISK_SPACE_INDICATOR;
        }
        return beginDateModified;
    }

    private String getExecutionDateModified() {
        String executionDateModified = null;
        if (this.award.getAwardExecutionDate() != null) {
            if (this.prevAward.getAwardExecutionDate() == null || !this.prevAward.getAwardExecutionDate().equals(this.award.getAwardExecutionDate())) {
                executionDateModified = END_ASTERISK_SPACE_INDICATOR;
            }
        } else if (this.prevAward.getAwardExecutionDate() != null) {
            executionDateModified = END_ASTERISK_SPACE_INDICATOR;
        }
        return executionDateModified;
    }

    private AwardType.AwardDetails.OtherHeaderDetails getOtherHeaderDetails() {
        AwardHierarchy hierarchy;
        String fellowShipname;
        String invoiceInstructions;
        String paymentMethodDesc;
        String basisPaymentDesc;
        AwardType.AwardDetails.OtherHeaderDetails otherHeaderDetails = (AwardType.AwardDetails.OtherHeaderDetails)AwardType.AwardDetails.OtherHeaderDetails.Factory.newInstance();
        if (this.award.getProposalNumber() != null) {
            otherHeaderDetails.setProposalNumber(this.award.getProposalNumber());
        }
        if (this.award.getAwardTypeCode() != null) {
            otherHeaderDetails.setAwardTypeCode(this.award.getAwardTypeCode());
        }
        if (this.award.getAwardTypeCode() != null) {
            if (this.prevAward != null && this.prevAward.getAwardTypeCode() != null) {
                String prevAwardTypeDescription;
                String awardTypeDescription = this.getAwardTypeDesc(this.award.getAwardTypeCode());
                String awardTypeDesc = this.getTypeDescription(awardTypeDescription, prevAwardTypeDescription = this.getAwardTypeDesc(this.prevAward.getAwardTypeCode()));
                if (awardTypeDesc != null) {
                    otherHeaderDetails.setAwardTypeDesc(awardTypeDesc);
                }
            } else {
                String awardTypeDesc = this.getAwardTypeDesc(this.award.getAwardTypeCode());
                if (awardTypeDesc != null) {
                    otherHeaderDetails.setAwardTypeDesc(awardTypeDesc);
                }
            }
        }
        if (this.award.getSpecialEbRateOffCampus() != null) {
            otherHeaderDetails.setSpecialEBRateOffCampus(this.award.getSpecialEbRateOffCampus().bigDecimalValue());
        }
        if (this.award.getSpecialEbRateOnCampus() != null) {
            otherHeaderDetails.setSpecialEBRateOnCampus(this.award.getSpecialEbRateOnCampus().bigDecimalValue());
        }
        if (this.award.getAwardSpecialRate() != null && this.award.getAwardSpecialRate().getComments() != null) {
            otherHeaderDetails.setSpecialRateComments(this.award.getAwardBenefitsRateComment().getComments());
        }
        ScaleTwoDecimal bdecPreAwardAuthorizedAmt = this.award.getPreAwardAuthorizedAmount() == null ? ScaleTwoDecimal.ZERO : this.award.getPreAwardAuthorizedAmount();
        otherHeaderDetails.setPreAwardAuthorizedAmt(bdecPreAwardAuthorizedAmt.bigDecimalValue().setScale(2, 5));
        ScaleTwoDecimal bdecPreAwardAuthorizedAmtModified = this.award.getPreAwardInstitutionalAuthorizedAmount() == null ? ScaleTwoDecimal.ZERO : this.award.getPreAwardInstitutionalAuthorizedAmount();
        otherHeaderDetails.setPreAwardAuthorizedAmtModifeid(bdecPreAwardAuthorizedAmtModified.bigDecimalValue().setScale(2, 5).toString());
        if (this.award.getPreAwardEffectiveDate() != null) {
            Calendar preAwardEffectiveDate = this.dateTimeService.getCalendar((Date)this.award.getPreAwardEffectiveDate());
            otherHeaderDetails.setPreAwardEffectiveDate(preAwardEffectiveDate);
        }
        if (this.award.getPreAwardInstitutionalEffectiveDate() != null) {
            otherHeaderDetails.setPreAwardEffectiveDateModifeid(this.dateTimeService.toDateString((Date)this.award.getPreAwardInstitutionalEffectiveDate()));
        }
        if (this.prevAward != null) {
            String awardEffectiveDate;
            String preAwardAuthorizedAmtModified = this.getPreAwardAuthorizedAmountModified();
            if (preAwardAuthorizedAmtModified != null) {
                otherHeaderDetails.setPreAwardAuthorizedAmtModifeid(preAwardAuthorizedAmtModified);
            }
            if ((awardEffectiveDate = this.getPreAwardEffectiveDateModified()) != null) {
                otherHeaderDetails.setPreAwardEffectiveDateModifeid(awardEffectiveDate);
            }
            if (!CollectionUtils.isEqualCollection((Collection)this.award.getAwardCfdas().stream().map(AwardCfda::getCfdaNumber).collect(Collectors.toList()), (Collection)this.prevAward.getAwardCfdas().stream().map(AwardCfda::getCfdaNumber).collect(Collectors.toList()))) {
                otherHeaderDetails.setCFDANumber(this.award.getAwardCfdas().stream().map(AwardCfda::getCfdaNumber).collect(Collectors.joining(STRING_SEPARATER)));
            }
            if (!(this.award.getSubPlanFlag() == null || this.prevAward.getSubPlanFlag() == null && this.award.getSubPlanFlag().equals(this.prevAward.getSubPlanFlag()))) {
                otherHeaderDetails.setSubPlan(this.award.getSubPlanFlag());
            }
            if (!(this.award.getPrimeSponsorCode() == null || this.prevAward.getPrimeSponsorCode() != null && this.award.getPrimeSponsorCode().equals(this.prevAward.getPrimeSponsorCode()))) {
                otherHeaderDetails.setPrimeSponsorCode(this.award.getPrimeSponsorCode());
            }
        } else {
            otherHeaderDetails.setCFDANumber(this.award.getAwardCfdas().stream().map(AwardCfda::getCfdaNumber).collect(Collectors.joining(STRING_SEPARATER)));
            if (this.award.getSubPlanFlag() != null) {
                otherHeaderDetails.setSubPlan(this.award.getSubPlanFlag());
            }
            if (this.award.getPrimeSponsorCode() != null) {
                otherHeaderDetails.setPrimeSponsorCode(this.award.getPrimeSponsorCode());
            }
        }
        if (this.award.getDocumentFundingId() != null) {
            otherHeaderDetails.setDFAFSNumber(this.award.getDocumentFundingId());
        }
        if (this.award.getProcurementPriorityCode() != null) {
            otherHeaderDetails.setProcurementPriorityCode(this.award.getProcurementPriorityCode());
        }
        if (this.award.getPrimeSponsor() != null && this.award.getPrimeSponsor().getSponsorName() != null) {
            otherHeaderDetails.setPrimeSponsorDescription(this.award.getPrimeSponsor().getSponsorName());
        }
        if (this.award.getBasisOfPaymentCode() != null) {
            otherHeaderDetails.setBasisPaymentCode(this.award.getBasisOfPaymentCode());
        }
        if ((basisPaymentDesc = this.getAwardBasisPaymentDesc()) != null) {
            otherHeaderDetails.setBasisPaymentDesc(basisPaymentDesc);
        }
        if (this.award.getMethodOfPaymentCode() != null) {
            otherHeaderDetails.setPaymentMethodCode(this.award.getMethodOfPaymentCode());
        }
        if ((paymentMethodDesc = this.getAwardPaymentMethodDesc()) != null) {
            otherHeaderDetails.setPaymentMethodDesc(paymentMethodDesc);
        }
        if (this.award.getActivityTypeCode() != null) {
            otherHeaderDetails.setActivityTypeCode(Integer.parseInt(this.award.getActivityTypeCode()));
            if (this.prevAward != null && this.prevAward.getActivityTypeCode() != null) {
                String prevActivityypeDescription;
                String activityTypeDescription = this.getActivityTypeDesc(String.valueOf(this.award.getActivityTypeCode()));
                String activityTypeDesc = this.getTypeDescription(activityTypeDescription, prevActivityypeDescription = this.getActivityTypeDesc(String.valueOf(this.prevAward.getActivityTypeCode())));
                if (activityTypeDesc != null) {
                    otherHeaderDetails.setActivityTypeDesc(activityTypeDesc);
                }
            } else {
                String activityTypeDesc = this.getActivityTypeDesc(String.valueOf(this.award.getActivityTypeCode()));
                if (activityTypeDesc != null) {
                    otherHeaderDetails.setActivityTypeDesc(activityTypeDesc);
                }
            }
        }
        if ((invoiceInstructions = this.getInvoiceInstructionComments()) != null) {
            otherHeaderDetails.setInvoiceInstructions(invoiceInstructions);
        }
        if ((fellowShipname = this.getFellowshipAdminName()) != null) {
            otherHeaderDetails.setFellowshipAdminName(fellowShipname);
        }
        if (this.award.getAccountTypeCode() != null) {
            otherHeaderDetails.setAccountTypeCode(String.valueOf(this.award.getAccountTypeCode()));
        }
        if (this.award.getAccountTypeCode() != null) {
            String accountTypeDescription;
            if (this.prevAward != null && this.prevAward.getAccountTypeCode() != null) {
                String prevAccountTypeDescription;
                accountTypeDescription = this.getAccountTypeDesc(String.valueOf(this.award.getAccountTypeCode()));
                String accountTypeDesc = this.getTypeDescription(accountTypeDescription, prevAccountTypeDescription = this.getAccountTypeDesc(String.valueOf(this.prevAward.getAccountTypeCode())));
                if (accountTypeDesc != null) {
                    otherHeaderDetails.setAccountTypeDesc(accountTypeDesc);
                }
            } else {
                accountTypeDescription = this.getAccountTypeDesc(String.valueOf(this.award.getAccountTypeCode()));
                if (accountTypeDescription != null) {
                    otherHeaderDetails.setAccountTypeDesc(accountTypeDescription);
                }
            }
        }
        if ((hierarchy = this.getAwardHierarchyService().loadAwardHierarchy(this.awardDocument.getAward().getAwardNumber())) != null) {
            AwardHierarchy parent = hierarchy.getParent();
            if (parent != null) {
                otherHeaderDetails.setRootAccountNumber(parent.getAward().getAccountNumber());
            } else {
                otherHeaderDetails.setRootAccountNumber(this.award.getAccountNumber());
            }
        }
        if (this.award.getUpdateUser() != null) {
            otherHeaderDetails.setUpdateUser(this.award.getUpdateUser());
        }
        if (this.award.getUpdateTimestamp() != null) {
            Calendar calendar = this.dateTimeService.getCalendar((Date)this.award.getUpdateTimestamp());
            otherHeaderDetails.setLastUpdate(calendar);
        }
        return otherHeaderDetails;
    }

    private String getInvoiceInstructionComments() {
        List<AwardComment> awardComments = this.award.getAwardComments();
        for (AwardComment awardComment : awardComments) {
            if (!awardComment.getCommentTypeCode().equals("1")) continue;
            return awardComment.getComments();
        }
        return null;
    }

    private String getAwardPaymentMethodDesc() {
        this.award.refreshReferenceObject("awardMethodOfPayment");
        String paymentMethodDesc = null;
        if (this.prevAward != null) {
            if (this.award.getAwardMethodOfPayment() != null && this.award.getAwardMethodOfPayment().getDescription() != null && this.award.getMethodOfPaymentCode() != null && this.prevAward.getMethodOfPaymentCode() != null) {
                paymentMethodDesc = this.award.getMethodOfPaymentCode().equals(this.prevAward.getMethodOfPaymentCode()) ? this.award.getAwardMethodOfPayment().getDescription() : START_ASTERISK_SPACE_INDICATOR + this.award.getAwardMethodOfPayment().getDescription();
            }
        } else if (this.award.getAwardMethodOfPayment() != null && this.award.getAwardMethodOfPayment().getDescription() != null) {
            paymentMethodDesc = this.award.getAwardMethodOfPayment().getDescription();
        }
        return paymentMethodDesc;
    }

    private String getAwardBasisPaymentDesc() {
        this.award.refreshReferenceObject("awardBasisOfPayment");
        String basisPaymentDesc = null;
        if (this.prevAward != null) {
            if (this.award.getBasisOfPaymentCode() != null && this.prevAward.getBasisOfPaymentCode() != null) {
                basisPaymentDesc = this.award.getBasisOfPaymentCode().equals(this.prevAward.getBasisOfPaymentCode()) ? this.award.getAwardBasisOfPayment().getDescription() : START_ASTERISK_SPACE_INDICATOR + this.award.getAwardBasisOfPayment().getDescription();
            }
        } else if (this.award.getAwardBasisOfPayment() != null && this.award.getAwardBasisOfPayment().getDescription() != null) {
            basisPaymentDesc = this.award.getAwardBasisOfPayment().getDescription();
        }
        return basisPaymentDesc;
    }

    private String getFellowshipAdminName() {
        String fellowshipname = this.award.getActivityTypeCode() != null && this.award.getActivityTypeCode().equals("3") && this.award.getActivityTypeCode().equals("7") ? this.getAdminName() : this.getAwardParameterValue(FELLOWSHIP_ADMIN_NAME);
        return fellowshipname;
    }

    private String getAdminName() {
        String adminName = this.award.getOspAdministratorName();
        if (adminName != null) {
            String lastName = null;
            String firstName = null;
            int pos = adminName.indexOf(STRING_SEPARATER);
            if (pos <= 0) {
                pos = adminName.indexOf(EMPTY_SPACE);
            }
            if (pos >= 0) {
                firstName = adminName.substring(0, pos).trim();
                lastName = adminName.substring(pos + 1).trim();
            }
            if (lastName != null && firstName != null) {
                adminName = firstName + EMPTY_SPACE + lastName;
            } else if (lastName != null) {
                adminName = firstName;
            } else if (firstName != null) {
                adminName = lastName;
            }
        }
        return adminName;
    }

    private String getTypeDescription(String awardTypeDescription, String prevAwardTypeDescription) {
        String awardTypeDesc = null;
        if (awardTypeDescription != null) {
            awardTypeDesc = !awardTypeDescription.equals(prevAwardTypeDescription) ? awardTypeDescription + END_ASTERISK_SPACE_INDICATOR : awardTypeDescription;
        } else if (prevAwardTypeDescription != null) {
            awardTypeDesc = START_ASTERISK_SPACE_INDICATOR;
        }
        return awardTypeDesc;
    }

    private String getAwardTypeDesc(Integer awardTypeCode) {
        String description = null;
        AwardType awardType = (AwardType)this.dataObjectService.find(AwardType.class, (Object)awardTypeCode);
        if (awardType != null) {
            description = awardType.getDescription();
        }
        return description;
    }

    private String getActivityTypeDesc(String activityTypeCode) {
        String description = null;
        HashMap<String, String> activityTypeCodeMap = new HashMap<String, String>();
        activityTypeCodeMap.put(ACTIVITY_TYPE_CODE_PARAMETER, activityTypeCode);
        List activityTypes = this.businessObjectService.findMatching(ActivityType.class, activityTypeCodeMap);
        if (activityTypes != null && !activityTypes.isEmpty()) {
            description = ((ActivityType)activityTypes.get(0)).getDescription();
        }
        return description;
    }

    private String getAccountTypeDesc(String accountTypeCode) {
        String description = null;
        HashMap<String, String> accountTypeCodeMap = new HashMap<String, String>();
        accountTypeCodeMap.put(ACCOUNT_TYPE_CODE_PARAMETER, accountTypeCode);
        List accountTypes = this.businessObjectService.findMatching(AccountType.class, accountTypeCodeMap);
        if (accountTypes != null && !accountTypes.isEmpty()) {
            description = ((AccountType)accountTypes.get(0)).getDescription();
        }
        return description;
    }

    private String getCommentTypeDesc(String commentTypeCode) {
        String description = null;
        HashMap<String, String> commentTypeCodeMap = new HashMap<String, String>();
        commentTypeCodeMap.put(COMMENT_TYPE_CODE_PARAMETER, commentTypeCode);
        List commentTypes = this.businessObjectService.findMatching(CommentType.class, commentTypeCodeMap);
        if (commentTypes != null && !commentTypes.isEmpty()) {
            description = ((CommentType)commentTypes.get(0)).getDescription();
        }
        return description;
    }

    private String getPreAwardEffectiveDateModified() {
        String preAwardEffectiveDateModified = null;
        if (this.award.getPreAwardEffectiveDate() != null) {
            if (this.prevAward.getPreAwardEffectiveDate() == null || !this.prevAward.getPreAwardEffectiveDate().equals(this.award.getPreAwardEffectiveDate())) {
                preAwardEffectiveDateModified = END_ASTERISK_SPACE_INDICATOR;
            }
        } else if (this.prevAward.getPreAwardEffectiveDate() != null) {
            preAwardEffectiveDateModified = END_ASTERISK_SPACE_INDICATOR;
        }
        return preAwardEffectiveDateModified;
    }

    private String getPreAwardAuthorizedAmountModified() {
        double prevPreAwardAuthorizedAmt;
        String preAwardAuthorizedAmtModified = null;
        double d = prevPreAwardAuthorizedAmt = this.prevAward.getPreAwardAuthorizedAmount() == null ? 0.0 : this.prevAward.getPreAwardAuthorizedAmount().doubleValue();
        if (this.award.getPreAwardAuthorizedAmount() != null && prevPreAwardAuthorizedAmt != this.award.getPreAwardAuthorizedAmount().doubleValue()) {
            preAwardAuthorizedAmtModified = END_ASTERISK_SPACE_INDICATOR;
        }
        return preAwardAuthorizedAmtModified;
    }

    private Calendar getSubmitDate(AwardPaymentSchedule awardPaymentSchedule) {
        Calendar submitDate = null;
        if (awardPaymentSchedule.getSubmitDate() != null) {
            submitDate = this.dateTimeService.getCalendar((Date)awardPaymentSchedule.getSubmitDate());
        }
        return submitDate;
    }

    private Calendar getDueDate(AwardPaymentSchedule awardPaymentSchedule) {
        Calendar paymentScheduleDueDate = null;
        if (awardPaymentSchedule.getDueDate() != null) {
            paymentScheduleDueDate = this.dateTimeService.getCalendar((Date)awardPaymentSchedule.getDueDate());
        }
        return paymentScheduleDueDate;
    }

    protected String getAwardParameterValue(String param) {
        String value = null;
        try {
            value = this.parameterService.getParameterValueAsString(AwardDocument.class, param);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public CostShareService getCostShareService() {
        return this.costShareService;
    }

    public void setCostShareService(CostShareService costShareService) {
        this.costShareService = costShareService;
    }

    public StateService getStateService() {
        return this.stateService;
    }

    public void setStateService(StateService stateService) {
        this.stateService = stateService;
    }

    public CountryService getCountryService() {
        return this.countryService;
    }

    public void setCountryService(CountryService countryService) {
        this.countryService = countryService;
    }

    public AwardHierarchyService getAwardHierarchyService() {
        return this.awardHierarchyService;
    }

    public void setAwardHierarchyService(AwardHierarchyService awardHierarchyService) {
        this.awardHierarchyService = awardHierarchyService;
    }
}

