/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPublisher;
import org.kuali.coeus.coi.framework.ProjectRetrievalService;
import org.kuali.coeus.common.framework.auth.perm.DocumentLevelPermissionable;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.impl.krms.KcKrmsFactBuilderServiceHelper;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonCreditSplit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnit;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalVersioningService;
import org.kuali.kra.institutionalproposal.specialreview.InstitutionalProposalSpecialReview;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krms.api.engine.Facts;

@ParameterConstants.NAMESPACE(namespace="KC-IP")
@ParameterConstants.COMPONENT(component="Document")
public class InstitutionalProposalDocument
extends KcTransactionalDocumentBase
implements KrmsRulesContext,
DocumentLevelPermissionable {
    public static final String DOCUMENT_TYPE_CODE = "INPR";
    private static final long serialVersionUID = 5101782927161970631L;
    private static final String NAMESPACE_CODE = "namespaceCode";
    private static final String NAME = "name";
    private static final Logger LOG = LogManager.getLogger(InstitutionalProposalDocument.class);
    private List<InstitutionalProposal> institutionalProposalList;
    private transient KcKrmsFactBuilderServiceHelper institutionalProposalFactBuilderService;
    private transient ProjectRetrievalService projectRetrievalService;
    private transient ProjectPublisher projectPublisher;

    public InstitutionalProposalDocument() {
        this.init();
    }

    public InstitutionalProposal getInstitutionalProposal() {
        return this.institutionalProposalList.get(0);
    }

    public void setInstitutionalProposal(InstitutionalProposal institutionalProposal) {
        this.institutionalProposalList.set(0, institutionalProposal);
    }

    public List<InstitutionalProposal> getInstitutionalProposalList() {
        return this.institutionalProposalList;
    }

    public void setInstitutionalProposalList(List<InstitutionalProposal> institutionalProposalList) {
        this.institutionalProposalList = institutionalProposalList;
    }

    @Override
    public KcPersistableBusinessObjectBase getBusinessObject() {
        return this.getInstitutionalProposal();
    }

    @Override
    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    protected void init() {
        this.institutionalProposalList = new ArrayList<InstitutionalProposal>();
        this.institutionalProposalList.add(new InstitutionalProposal());
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        InstitutionalProposal institutionalProposal = this.getInstitutionalProposal();
        managedLists.add(institutionalProposal.getInstitutionalProposalUnitContacts());
        managedLists.add(institutionalProposal.getInstitutionalProposalScienceKeywords());
        managedLists.add(institutionalProposal.getInstitutionalProposalCostShares());
        managedLists.add(institutionalProposal.getInstitutionalProposalUnrecoveredFandAs());
        managedLists.add(institutionalProposal.getInstitutionalProposalFandAs());
        managedLists.add(institutionalProposal.getAwardFundingProposals());
        managedLists.add(institutionalProposal.getInstitutionalProposalNotepads());
        ArrayList specialReviewExemptions = new ArrayList();
        for (InstitutionalProposalSpecialReview specialReview : this.getInstitutionalProposal().getSpecialReviews()) {
            specialReviewExemptions.addAll(specialReview.getSpecialReviewExemptions());
        }
        managedLists.add(specialReviewExemptions);
        managedLists.add(institutionalProposal.getSpecialReviews());
        ArrayList<InstitutionalProposalPersonUnit> units = new ArrayList<InstitutionalProposalPersonUnit>();
        ArrayList<InstitutionalProposalPersonCreditSplit> creditSplits = new ArrayList<InstitutionalProposalPersonCreditSplit>();
        for (InstitutionalProposalPerson person : institutionalProposal.getProjectPersons()) {
            units.addAll(person.getUnits());
            creditSplits.addAll(person.getCreditSplits());
        }
        managedLists.add(units);
        managedLists.add(creditSplits);
        managedLists.add(institutionalProposal.getProjectPersons());
        managedLists.add(institutionalProposal.getProposalCfdas());
        return managedLists;
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        this.executeAsLastActionUser(() -> {
            super.doRouteStatusChange(statusChangeEvent);
            String newStatus = statusChangeEvent.getNewRouteStatus();
            LOG.debug(String.format("********************* Status Change: from %s to %s", statusChangeEvent.getOldRouteStatus(), newStatus));
            if ("P".equalsIgnoreCase(newStatus)) {
                this.getInstitutionalProposalVersioningService().updateInstitutionalProposalVersionStatus(this.getInstitutionalProposal(), VersionStatus.ACTIVE);
            } else if (newStatus.equalsIgnoreCase("X") || newStatus.equalsIgnoreCase("D")) {
                this.getInstitutionalProposalVersioningService().updateInstitutionalProposalVersionStatus(this.getInstitutionalProposal(), VersionStatus.CANCELED);
            }
            Project project = this.getProjectRetrievalService().retrieveProject(this.getInstitutionalProposal().getProposalNumber());
            if (project != null) {
                this.getProjectPublisher().publishProject(project);
            }
            return null;
        });
    }

    private InstitutionalProposalVersioningService getInstitutionalProposalVersioningService() {
        return KcServiceLocator.getService(InstitutionalProposalVersioningService.class);
    }

    @Override
    public void prepareForSave() {
        super.prepareForSave();
        if (ObjectUtils.isNull((Object)this.getVersionNumber())) {
            this.setVersionNumber(0L);
        }
    }

    public boolean isSaved() {
        return this.getDocumentHeader().getWorkflowDocument().isSaved();
    }

    @Override
    public String getDocumentBoNumber() {
        return this.getInstitutionalProposal().getInstProposalNumber();
    }

    @Override
    public boolean isProcessComplete() {
        String docRouteStatus;
        boolean isComplete = false;
        if (this.getDocumentHeader().hasWorkflowDocument() && "F".equals(docRouteStatus = this.getDocumentHeader().getWorkflowDocument().getStatus().getCode())) {
            isComplete = true;
        }
        return isComplete;
    }

    @Override
    public void afterWorkflowEngineProcess(boolean success) {
        if (CollectionUtils.isNotEmpty(this.getInstitutionalProposalList())) {
            this.getInstitutionalProposalList().get(0);
        }
        super.afterWorkflowEngineProcess(success);
    }

    @Override
    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return this.getInstitutionalProposal().getInstitutionalProposalCustomDataList();
    }

    @Override
    public void populateContextQualifiers(Map<String, String> qualifiers) {
        qualifiers.put(NAMESPACE_CODE, "KC-IP");
        qualifiers.put(NAME, "KC Institutional Proposal Context");
    }

    @Override
    public void addFacts(Facts.Builder factsBuilder) {
        this.getInstitutionalProposalFactBuilderService().addFacts(factsBuilder, this);
    }

    @Override
    public void populateAgendaQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("Unit Number", this.getLeadUnitNumber());
    }

    @Override
    public String getDocumentNumberForPermission() {
        return this.getInstitutionalProposal().getInstProposalNumber();
    }

    @Override
    public void populateAdditionalQualifiedRoleAttributes(Map<String, String> qualifiedRoleAttributes) {
        if (this.getInstitutionalProposal().getProposalId() != null) {
            qualifiedRoleAttributes.put("proposal", this.getInstitutionalProposal().getProposalId().toString());
        }
    }

    @Override
    public String getDocumentKey() {
        return "institutionalProposal";
    }

    @Override
    public List<String> getRoleNames() {
        return new ArrayList<String>();
    }

    @Override
    public String getNamespace() {
        return "KC-IP";
    }

    @Override
    public String getLeadUnitNumber() {
        return this.getInstitutionalProposal().getLeadUnitNumber();
    }

    @Override
    public String getDocumentRoleTypeCode() {
        return "KC-IP";
    }

    public KcKrmsFactBuilderServiceHelper getInstitutionalProposalFactBuilderService() {
        if (this.institutionalProposalFactBuilderService == null) {
            this.institutionalProposalFactBuilderService = (KcKrmsFactBuilderServiceHelper)KcServiceLocator.getService("institutionalProposalFactBuilderService");
        }
        return this.institutionalProposalFactBuilderService;
    }

    public void setInstitutionalProposalFactBuilderService(KcKrmsFactBuilderServiceHelper institutionalProposalFactBuilderService) {
        this.institutionalProposalFactBuilderService = institutionalProposalFactBuilderService;
    }

    public ProjectPublisher getProjectPublisher() {
        if (this.projectPublisher == null) {
            this.projectPublisher = KcServiceLocator.getService(ProjectPublisher.class);
        }
        return this.projectPublisher;
    }

    public void setProjectPublisher(ProjectPublisher projectPublisher) {
        this.projectPublisher = projectPublisher;
    }

    public ProjectRetrievalService getProjectRetrievalService() {
        if (this.projectRetrievalService == null) {
            this.projectRetrievalService = (ProjectRetrievalService)KcServiceLocator.getService("instPropProjectRetrievalService");
        }
        return this.projectRetrievalService;
    }

    public void setProjectRetrievalService(ProjectRetrievalService projectRetrievalService) {
        this.projectRetrievalService = projectRetrievalService;
    }

    @Override
    public Map<String, String> getKrmsRoleQualifiers() {
        HashMap<String, String> qualifiers = new HashMap<String, String>();
        qualifiers.put("proposal", this.getInstitutionalProposal().getProposalId().toString());
        return qualifiers;
    }
}

