/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.web.struts.action;

import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.proposal.framework.report.CurrentAndPendingReportService;
import org.kuali.coeus.sys.framework.controller.StrutsConfirmation;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.AuditHelper;
import org.kuali.kra.common.web.struts.form.ReportHelperBean;
import org.kuali.kra.common.web.struts.form.ReportHelperBeanContainer;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.fundedawards.FundedAwardsBean;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.notification.InstitutionalProposalNotificationContext;
import org.kuali.kra.institutionalproposal.printing.InstitutionalProposalPrintType;
import org.kuali.kra.institutionalproposal.printing.service.InstitutionalProposalPrintingService;
import org.kuali.kra.institutionalproposal.web.struts.action.InstitutionalProposalAction;
import org.kuali.kra.institutionalproposal.web.struts.form.InstitutionalProposalForm;
import org.kuali.rice.kns.web.struts.action.AuditModeAction;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.GlobalVariables;

public class InstitutionalProposalActionsAction
extends InstitutionalProposalAction
implements AuditModeAction {
    private static final int ERROR = 2;
    private static final int OK = 0;
    private static final int WARNING = 1;
    private static final String CONFIRM_UNLOCK_SELECTED = "confirmUnlockSelected";
    private static final String CONFIRM_UNLOCK_SELECTED_KEY = "confirmUnlockSelectedKey";
    private static final String ERROR_SELECTING_FUNDING_PROPS = "error.fundingproposal.unlockNoSelection";

    public ActionForward activate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return KcServiceLocator.getService(AuditHelper.class).setAuditMode(mapping, (InstitutionalProposalForm)form, true);
    }

    public ActionForward deactivate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return KcServiceLocator.getService(AuditHelper.class).setAuditMode(mapping, (InstitutionalProposalForm)form, false);
    }

    public ActionForward unlockSelected(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm iForm = (InstitutionalProposalForm)form;
        if (iForm.getSelectedAwardFundingProposals() == null || iForm.getSelectedAwardFundingProposals().length == 0) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("selectedAwardFundingProposals", ERROR_SELECTING_FUNDING_PROPS, new String[0]);
            return mapping.findForward("institutionalProposalActions");
        }
        return this.confirm(this.buildUnlockSelectedConfirmationQuestion(mapping, form, request, response), CONFIRM_UNLOCK_SELECTED, "");
    }

    public ActionForward confirmUnlockSelected(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        new FundedAwardsBean((InstitutionalProposalForm)form).removeUnlockedAwards();
        return mapping.findForward("basic");
    }

    public ActionForward selectAllFundedAwards(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        new FundedAwardsBean((InstitutionalProposalForm)form).selectAllFundedAwards();
        return mapping.findForward("basic");
    }

    public ActionForward deselectAllFundedAwards(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((InstitutionalProposalForm)form).setSelectedAwardFundingProposals(new String[0]);
        return mapping.findForward("basic");
    }

    public ActionForward printProposalSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm ipForm = (InstitutionalProposalForm)form;
        InstitutionalProposalPrintingService ipPrintingService = KcServiceLocator.getService(InstitutionalProposalPrintingService.class);
        AttachmentDataSource dataStream = ipPrintingService.printInstitutionalProposalReport(ipForm.getInstitutionalProposalDocument().getInstitutionalProposal(), InstitutionalProposalPrintType.INSTITUTIONAL_PROPOSAL_REPORT.getInstitutionalProposalPrintType(), new HashMap<String, Object>());
        this.streamToResponse(dataStream, response);
        return null;
    }

    public ActionForward prepareCurrentReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportHelperBean helper = ((ReportHelperBeanContainer)form).getReportHelperBean();
        request.setAttribute("currentReportRows", helper.prepareCurrentReport());
        request.setAttribute("reportPersonName", (Object)helper.getTargetPersonName());
        return mapping.findForward("basic");
    }

    public ActionForward preparePendingReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportHelperBean helper = ((ReportHelperBeanContainer)form).getReportHelperBean();
        request.setAttribute("pendingReportRows", helper.preparePendingReport());
        request.setAttribute("reportPersonName", (Object)helper.getTargetPersonName());
        return mapping.findForward("basic");
    }

    public ActionForward printCurrentReportPdf(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CurrentAndPendingReportService currentAndPendingReportService = KcServiceLocator.getService(CurrentAndPendingReportService.class);
        ReportHelperBean helper = ((ReportHelperBeanContainer)form).getReportHelperBean();
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        reportParameters.put("personId", helper.getPersonId());
        reportParameters.put("reportPersonName", helper.getTargetPersonName());
        AttachmentDataSource dataStream = currentAndPendingReportService.printCurrentReport(reportParameters);
        this.streamToResponse(dataStream.getData(), dataStream.getName(), null, response);
        return null;
    }

    public ActionForward printPendingReportPdf(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CurrentAndPendingReportService currentAndPendingReportService = KcServiceLocator.getService(CurrentAndPendingReportService.class);
        ReportHelperBean helper = ((ReportHelperBeanContainer)form).getReportHelperBean();
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        reportParameters.put("personId", helper.getPersonId());
        reportParameters.put("reportPersonName", helper.getTargetPersonName());
        AttachmentDataSource dataStream = currentAndPendingReportService.printPendingReport(reportParameters);
        this.streamToResponse(dataStream.getData(), dataStream.getName(), null, response);
        return null;
    }

    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm proposalForm = (InstitutionalProposalForm)form;
        ActionForward forward = super.approve(mapping, form, request, response);
        String routeHeaderId = proposalForm.getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "institutionalProposalActions", "InstitutionalProposalDocument");
        ActionForward basicForward = mapping.findForward("portal");
        ActionRedirect holdingPageForward = new ActionRedirect((ForwardConfig)mapping.findForward("kraHoldingPage"));
        holdingPageForward.addParameter("holdingPageDocumentId", (Object)routeHeaderId);
        return this.routeToHoldingPage(basicForward, forward, holdingPageForward, returnLocation, routeHeaderId);
    }

    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm proposalForm = (InstitutionalProposalForm)form;
        ActionForward forward = mapping.findForward("basic");
        proposalForm.setAuditActivated(true);
        if (this.submissionStatus(proposalForm.getInstitutionalProposalDocument()) == 2) {
            return mapping.findForward("basic");
        }
        forward = super.blanketApprove(mapping, form, request, response);
        String routeHeaderId = proposalForm.getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "institutionalProposalActions", "InstitutionalProposalDocument");
        ActionForward basicForward = mapping.findForward("portal");
        ActionRedirect holdingPageForward = new ActionRedirect((ForwardConfig)mapping.findForward("kraHoldingPage"));
        holdingPageForward.addParameter("holdingPageDocumentId", (Object)routeHeaderId);
        return this.routeToHoldingPage(basicForward, forward, holdingPageForward, returnLocation, routeHeaderId);
    }

    @Override
    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm proposalForm = (InstitutionalProposalForm)form;
        ActionForward forward = mapping.findForward("basic");
        proposalForm.setAuditActivated(true);
        if (this.submissionStatus(proposalForm.getInstitutionalProposalDocument()) == 2) {
            return mapping.findForward("basic");
        }
        forward = super.route(mapping, form, request, response);
        String routeHeaderId = proposalForm.getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "institutionalProposalActions", "InstitutionalProposalDocument");
        ActionForward basicForward = mapping.findForward("portal");
        ActionRedirect holdingPageForward = new ActionRedirect((ForwardConfig)mapping.findForward("kraHoldingPage"));
        holdingPageForward.addParameter("holdingPageDocumentId", (Object)routeHeaderId);
        return this.routeToHoldingPage(basicForward, forward, holdingPageForward, returnLocation, routeHeaderId);
    }

    private int submissionStatus(InstitutionalProposalDocument institutionalProposalDocument) {
        int state = 0;
        boolean auditPassed = KcServiceLocator.getService(AuditHelper.class).auditUnconditionally(institutionalProposalDocument);
        if (!auditPassed) {
            state = 1;
            Iterator iter = GlobalVariables.getAuditErrorMap().keySet().iterator();
            while (iter.hasNext()) {
                AuditCluster auditCluster = (AuditCluster)GlobalVariables.getAuditErrorMap().get(iter.next());
                if (StringUtils.equalsIgnoreCase((CharSequence)auditCluster.getCategory(), (CharSequence)"Warnings")) continue;
                state = 2;
                GlobalVariables.getMessageMap().putError("noKey", "error.institutionalproposal.validationFailed", new String[0]);
                break;
            }
        }
        return state;
    }

    public ActionForward acknowledge(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((InstitutionalProposalForm)form).getDocument().prepareForSave();
        return super.acknowledge(mapping, form, request, response);
    }

    public ActionForward fyi(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((InstitutionalProposalForm)form).getDocument().prepareForSave();
        return super.fyi(mapping, form, request, response);
    }

    public ActionForward sendNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        InstitutionalProposal institutionalProposal = institutionalProposalForm.getInstitutionalProposalDocument().getInstitutionalProposal();
        InstitutionalProposalNotificationContext context = new InstitutionalProposalNotificationContext(institutionalProposal, "999", "Ad-Hoc Notification", "institutionalProposalActions");
        institutionalProposalForm.getNotificationHelper().initializeDefaultValues(context);
        return mapping.findForward("notificationEditor");
    }

    private StrutsConfirmation buildUnlockSelectedConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_UNLOCK_SELECTED_KEY, "question.unlock.fundedAwards", new String[0]);
    }
}

