/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.reporting.printing.service.impl;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.api.pdf.PdfService;
import org.kuali.coeus.common.api.pdf.dto.AcroFormPutActionDto;
import org.kuali.coeus.common.api.pdf.dto.ActionDto;
import org.kuali.coeus.common.api.pdf.dto.AttachmentDto;
import org.kuali.coeus.common.api.pdf.dto.AttachmentPutActionDto;
import org.kuali.coeus.common.api.pdf.dto.JobDto;
import org.kuali.coeus.common.api.pdf.dto.LinkDto;
import org.kuali.coeus.common.api.pdf.dto.MapActionDto;
import org.kuali.coeus.common.api.pdf.dto.SingleTargetAction;
import org.kuali.coeus.common.api.pdf.dto.Status;
import org.kuali.coeus.common.framework.attachment.AttachmentFile;
import org.kuali.coeus.common.framework.print.AbstractPrint;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.PrintableAttachment;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.common.framework.print.PrintingService;
import org.kuali.coeus.sys.framework.auth.JwtService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.subaward.bo.SubAwardForms;
import org.kuali.kra.subaward.bo.SubAwardPrintAgreement;
import org.kuali.kra.subaward.bo.SubAwardPrintAgreementAttachment;
import org.kuali.kra.subaward.reporting.printing.SubAwardPrintType;
import org.kuali.kra.subaward.reporting.printing.print.SubAwardSF294Print;
import org.kuali.kra.subaward.reporting.printing.print.SubAwardSF295Print;
import org.kuali.kra.subaward.reporting.printing.service.SubAwardPrintingService;
import org.kuali.kra.subaward.service.SubAwardFormsService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.http.HttpMethod;

public class SubAwardPrintingServiceImpl
implements SubAwardPrintingService {
    private static final Logger LOG = LogManager.getLogger(SubAwardPrintingServiceImpl.class);
    private static final String SF_295_REPORT = "SF295";
    private static final String SF_294_REPORT = "SF294";
    private static final String APPLICATION_URL = "application.url";
    private SubAwardSF294Print subAwardSF294Print;
    private SubAwardSF295Print subAwardSF295Print;
    private PrintingService printingService;
    private SubAwardFormsService subAwardFormsService;
    private PdfService pdfService;
    private ConfigurationService configurationService;
    private JwtService jwtService;

    @Override
    public AttachmentDataSource printSubAwardReport(KcPersistableBusinessObjectBase awardDocument, SubAwardPrintType subAwardPrintType, Map<String, Object> reportParameters) throws PrintingException {
        AbstractPrint printable = null;
        if (reportParameters.get("printType") != null) {
            printable = reportParameters.get("printType").equals(SF_295_REPORT) ? this.getSubAwardSF295Print() : this.getSubAwardSF294Print();
        }
        printable.setPrintableBusinessObject(awardDocument);
        printable.setReportParameters(reportParameters);
        AttachmentDataSource source = this.getPrintingService().print(printable);
        source.setType("application/pdf");
        if (reportParameters.get("printType").equals(SF_295_REPORT)) {
            source.setName("SF295.pdf");
        } else {
            source.setName("SF294.pdf");
        }
        return source;
    }

    public PrintingService getPrintingService() {
        return this.printingService;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    public SubAwardSF294Print getSubAwardSF294Print() {
        return this.subAwardSF294Print;
    }

    public void setSubAwardSF294Print(SubAwardSF294Print subAwardSF294Print) {
        this.subAwardSF294Print = subAwardSF294Print;
    }

    public SubAwardSF295Print getSubAwardSF295Print() {
        return this.subAwardSF295Print;
    }

    public void setSubAwardSF295Print(SubAwardSF295Print subAwardSF295Print) {
        this.subAwardSF295Print = subAwardSF295Print;
    }

    @Override
    public List<AttachmentDataSource> printSubawardTemplates(SubAwardPrintAgreement agreement) {
        if (agreement.getFundingSource() == null) {
            throw new PrintingException("Funding source is required");
        }
        try {
            JobDto job = new JobDto();
            Map actionIdToForms = agreement.getSelectedForms().stream().map(this.getSubAwardFormsService()::byId).map(form -> org.kuali.coeus.sys.framework.util.CollectionUtils.entry(this.addActions((SubAwardForms)form, agreement, job), form)).collect(org.kuali.coeus.sys.framework.util.CollectionUtils.entriesToMap());
            JobDto response = this.getPdfService().submitAndAwaitJob(job);
            if (response.getStatus() != Status.SUCCESS) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)response);
                }
                throw new PrintingException("Pdf failed to process (Job " + response.getJobId() + ")");
            }
            return actionIdToForms.entrySet().stream().map(entry -> {
                try {
                    PrintableAttachment pdf = new PrintableAttachment();
                    URL targetUrl = new URL(this.findActionUrl((String)entry.getKey(), response.getActions()));
                    pdf.setData(IOUtils.toByteArray((URL)targetUrl));
                    pdf.setName(((SubAwardForms)entry.getValue()).getPdfFormFile().getFileName());
                    pdf.setType(((SubAwardForms)entry.getValue()).getPdfFormFile().getContentType());
                    return pdf;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        }
        catch (PrintingException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new PrintingException(e);
        }
    }

    private String findActionUrl(String actionId, List<? extends ActionDto<?>> actions) {
        return actions.stream().filter(a -> a.getActionId().equals(actionId)).map(a -> (SingleTargetAction)((Object)a)).map(a -> a.getTarget().getUrl()).findFirst().orElseThrow();
    }

    private String addActions(SubAwardForms form, SubAwardPrintAgreement agreement, JobDto job) {
        String finalActionId;
        if (form.getPdfFormFile() == null || form.getMappingFile() == null) {
            throw new PrintingException("Printing " + form + " requires a pdf form and mapping file");
        }
        MapActionDto mapAction = new MapActionDto().inputSources(Map.of("subAward", this.createSubawardLink(agreement), "topUnit", this.createTopUnit())).mappingSource(this.createMappingsLink(form.getMappingFile())).actionId("map" + form.getId());
        LinkDto fieldActionSource = new LinkDto().url("action://{$jobId}/map" + form.getId() + "/0");
        AcroFormPutActionDto acroFormPutAction = new AcroFormPutActionDto().fieldActions(Collections.emptyMap()).source(this.createPdfFormLink(form.getPdfFormFile())).fieldActionSource(fieldActionSource).actionId("acroFormPut" + form.getId());
        if (CollectionUtils.isNotEmpty(agreement.getAttachments())) {
            LinkDto attachmentPutSource = new LinkDto().url("action://{$jobId}/acroFormPut" + form.getId() + "/0");
            Map<String, AttachmentDto> attachments = agreement.getAttachments().stream().map(a -> org.kuali.coeus.sys.framework.util.CollectionUtils.entry(a.getFileName(), new AttachmentDto().embedded(true).fileDisplay(a.getFileName()).description(a.getDescription()).mimeType(a.getMimeType()).location(this.createFileLink((SubAwardPrintAgreementAttachment)((Object)a))))).collect(org.kuali.coeus.sys.framework.util.CollectionUtils.entriesToMap());
            AttachmentPutActionDto attachmentPutAction = new AttachmentPutActionDto().source(attachmentPutSource).attachments(attachments).actionId("attachmentPut" + form.getId());
            finalActionId = attachmentPutAction.getActionId();
            job.addActionsItem(mapAction).addActionsItem(acroFormPutAction).addActionsItem(attachmentPutAction);
        } else {
            finalActionId = acroFormPutAction.getActionId();
            job.addActionsItem(mapAction).addActionsItem(acroFormPutAction);
        }
        return finalActionId;
    }

    private LinkDto createTopUnit() {
        return new LinkDto().url(this.configurationService.getPropertyValueAsString(APPLICATION_URL) + "/research-common/api/v1/units/top-unit").method(HttpMethod.GET.name()).addHeader("Authorization", this.getAuthToken()).addHeader("Content-Type", "application/json");
    }

    private LinkDto createSubawardLink(SubAwardPrintAgreement agreement) {
        return new LinkDto().url(this.configurationService.getPropertyValueAsString(APPLICATION_URL) + "/subaward/api/v1/subaward-documents/" + agreement.getDocumentNumber() + "?includeFundingSourceDetails=true&subAwardFundingSourceId=" + agreement.getFundingSource() + "&calculateAmountInfo=true").method(HttpMethod.GET.name()).addHeader("Authorization", this.getAuthToken()).addHeader("Content-Type", "application/json");
    }

    private LinkDto createFileLink(SubAwardPrintAgreementAttachment a) {
        return new LinkDto().url(this.configurationService.getPropertyValueAsString(APPLICATION_URL) + "/research-common/api/v1/file-data/" + a.getFileDataId()).method(HttpMethod.GET.name()).addHeader("Authorization", this.getAuthToken());
    }

    private String getAuthToken() {
        return "Bearer " + this.getJwtService().createToken();
    }

    private LinkDto createPdfFormLink(AttachmentFile pdf) {
        return new LinkDto().url(this.configurationService.getPropertyValueAsString(APPLICATION_URL) + "/research-common/api/v1/file-data/" + pdf.getFileDataId()).method(HttpMethod.GET.name()).addHeader("Authorization", this.getAuthToken());
    }

    private LinkDto createMappingsLink(AttachmentFile mapping) {
        return new LinkDto().url(this.configurationService.getPropertyValueAsString(APPLICATION_URL) + "/research-common/api/v1/file-data/" + mapping.getFileDataId()).method(HttpMethod.GET.name()).addHeader("Authorization", this.getAuthToken());
    }

    public SubAwardFormsService getSubAwardFormsService() {
        return this.subAwardFormsService;
    }

    public void setSubAwardFormsService(SubAwardFormsService subAwardFormsService) {
        this.subAwardFormsService = subAwardFormsService;
    }

    public PdfService getPdfService() {
        return this.pdfService;
    }

    public void setPdfService(PdfService pdfService) {
        this.pdfService = pdfService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public JwtService getJwtService() {
        return this.jwtService;
    }

    public void setJwtService(JwtService jwtService) {
        this.jwtService = jwtService;
    }
}

