/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.subawardrule;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.pdf.dto.MappingDefinitionDto;
import org.kuali.coeus.common.framework.attachment.AttachmentFile;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.PdfBoxUtils;
import org.kuali.kra.subaward.bo.SubAwardForms;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;

public class SubAwardFormsMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    private static final Set<String> MAPPING_MIME_TYPES = Set.of("application/json");
    private static final Set<String> PDF_FORM_MIME_TYPES = Set.of("application/pdf");
    private static final String MAPPING_FILE_FIELD_NAME = "mappingFile.formFile";
    private static final String PDF_FORM_FILE_FIELD_NAME = "pdfFormFile.formFile";
    private static final String ERROR_DELETION_SUBAWARD_FORM_DEFAULT = "error.deletion.subaward.form.default";
    private static final String FORM_ID = "formId";
    private static final String ERROR_SUBAWARD_FORM_PDF_FORM_MAPPING_BOTH = "error.subaward.form.pdf.form.mapping.both";
    private static final String ERROR_SUBAWARD_FORM_MISSING_PDF_FORM = "error.subaward.form.missing.pdf.form";
    private static final String ERROR_SUBAWARD_FORM_MISSING_MAPPING_FILE = "error.subaward.form.missing.mapping.file";
    private static final String PDF_FORM = "PDF form";
    private static final String MAPPING_FILE = "mapping file";
    public static final String ERROR_SUBAWARD_FORM_INVALID_MAPPING_FILE = "error.subaward.form.invalid.mapping.file";
    public static final String ERROR_SUBAWARD_FORM_INVALID_PDF_FORM = "error.subaward.form.invalid.pdf.form";
    private transient ObjectMapper objectMapper;

    @Override
    protected boolean processGlobalRouteDocumentBusinessRules(MaintenanceDocument document) {
        return super.processGlobalRouteDocumentBusinessRules(document) && this.canDelete(document);
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    private boolean canDelete(MaintenanceDocument document) {
        Maintainable newMaintainable = document.getNewMaintainableObject();
        if (newMaintainable.getMaintenanceAction().equals("Delete") && ((SubAwardForms)newMaintainable.getBusinessObject()).isSystemDefault()) {
            this.getGlobalVariableService().getMessageMap().putError("GLOBAL_ERRORS", ERROR_DELETION_SUBAWARD_FORM_DEFAULT, new String[0]);
            return false;
        }
        return true;
    }

    public boolean isDocumentValidForSave(MaintenanceDocument document) {
        boolean result = super.isDocumentValidForSave(document);
        SubAwardForms subAwardForms = (SubAwardForms)document.getNewMaintainableObject().getDataObject();
        result &= this.validateMapping(subAwardForms);
        result &= this.validatePdfForm(subAwardForms);
        result &= this.validateMappingAndPdfForm(subAwardForms);
        result &= this.validateUniqueDescription(document);
        return result &= this.validateFormId(document);
    }

    private boolean validateMapping(SubAwardForms subAwardForms) {
        block7: {
            String contentType;
            AttachmentFile mappingFile = subAwardForms.getMappingFile();
            String string = StringUtils.isNotBlank((CharSequence)mappingFile.getContentType()) ? mappingFile.getContentType() : (contentType = mappingFile.getFormFile() != null ? mappingFile.getFormFile().getContentType() : null);
            if (contentType != null && !MAPPING_MIME_TYPES.contains(contentType)) {
                this.putFieldError(MAPPING_FILE_FIELD_NAME, "error.subaward.invalid.file.type", MAPPING_MIME_TYPES.toString());
                return false;
            }
            try {
                byte[] content;
                Object object = mappingFile.getData() != null ? mappingFile.getData() : (content = (Object)(mappingFile.getFormFile() != null ? mappingFile.getFormFile().getFileData() : null));
                if (content == null) break block7;
                try {
                    List mappings = (List)this.getObjectMapper().readValue(content, (TypeReference)new TypeReference<List<MappingDefinitionDto>>(){});
                    if (CollectionUtils.isEmpty((Collection)mappings) || mappings.stream().anyMatch(m -> StringUtils.isBlank((CharSequence)m.getKey()) || StringUtils.isBlank((CharSequence)m.getAction()) || StringUtils.isBlank((CharSequence)m.getExpression()))) {
                        this.putFieldError(MAPPING_FILE_FIELD_NAME, ERROR_SUBAWARD_FORM_INVALID_MAPPING_FILE);
                    }
                }
                catch (IOException | ClassCastException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(e.getMessage(), (Throwable)e);
                    }
                    this.putFieldError(MAPPING_FILE_FIELD_NAME, ERROR_SUBAWARD_FORM_INVALID_MAPPING_FILE);
                    return false;
                }
                return true;
            }
            catch (IOException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    private boolean validatePdfForm(SubAwardForms subAwardForms) {
        String contentType;
        AttachmentFile pdfFormFile = subAwardForms.getPdfFormFile();
        String string = StringUtils.isNotBlank((CharSequence)pdfFormFile.getContentType()) ? pdfFormFile.getContentType() : (contentType = pdfFormFile.getFormFile() != null ? pdfFormFile.getFormFile().getContentType() : null);
        if (contentType != null && !PDF_FORM_MIME_TYPES.contains(contentType)) {
            this.putFieldError(PDF_FORM_FILE_FIELD_NAME, "error.subaward.invalid.file.type", PDF_FORM_MIME_TYPES.toString());
            return false;
        }
        try {
            byte[] content;
            Object object = pdfFormFile.getData() != null ? pdfFormFile.getData() : (content = (Object)(pdfFormFile.getFormFile() != null ? pdfFormFile.getFormFile().getFileData() : null));
            if (content != null && !PdfBoxUtils.isValidAcroPdf(content)) {
                this.putFieldError(PDF_FORM_FILE_FIELD_NAME, ERROR_SUBAWARD_FORM_INVALID_PDF_FORM);
                return false;
            }
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private boolean validateMappingAndPdfForm(SubAwardForms subAwardForms) {
        boolean mappingFilePresent;
        AttachmentFile pdfFormFile = subAwardForms.getPdfFormFile();
        AttachmentFile mappingFile = subAwardForms.getMappingFile();
        boolean pdfFormFilePresent = StringUtils.isNotBlank((CharSequence)pdfFormFile.getFileName()) || pdfFormFile.getFormFile() != null && StringUtils.isNotBlank((CharSequence)pdfFormFile.getFormFile().getFileName());
        boolean bl = mappingFilePresent = StringUtils.isNotBlank((CharSequence)mappingFile.getFileName()) || mappingFile.getFormFile() != null && StringUtils.isNotBlank((CharSequence)mappingFile.getFormFile().getFileName());
        if (!pdfFormFilePresent && !mappingFilePresent && Integer.valueOf(4).equals(subAwardForms.getTemplateTypeCode())) {
            this.putFieldError(PDF_FORM_FILE_FIELD_NAME, ERROR_SUBAWARD_FORM_PDF_FORM_MAPPING_BOTH, PDF_FORM, MAPPING_FILE, subAwardForms.getSubAwardTemplateType().getDescription());
            return false;
        }
        if (pdfFormFilePresent && !mappingFilePresent) {
            this.putFieldError(MAPPING_FILE_FIELD_NAME, ERROR_SUBAWARD_FORM_MISSING_MAPPING_FILE);
            return false;
        }
        if (!pdfFormFilePresent && mappingFilePresent) {
            this.putFieldError(PDF_FORM_FILE_FIELD_NAME, ERROR_SUBAWARD_FORM_MISSING_PDF_FORM);
            return false;
        }
        return true;
    }

    private boolean validateUniqueDescription(MaintenanceDocument document) {
        Maintainable newMaintainable = document.getNewMaintainableObject();
        if (!newMaintainable.getMaintenanceAction().equals("Delete")) {
            SubAwardForms newSubAwardForms = (SubAwardForms)document.getNewMaintainableObject().getDataObject();
            List forms = this.getBoService().findMatching(SubAwardForms.class, Map.of("description", newSubAwardForms.getDescription()));
            if (forms.stream().anyMatch(f -> !f.getId().equals(newSubAwardForms.getId()))) {
                this.putFieldError("description", "error.subaward.form.unique.description");
                return false;
            }
        }
        return true;
    }

    private boolean validateFormId(MaintenanceDocument document) {
        SubAwardForms newSubAwardForms;
        Maintainable newMaintainable = document.getNewMaintainableObject();
        if (!newMaintainable.getMaintenanceAction().equals("Delete") && !SubAwardForms.VALID_FORM_ID.contains((newSubAwardForms = (SubAwardForms)document.getNewMaintainableObject().getDataObject()).getFormId())) {
            this.putFieldError(FORM_ID, "error.subaward.form.id.invalid", SubAwardForms.VALID_FORM_ID.toString());
            return false;
        }
        return true;
    }

    public ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = (ObjectMapper)KcServiceLocator.getService("pdfObjectMapper");
        }
        return this.objectMapper;
    }
}

