/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.web.krad.homepage;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.web.krad.homepage.HomePageMenuItem;
import org.kuali.kra.web.krad.homepage.HomePageMenuItemService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="homePageMenuItemService")
public class HomePageMenuItemServiceImpl
implements HomePageMenuItemService {
    protected static final String APP_URL_TOKEN = "<<APPLICATION_URL>>";
    private static final String CREATE_IP_LINK_NAME = "Create Institute Proposal";
    private static final String CREATE_IP_LINK_URL = "/kc-krad/landingPage?methodToCall=start&href=<<APPLICATION_URL>>%2FinstitutionalProposalHome.do%3FmethodToCall%3DdocHandler%26command%3Dinitiate%26docTypeName%3DInstitutionalProposalDocument&viewId=Kc-Header-IframeView";
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="kcEntityManager")
    private EntityManager entityManager;

    @Override
    public List<HomePageItemSuggestion> getActiveMenuItems() {
        QueryResults menuItems = this.getDataObjectService().findMatching(HomePageMenuItem.class, QueryByCriteria.Builder.andAttributes(Collections.singletonMap("active", "Y")).build());
        return this.toSuggestions(menuItems.getResults());
    }

    @Override
    public List<HomePageItemSuggestion> getAllMenuItems() {
        QueryResults menuItems = this.getDataObjectService().findAll(HomePageMenuItem.class);
        return this.toSuggestions(menuItems.getResults());
    }

    protected List<HomePageItemSuggestion> toSuggestions(List<HomePageMenuItem> menuItems) {
        String appUrl = this.configurationService.getPropertyValueAsString("application.url");
        boolean createIpEnabled = this.getParameterService().getParameterValueAsBoolean("KC-IP", "All", "Enable_Direct_IP_Creation", Boolean.FALSE);
        return menuItems.stream().map(menuItem -> this.upgradeLinks((HomePageMenuItem)menuItem, createIpEnabled)).map(menuItem -> new HomePageItemSuggestion((HomePageMenuItem)menuItem, appUrl)).collect(Collectors.toList());
    }

    private HomePageMenuItem upgradeLinks(HomePageMenuItem homePageMenuItem, boolean createIpEnabled) {
        if (createIpEnabled && StringUtils.equals((String)homePageMenuItem.getMenuItem(), (String)CREATE_IP_LINK_NAME)) {
            homePageMenuItem.setMenuAction(CREATE_IP_LINK_URL);
            this.getEntityManager().detach((Object)homePageMenuItem);
        }
        return homePageMenuItem;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public class HomePageItemSuggestion {
        private String label;
        private String value;
        private String href;

        public HomePageItemSuggestion(HomePageMenuItem item, String appUrl) {
            String href;
            this.setLabel(item.getMenuItemFormatted());
            this.setValue(item.getMenuItem());
            try {
                href = appUrl + item.getMenuAction().replace(HomePageMenuItemServiceImpl.APP_URL_TOKEN, URLEncoder.encode(appUrl, StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            this.setHref(href);
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getHref() {
            return this.href;
        }

        public void setHref(String href) {
            this.href = href;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HomePageItemSuggestion that = (HomePageItemSuggestion)o;
            if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
                return false;
            }
            if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
                return false;
            }
            return this.href != null ? this.href.equals(that.href) : that.href == null;
        }

        public int hashCode() {
            int result = this.label != null ? this.label.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            result = 31 * result + (this.href != null ? this.href.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "HomePageItemSuggestion{label='" + this.label + "', value='" + this.value + "', href='" + this.href + "'}";
        }
    }
}

