/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.math.BigInteger;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.script.Converter;
import org.elasticsearch.script.Converters;
import org.elasticsearch.script.FieldValues;
import org.elasticsearch.script.JodaCompatibleZonedDateTime;

public abstract class Field<T> {
    public static final Converter<BigInteger, BigIntegerField> BigInteger = Converters.BIGINTEGER;
    public static final Converter<Long, LongField> Long = Converters.LONG;
    protected final String name;
    protected final FieldValues<T> values;

    public Field(String name, FieldValues<T> values) {
        this.name = name;
        this.values = values;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public List<T> getValues() {
        return this.values.getValues();
    }

    public final <CT, CF extends Field<CT>> Field<CT> as(Converter<CT, CF> converter) {
        if (converter.getFieldClass().isInstance(this)) {
            return (Field)converter.getFieldClass().cast(this);
        }
        return this.convert(converter);
    }

    protected <CT, CF extends Field<CT>> Field<CT> convert(Converter<CT, CF> converter) {
        return converter.convert(this);
    }

    public FieldValues<T> getFieldValues() {
        return this.values;
    }

    public T getValue(T defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        try {
            return this.values.getNonPrimitiveValue();
        }
        catch (RuntimeException err) {
            return defaultValue;
        }
    }

    public double getDouble(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        try {
            return this.values.getDoubleValue();
        }
        catch (RuntimeException err) {
            return defaultValue;
        }
    }

    public long getLong(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        try {
            return this.values.getLongValue();
        }
        catch (RuntimeException err) {
            return defaultValue;
        }
    }

    public static class IpField
    extends Field<String> {
        public IpField(String name, FieldValues<String> values) {
            super(name, values);
        }
    }

    public static class VersionField
    extends Field<String> {
        public VersionField(String name, FieldValues<String> values) {
            super(name, values);
        }
    }

    public static class BigIntegerField
    extends Field<BigInteger> {
        public BigIntegerField(String name, FieldValues<BigInteger> values) {
            super(name, values);
        }
    }

    public static class BytesRefField
    extends Field<BytesRef> {
        public BytesRefField(String name, FieldValues<BytesRef> values) {
            super(name, values);
        }
    }

    public static class StringField
    extends Field<String> {
        public StringField(String name, FieldValues<String> values) {
            super(name, values);
        }
    }

    public static class GeoPointField
    extends Field<GeoPoint> {
        public GeoPointField(String name, FieldValues<GeoPoint> values) {
            super(name, values);
        }
    }

    public static class DateMillisField
    extends Field<JodaCompatibleZonedDateTime> {
        public DateMillisField(String name, FieldValues<JodaCompatibleZonedDateTime> values) {
            super(name, values);
        }
    }

    public static class DateNanosField
    extends Field<JodaCompatibleZonedDateTime> {
        public DateNanosField(String name, FieldValues<JodaCompatibleZonedDateTime> values) {
            super(name, values);
        }
    }

    public static class LongField
    extends Field<Long> {
        public LongField(String name, FieldValues<Long> values) {
            super(name, values);
        }
    }

    public static class DoubleField
    extends Field<Double> {
        public DoubleField(String name, FieldValues<Double> values) {
            super(name, values);
        }
    }

    public static class BooleanField
    extends Field<Boolean> {
        public BooleanField(String name, FieldValues<Boolean> values) {
            super(name, values);
        }
    }
}

