/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.impl.security;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.ArrayTypePermission;
import com.thoughtworks.xstream.security.CGLIBProxyTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import com.thoughtworks.xstream.security.ProxyTypePermission;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.framework.security.XStreamSecurityService;

public class XStreamSecurityServiceImpl
implements XStreamSecurityService {
    public static final String XSTREAM_PACKAGE_ALLOWLIST = "xstream.package.allowlist";
    private ConfigurationService configurationService;

    public XStream applySecurityRules(XStream xstream) {
        xstream.addPermission(NullPermission.NULL);
        xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        xstream.addPermission(ArrayTypePermission.ARRAYS);
        xstream.addPermission(CGLIBProxyTypePermission.PROXIES);
        xstream.addPermission(ProxyTypePermission.PROXIES);
        xstream.allowTypeHierarchy(Collection.class);
        xstream.allowTypesByWildcard(this.allowTypesByWildCard());
        return xstream;
    }

    protected String[] allowTypesByWildCard() {
        return (String[])Arrays.stream(this.configurationService.getPropertyValueAsString(XSTREAM_PACKAGE_ALLOWLIST).split(",")).map(String::trim).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).toArray(String[]::new);
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

