/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.resourceloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.framework.resourceloader.BaseResourceLoader;
import org.kuali.rice.core.framework.resourceloader.SimpleServiceLocator;
import org.kuali.rice.core.framework.resourceloader.SpringResourceLoader;

public class RiceResourceLoaderFactory {
    private static final String RICE_ROOT_RESOURCE_LOADER_NAME = "RICE_ROOT_RESOURCE_LOADER";
    private static final String RICE_SPRING_RESOURCE_LOADER_NAME = "RICE_SPRING_RESOURCE_LOADER_NAME";

    public static ResourceLoader createRootRiceResourceLoader(ServletContext context, List<String> springFileLocations, String prefix) {
        if ("KSB".equals(prefix.toUpperCase())) {
            prefix = "K~S~B";
        }
        String applicationId = CoreConfigHelper.getApplicationId();
        QName root = new QName(applicationId, prefix.toUpperCase() + "_RICE_ROOT_RESOURCE_LOADER");
        if (RiceResourceLoaderFactory.getRootResourceLoaderNames() == null || !RiceResourceLoaderFactory.getRootResourceLoaderNames().contains(root)) {
            RiceResourceLoaderFactory.addRootResourceLoaderName(root);
        }
        QName spring = new QName(applicationId, prefix.toUpperCase() + "_RICE_SPRING_RESOURCE_LOADER_NAME");
        if (RiceResourceLoaderFactory.getSpringResourceLoaderNames() == null || !RiceResourceLoaderFactory.getSpringResourceLoaderNames().contains(root)) {
            RiceResourceLoaderFactory.addSpringResourceLoaderName(spring);
        }
        BaseResourceLoader rootResourceLoader = new BaseResourceLoader(root, new SimpleServiceLocator());
        SpringResourceLoader springResourceLoader = new SpringResourceLoader(spring, springFileLocations, context);
        rootResourceLoader.addResourceLoaderFirst(springResourceLoader);
        return rootResourceLoader;
    }

    public static Collection<BaseResourceLoader> getRootResourceLoaders() {
        Collection<QName> names = RiceResourceLoaderFactory.getRootResourceLoaderNames();
        ArrayList<BaseResourceLoader> loaders = new ArrayList<BaseResourceLoader>();
        for (QName name : names) {
            loaders.add((BaseResourceLoader)GlobalResourceLoader.getResourceLoader((QName)name));
        }
        return loaders;
    }

    public static Collection<SpringResourceLoader> getSpringResourceLoaders() {
        Collection<QName> names = RiceResourceLoaderFactory.getSpringResourceLoaderNames();
        ArrayList<SpringResourceLoader> loaders = new ArrayList<SpringResourceLoader>();
        for (QName name : names) {
            loaders.add((SpringResourceLoader)GlobalResourceLoader.getResourceLoader((QName)name));
        }
        return loaders;
    }

    private static Collection<QName> getRootResourceLoaderNames() {
        return (Collection)ConfigContext.getCurrentContextConfig().getObject(RICE_ROOT_RESOURCE_LOADER_NAME);
    }

    private static void addRootResourceLoaderName(QName name) {
        ArrayList<QName> names = (ArrayList<QName>)ConfigContext.getCurrentContextConfig().getObject(RICE_ROOT_RESOURCE_LOADER_NAME);
        if (names == null) {
            names = new ArrayList<QName>();
        }
        names.add(name);
        ConfigContext.getCurrentContextConfig().putObject(RICE_ROOT_RESOURCE_LOADER_NAME, names);
    }

    private static Collection<QName> getSpringResourceLoaderNames() {
        return (Collection)ConfigContext.getCurrentContextConfig().getObject(RICE_SPRING_RESOURCE_LOADER_NAME);
    }

    private static void addSpringResourceLoaderName(QName name) {
        ArrayList<QName> names = (ArrayList<QName>)ConfigContext.getCurrentContextConfig().getObject(RICE_SPRING_RESOURCE_LOADER_NAME);
        if (names == null) {
            names = new ArrayList<QName>();
        }
        names.add(name);
        ConfigContext.getCurrentContextConfig().putObject(RICE_SPRING_RESOURCE_LOADER_NAME, names);
    }
}

