/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype.bo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.exception.RiceRemoteServiceConnectionException;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.actionlist.CustomActionListAttribute;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeAttribute;
import org.kuali.rice.kew.api.doctype.DocumentTypeAttributeContract;
import org.kuali.rice.kew.api.doctype.DocumentTypeContract;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.api.extension.ExtensionDefinitionContract;
import org.kuali.rice.kew.api.extension.ExtensionUtils;
import org.kuali.rice.kew.api.util.CodeTranslator;
import org.kuali.rice.kew.doctype.ApplicationDocumentStatus;
import org.kuali.rice.kew.doctype.ApplicationDocumentStatusCategory;
import org.kuali.rice.kew.doctype.DocumentTypeAttributeBo;
import org.kuali.rice.kew.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.doctype.DocumentTypeSecurity;
import org.kuali.rice.kew.doctype.bo.DocumentTypeEBO;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.engine.node.ProcessDefinitionBo;
import org.kuali.rice.kew.framework.document.attribute.SearchableAttribute;
import org.kuali.rice.kew.framework.postprocessor.PostProcessor;
import org.kuali.rice.kew.mail.CustomEmailAttribute;
import org.kuali.rice.kew.notes.CustomNoteAttribute;
import org.kuali.rice.kew.postprocessor.DefaultPostProcessor;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.Utilities;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.data.DataObjectWrapper;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.Boolean01Converter;
import org.kuali.rice.krad.util.KRADUtils;

@Entity
@Table(name="KREW_DOC_TYP_T")
@NamedQueries(value={@NamedQuery(name="DocumentType.GetAppIdByDocumentId", query="SELECT DT.actualApplicationId FROM DocumentType DT, DocumentRouteHeaderValue DH WHERE DH.documentTypeId=DT.documentTypeId AND DH.documentId = :documentId"), @NamedQuery(name="DocumentType.GetIdByName", query="SELECT d.documentTypeId FROM DocumentType d WHERE d.name = :docTypeName AND d.currentInd = true"), @NamedQuery(name="DocumentType.FindDocumentTypeNameById", query="SELECT d.name FROM DocumentType d WHERE d.documentTypeId = :documentTypeId AND d.currentInd = true"), @NamedQuery(name="DocumentType.GetMaxVersionNumber", query="SELECT MAX(d.version) FROM DocumentType d WHERE d.name = :docTypeName"), @NamedQuery(name="DocumentType.GetChildDocumentTypeIds", query="SELECT d.documentTypeId FROM DocumentType d WHERE d.currentInd = true AND d.docTypeParentId = :parentDocumentTypeId"), @NamedQuery(name="DocumentType.GetDocumentTypeByDocumentId", query="SELECT DT FROM DocumentType DT, DocumentRouteHeaderValue DH WHERE DH.documentTypeId=DT.documentTypeId AND DH.documentId = :documentId"), @NamedQuery(name="DocumentType.GetDocumentTypeByName", query="SELECT d FROM DocumentType d WHERE d.currentInd = true AND d.name = :name"), @NamedQuery(name="DocumentType.QuickLinks.FindInitiatedDocumentTypesListByInitiatorWorkflowId", query="SELECT DISTINCT dt.name, dt.label FROM DocumentType dt, DocumentRouteHeaderValue drhv WHERE drhv.initiatorWorkflowId = :initiatorWorkflowId AND drhv.documentTypeId = dt.documentTypeId AND dt.active = true AND dt.currentInd = true ORDER BY UPPER(dt.label)")})
public class DocumentType
extends PersistableBusinessObjectBase
implements MutableInactivatable,
DocumentTypeEBO,
DocumentTypeContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    private static final Logger LOG = LogManager.getLogger(DocumentType.class);
    private static final long serialVersionUID = 1312830153583125069L;
    @Id
    @GeneratedValue(generator="KREW_DOC_HDR_S")
    @PortableSequenceGenerator(name="KREW_DOC_HDR_S")
    @Column(name="DOC_TYP_ID", nullable=false)
    private String documentTypeId;
    @Column(name="PARNT_ID")
    private String docTypeParentId;
    @Column(name="DOC_TYP_NM")
    private String name;
    @Column(name="DOC_TYP_VER_NBR")
    private Integer version = 0;
    @Column(name="ACTV_IND")
    @Convert(converter=Boolean01Converter.class)
    private Boolean active;
    @Column(name="CUR_IND")
    @Convert(converter=Boolean01Converter.class)
    private Boolean currentInd;
    @Column(name="DOC_TYP_DESC")
    private String description;
    @Column(name="LBL", nullable=false)
    private String label = null;
    @Column(name="PREV_DOC_TYP_VER_NBR")
    private String previousVersionId;
    @Column(name="DOC_HDR_ID")
    private String documentId;
    @Column(name="HELP_DEF_URL")
    private String unresolvedHelpDefinitionUrl;
    @Column(name="DOC_SEARCH_HELP_URL")
    private String unresolvedDocSearchHelpUrl;
    @Column(name="DOC_HDLR_URL")
    private String unresolvedDocHandlerUrl;
    @Column(name="POST_PRCSR")
    private String postProcessorName;
    @Column(name="GRP_ID")
    private String workgroupId;
    @Column(name="BLNKT_APPR_GRP_ID")
    private String blanketApproveWorkgroupId;
    @Column(name="BLNKT_APPR_PLCY")
    private String blanketApprovePolicy;
    @Column(name="RPT_GRP_ID")
    private String reportingWorkgroupId;
    @Column(name="APPL_ID")
    private String actualApplicationId;
    @Column(name="AUTHORIZER")
    private String authorizer;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="documentType")
    private Collection<DocumentTypePolicy> documentTypePolicies;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="DOC_TYP_ID")
    private List<ApplicationDocumentStatus> validApplicationStatuses;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="DOC_TYP_ID")
    private List<ApplicationDocumentStatusCategory> applicationStatusCategories;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="documentType")
    @OrderBy(value="orderIndex ASC")
    private List<DocumentTypeAttributeBo> documentTypeAttributes;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="documentType")
    private List<ProcessDefinitionBo> processes = new ArrayList<ProcessDefinitionBo>();
    @Column(name="RTE_VER_NBR")
    private String routingVersion = "2";
    @Column(name="NOTIFY_ADDR")
    private String actualNotificationFromAddress;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="SEC_XML")
    private String documentTypeSecurityXml;
    @Column(name="EMAIL_XSL")
    private String customEmailStylesheet;
    @Transient
    private String returnUrl;
    @Transient
    private String actionsUrl;
    @Transient
    private Boolean applyRetroactively = Boolean.FALSE;
    @Transient
    private Group defaultExceptionWorkgroup;
    @Transient
    private Collection<DocumentType> childrenDocTypes;
    @Transient
    private DocumentTypeSecurity documentTypeSecurity;

    public DocumentType() {
        this.documentTypeAttributes = new ArrayList<DocumentTypeAttributeBo>();
        this.documentTypePolicies = new ArrayList<DocumentTypePolicy>();
    }

    public void populateDataDictionaryEditableFields(Set<String> propertyNamesEditableViaUI, DocumentType dataDictionaryEditedType) {
        DataObjectWrapper wrapper = KradDataServiceLocator.getDataObjectService().wrap((Object)dataDictionaryEditedType);
        String currentPropertyName = "";
        try {
            Iterator<String> iterator = propertyNamesEditableViaUI.iterator();
            while (iterator.hasNext()) {
                String propertyName;
                currentPropertyName = propertyName = iterator.next();
                if ("parentDocType.name".equals(propertyName)) {
                    String parentDocumentTypeName = (String)wrapper.getPropertyValueNullSafe(propertyName);
                    if (!StringUtils.isNotBlank((String)parentDocumentTypeName)) continue;
                    DocumentType parentDocType = KEWServiceLocator.getDocumentTypeService().findByName(parentDocumentTypeName);
                    if (parentDocType == null) {
                        throw new WorkflowRuntimeException("Could not find valid document type for document type name '" + parentDocumentTypeName + "' to set as Parent Document Type");
                    }
                    this.setDocTypeParentId(parentDocType.getDocumentTypeId());
                    continue;
                }
                LOG.info("*** COPYING PROPERTY NAME FROM OLD BO TO NEW BO: " + propertyName);
                KRADUtils.setObjectProperty((Object)this, (String)propertyName, (Object)wrapper.getPropertyValueNullSafe(propertyName));
            }
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException("Error setting property '" + currentPropertyName + "' in Document Type", (Throwable)e);
        }
    }

    public DocumentTypePolicy getAllowUnrequestedActionPolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.ALLOW_UNREQUESTED_ACTION.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getDefaultApprovePolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DEFAULT_APPROVE.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getUseWorkflowSuperUserDocHandlerUrl() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.USE_KEW_SUPERUSER_DOCHANDLER.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getInitiatorMustRoutePolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.INITIATOR_MUST_ROUTE.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getInitiatorMustSavePolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.INITIATOR_MUST_SAVE.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getInitiatorMustCancelPolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.INITIATOR_MUST_CANCEL.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getInitiatorMustBlanketApprovePolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.INITIATOR_MUST_BLANKET_APPROVE.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getLookIntoFuturePolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.LOOK_FUTURE.getCode(), Boolean.FALSE);
    }

    public DocumentTypePolicy getSuperUserApproveNotificationPolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.SEND_NOTIFICATION_ON_SU_APPROVE.getCode(), Boolean.FALSE);
    }

    public DocumentTypePolicy getSupportsQuickInitiatePolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.SUPPORTS_QUICK_INITIATE.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getNotifyOnSavePolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.NOTIFY_ON_SAVE.getCode(), Boolean.FALSE);
    }

    public DocumentTypePolicy getDocumentStatusPolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DOCUMENT_STATUS_POLICY.getCode(), "KEW");
    }

    public DocumentTypePolicy getSuPostprocessorOverridePolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.ALLOW_SU_POSTPROCESSOR_OVERRIDE.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getFailOnInactiveGroup() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.FAIL_ON_INACTIVE_GROUP.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getEnrouteErrorSuppression() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.ENROUTE_ERROR_SUPPRESSION.getCode(), Boolean.FALSE);
    }

    public DocumentTypePolicy getRegenerateActionRequestsOnChange() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.REGENERATE_ACTION_REQUESTS_ON_CHANGE.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getRecallNotification() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.RECALL_NOTIFICATION.getCode(), (String)null);
    }

    public DocumentTypePolicy getSuppressImmediateEmailsOnSuActionPolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.SUPPRESS_IMMEDIATE_EMAILS_ON_SU_ACTION.getCode(), Boolean.FALSE);
    }

    public DocumentTypePolicy getAllowSuperUserFinalApprovalPolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.ALLOW_SU_FINAL_APPROVAL.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getDocSearchTarget() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DOC_SEARCH_TARGET.getCode(), (String)null);
    }

    public Boolean isKEWStatusInUse() {
        if (this.isPolicyDefined(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DOCUMENT_STATUS_POLICY)) {
            String policyValue = this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DOCUMENT_STATUS_POLICY.getCode(), "KEW").getPolicyStringValue();
            return policyValue == null || "".equals(policyValue) || "KEW".equalsIgnoreCase(policyValue) || "BOTH".equalsIgnoreCase(policyValue) ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean isAppDocStatusInUse() {
        if (this.isPolicyDefined(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DOCUMENT_STATUS_POLICY)) {
            String policyValue = this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DOCUMENT_STATUS_POLICY.getCode(), "KEW").getPolicyStringValue();
            return "APP".equalsIgnoreCase(policyValue) || "BOTH".equalsIgnoreCase(policyValue) ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Boolean areBothStatusesInUse() {
        if (this.isPolicyDefined(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DOCUMENT_STATUS_POLICY)) {
            String policyValue = this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DOCUMENT_STATUS_POLICY.getCode(), "KEW").getPolicyStringValue();
            return "BOTH".equalsIgnoreCase(policyValue) ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public String getUseWorkflowSuperUserDocHandlerUrlValue() {
        if (this.getUseWorkflowSuperUserDocHandlerUrl() != null) {
            return this.getUseWorkflowSuperUserDocHandlerUrl().getPolicyDisplayValue();
        }
        return null;
    }

    public String getAllowUnrequestedActionPolicyDisplayValue() {
        if (this.getAllowUnrequestedActionPolicy() != null) {
            return this.getAllowUnrequestedActionPolicy().getPolicyDisplayValue();
        }
        return null;
    }

    public String getDefaultApprovePolicyDisplayValue() {
        if (this.getDefaultApprovePolicy() != null) {
            return this.getDefaultApprovePolicy().getPolicyDisplayValue();
        }
        return null;
    }

    public String getInitiatorMustRouteDisplayValue() {
        if (this.getInitiatorMustRoutePolicy() != null) {
            return this.getInitiatorMustRoutePolicy().getPolicyDisplayValue();
        }
        return null;
    }

    public String getInitiatorMustSaveDisplayValue() {
        if (this.getInitiatorMustSavePolicy() != null) {
            return this.getInitiatorMustSavePolicy().getPolicyDisplayValue();
        }
        return null;
    }

    public boolean isPolicyDefined(org.kuali.rice.kew.api.doctype.DocumentTypePolicy policyToCheck) {
        for (DocumentTypePolicy policy : this.getDocumentTypePolicies()) {
            if (!policyToCheck.getCode().equals(policy.getPolicyName())) continue;
            return true;
        }
        return this.getParentDocType() != null && this.getParentDocType().isPolicyDefined(policyToCheck);
    }

    public List<DocumentTypeAttributeBo> getDocumentTypeAttributes(String ... attributeTypes) {
        ArrayList<DocumentTypeAttributeBo> filteredAttributes = new ArrayList<DocumentTypeAttributeBo>();
        if (CollectionUtils.isNotEmpty((Collection)this._persistence_get_documentTypeAttributes())) {
            if (attributeTypes == null) {
                filteredAttributes.addAll(this._persistence_get_documentTypeAttributes());
            } else {
                List<String> attributeTypeList = Arrays.asList(attributeTypes);
                for (DocumentTypeAttributeBo documentTypeAttribute : this._persistence_get_documentTypeAttributes()) {
                    RuleAttribute ruleAttribute = documentTypeAttribute.getRuleAttribute();
                    if (!attributeTypeList.contains(ruleAttribute.getType())) continue;
                    filteredAttributes.add(documentTypeAttribute);
                }
            }
        }
        if (filteredAttributes.isEmpty() && this.getParentDocType() != null) {
            return this.getParentDocType().getDocumentTypeAttributes(attributeTypes);
        }
        return Collections.unmodifiableList(filteredAttributes);
    }

    public boolean hasSearchableAttributes() {
        return !this.getSearchableAttributes().isEmpty();
    }

    public List<DocumentTypeAttributeBo> getSearchableAttributes() {
        return this.getDocumentTypeAttributes("SearchableAttribute", "SearchableXmlAttribute");
    }

    public DocumentTypeAttributeBo getCustomizerAttribute() {
        List<DocumentTypeAttributeBo> documentTypeAttributes = this.getDocumentTypeAttributes("DocumentSearchCustomizer");
        if (documentTypeAttributes.size() > 1) {
            throw new IllegalStateException("Encountered more than one DocumentSearchCustomizer attribute on this document type: " + this.getName());
        }
        if (documentTypeAttributes.isEmpty()) {
            return null;
        }
        return documentTypeAttributes.get(0);
    }

    public RuleAttribute getCustomActionListRuleAttribute() {
        List<DocumentTypeAttributeBo> documentTypeAttributes = this.getDocumentTypeAttributes("ActionListAttribute");
        if (documentTypeAttributes.size() > 1) {
            throw new IllegalStateException("Encountered more than one ActionListAttribute on this document type: " + this.getName());
        }
        if (documentTypeAttributes.isEmpty()) {
            return null;
        }
        return documentTypeAttributes.get(0).getRuleAttribute();
    }

    public List<ExtensionHolder<SearchableAttribute>> loadSearchableAttributes() {
        List<DocumentTypeAttributeBo> searchableAttributes = this.getSearchableAttributes();
        ArrayList<ExtensionHolder<SearchableAttribute>> loadedAttributes = new ArrayList<ExtensionHolder<SearchableAttribute>>();
        for (DocumentTypeAttributeBo documentTypeAttribute : searchableAttributes) {
            RuleAttribute ruleAttribute = documentTypeAttribute.getRuleAttribute();
            try {
                ExtensionDefinition extensionDefinition = KewApiServiceLocator.getExtensionRepositoryService().getExtensionById(ruleAttribute.getId());
                SearchableAttribute attributeService = (SearchableAttribute)ExtensionUtils.loadExtension((ExtensionDefinitionContract)extensionDefinition, (String)this.getApplicationId());
                loadedAttributes.add(new ExtensionHolder<SearchableAttribute>(extensionDefinition, attributeService));
            }
            catch (RiceRemoteServiceConnectionException e) {
                LOG.warn("Unable to connect to load searchable attribute for " + ruleAttribute, (Throwable)e);
            }
        }
        return loadedAttributes;
    }

    public DocumentTypeAttributeBo getDocumentTypeAttribute(int index) {
        while (this.getDocumentTypeAttributes().size() <= index) {
            DocumentTypeAttributeBo attribute = new DocumentTypeAttributeBo();
            this.getDocumentTypeAttributes().add(attribute);
        }
        return this.getDocumentTypeAttributes().get(index);
    }

    public void setDocumentTypeAttribute(int index, DocumentTypeAttributeBo documentTypeAttribute) {
        this._persistence_get_documentTypeAttributes().set(index, documentTypeAttribute);
    }

    public String getDocTypeActiveIndicatorDisplayValue() {
        if (this.getActive() == null) {
            return "Inactive";
        }
        return CodeTranslator.getActiveIndicatorLabel((Boolean)this.getActive());
    }

    public Collection<DocumentType> getChildrenDocTypes() {
        if (this.childrenDocTypes == null) {
            this.childrenDocTypes = KEWServiceLocator.getDocumentTypeService().getChildDocumentTypes(this.getDocumentTypeId());
        }
        return this.childrenDocTypes;
    }

    @Override
    public String getDocTypeParentId() {
        return this._persistence_get_docTypeParentId();
    }

    public void setDocTypeParentId(String docTypeParentId) {
        this._persistence_set_docTypeParentId(docTypeParentId);
    }

    public DocumentType getParentDocType() {
        return KEWServiceLocator.getDocumentTypeService().findById(this._persistence_get_docTypeParentId());
    }

    public Collection<DocumentTypePolicy> getDocumentTypePolicies() {
        return this._persistence_get_documentTypePolicies();
    }

    public void setDocumentTypePolicies(Collection<DocumentTypePolicy> policies) {
        this._persistence_set_documentTypePolicies(policies);
    }

    public Map<org.kuali.rice.kew.api.doctype.DocumentTypePolicy, String> getPolicies() {
        HashMap<org.kuali.rice.kew.api.doctype.DocumentTypePolicy, String> policies = new HashMap<org.kuali.rice.kew.api.doctype.DocumentTypePolicy, String>();
        if (this._persistence_get_documentTypePolicies() != null) {
            for (DocumentTypePolicy policy : this._persistence_get_documentTypePolicies()) {
                policies.put(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.fromCode((String)policy.getPolicyName()), policy.getActualPolicyValue());
            }
        }
        return policies;
    }

    public List<ApplicationDocumentStatus> getValidApplicationStatuses() {
        if ((this._persistence_get_validApplicationStatuses() == null || this._persistence_get_validApplicationStatuses().isEmpty()) && this.getParentDocType() != null && this.isAppDocStatusInUse().booleanValue()) {
            return this.getParentDocType().getValidApplicationStatuses();
        }
        return this._persistence_get_validApplicationStatuses();
    }

    public void setValidApplicationStatuses(List<ApplicationDocumentStatus> validApplicationStatuses) {
        this._persistence_set_validApplicationStatuses(validApplicationStatuses);
    }

    public List<ApplicationDocumentStatusCategory> getApplicationStatusCategories() {
        if ((this._persistence_get_validApplicationStatuses() == null || this._persistence_get_validApplicationStatuses().isEmpty()) && KRADUtils.isNotNull((Object)this.getParentDocType()) && this.isAppDocStatusInUse().booleanValue()) {
            return this.getParentDocType().getApplicationStatusCategories();
        }
        return this._persistence_get_applicationStatusCategories();
    }

    public void setApplicationStatusCategories(List<ApplicationDocumentStatusCategory> applicationStatusCategories) {
        this._persistence_set_applicationStatusCategories(applicationStatusCategories);
    }

    public String getDocumentTypeSecurityXml() {
        return this._persistence_get_documentTypeSecurityXml();
    }

    public void setDocumentTypeSecurityXml(String documentTypeSecurityXml) {
        this._persistence_set_documentTypeSecurityXml(documentTypeSecurityXml);
        this.documentTypeSecurity = StringUtils.isNotBlank((String)documentTypeSecurityXml) ? new DocumentTypeSecurity(this.getApplicationId(), documentTypeSecurityXml) : null;
    }

    public DocumentTypeSecurity getDocumentTypeSecurity() {
        if (this.documentTypeSecurity == null && this._persistence_get_documentTypeSecurityXml() != null && !StringUtils.isEmpty((String)this._persistence_get_documentTypeSecurityXml().trim())) {
            this.documentTypeSecurity = new DocumentTypeSecurity(this.getApplicationId(), this._persistence_get_documentTypeSecurityXml());
        }
        if (this.documentTypeSecurity == null && this.getParentDocType() != null) {
            return this.getParentDocType().getDocumentTypeSecurity();
        }
        return this.documentTypeSecurity;
    }

    public String getActionsUrl() {
        return this.actionsUrl;
    }

    public void setActionsUrl(String actions) {
        this.actionsUrl = actions;
    }

    public Boolean getActive() {
        return this._persistence_get_active();
    }

    public void setActive(Boolean activeInd) {
        this._persistence_set_active(activeInd);
    }

    public Boolean getCurrentInd() {
        return this._persistence_get_currentInd();
    }

    public boolean isCurrent() {
        if (this._persistence_get_currentInd() == null) {
            return true;
        }
        return this._persistence_get_currentInd();
    }

    public void setCurrentInd(Boolean currentInd) {
        this._persistence_set_currentInd(currentInd);
    }

    @Override
    public String getDescription() {
        return this._persistence_get_description();
    }

    public void setDescription(String description) {
        this._persistence_set_description(description);
    }

    public String getResolvedDocumentHandlerUrl() {
        return this.resolveDocHandlerUrl(this.getUnresolvedInheritedDocHandlerUrl(false));
    }

    protected String getUnresolvedInheritedDocHandlerUrl(boolean forDisplayPurposes) {
        if (StringUtils.isNotBlank((String)this.getUnresolvedDocHandlerUrl())) {
            return this.getUnresolvedDocHandlerUrl();
        }
        DocumentType docType = this.getParentDocType();
        if (KRADUtils.isNotNull((Object)docType)) {
            Object parentValue = docType.getUnresolvedDocHandlerUrl();
            if (StringUtils.isNotBlank((String)parentValue)) {
                if (forDisplayPurposes) {
                    parentValue = (String)parentValue + " (Inherited from Parent)";
                }
                return parentValue;
            }
            return docType.getUnresolvedInheritedDocHandlerUrl(forDisplayPurposes);
        }
        return null;
    }

    public String getDisplayableUnresolvedDocHandlerUrl() {
        return this.getUnresolvedInheritedDocHandlerUrl(true);
    }

    @Deprecated
    public void setDisplayableUnresolvedDocHandlerUrl(String displayableUnresolvedDocHandlerUrl) {
    }

    public String getUnresolvedDocHandlerUrl() {
        return this._persistence_get_unresolvedDocHandlerUrl();
    }

    public void setUnresolvedDocHandlerUrl(String unresolvedDocHandlerUrl) {
        this._persistence_set_unresolvedDocHandlerUrl(unresolvedDocHandlerUrl);
    }

    protected String resolveDocHandlerUrl(String docHandlerUrl) {
        if (StringUtils.isBlank((String)docHandlerUrl)) {
            return "";
        }
        return Utilities.substituteConfigParameters(this.getApplicationId(), docHandlerUrl);
    }

    @Deprecated
    public void setDocHandlerUrl(String docHandlerUrl) {
        this.setUnresolvedDocHandlerUrl(docHandlerUrl);
    }

    public String getUnresolvedHelpDefinitionUrl() {
        return this._persistence_get_unresolvedHelpDefinitionUrl();
    }

    public void setUnresolvedHelpDefinitionUrl(String unresolvedHelpDefinitionUrl) {
        this._persistence_set_unresolvedHelpDefinitionUrl(unresolvedHelpDefinitionUrl);
    }

    @Override
    public String getHelpDefinitionUrl() {
        return this.resolveHelpUrl(this.getUnresolvedHelpDefinitionUrl());
    }

    protected String resolveHelpUrl(String helpDefinitionUrl) {
        if (StringUtils.isBlank((String)helpDefinitionUrl)) {
            return "";
        }
        return Utilities.substituteConfigParameters(helpDefinitionUrl);
    }

    public String getUnresolvedDocSearchHelpUrl() {
        return this._persistence_get_unresolvedDocSearchHelpUrl();
    }

    public void setUnresolvedDocSearchHelpUrl(String unresolvedDocSearchHelpUrl) {
        this._persistence_set_unresolvedDocSearchHelpUrl(unresolvedDocSearchHelpUrl);
    }

    public String getDocSearchHelpUrl() {
        return this.resolveHelpUrl(this.getUnresolvedDocSearchHelpUrl());
    }

    @Override
    public String getLabel() {
        return this._persistence_get_label();
    }

    public void setLabel(String label) {
        this._persistence_set_label(label);
    }

    @Override
    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public PostProcessor getPostProcessor() {
        String pname = this.getPostProcessorName();
        if (StringUtils.equals((String)pname, (String)"none")) {
            return new DefaultPostProcessor();
        }
        if (StringUtils.isBlank((String)pname)) {
            if (this.getParentDocType() != null) {
                return this.getParentDocType().getPostProcessor();
            }
            return new DefaultPostProcessor();
        }
        ObjectDefinition objDef = this.getObjectDefinition(pname);
        Object postProcessor = GlobalResourceLoader.getObject((ObjectDefinition)objDef);
        if (postProcessor == null) {
            throw new WorkflowRuntimeException("Could not locate PostProcessor in this JVM or at application id " + this.getApplicationId() + ": " + pname);
        }
        return (PostProcessor)postProcessor;
    }

    protected String getInheritedPostProcessorName(boolean forDisplayPurposes) {
        if (StringUtils.isNotBlank((String)this.getPostProcessorName())) {
            return this.getPostProcessorName();
        }
        if (KRADUtils.isNotNull((Object)this.getParentDocType())) {
            Object parentValue = this.getParentDocType().getPostProcessorName();
            if (StringUtils.isNotBlank((String)parentValue)) {
                if (forDisplayPurposes) {
                    parentValue = (String)parentValue + " (Inherited from Parent)";
                }
                return parentValue;
            }
            return this.getParentDocType().getInheritedPostProcessorName(forDisplayPurposes);
        }
        return null;
    }

    public String getPostProcessorName() {
        return this._persistence_get_postProcessorName();
    }

    public void setPostProcessorName(String postProcessorName) {
        this._persistence_set_postProcessorName(postProcessorName);
    }

    public String getDisplayablePostProcessorName() {
        return this.getInheritedPostProcessorName(true);
    }

    @Deprecated
    public void setDisplayablePostProcessorName(String displayablePostProcessorName) {
    }

    public String getPreviousVersionId() {
        return this._persistence_get_previousVersionId();
    }

    public void setPreviousVersionId(String previousVersionId) {
        this._persistence_set_previousVersionId(previousVersionId);
    }

    public String getDocumentId() {
        return this._persistence_get_documentId();
    }

    public void setDocumentId(String documentId) {
        this._persistence_set_documentId(documentId);
    }

    public Integer getVersion() {
        return this._persistence_get_version();
    }

    public void setVersion(Integer version) {
        this._persistence_set_version(version);
    }

    @Override
    public String getDocumentTypeId() {
        return this._persistence_get_documentTypeId();
    }

    public void setDocumentTypeId(String docTypeGrpId) {
        this._persistence_set_documentTypeId(docTypeGrpId);
    }

    public String getId() {
        return this.getDocumentTypeId();
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public DocumentTypePolicy getPolicyByName(String policyName, Boolean defaultValue) {
        DocumentTypePolicy policy;
        for (DocumentTypePolicy policy2 : this.getDocumentTypePolicies()) {
            if (!policyName.equals(policy2.getPolicyName())) continue;
            policy2.setInheritedFlag(Boolean.FALSE);
            return policy2;
        }
        if (this.getParentDocType() != null) {
            policy = this.getParentDocType().getPolicyByName(policyName, defaultValue);
            policy.setInheritedFlag(Boolean.TRUE);
            if (policy.getPolicyValue() == null) {
                policy.setPolicyValue(Boolean.TRUE);
            }
            return policy;
        }
        policy = new DocumentTypePolicy();
        policy.setPolicyName(policyName);
        policy.setInheritedFlag(Boolean.FALSE);
        policy.setPolicyValue(defaultValue);
        return policy;
    }

    public DocumentTypePolicy getPolicyByName(String policyName, String defaultValue) {
        DocumentTypePolicy policy;
        for (DocumentTypePolicy policy2 : this.getDocumentTypePolicies()) {
            if (!policyName.equals(policy2.getPolicyName())) continue;
            policy2.setInheritedFlag(Boolean.FALSE);
            return policy2;
        }
        if (this.getParentDocType() != null) {
            policy = this.getParentDocType().getPolicyByName(policyName, defaultValue);
            policy.setInheritedFlag(Boolean.TRUE);
            if (policy.getPolicyValue() == null) {
                policy.setPolicyValue(Boolean.TRUE);
            }
            return policy;
        }
        policy = new DocumentTypePolicy();
        policy.setPolicyName(policyName);
        policy.setInheritedFlag(Boolean.FALSE);
        policy.setPolicyValue(Boolean.TRUE);
        policy.setPolicyStringValue(defaultValue);
        return policy;
    }

    private DocumentTypeService getDocumentTypeService() {
        return (DocumentTypeService)KEWServiceLocator.getService("enDocumentTypeService");
    }

    public Group getSuperUserWorkgroup() {
        Group superUserWorkgroup = this.getSuperUserWorkgroupNoInheritence();
        if (superUserWorkgroup == null && this.getParentDocType() != null) {
            return this.getParentDocType().getSuperUserWorkgroup();
        }
        return superUserWorkgroup;
    }

    public Group getSuperUserWorkgroupNoInheritence() {
        if (this._persistence_get_workgroupId() == null) {
            return null;
        }
        return this.getGroupService().getGroup(this._persistence_get_workgroupId());
    }

    public void setSuperUserWorkgroupNoInheritence(Group suWorkgroup) {
        this._persistence_set_workgroupId(null);
        if (KRADUtils.isNotNull((Object)suWorkgroup)) {
            this._persistence_set_workgroupId(suWorkgroup.getId());
        }
    }

    public void setSuperUserWorkgroupIdNoInheritence(String suWorkgroupId) {
        this._persistence_set_workgroupId(suWorkgroupId);
    }

    public boolean isSuperUserGroupDefined() {
        if (this._persistence_get_workgroupId() == null) {
            return this.getParentDocType() != null && this.getParentDocType().isSuperUserGroupDefined();
        }
        return true;
    }

    public DocumentType getPreviousVersion() {
        return this.getDocumentTypeService().findById(this._persistence_get_previousVersionId());
    }

    public Group getBlanketApproveWorkgroup() {
        if (StringUtils.isBlank((String)this._persistence_get_blanketApproveWorkgroupId())) {
            return null;
        }
        return this.getGroupService().getGroup(this._persistence_get_blanketApproveWorkgroupId());
    }

    public void setBlanketApproveWorkgroup(Group blanketApproveWorkgroup) {
        this._persistence_set_blanketApproveWorkgroupId(null);
        if (KRADUtils.isNotNull((Object)blanketApproveWorkgroup)) {
            this._persistence_set_blanketApproveWorkgroupId(blanketApproveWorkgroup.getId());
        }
    }

    public String getBlanketApprovePolicy() {
        return this._persistence_get_blanketApprovePolicy();
    }

    public void setBlanketApprovePolicy(String blanketApprovePolicy) {
        this._persistence_set_blanketApprovePolicy(blanketApprovePolicy);
    }

    public Group getBlanketApproveWorkgroupWithInheritance() {
        if (this.getParentDocType() != null && this._persistence_get_blanketApproveWorkgroupId() == null) {
            return this.getParentDocType().getBlanketApproveWorkgroupWithInheritance();
        }
        if (this._persistence_get_blanketApproveWorkgroupId() != null) {
            return this.getGroupService().getGroup(this._persistence_get_blanketApproveWorkgroupId());
        }
        return null;
    }

    public boolean isBlanketApprover(String principalId) {
        if ("none".equalsIgnoreCase(this.getBlanketApprovePolicy())) {
            return false;
        }
        if ("any".equalsIgnoreCase(this.getBlanketApprovePolicy())) {
            return true;
        }
        if (this._persistence_get_blanketApproveWorkgroupId() != null) {
            return this.getGroupService().isMemberOfGroup(principalId, this._persistence_get_blanketApproveWorkgroupId());
        }
        DocumentType parentDoc = this.getParentDocType();
        if (parentDoc != null) {
            return parentDoc.isBlanketApprover(principalId);
        }
        return false;
    }

    public boolean isBlanketApproveGroupDefined() {
        if (StringUtils.isBlank((String)this.getBlanketApprovePolicy()) && this._persistence_get_blanketApproveWorkgroupId() == null) {
            return this.getParentDocType() != null && this.getParentDocType().isBlanketApproveGroupDefined();
        }
        return true;
    }

    public String getReportingWorkgroupId() {
        return this._persistence_get_reportingWorkgroupId();
    }

    public void setReportingWorkgroupId(String reportingWorkgroupId) {
        this._persistence_set_reportingWorkgroupId(reportingWorkgroupId);
    }

    public Group getReportingWorkgroup() {
        if (StringUtils.isBlank((String)this._persistence_get_reportingWorkgroupId())) {
            return null;
        }
        return this.getGroupService().getGroup(this._persistence_get_reportingWorkgroupId());
    }

    public void setReportingWorkgroup(Group reportingWorkgroup) {
        this._persistence_set_reportingWorkgroupId(null);
        if (KRADUtils.isNotNull((Object)reportingWorkgroup)) {
            this._persistence_set_reportingWorkgroupId(reportingWorkgroup.getId());
        }
    }

    public Group getDefaultExceptionWorkgroup() {
        return this.defaultExceptionWorkgroup;
    }

    public void setDefaultExceptionWorkgroup(Group defaultExceptionWorkgroup) {
        this.defaultExceptionWorkgroup = defaultExceptionWorkgroup;
    }

    public CustomActionListAttribute getCustomActionListAttribute() {
        CustomActionListAttribute result = null;
        RuleAttribute customActionListRuleAttribute = this.getCustomActionListRuleAttribute();
        if (customActionListRuleAttribute != null) {
            try {
                ExtensionDefinition extensionDefinition = KewApiServiceLocator.getExtensionRepositoryService().getExtensionById(customActionListRuleAttribute.getId());
                if (extensionDefinition != null) {
                    result = (CustomActionListAttribute)ExtensionUtils.loadExtension((ExtensionDefinitionContract)extensionDefinition, (String)customActionListRuleAttribute.getApplicationId());
                } else {
                    LOG.warn("Could not load ExtensionDefinition for " + customActionListRuleAttribute);
                }
            }
            catch (RiceRemoteServiceConnectionException e) {
                LOG.warn("Unable to connect to load custom action list attribute for " + customActionListRuleAttribute, (Throwable)e);
            }
        }
        return result;
    }

    public CustomEmailAttribute getCustomEmailAttribute() {
        ObjectDefinition objDef = this.getAttributeObjectDefinition("EmailAttribute");
        if (objDef == null) {
            return null;
        }
        return (CustomEmailAttribute)GlobalResourceLoader.getObject((ObjectDefinition)objDef);
    }

    public ObjectDefinition getAttributeObjectDefinition(String typeCode) {
        for (DocumentTypeAttributeBo documentTypeAttributeBo : this.getDocumentTypeAttributes()) {
            RuleAttribute attribute = documentTypeAttributeBo.getRuleAttribute();
            if (!attribute.getType().equals(typeCode)) continue;
            return this.getAttributeObjectDefinition(attribute);
        }
        if (this.getParentDocType() != null) {
            return this.getParentDocType().getAttributeObjectDefinition(typeCode);
        }
        return null;
    }

    public ObjectDefinition getAttributeObjectDefinition(RuleAttribute ruleAttribute) {
        if (ruleAttribute.getApplicationId() == null) {
            return new ObjectDefinition(ruleAttribute.getResourceDescriptor(), this.getApplicationId());
        }
        return new ObjectDefinition(ruleAttribute.getResourceDescriptor(), ruleAttribute.getApplicationId());
    }

    public CustomNoteAttribute getCustomNoteAttribute() {
        ObjectDefinition objDef = this.getAttributeObjectDefinition("NoteAttribute");
        if (objDef == null) {
            String defaultNoteClass = ConfigContext.getCurrentContextConfig().getDefaultKewNoteClass();
            if (defaultNoteClass == null && (defaultNoteClass = ConfigContext.getCurrentContextConfig().getDefaultKewNoteClass()) == null) {
                return null;
            }
            objDef = new ObjectDefinition(defaultNoteClass);
        }
        return (CustomNoteAttribute)GlobalResourceLoader.getObject((ObjectDefinition)objDef);
    }

    public ObjectDefinition getObjectDefinition(String objectName) {
        return new ObjectDefinition(objectName, this.getApplicationId());
    }

    public boolean isRouteInherited() {
        return this._persistence_get_processes().isEmpty() && this.getParentDocType() != null;
    }

    public DocumentType getRouteDefiningDocumentType() {
        if (this.isRouteInherited()) {
            return this.getParentDocType().getRouteDefiningDocumentType();
        }
        return this;
    }

    public boolean isDocTypeActive() {
        if (!this.getActive().booleanValue()) {
            return false;
        }
        if (this.getParentDocType() != null) {
            return this.getParentActiveInd(this.getParentDocType());
        }
        return true;
    }

    private boolean getParentActiveInd(DocumentType parentDocType) {
        if (parentDocType.getActive() == null || parentDocType.getActive().booleanValue()) {
            if (parentDocType.getParentDocType() != null) {
                return this.getParentActiveInd(parentDocType.getParentDocType());
            }
            return true;
        }
        return false;
    }

    public void setDocumentTypeAttributes(List<DocumentTypeAttributeBo> documentTypeAttributes) {
        this._persistence_set_documentTypeAttributes(documentTypeAttributes);
    }

    public List<DocumentTypeAttributeBo> getDocumentTypeAttributes() {
        return this._persistence_get_documentTypeAttributes();
    }

    public void addProcess(ProcessDefinitionBo process) {
        this._persistence_get_processes().add(process);
    }

    public List getProcesses() {
        if (this._persistence_get_processes().isEmpty() && this.getParentDocType() != null) {
            return this.getParentProcesses(this.getParentDocType());
        }
        return Collections.unmodifiableList(this._persistence_get_processes());
    }

    public void setProcesses(List routeNodes) {
        this._persistence_set_processes(routeNodes);
    }

    private List getParentProcesses(DocumentType parent) {
        List parentProcesses = parent.getProcesses();
        if (parentProcesses == null) {
            parentProcesses = this.getParentProcesses(parent.getParentDocType());
        }
        return parentProcesses;
    }

    public ProcessDefinitionBo getPrimaryProcess() {
        for (Object o : this.getProcesses()) {
            ProcessDefinitionBo process = (ProcessDefinitionBo)o;
            if (!process.isInitial()) continue;
            return process;
        }
        return null;
    }

    public ProcessDefinitionBo getNamedProcess(String name) {
        for (Object o : this.getProcesses()) {
            ProcessDefinitionBo process = (ProcessDefinitionBo)o;
            if (!ObjectUtils.equals((Object)name, (Object)process.getName())) continue;
            return process;
        }
        return null;
    }

    public String getRoutingVersion() {
        return this._persistence_get_routingVersion();
    }

    public void setRoutingVersion(String routingVersion) {
        this._persistence_set_routingVersion(routingVersion);
    }

    public String getActualNotificationFromAddress() {
        return this._persistence_get_actualNotificationFromAddress();
    }

    public void setActualNotificationFromAddress(String actualNotificationFromAddress) {
        this._persistence_set_actualNotificationFromAddress(actualNotificationFromAddress);
    }

    public String getDisplayableNotificationFromAddress() {
        return this.getNotificationFromAddress(true);
    }

    @Deprecated
    public void setDisplayableNotificationFromAddress(String displayableNotificationFromAddress) {
    }

    public String getNotificationFromAddress() {
        return this.getNotificationFromAddress(false);
    }

    protected String getNotificationFromAddress(boolean forDisplayPurposes) {
        if (StringUtils.isNotBlank((String)this.getActualNotificationFromAddress())) {
            return this.getActualNotificationFromAddress();
        }
        if (KRADUtils.isNotNull((Object)this.getParentDocType())) {
            Object parentNotificationFromAddress = this.getParentDocType().getActualNotificationFromAddress();
            if (StringUtils.isNotBlank((String)parentNotificationFromAddress)) {
                if (forDisplayPurposes) {
                    parentNotificationFromAddress = (String)parentNotificationFromAddress + " (Inherited from Parent)";
                }
                return parentNotificationFromAddress;
            }
            return this.getParentDocType().getNotificationFromAddress(forDisplayPurposes);
        }
        return null;
    }

    @Deprecated
    public void setNotificationFromAddress(String notificationFromAddress) {
        this.setActualNotificationFromAddress(notificationFromAddress);
    }

    public boolean isParentOf(DocumentType documentType) {
        for (DocumentType child : this.getChildrenDocTypes()) {
            if (!child.getName().equals(documentType.getName()) && !child.isParentOf(documentType)) continue;
            return true;
        }
        return false;
    }

    public String getLookupParentName() {
        DocumentType parent = this.getParentDocType();
        if (parent == null) {
            return "Root";
        }
        return parent.getName();
    }

    public boolean isSuperUser(String principalId) {
        Group workgroup = this.getSuperUserWorkgroup();
        if (workgroup == null) {
            return false;
        }
        return this.getGroupService().isMemberOfGroup(principalId, workgroup.getId());
    }

    public boolean hasPreviousVersion() {
        if (this._persistence_get_documentTypeId() == null) {
            return false;
        }
        return !this._persistence_get_documentTypeId().equals(this._persistence_get_previousVersionId());
    }

    public String getActualApplicationId() {
        return this._persistence_get_actualApplicationId();
    }

    public void setActualApplicationId(String actualApplicationId) {
        this._persistence_set_actualApplicationId(actualApplicationId);
    }

    @Override
    public String getApplicationId() {
        return this.getApplicationId(false);
    }

    protected String getApplicationId(boolean forDisplayPurposes) {
        if (StringUtils.isNotBlank((String)this.getActualApplicationId())) {
            return this.getActualApplicationId();
        }
        if (KRADUtils.isNotNull((Object)this.getParentDocType())) {
            Object parentValue = this.getParentDocType().getActualApplicationId();
            if (StringUtils.isNotBlank((String)parentValue)) {
                if (forDisplayPurposes) {
                    parentValue = (String)parentValue + " (Inherited from Parent)";
                }
                return parentValue;
            }
            return this.getParentDocType().getApplicationId(forDisplayPurposes);
        }
        Object defaultValue = CoreConfigHelper.getApplicationId();
        if (forDisplayPurposes) {
            defaultValue = (String)defaultValue + " (System Default)";
        }
        return defaultValue;
    }

    public String getDisplayableApplicationId() {
        return this.getApplicationId(true);
    }

    public String getCustomEmailStylesheet() {
        return this._persistence_get_customEmailStylesheet();
    }

    public void setCustomEmailStylesheet(String customEmailStylesheet) {
        this._persistence_set_customEmailStylesheet(customEmailStylesheet);
    }

    public String getBlanketApproveWorkgroupId() {
        return this._persistence_get_blanketApproveWorkgroupId();
    }

    public void setBlanketApproveWorkgroupId(String blanketApproveWorkgroupId) {
        this._persistence_set_blanketApproveWorkgroupId(blanketApproveWorkgroupId);
    }

    public Boolean getApplyRetroactively() {
        return this.applyRetroactively;
    }

    public void setApplyRetroactively(Boolean applyRetroactively) {
        this.applyRetroactively = applyRetroactively;
    }

    private GroupService getGroupService() {
        return KimApiServiceLocator.getGroupService();
    }

    @Override
    public boolean isActive() {
        boolean bRet = false;
        if (this._persistence_get_active() != null) {
            bRet = this._persistence_get_active();
        }
        return bRet;
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public Integer getDocumentTypeVersion() {
        return this._persistence_get_version();
    }

    public String getParentId() {
        return this._persistence_get_docTypeParentId();
    }

    public String getBlanketApproveGroupId() {
        return this._persistence_get_blanketApproveWorkgroupId();
    }

    public String getSuperUserGroupId() {
        return this._persistence_get_workgroupId();
    }

    public String getAuthorizer() {
        String result = this._persistence_get_authorizer();
        if (StringUtils.isBlank((String)result) && this.getParentDocType() != null) {
            return this.getParentDocType().getAuthorizer();
        }
        return result;
    }

    public void setAuthorizer(String authorizer) {
        this._persistence_set_authorizer(authorizer);
    }

    public static org.kuali.rice.kew.api.doctype.DocumentType to(DocumentType documentTypeBo) {
        if (documentTypeBo == null) {
            return null;
        }
        DocumentType.Builder builder = DocumentType.Builder.create((DocumentTypeContract)documentTypeBo);
        builder.setApplicationId(documentTypeBo.getActualApplicationId());
        return builder.build();
    }

    public static DocumentType from(DocumentTypeContract dt) {
        if (dt == null) {
            return null;
        }
        DocumentType ebo = new DocumentType();
        ebo.setDocumentTypeId(dt.getId());
        ebo.setActive(dt.isActive());
        ebo.setActualApplicationId(dt.getApplicationId());
        ebo.setBlanketApproveWorkgroupId(dt.getBlanketApproveGroupId());
        ebo.setCurrentInd(dt.isCurrent());
        ebo.setDescription(dt.getDescription());
        ebo.setVersionNumber(dt.getVersionNumber());
        ebo.setObjectId(dt.getObjectId());
        ebo.setVersion(dt.getDocumentTypeVersion());
        ebo.setUnresolvedDocHandlerUrl(dt.getUnresolvedDocHandlerUrl());
        ebo.setUnresolvedDocSearchHelpUrl(dt.getDocSearchHelpUrl());
        ebo.setUnresolvedHelpDefinitionUrl(dt.getHelpDefinitionUrl());
        ebo.setLabel(dt.getLabel());
        ebo.setName(dt.getName());
        ebo.setDocTypeParentId(dt.getParentId());
        ebo.setPostProcessorName(dt.getPostProcessorName());
        ebo.setSuperUserWorkgroupIdNoInheritence(dt.getSuperUserGroupId());
        ArrayList<DocumentTypePolicy> policies = new ArrayList<DocumentTypePolicy>();
        if (dt.getPolicies() != null) {
            for (Map.Entry entry : dt.getPolicies().entrySet()) {
                policies.add(new DocumentTypePolicy(dt.getId(), ((org.kuali.rice.kew.api.doctype.DocumentTypePolicy)entry.getKey()).getCode(), Boolean.TRUE.toString().equals(entry.getValue())));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)dt.getDocumentTypeAttributes())) {
            ArrayList<DocumentTypeAttributeBo> attributes = new ArrayList<DocumentTypeAttributeBo>();
            for (DocumentTypeAttributeContract attr : dt.getDocumentTypeAttributes()) {
                attributes.add(DocumentTypeAttributeBo.from(DocumentTypeAttribute.Builder.create((DocumentTypeAttributeContract)attr).build()));
            }
        }
        ebo.setDocumentTypePolicies(policies);
        ebo.setAuthorizer(dt.getAuthorizer());
        return ebo;
    }

    public String getWorkgroupId() {
        return this._persistence_get_workgroupId();
    }

    public void setWorkgroupId(String workgroupId) {
        this._persistence_set_workgroupId(workgroupId);
    }

    public void refresh() {
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new DocumentType();
    }

    public Object _persistence_get(String string) {
        if (string == "routingVersion") {
            return this.routingVersion;
        }
        if (string == "unresolvedDocSearchHelpUrl") {
            return this.unresolvedDocSearchHelpUrl;
        }
        if (string == "documentTypeId") {
            return this.documentTypeId;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "documentTypeAttributes") {
            return this.documentTypeAttributes;
        }
        if (string == "customEmailStylesheet") {
            return this.customEmailStylesheet;
        }
        if (string == "unresolvedHelpDefinitionUrl") {
            return this.unresolvedHelpDefinitionUrl;
        }
        if (string == "blanketApproveWorkgroupId") {
            return this.blanketApproveWorkgroupId;
        }
        if (string == "validApplicationStatuses") {
            return this.validApplicationStatuses;
        }
        if (string == "documentTypePolicies") {
            return this.documentTypePolicies;
        }
        if (string == "unresolvedDocHandlerUrl") {
            return this.unresolvedDocHandlerUrl;
        }
        if (string == "postProcessorName") {
            return this.postProcessorName;
        }
        if (string == "docTypeParentId") {
            return this.docTypeParentId;
        }
        if (string == "processes") {
            return this.processes;
        }
        if (string == "blanketApprovePolicy") {
            return this.blanketApprovePolicy;
        }
        if (string == "authorizer") {
            return this.authorizer;
        }
        if (string == "actualNotificationFromAddress") {
            return this.actualNotificationFromAddress;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "applicationStatusCategories") {
            return this.applicationStatusCategories;
        }
        if (string == "label") {
            return this.label;
        }
        if (string == "version") {
            return this.version;
        }
        if (string == "currentInd") {
            return this.currentInd;
        }
        if (string == "previousVersionId") {
            return this.previousVersionId;
        }
        if (string == "documentTypeSecurityXml") {
            return this.documentTypeSecurityXml;
        }
        if (string == "workgroupId") {
            return this.workgroupId;
        }
        if (string == "reportingWorkgroupId") {
            return this.reportingWorkgroupId;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "documentId") {
            return this.documentId;
        }
        if (string == "actualApplicationId") {
            return this.actualApplicationId;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "routingVersion") {
            this.routingVersion = (String)object;
            return;
        }
        if (string == "unresolvedDocSearchHelpUrl") {
            this.unresolvedDocSearchHelpUrl = (String)object;
            return;
        }
        if (string == "documentTypeId") {
            this.documentTypeId = (String)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "documentTypeAttributes") {
            this.documentTypeAttributes = (List)object;
            return;
        }
        if (string == "customEmailStylesheet") {
            this.customEmailStylesheet = (String)object;
            return;
        }
        if (string == "unresolvedHelpDefinitionUrl") {
            this.unresolvedHelpDefinitionUrl = (String)object;
            return;
        }
        if (string == "blanketApproveWorkgroupId") {
            this.blanketApproveWorkgroupId = (String)object;
            return;
        }
        if (string == "validApplicationStatuses") {
            this.validApplicationStatuses = (List)object;
            return;
        }
        if (string == "documentTypePolicies") {
            this.documentTypePolicies = (Collection)object;
            return;
        }
        if (string == "unresolvedDocHandlerUrl") {
            this.unresolvedDocHandlerUrl = (String)object;
            return;
        }
        if (string == "postProcessorName") {
            this.postProcessorName = (String)object;
            return;
        }
        if (string == "docTypeParentId") {
            this.docTypeParentId = (String)object;
            return;
        }
        if (string == "processes") {
            this.processes = (List)object;
            return;
        }
        if (string == "blanketApprovePolicy") {
            this.blanketApprovePolicy = (String)object;
            return;
        }
        if (string == "authorizer") {
            this.authorizer = (String)object;
            return;
        }
        if (string == "actualNotificationFromAddress") {
            this.actualNotificationFromAddress = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "applicationStatusCategories") {
            this.applicationStatusCategories = (List)object;
            return;
        }
        if (string == "label") {
            this.label = (String)object;
            return;
        }
        if (string == "version") {
            this.version = (Integer)object;
            return;
        }
        if (string == "currentInd") {
            this.currentInd = (Boolean)object;
            return;
        }
        if (string == "previousVersionId") {
            this.previousVersionId = (String)object;
            return;
        }
        if (string == "documentTypeSecurityXml") {
            this.documentTypeSecurityXml = (String)object;
            return;
        }
        if (string == "workgroupId") {
            this.workgroupId = (String)object;
            return;
        }
        if (string == "reportingWorkgroupId") {
            this.reportingWorkgroupId = (String)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "documentId") {
            this.documentId = (String)object;
            return;
        }
        if (string == "actualApplicationId") {
            this.actualApplicationId = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_routingVersion() {
        this._persistence_checkFetched("routingVersion");
        return this.routingVersion;
    }

    public void _persistence_set_routingVersion(String string) {
        this._persistence_checkFetchedForSet("routingVersion");
        this.routingVersion = string;
    }

    public String _persistence_get_unresolvedDocSearchHelpUrl() {
        this._persistence_checkFetched("unresolvedDocSearchHelpUrl");
        return this.unresolvedDocSearchHelpUrl;
    }

    public void _persistence_set_unresolvedDocSearchHelpUrl(String string) {
        this._persistence_checkFetchedForSet("unresolvedDocSearchHelpUrl");
        this.unresolvedDocSearchHelpUrl = string;
    }

    public String _persistence_get_documentTypeId() {
        this._persistence_checkFetched("documentTypeId");
        return this.documentTypeId;
    }

    public void _persistence_set_documentTypeId(String string) {
        this._persistence_checkFetchedForSet("documentTypeId");
        this.documentTypeId = string;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this.description = string;
    }

    public List _persistence_get_documentTypeAttributes() {
        this._persistence_checkFetched("documentTypeAttributes");
        return this.documentTypeAttributes;
    }

    public void _persistence_set_documentTypeAttributes(List list) {
        this._persistence_checkFetchedForSet("documentTypeAttributes");
        this.documentTypeAttributes = list;
    }

    public String _persistence_get_customEmailStylesheet() {
        this._persistence_checkFetched("customEmailStylesheet");
        return this.customEmailStylesheet;
    }

    public void _persistence_set_customEmailStylesheet(String string) {
        this._persistence_checkFetchedForSet("customEmailStylesheet");
        this.customEmailStylesheet = string;
    }

    public String _persistence_get_unresolvedHelpDefinitionUrl() {
        this._persistence_checkFetched("unresolvedHelpDefinitionUrl");
        return this.unresolvedHelpDefinitionUrl;
    }

    public void _persistence_set_unresolvedHelpDefinitionUrl(String string) {
        this._persistence_checkFetchedForSet("unresolvedHelpDefinitionUrl");
        this.unresolvedHelpDefinitionUrl = string;
    }

    public String _persistence_get_blanketApproveWorkgroupId() {
        this._persistence_checkFetched("blanketApproveWorkgroupId");
        return this.blanketApproveWorkgroupId;
    }

    public void _persistence_set_blanketApproveWorkgroupId(String string) {
        this._persistence_checkFetchedForSet("blanketApproveWorkgroupId");
        this.blanketApproveWorkgroupId = string;
    }

    public List _persistence_get_validApplicationStatuses() {
        this._persistence_checkFetched("validApplicationStatuses");
        return this.validApplicationStatuses;
    }

    public void _persistence_set_validApplicationStatuses(List list) {
        this._persistence_checkFetchedForSet("validApplicationStatuses");
        this.validApplicationStatuses = list;
    }

    public Collection _persistence_get_documentTypePolicies() {
        this._persistence_checkFetched("documentTypePolicies");
        return this.documentTypePolicies;
    }

    public void _persistence_set_documentTypePolicies(Collection collection) {
        this._persistence_checkFetchedForSet("documentTypePolicies");
        this.documentTypePolicies = collection;
    }

    public String _persistence_get_unresolvedDocHandlerUrl() {
        this._persistence_checkFetched("unresolvedDocHandlerUrl");
        return this.unresolvedDocHandlerUrl;
    }

    public void _persistence_set_unresolvedDocHandlerUrl(String string) {
        this._persistence_checkFetchedForSet("unresolvedDocHandlerUrl");
        this.unresolvedDocHandlerUrl = string;
    }

    public String _persistence_get_postProcessorName() {
        this._persistence_checkFetched("postProcessorName");
        return this.postProcessorName;
    }

    public void _persistence_set_postProcessorName(String string) {
        this._persistence_checkFetchedForSet("postProcessorName");
        this.postProcessorName = string;
    }

    public String _persistence_get_docTypeParentId() {
        this._persistence_checkFetched("docTypeParentId");
        return this.docTypeParentId;
    }

    public void _persistence_set_docTypeParentId(String string) {
        this._persistence_checkFetchedForSet("docTypeParentId");
        this.docTypeParentId = string;
    }

    public List _persistence_get_processes() {
        this._persistence_checkFetched("processes");
        return this.processes;
    }

    public void _persistence_set_processes(List list) {
        this._persistence_checkFetchedForSet("processes");
        this.processes = list;
    }

    public String _persistence_get_blanketApprovePolicy() {
        this._persistence_checkFetched("blanketApprovePolicy");
        return this.blanketApprovePolicy;
    }

    public void _persistence_set_blanketApprovePolicy(String string) {
        this._persistence_checkFetchedForSet("blanketApprovePolicy");
        this.blanketApprovePolicy = string;
    }

    public String _persistence_get_authorizer() {
        this._persistence_checkFetched("authorizer");
        return this.authorizer;
    }

    public void _persistence_set_authorizer(String string) {
        this._persistence_checkFetchedForSet("authorizer");
        this.authorizer = string;
    }

    public String _persistence_get_actualNotificationFromAddress() {
        this._persistence_checkFetched("actualNotificationFromAddress");
        return this.actualNotificationFromAddress;
    }

    public void _persistence_set_actualNotificationFromAddress(String string) {
        this._persistence_checkFetchedForSet("actualNotificationFromAddress");
        this.actualNotificationFromAddress = string;
    }

    public Boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(Boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this.active = bl;
    }

    public List _persistence_get_applicationStatusCategories() {
        this._persistence_checkFetched("applicationStatusCategories");
        return this.applicationStatusCategories;
    }

    public void _persistence_set_applicationStatusCategories(List list) {
        this._persistence_checkFetchedForSet("applicationStatusCategories");
        this.applicationStatusCategories = list;
    }

    public String _persistence_get_label() {
        this._persistence_checkFetched("label");
        return this.label;
    }

    public void _persistence_set_label(String string) {
        this._persistence_checkFetchedForSet("label");
        this.label = string;
    }

    public Integer _persistence_get_version() {
        this._persistence_checkFetched("version");
        return this.version;
    }

    public void _persistence_set_version(Integer n) {
        this._persistence_checkFetchedForSet("version");
        this.version = n;
    }

    public Boolean _persistence_get_currentInd() {
        this._persistence_checkFetched("currentInd");
        return this.currentInd;
    }

    public void _persistence_set_currentInd(Boolean bl) {
        this._persistence_checkFetchedForSet("currentInd");
        this.currentInd = bl;
    }

    public String _persistence_get_previousVersionId() {
        this._persistence_checkFetched("previousVersionId");
        return this.previousVersionId;
    }

    public void _persistence_set_previousVersionId(String string) {
        this._persistence_checkFetchedForSet("previousVersionId");
        this.previousVersionId = string;
    }

    public String _persistence_get_documentTypeSecurityXml() {
        this._persistence_checkFetched("documentTypeSecurityXml");
        return this.documentTypeSecurityXml;
    }

    public void _persistence_set_documentTypeSecurityXml(String string) {
        this._persistence_checkFetchedForSet("documentTypeSecurityXml");
        this.documentTypeSecurityXml = string;
    }

    public String _persistence_get_workgroupId() {
        this._persistence_checkFetched("workgroupId");
        return this.workgroupId;
    }

    public void _persistence_set_workgroupId(String string) {
        this._persistence_checkFetchedForSet("workgroupId");
        this.workgroupId = string;
    }

    public String _persistence_get_reportingWorkgroupId() {
        this._persistence_checkFetched("reportingWorkgroupId");
        return this.reportingWorkgroupId;
    }

    public void _persistence_set_reportingWorkgroupId(String string) {
        this._persistence_checkFetchedForSet("reportingWorkgroupId");
        this.reportingWorkgroupId = string;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this.name = string;
    }

    public String _persistence_get_documentId() {
        this._persistence_checkFetched("documentId");
        return this.documentId;
    }

    public void _persistence_set_documentId(String string) {
        this._persistence_checkFetchedForSet("documentId");
        this.documentId = string;
    }

    public String _persistence_get_actualApplicationId() {
        this._persistence_checkFetched("actualApplicationId");
        return this.actualApplicationId;
    }

    public void _persistence_set_actualApplicationId(String string) {
        this._persistence_checkFetchedForSet("actualApplicationId");
        this.actualApplicationId = string;
    }

    public static final class ExtensionHolder<T> {
        private final ExtensionDefinition extensionDefinition;
        private final T extension;

        public ExtensionHolder(ExtensionDefinition extensionDefinition, T extension) {
            this.extensionDefinition = extensionDefinition;
            this.extension = extension;
        }

        public ExtensionDefinition getExtensionDefinition() {
            return this.extensionDefinition;
        }

        public T getExtension() {
            return this.extension;
        }
    }
}

