/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.framework.security.XStreamSecurityService;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.service.XmlObjectSerializerService;
import org.kuali.rice.krad.service.util.DateTimeConverter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

public class XmlObjectSerializerServiceImpl
implements XmlObjectSerializerService,
InitializingBean {
    private static final Logger LOG = LogManager.getLogger(XmlObjectSerializerServiceImpl.class);
    protected LegacyDataAdapter lda;
    protected XStreamSecurityService xStreamSecurityService;
    protected XStream xstream;

    @Required
    public void setLegacyDataAdapter(LegacyDataAdapter lda) {
        this.lda = lda;
    }

    @Required
    public void setXStreamSecurityService(XStreamSecurityService xStreamSecurityService) {
        this.xStreamSecurityService = xStreamSecurityService;
    }

    public String toXml(Object object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("toXml(" + object + ") : \n" + this.xstream.toXML(object));
        }
        return this.xstream.toXML(object);
    }

    public Object fromXml(String xml) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("fromXml() : \n" + xml);
        }
        if (xml != null) {
            xml = xml.replaceAll("--EnhancerByCGLIB--[0-9a-f]{0,8}", "");
        }
        return this.xstream.fromXML(xml);
    }

    public void afterPropertiesSet() {
        this.xstream = this.xStreamSecurityService.applySecurityRules(new XStream((ReflectionProvider)new ProxyAwareJavaReflectionProvider()));
        this.xstream.registerConverter((Converter)new ProxyConverter(this.xstream.getMapper(), this.xstream.getReflectionProvider()));
        try {
            Class<?> objListProxyClass = Class.forName("org.apache.ojb.broker.core.proxy.ListProxyDefaultImpl");
            this.xstream.addDefaultImplementation(ArrayList.class, objListProxyClass);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.xstream.registerConverter((SingleValueConverter)new DateTimeConverter());
    }

    public class ProxyAwareJavaReflectionProvider
    extends PureJavaReflectionProvider {
        public void visitSerializableFields(Object object, ReflectionProvider.Visitor visitor) {
            Iterator iterator = this.fieldDictionary.serializableFieldsFor(object.getClass());
            while (iterator.hasNext()) {
                Object value;
                Field field = (Field)iterator.next();
                if (!this.fieldModifiersSupported(field)) continue;
                this.validateFieldAccess(field);
                if (this.ignoreField(field)) continue;
                try {
                    value = field.get(object);
                    if (value != null && XmlObjectSerializerServiceImpl.this.lda.isProxied(value)) {
                        value = XmlObjectSerializerServiceImpl.this.lda.resolveProxy(value);
                    }
                }
                catch (Exception e) {
                    throw new ObjectAccessException("Could not get field " + field.getClass() + "." + field.getName() + " on " + object, (Throwable)e);
                }
                visitor.visit(field.getName(), field.getType(), field.getDeclaringClass(), value);
            }
        }

        protected boolean ignoreField(Field field) {
            return false;
        }
    }

    public class ProxyConverter
    extends ReflectionConverter {
        public ProxyConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
            super(mapper, reflectionProvider);
        }

        public boolean canConvert(Class clazz) {
            return clazz.getName().contains("CGLIB") || clazz.getName().equals("org.apache.ojb.broker.core.proxy.ListProxyDefaultImpl");
        }

        public void marshal(Object obj, HierarchicalStreamWriter writer, MarshallingContext context) {
            if (obj.getClass().getName().equals("org.apache.ojb.broker.core.proxy.ListProxyDefaultImpl")) {
                context.convertAnother(new ArrayList((List)obj));
            } else {
                super.marshal(XmlObjectSerializerServiceImpl.this.lda.resolveProxy(obj), writer, context);
            }
        }
    }
}

