-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /

DROP PROCEDURE IF EXISTS cleanupSequences
/
CREATE PROCEDURE cleanupSequences()
BEGIN
    DECLARE NO_MORE_SEQUENCES BOOLEAN DEFAULT FALSE;
    DECLARE V_TABLE_NAME VARCHAR(64);

    DECLARE SEQUENCES_CUR CURSOR FOR
        SELECT TABLE_NAME
        FROM information_schema.columns
        WHERE UPPER(COLUMN_NAME) = 'ID'
          AND TABLE_SCHEMA = DATABASE()
          AND TABLE_NAME in (
            SELECT TABLE_NAME
            FROM information_schema.COLUMNS
            WHERE TABLE_SCHEMA = DATABASE()
            GROUP BY TABLE_SCHEMA, TABLE_NAME
            HAVING COUNT(*) = 1
        );

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET NO_MORE_SEQUENCES = TRUE;

    OPEN SEQUENCES_CUR;

    sequences_loop:
        LOOP
            FETCH SEQUENCES_CUR INTO V_TABLE_NAME;

            IF NO_MORE_SEQUENCES THEN
                LEAVE sequences_loop;
            END IF;

            SET @cleanup_seq := CONCAT('DELETE FROM ', V_TABLE_NAME);
            PREPARE cleanup_seq_stmt FROM @cleanup_seq;
            EXECUTE cleanup_seq_stmt;
            DEALLOCATE PREPARE cleanup_seq_stmt;
        END LOOP;

    CLOSE SEQUENCES_CUR;
END
/
CALL cleanupSequences()
/
DELIMITER ;