-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

CREATE TABLE SEQ_PROPOSAL_ATTACHMENT_ID (
  id bigint(19) not null auto_increment, primary key (id)
) ENGINE MyISAM;

ALTER TABLE SEQ_PROPOSAL_ATTACHMENT_ID auto_increment = 1;

CREATE TABLE PROPOSAL_ATTACHMENT_TYPE(
ATTACHMENT_TYPE_CODE DECIMAL(3,0) NOT NULL,
DESCRIPTION VARCHAR(200) NOT NULL,
ALLOW_MULTIPLE VARCHAR(1) NOT NULL,
UPDATE_TIMESTAMP DATETIME NOT NULL,
UPDATE_USER VARCHAR(60) NOT NULL,
VER_NBR DECIMAL (8,0) NOT NULL DEFAULT 1,
OBJ_ID VARCHAR(36) NOT NULL);

ALTER TABLE PROPOSAL_ATTACHMENT_TYPE
ADD CONSTRAINT PK_ATTACHMENT_TYPE_CODE
PRIMARY KEY (ATTACHMENT_TYPE_CODE);

CREATE TABLE PROPOSAL_ATTACHMENTS(
PROPOSAL_ATTACHMENTS_ID DECIMAL(12,0),
PROPOSAL_ID DECIMAL(12,0),
PROPOSAL_NUMBER VARCHAR(8) NOT NULL,
SEQUENCE_NUMBER DECIMAL(4,0) NOT NULL,
ATTACHMENT_NUMBER DECIMAL (4,0) NOT NULL,
ATTACHMENT_TITLE VARCHAR(150),
ATTACHMENT_TYPE_CODE DECIMAL(3,0),
FILE_NAME VARCHAR(2000),
CONTENT_TYPE VARCHAR(255),
COMMENTS VARCHAR(300),
VER_NBR DECIMAL(8,0) NOT NULL DEFAULT 1,
OBJ_ID VARCHAR(36) NOT NULL,
UPDATE_USER VARCHAR(60) NOT NULL,
UPDATE_TIMESTAMP DATETIME NOT NULL,
LAST_UPDATE_USER VARCHAR(60) NOT NULL,
LAST_UPDATE_TIMESTAMP DATETIME NOT NULL,
DOCUMENT_STATUS_CODE CHAR(1),
FILE_DATA_ID VARCHAR(36));

ALTER TABLE PROPOSAL_ATTACHMENTS
ADD CONSTRAINT PK_PROPOSAL_ATTACHMENTS
PRIMARY KEY (PROPOSAL_ATTACHMENTS_ID);

ALTER TABLE PROPOSAL_ATTACHMENTS
ADD CONSTRAINT UK_PROPOSAL_ATTACHMENTS
UNIQUE (PROPOSAL_NUMBER, ATTACHMENT_NUMBER);

ALTER TABLE PROPOSAL_ATTACHMENTS
ADD CONSTRAINT FK_PROPOSAL_ATTACHMENTS
FOREIGN KEY (PROPOSAL_ID)
REFERENCES PROPOSAL (PROPOSAL_ID);

ALTER TABLE PROPOSAL_ATTACHMENTS
ADD CONSTRAINT FK_ATTACHMENT_TYPE_CODE
FOREIGN KEY (ATTACHMENT_TYPE_CODE)
REFERENCES PROPOSAL_ATTACHMENT_TYPE (ATTACHMENT_TYPE_CODE);

alter table PROPOSAL_ATTACHMENTS modify FILE_DATA_ID varchar(36) character set utf8 collate utf8_bin;

ALTER TABLE PROPOSAL_ATTACHMENTS
ADD CONSTRAINT FK_FILE_DATA_ID
FOREIGN KEY (FILE_DATA_ID)
REFERENCES FILE_DATA (ID);
