-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /

DROP PROCEDURE IF EXISTS FIX_DETAILS_CAL_AMOUNTS_PERSONNEL_DETS
/

CREATE PROCEDURE FIX_DETAILS_CAL_AMOUNTS_PERSONNEL_DETS()
BEGIN
  DECLARE NO_MORE_RECORDS BOOLEAN DEFAULT FALSE;

  DECLARE V_BUDGET_ID DECIMAL(12,0);
  DECLARE V_BUDGET_PERIOD_NUMBER DECIMAL(12,0);
  DECLARE V_BUDGET_PERIOD DECIMAL(3,0);
  DECLARE V_BUDGET_DETAILS_ID DECIMAL(12,0);
  DECLARE COUNTER INT DEFAULT 0;

  DECLARE RECORD_CUR CURSOR FOR
    SELECT BUDGET_ID, BUDGET_PERIOD_NUMBER, BUDGET_PERIOD, BUDGET_DETAILS_ID FROM BUDGET_DETAILS;

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET NO_MORE_RECORDS = TRUE;

  OPEN RECORD_CUR;

  record_loop: LOOP
    FETCH RECORD_CUR INTO V_BUDGET_ID, V_BUDGET_PERIOD_NUMBER, V_BUDGET_PERIOD, V_BUDGET_DETAILS_ID;
    IF NO_MORE_RECORDS THEN
      CLOSE RECORD_CUR;
      LEAVE record_loop;
    END IF;

    UPDATE BUDGET_DETAILS_CAL_AMTS
    SET BUDGET_ID = V_BUDGET_ID, BUDGET_PERIOD = V_BUDGET_PERIOD, BUDGET_PERIOD_NUMBER = V_BUDGET_PERIOD_NUMBER
    WHERE BUDGET_DETAILS_ID = V_BUDGET_DETAILS_ID;

    UPDATE BUDGET_PERSONNEL_DETAILS
    SET BUDGET_ID = V_BUDGET_ID, BUDGET_PERIOD = V_BUDGET_PERIOD, BUDGET_PERIOD_NUMBER = V_BUDGET_PERIOD_NUMBER
    WHERE BUDGET_DETAILS_ID = V_BUDGET_DETAILS_ID;

    UPDATE BUDGET_RATE_AND_BASE
    SET BUDGET_ID = V_BUDGET_ID, BUDGET_PERIOD = V_BUDGET_PERIOD, BUDGET_PERIOD_NUMBER = V_BUDGET_PERIOD_NUMBER
    WHERE BUDGET_DETAILS_ID = V_BUDGET_DETAILS_ID;

	IF COUNTER >= 500 THEN
		COMMIT;
		SET COUNTER = 1;
	ELSE
		SET COUNTER = COUNTER + 1;
	END IF;

  END LOOP;
  COMMIT;

END
/

CALL FIX_DETAILS_CAL_AMOUNTS_PERSONNEL_DETS
/

DELIMITER ;