-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

INSERT INTO COEUS_MODULE (MODULE_CODE, DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
VALUES (12, 'Export Control', now(), 'admin', uuid());

INSERT INTO SEQ_NOTIFICATION_TYPE_ID VALUES (NULL);
INSERT INTO NOTIFICATION_TYPE (NOTIFICATION_TYPE_ID, MODULE_CODE, ACTION_CODE, DESCRIPTION, SUBJECT, MESSAGE, PROMPT_USER, SEND_NOTIFICATION, UPDATE_USER,
                               UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_NOTIFICATION_TYPE_ID), 12, '-3', 'Notification to others when Export Control status updated',
        'Export Control {EC_NUMBER} {EC_TITLE} is now in {EC_STATUS_NAME} status.',
        '<p>The export control {EC_NUMBER}: {PROJECT_TYPE_NAME} {EC_TITLE} is now in the status {EC_STATUS_NAME}.</p><p>Lead Unit: {LEAD_UNIT_NAME} ({LEAD_UNIT_NUMBER})</p><p>{SPONSOR_NAME} ({SPONSOR_CODE})</p><p>Related Project Personnel:</p><p>{PROJECT_PERSONNEL_NAMES}</p><p>Associated research activities:</p><p>{EC_ASSOCIATIONS_LIST}</p><p>If you have questions about this email, please contact the export control officer.</p>',
        'N', 'Y', 'admin', now(), 1, uuid());

INSERT INTO SEQ_NTFCTN_MODULE_ROLE_ID VALUES (NULL);
INSERT INTO NOTIFICATION_MODULE_ROLE (NOTIFICATION_MODULE_ROLE_ID, MODULE_CODE, ROLE_NAME, OBJ_ID, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER)
VALUES ((SELECT (MAX(ID)) FROM SEQ_NTFCTN_MODULE_ROLE_ID), 12, 'KC-EXCON:PI', UUID(), 1, NOW(), 'admin');

INSERT INTO SEQ_NOTIFICATION_TYPE_ID VALUES (NULL);
INSERT INTO NOTIFICATION_TYPE_RECIPIENT (NOTIFICATION_TYPE_RECIPIENT_ID, NOTIFICATION_TYPE_ID, ROLE_NAME, UPDATE_USER, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_NOTIFICATION_TYPE_ID), (SELECT NOTIFICATION_TYPE_ID FROM NOTIFICATION_TYPE WHERE MODULE_CODE = 12 AND ACTION_CODE = '-3'),
        'KC-EXCON:PI', 'admin', now(), 1, uuid());

INSERT INTO SEQ_NTFCTN_MDL_ROLE_QLFR_ID VALUES (NULL);
INSERT INTO NOTIFICATION_MDL_ROLE_QLFR (NOTIFICATION_MDL_ROLE_QLFR_ID, NOTIFICATION_MODULE_ROLE_ID, OBJ_ID, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, QUALIFIER)
VALUES ((SELECT (MAX(ID)) FROM SEQ_NTFCTN_MDL_ROLE_QLFR_ID), (SELECT NOTIFICATION_MODULE_ROLE_ID FROM NOTIFICATION_MODULE_ROLE WHERE ROLE_NAME = 'KC-EXCON:PI'),
        uuid(), 1, now(), 'admin', 'exportControl');

CREATE TABLE `excon_notification`
(
    `NOTIFICATION_ID`       decimal(20, 0) NOT NULL DEFAULT '0',
    `NOTIFICATION_TYPE_ID`  decimal(6, 0)  NOT NULL,
    `DOCUMENT_NUMBER`       varchar(40)    NOT NULL,
    `OWNING_DOCUMENT_ID_FK` decimal(22, 0) NOT NULL,
    `RECIPIENTS`            varchar(1000)           DEFAULT NULL,
    `SUBJECT`               varchar(1000)           DEFAULT NULL,
    `MESSAGE`               varchar(4000)           DEFAULT NULL,
    `UPDATE_USER`           varchar(60)    NOT NULL,
    `UPDATE_TIMESTAMP`      datetime       NOT NULL,
    `CREATE_TIMESTAMP`      datetime       NOT NULL,
    `VER_NBR`               decimal(8, 0)  NOT NULL DEFAULT '1',
    `OBJ_ID`                varchar(36)    NOT NULL,
    PRIMARY KEY (`NOTIFICATION_ID`),
    KEY `FK1_EXCON_NOTIFICATION` (`OWNING_DOCUMENT_ID_FK`),
    KEY `FK2_EXCON_NOTIFICATION` (`NOTIFICATION_TYPE_ID`),
    CONSTRAINT `FK1_EXCON_NOTIFICATION` FOREIGN KEY (`OWNING_DOCUMENT_ID_FK`) REFERENCES `excon_project` (`PROJECT_ID`),
    CONSTRAINT `FK2_EXCON_NOTIFICATION` FOREIGN KEY (`NOTIFICATION_TYPE_ID`) REFERENCES `notification_type` (`NOTIFICATION_TYPE_ID`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_bin;