-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

delimiter /
TRUNCATE TABLE QUESTION
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (1,1,1,'C','Does this project involve human subjects?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (5,2,1,'C','Does this project involve animal subjects?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (9,3,1,'C','Are you involved in recruiting and/or obtaining consent of human subjects to participate in this study?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (13,4,1,'C','Will the entity provide a drug, device, vaccine or procedure for use in the protocol?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (17,5,1,'C','Are you the inventor of any drug, device, vaccine or procedure associated with this protocol?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (21,6,1,'C','Will Non-University Investigators be involved with the PI or Co-PI in the design, conduct or reporting of the activities associated with the project (e.g., subcontractors, consultants, others with significant responsibilities)?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (25,7,1,'C','Please explain where we can find the institutions'' policies that indicate compliance with the funding agency''s regulations.  You may also attach materials and enter "See attached".',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (29,8,1,'C','Please indicate the protocol number.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Lookup'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A','org.kuali.kra.irb.Protocol','protocolNumber',null,1,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (33,9,1,'C','Please indicate the name of the drug, device, vaccine or procedure.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,50,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (37,10,1,'C','Are you a consultant with this entity?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (41,11,1,'C','Do you have a written consulting agreement (non-University agreement) with this entity?  If yes, please attach a copy of the agreement to this report.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (45,12,1,'C','Please describe in detail the frequency and nature of your consulting activities with this entity.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (49,13,1,'C','Will the terms of your consulting in any way restrict the release of information or other dissemination of research results by faculty/researchers involved in the project?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (53,14,1,'C','Do you, your spouse, registered domestic partner, or any dependent child(ren) hold a position of management or employment with this entity?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (57,15,1,'C','Please indicate the positions held.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,7,7,50,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (61,16,1,'C','Please describe the responsibilities of your position(s) with the entity and how they relate to the project funded by the entity.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (65,17,1,'C','Do you, your spouse, registered domestic partner, or any dependent child(ren) hold an equity interest in this entity?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (69,18,1,'C','Please indicate the type of equity interest that you, your spouse, registered domestic partner, or any dependent child(ren) have in this entity.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,4,4,50,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (73,19,1,'C','Is the equity publicly traded?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (77,20,1,'C','What is the current total market value of the equity you, your spouse, registered domestic partner, and any dependent children hold in this entity?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,50,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (81,21,1,'C','Please provide an internal estimate of the value of the equity.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,50,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (85,22,1,'C','Please indicate the total percentage of equity held in this entity.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Number'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,3,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (89,23,1,'C','For non-governmental sponsored projects, is the entity supporting full direct and indirect costs of this project? If a gift or Material Transfer Agreement indicate "Not Applicable."',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No/NA'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (93,24,1,'C','List any other entity funding this research and their amount of support. Also identify any University funds that will be supplementing the project.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (97,25,1,'C','Will the research be conducted in the entity''s facilities?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (101,26,1,'C','How many hours per week will be spent in the entity''s facilities?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,50,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (105,27,1,'C','Will any of the entity''s personnel work on the research?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (109,28,1,'C','Please explain what the entities'' personnel will be doing on the research.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (113,29,1,'C','Please indicate the amount received in the past 12 months.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,50,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (117,30,1,'C','Please explain.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (121,31,1,'C','Have you received honoraria income from the entity?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (125,32,1,'C','Please describe the nature and frequency of your activities with this entity.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (129,33,1,'C','Are your activities with this entity related to the subject of the proposed research?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (133,34,1,'C','Please describe how activities with this entity are related to the subject of the proposed research.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (137,35,1,'C','Is entity a subcontractor, consortium member, supplier of goods, lessor, or otherwise involved with the project?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (141,36,1,'C','Please explain how they are involved with the project.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (145,37,1,'C','Are you the inventor of any device, vaccine, procedure, drug or any other product associated with this research?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (149,38,1,'C','Does the entity manufacture or commercialize any device, vaccine, procedure, drug or any other product associated with this research?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (151,39,1,'C','Please explain what the entity does that is associated with this research.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (155,40,1,'C','Is it reasonable to anticipate that the entity will be, or could be, directly and significantly affected by the design, conduct or reporting of the research activity?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (159,41,1,'C','Please explain how the entity might be impacted by the design, conduct or reporting of the research activity.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (163,42,1,'C','Is the entity a non-profit foundation?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (167,43,1,'C','Do you have a financial interest in the company(ies) that is (are) providing funds to this non-profit foundation?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (171,44,1,'C','If the sponsoring foundation is primarily a vehicle for one or two companies or a closely cooperating group of businesses, please identify these firms:',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (175,45,1,'C','Will the project purchase/lease any device/material from the entity?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (179,46,1,'C','Please provide name of any devices/materials and approximate cost.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (183,47,1,'C','Excluding gifts, contracts or grants administered by the University, have you, your spouse, registered domestic partner or dependent child(ren) received income from this entity in the past 12 months?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (187,48,1,'C','Please indicate the nature of income you received from this entity.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,4,4,50,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (191,49,1,'C','Please explain how you are keeping your interests and obligations to the entity separate from your University activities.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (195,50,1,'C','Were you part of a formal committee/body that made the decision which led to the award?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (199,51,1,'C','Were you present when the decision which led to the award was made?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (203,52,1,'C','Please describe the proceedings or enter "see attachment" and upload a copy of the minutes.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (207,53,1,'C','Does the project involves testing of any drugs or devices or the development of a product?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (211,54,1,'C','Briefly describe the research project (or enter "see attachment" and upload a statement of work/abstract).',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (215,55,1,'C','Provide a detailed description of the research project (or enter "see attachment" and upload a statement of work/abstract).',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (219,56,1,'C','Is the entity providing any proprietary data, materials or equipment?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (223,57,1,'C','Explain what control on access to the research will be necessary.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (227,58,1,'C','Does the entity participate in deciding the direction of the research?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (231,59,1,'C','Please explain what role the entity will play in participating or deciding the direction of the research.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (235,60,1,'C','For non-governmental sponsored projects: Will the contract, grant or gift that will fund this research require the granting of an exclusive license or option to the entity?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (239,61,1,'C','Please explain how it is documented in a research agreement or clinical trial agreement:',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (243,62,1,'C','Does the entity hold rights in a pending patent application/issued patent/copyright in which you, your spouse, registered domestic partner, or domestic child(ren) are inventor(s)/author(s)?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (247,63,1,'C','Has the entity licensed rights from the University?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (251,64,1,'C','Please indicate the invention/copyright disclosure number.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,50,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (255,65,1,'C','Does the entity have ownership rights?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (259,66,1,'C','Please explain how the entity acquired ownership rights.',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (263,67,1,'C','Does the entity have ownership rights on existing intellectual property?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (267,68,1,'C','Are any undergraduate, graduate or postdoctoral students involved in the project?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (271,69,1,'C','How many undergraduates, graduates and/or postdocs are involved and in what capacity?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Text'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,1,1,1000,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (275,70,1,'C','Are there any constraints or restrictions imposed on the reporting of student work?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (279,71,1,'C','Are you the advisor to any of these students?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (283,72,1,'C','Do you hold a position (such as board member, scientific advisor, director, officer, partner, trustee or employee) with any single business entity that could reasonably appear to benefit by the proposed research?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (287,73,1,'C','Do you have an equity interest (stock, stock options, real estate, investment or other ownership) with any single business entity that could reasonably appear to benefit by the proposed research?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (291,74,1,'C','Do you receive income (such as consulting fees, honoraria, travel reimbursement, or other income) from any single business entity that could reasonably appear to benefit by the proposed research?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (295,75,1,'C','Do you have rights to a pending application or issued patent to an invention(s), license rights, or copyright for software that has a direct relationship to the project?',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Yes/No'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'IRB'),'A',null,null,null,null,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (301,76,1,'C','State:',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Lookup'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'Others'),'A','org.kuali.rice.kns.bo.StateImpl','postalStateName',null,1,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (305,77,1,'C','Country:',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Lookup'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'Others'),'A','org.kuali.rice.kns.bo.CountryImpl','postalCountryName',null,1,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (309,78,1,'C','Start Date:',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Date'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'Others'),'A',null,null,1,1,null,'admin',NOW(),UUID(),1)
/
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,QUESTION_TYPE_ID,GROUP_TYPE_CODE,STATUS,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (313,79,1,'C','End Date:',(SELECT QUESTION_TYPE_ID FROM QUESTION_TYPES WHERE QUESTION_TYPE_NAME = 'Date'),(SELECT GROUP_TYPE_CODE FROM GROUP_TYPES WHERE GROUP_NAME = 'Others'),'A',null,null,1,1,null,'admin',NOW(),UUID(),1)
/
delimiter ;
