-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

-- Development Proposal updates --

-- EPS_PROP_EXEMPT_NUMBER --

ALTER TABLE EPS_PROP_EXEMPT_NUMBER 
DROP FOREIGN KEY FK_EPS_PROP_EXEMPT_NUMBER_KRA;

ALTER TABLE EPS_PROP_EXEMPT_NUMBER 
DROP PRIMARY KEY;

ALTER TABLE EPS_PROP_EXEMPT_NUMBER 
ADD (PROPOSAL_EXEMPT_NUMBER_ID DECIMAL(12, 0) NOT NULL,
    PROPOSAL_SPECIAL_REVIEW_ID DECIMAL(12, 0) NOT NULL);

CREATE TABLE SEQ_EPS_PROP_EXEMPT_NUMBER_ID
(
    id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM;

-- EPS_PROP_SPECIAL_REVIEW --

ALTER TABLE EPS_PROP_SPECIAL_REVIEW
DROP FOREIGN KEY FK_EPS_PROP_SPECIAL_REVIEW_KRA;

ALTER TABLE EPS_PROP_SPECIAL_REVIEW 
DROP PRIMARY KEY;

ALTER TABLE EPS_PROP_SPECIAL_REVIEW 
ADD (PROPOSAL_SPECIAL_REVIEW_ID DECIMAL(12, 0));

CREATE TABLE SEQ_EPS_PROP_SPECIAL_REVIEW_ID
(
    id bigint(19) not null auto_increment, primary key (id) 
) ENGINE MyISAM;

DROP PROCEDURE IF EXISTS sp;
DELIMITER //
CREATE PROCEDURE sp()
BEGIN
IF EXISTS (SELECT * FROM EPS_PROP_SPECIAL_REVIEW) THEN
    select @spnum := null;
    UPDATE EPS_PROP_SPECIAL_REVIEW SET PROPOSAL_SPECIAL_REVIEW_ID = @spnum := if(@spnum is null,1,@spnum + 1);
    INSERT INTO SEQ_EPS_PROP_SPECIAL_REVIEW_ID values (@spnum + 1);
END IF;
END //
DELIMITER ;
call sp ();
DROP PROCEDURE IF EXISTS sp;

DROP PROCEDURE IF EXISTS ex;
DELIMITER //
CREATE PROCEDURE ex()
BEGIN
IF EXISTS (SELECT * FROM EPS_PROP_EXEMPT_NUMBER) THEN
     SET @exnum := null;
     UPDATE EPS_PROP_EXEMPT_NUMBER SET PROPOSAL_EXEMPT_NUMBER_ID = @exnum := if(@exnum is null,1,@exnum + 1);
     INSERT INTO SEQ_EPS_PROP_EXEMPT_NUMBER_ID VALUES (@exnum + 1);
END IF;
END //
DELIMITER ;
call ex ();
DROP PROCEDURE IF EXISTS ex;

UPDATE EPS_PROP_EXEMPT_NUMBER EN
SET PROPOSAL_SPECIAL_REVIEW_ID =
(SELECT PROPOSAL_SPECIAL_REVIEW_ID
FROM EPS_PROP_SPECIAL_REVIEW SR 
WHERE SR.PROPOSAL_NUMBER = EN.PROPOSAL_NUMBER
AND SR.SPECIAL_REVIEW_NUMBER = EN.SPECIAL_REVIEW_NUMBER);

ALTER TABLE EPS_PROP_SPECIAL_REVIEW 
MODIFY PROPOSAL_SPECIAL_REVIEW_ID DECIMAL(12,0) NOT NULL;
    
ALTER TABLE EPS_PROP_SPECIAL_REVIEW
ADD CONSTRAINT EPS_PROP_SPECIAL_REVIEWP1 PRIMARY KEY (PROPOSAL_SPECIAL_REVIEW_ID);

ALTER TABLE EPS_PROP_SPECIAL_REVIEW
ADD CONSTRAINT FK_EPS_PROP_SPECIAL_REVIEW_KRA FOREIGN KEY (PROPOSAL_NUMBER) 
REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);

ALTER TABLE EPS_PROP_EXEMPT_NUMBER
ADD CONSTRAINT EPS_PROP_EXEMPT_NUMBERP1 PRIMARY KEY (PROPOSAL_EXEMPT_NUMBER_ID);

ALTER TABLE EPS_PROP_EXEMPT_NUMBER
ADD CONSTRAINT FK_EPS_PROP_SPECIAL_REVIEW FOREIGN KEY (PROPOSAL_SPECIAL_REVIEW_ID)
REFERENCES EPS_PROP_SPECIAL_REVIEW (PROPOSAL_SPECIAL_REVIEW_ID);

ALTER TABLE EPS_PROP_EXEMPT_NUMBER 
DROP COLUMN PROPOSAL_NUMBER;

ALTER TABLE EPS_PROP_EXEMPT_NUMBER 
DROP COLUMN SPECIAL_REVIEW_NUMBER;
