-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DROP PROCEDURE IF EXISTS sf;
DELIMITER //
CREATE PROCEDURE sf()
BEGIN
IF EXISTS (SELECT * FROM SPONSOR_FORMS) THEN
    select @sfnum := null;
    UPDATE SPONSOR_FORMS SET SPONSOR_FORM_ID = @sfnum := if(@sfnum is null,1,@sfnum + 1);
    INSERT INTO SEQ_SPONSOR_FORMS values (@sfnum + 1);
END IF;
END //
DELIMITER ;
call sf ();
DROP PROCEDURE IF EXISTS sf;

DROP PROCEDURE IF EXISTS sft;
DELIMITER //
CREATE PROCEDURE sft()
BEGIN
IF EXISTS (SELECT * FROM SPONSOR_FORM_TEMPLATES) THEN
    select @sftnum := null;
    UPDATE SPONSOR_FORM_TEMPLATES SET SPONSOR_FORM_TEMPLATE_ID = @sftnum := if(@sftnum is null,1,@sftnum + 1);
    INSERT INTO SEQ_SPONSOR_FORM_TEMPLATES values (@sftnum + 1);
END IF;
END //
DELIMITER ;
call sft ();
DROP PROCEDURE IF EXISTS sft;

ALTER TABLE SPONSOR_FORM_TEMPLATES DROP FOREIGN KEY FK_SPONSOR_FORM_TEMPLATES;

ALTER TABLE SPONSOR_FORM_TEMPLATES MODIFY COLUMN SPONSOR_FORM_TEMPLATE_ID DECIMAL(12,0) NOT NULL, DROP PRIMARY KEY, ADD PRIMARY KEY (SPONSOR_FORM_TEMPLATE_ID);

ALTER TABLE SPONSOR_FORMS DROP FOREIGN KEY FK_SPONSOR_FORMS;
ALTER TABLE SPONSOR_FORMS MODIFY COLUMN SPONSOR_FORM_ID DECIMAL(12,0) NOT NULL, DROP PRIMARY KEY, ADD PRIMARY KEY (SPONSOR_FORM_ID);
ALTER TABLE SPONSOR_FORMS ADD CONSTRAINT SPONSOR_FORMSU1 UNIQUE (SPONSOR_CODE, SPONSOR_HIERARCHY_NAME, PACKAGE_NUMBER);
ALTER TABLE SPONSOR_FORMS ADD CONSTRAINT FK_SPONSOR_FORMS FOREIGN KEY (SPONSOR_CODE) REFERENCES SPONSOR (SPONSOR_CODE);

UPDATE SPONSOR_FORM_TEMPLATES sft SET SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE = sft.SPONSOR_CODE AND PACKAGE_NUMBER = sft.PACKAGE_NUMBER);

ALTER TABLE SPONSOR_FORM_TEMPLATES ADD CONSTRAINT FK_SPONSOR_FORM_TEMPLATES FOREIGN KEY (SPONSOR_FORM_ID) REFERENCES SPONSOR_FORMS(SPONSOR_FORM_ID);
ALTER TABLE SPONSOR_FORM_TEMPLATES ADD CONSTRAINT SPONSOR_FORM_TEMPLATESU1 UNIQUE (SPONSOR_FORM_ID, PAGE_NUMBER);

ALTER TABLE SPONSOR_FORM_TEMPLATES DROP COLUMN SPONSOR_CODE, DROP COLUMN PACKAGE_NUMBER;
