-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /
DELETE FROM PROTO_CORRESP_TEMPL WHERE PROTO_CORRESP_TYPE_CODE = (SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Grant Exemption Notice')
/
commit
/
INSERT INTO SEQ_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO PROTO_CORRESP_TEMPL(PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,COMMITTEE_ID,FILE_NAME,CORRESPONDENCE_TEMPLATE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) values ((SELECT (MAX(ID)) FROM SEQ_PROTO_CORRESP_TEMPL),(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Grant Exemption Notice'),'DEFAULT','DEFAULT-17-GrantExemptionNotice.xsl',
'<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:n1="http://irb.mit.edu/irbnamespace" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="''PDF''"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="0.6in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in"/>
				<fo:region-before extent="0.79in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="headerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<!--fo:external-graphic>
								<xsl:attribute name="src">
									<xsl:text>url(</xsl:text>
									<xsl:call-template name="double-backslash">
										<xsl:with-param name="text">
											<xsl:value-of select="string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;)"/>
										</xsl:with-param>
										<xsl:with-param name="text-length">
											<xsl:value-of select="string-length(string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;))"/>
										</xsl:with-param>
									</xsl:call-template>
									<xsl:text>)</xsl:text>
								</xsl:attribute>
							</fo:external-graphic-->
							<fo:external-graphic src="url(''/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif'')" content-height="60%" content-width="60%"/>
							<fo:block text-align="center">
								<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
							</fo:block>
							<fo:block/>
							<xsl:for-each select="n1:Correspondence">
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block font-family="Arial" margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="24%"/>
											<fo:table-column column-width="76%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>To:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Investigator">
																	<xsl:if test="n1:PI_flag = &apos;true&apos;">
																		<xsl:for-each select="n1:Person">
																			<xsl:for-each select="n1:Firstname">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline font-size="10pt">
																				<xsl:text>&#160;</xsl:text>
																			</fo:inline>
																			<xsl:for-each select="n1:LastName">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			
																			<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																				<fo:block>
																					<xsl:for-each select="n1:OfficeLocation">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</fo:block>
																			</fo:block>
																		</xsl:for-each>
																	</xsl:if>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>From:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Submissions">
																	<xsl:for-each select="n1:CommitteeMember">
																		<xsl:if test="n1:CommitteeMemberRole/n1:MemberRoleDesc = &apos;Chair&apos;">
																			<xsl:for-each select="n1:Person">
																				<xsl:for-each select="n1:Firstname">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																				<!--fo:inline font-size="10pt">
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline-->
																				<xsl:for-each select="n1:LastName">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																								<fo:block font-size="10pt">
																									&#160;<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									&#160;<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
															<fo:inline font-size="10pt">
																<xsl:text>, Chair </xsl:text>
															</fo:inline>
															
															<fo:block margin="0pt">
																<fo:block>
																	<xsl:for-each select="n1:Protocol">
																		<xsl:for-each select="n1:Submissions">
																			<xsl:for-each select="n1:CommitteeMasterData">
																				<xsl:for-each select="n1:CommitteeName">
																					<xsl:if test="../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Date:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-size="10pt" padding="2pt" display-align="center">
														<fo:block>
															<xsl:for-each select="n1:CurrentDate">
																<fo:inline font-size="10pt">
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
																</fo:inline>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Committee Action:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Exemption Granted</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:block margin="0pt">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
													<fo:table-column column-width="24%"/>
													<fo:table-column column-width="76%"/>
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="before">
																<fo:block>
																	<fo:inline font-size="10pt" font-weight="bold">
																		<xsl:text>Committee Action Date:</xsl:text>
																	</fo:inline>
																	<fo:inline font-size="10pt">
																		<xsl:text>&#160;&#160;&#160;&#160; </xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell font-size="10pt" padding="2pt" display-align="before">
																<fo:block>
																	<xsl:for-each select="n1:Protocol">
																		<xsl:for-each select="n1:Submissions">
																			<xsl:for-each select="n1:SubmissionDetails">
																				<xsl:for-each select="n1:ActionType">
																					<xsl:for-each select="n1:ActionDate">
																						<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
																								<xsl:text>/</xsl:text>
																								<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
																								<xsl:text>/</xsl:text>
																								<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
																							</fo:inline>
																						</xsl:if>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline font-size="10pt" font-weight="bold">
																		<xsl:text>COUHES Protocol #: </xsl:text>
																	</fo:inline>
																	<fo:inline font-size="10pt">
																		<xsl:text>&#160;&#160;&#160; </xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="2pt" display-align="before">
																<fo:block>
																	<xsl:for-each select="n1:Protocol">
																		<xsl:for-each select="n1:ProtocolMasterData">
																			<xsl:for-each select="n1:ProtocolNumber">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline font-size="10pt" font-weight="bold">
																		<xsl:text>Study Title: </xsl:text>
																	</fo:inline>
																	<fo:inline font-size="10pt">
																		<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="2pt" display-align="before">
																<fo:block>
																	<xsl:for-each select="n1:Protocol">
																		<xsl:for-each select="n1:ProtocolMasterData">
																			<xsl:for-each select="n1:ProtocolTitle">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:block>
									</fo:block>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:block>
											<fo:leader leader-pattern="space"/>
										</fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:block margin="0pt">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block margin="0pt">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>The above-referenced protocol is considered exempt after review by the Committee on the Use of Humans as Experimental Subjects pursuant to Federal regulations, 45 CFR Part 46.101(b)</xsl:text>
														</fo:inline>
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:SubmissionDetails">
																	<xsl:for-each select="n1:SubmissionChecklistInfo">
																		<xsl:for-each select="n1:ChecklistCodesFormatted">
																			<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:if>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
														<fo:inline font-size="10pt">
															<xsl:text>.</xsl:text>
														</fo:inline>
														<fo:block/>
														<fo:block>
															<fo:leader leader-pattern="space"/>
														</fo:block>
														<fo:inline-container>
															<fo:block>
																<xsl:text>&#x2029;</xsl:text>
															</fo:block>
														</fo:inline-container>
														<fo:block font-size="10pt" margin="0pt">
															<fo:block>
																<fo:block/>
																<fo:inline font-family="Arial" font-size="10pt">
																	<xsl:text>This part of the federal regulations requires that the information be recorded by investigators in such a manner that subjects cannot be identified, directly or through identifiers linked to the subjects.&#160;&#160; It is necessary that the information obtained not be such that if disclosed outside the research, it could reasonably place the subjects at risk of criminal or civil liability, or be damaging to the subjects&apos; financial standing, employability, or reputation.</xsl:text>
																</fo:inline>
																<fo:block/>
																<fo:block font-family="Arial" space-before="5mm">
																	<xsl:text>If the research involves collaboration with another institution then the research cannot commence until COUHES receives written notification of approval from the collaborating institution&apos;s IRB.</xsl:text>
																</fo:block>
																<fo:block/>
																<fo:block font-family="Arial" space-before="5mm">
																	<xsl:text>If there are any changes to the protocol that significantly or substantially impact the rights of human subjects you must notify the Committee before those changes are initiated. You should retain a copy of this letter for your records. </xsl:text>
																</fo:block>
																<fo:block/>
																<fo:inline>
																	<xsl:text>
</xsl:text>
																</fo:inline>
																<fo:block/>
															</fo:block>
														</fo:block>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:block>
									</fo:block>
								  </fo:block>
								<fo:block/>
								<fo:block/>
								<fo:block/>
								<fo:block/>
								<fo:block/>
								<fo:block/>
								<fo:block/>
								<fo:block/>
								<fo:block/>
								<fo:block/>
								<fo:inline>
									<xsl:text>&#160;&#160;&#160;&#160; </xsl:text>
								</fo:inline>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table table-layout="fixed" width="50%" border-spacing="2pt">
									<fo:table-column column-width="437"/>
									<fo:table-column column-width="303"/>
									<fo:table-body start-indent="0pt">
										<fo:table-row>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block>
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x2029;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<fo:table table-layout="fixed" width="100" border-spacing="2pt">
														<fo:table-column column-width="27"/>
														<fo:table-column column-width="452"/>
														<fo:table-body start-indent="0pt">
															<fo:table-row>
																<fo:table-cell padding="2pt" display-align="center">
																	<fo:block/>
																</fo:table-cell>
																<fo:table-cell padding="2pt" display-align="before">
																	<fo:block>
																		<xsl:for-each select="n1:Protocol">
																			<xsl:for-each select="n1:Correspondent">
																				<xsl:for-each select="n1:Person">
																					<xsl:for-each select="n1:Fullname">
																						<xsl:if test="../../n1:TypeOfCorrespondent = &apos;CRC&apos;">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																									<fo:block font-family="Arial" font-size="10pt">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline font-family="Arial" font-size="10pt">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:if>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
														</fo:table-body>
													</fo:table>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
								<fo:block/>
								<fo:block/>
								<fo:block/>
								<fo:block/>
								<fo:inline font-family="Arial" font-size="10pt">
									<xsl:text>&#160;&#160; </xsl:text>
								</fo:inline>
								<fo:block/>
								<fo:block/>
								<fo:block/>
								<fo:block/>
								<fo:inline font-size="10pt">
									<xsl:text>
</xsl:text>
								</fo:inline>
							</xsl:for-each>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="headerall">
		<fo:static-content flow-name="xsl-region-before">
			<fo:block>
				<xsl:for-each select="$XML">
					<fo:inline-container>
						<fo:block>
							<xsl:text>&#x2029;</xsl:text>
						</fo:block>
					</fo:inline-container>
					<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-column column-width="150"/>
						<fo:table-body start-indent="0pt">
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" height="30" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-size="smaller" padding="0" text-align="left" display-align="center">
									<fo:block/>
								</fo:table-cell>
								<fo:table-cell font-size="smaller" padding="0" text-align="right" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</xsl:for-each>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>','admin',NOW(),UUID(),1)
/
commit
/
DELIMITER ;
