-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /

alter table AWARD_BUDGET_EXT add AWARD_ID decimal(22,0)
/

update AWARD_BUDGET_EXT budget set AWARD_ID = (select award.AWARD_ID from AWARD award left join BUDGET_DOCUMENT budgetdoc on award.document_number = budgetdoc.parent_document_key where budget.DOCUMENT_NUMBER = budgetdoc.DOCUMENT_NUMBER)
/

-- in the case an award could not be found, which indicates the award was deleted, save invalid records into orphan table and then delete them
create table AWARD_BUDGET_EXT_ORPHAN like AWARD_BUDGET_EXT
/
create table award_budget_limit_orphan like award_budget_limit
/
	
insert into award_budget_limit_orphan select * from award_budget_limit where budget_id in (select budget_id from award_budget_ext where award_id is null)
/
	
insert into AWARD_BUDGET_EXT_ORPHAN select * from AWARD_BUDGET_EXT where AWARD_ID is null
/

delete from award_budget_limit where budget_id in (select budget_id from award_budget_ext where award_id is null)
/

delete from AWARD_BUDGET_EXT where AWARD_ID is null
/

alter table AWARD_BUDGET_EXT modify AWARD_ID decimal(22,0) not null
/

DELIMITER ;
