-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /
INSERT INTO SEQ_SPONSOR_FORM_TEMPLATES VALUES(NULL)
/
INSERT INTO SPONSOR_FORM_TEMPLATES (SPONSOR_FORM_TEMPLATE_ID,SPONSOR_FORM_ID,PAGE_NUMBER,PAGE_DESCRIPTION,FILE_NAME,CONTENT_TYPE,FORM_TEMPLATE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_SPONSOR_FORM_TEMPLATES),(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)'),14,'Checklist','Checklist.xslt','text/xml',
'<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:common="http://era.nih.gov/Projectmgmt/SBIR/CGAP/common.namespace" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:nih="http://era.nih.gov/Projectmgmt/SBIR/CGAP/nihspecific.namespace" xmlns:phs398="http://era.nih.gov/Projectmgmt/SBIR/CGAP/phs398.namespace" xmlns:rar="http://era.nih.gov/Projectmgmt/SBIR/CGAP/researchandrelated.namespace" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
<xsl:param name="SV_OutputFormat" select="''PDF''"/>
<xsl:variable name="XML" select="/"/>
<xsl:variable name="fo:layout-master-set">
<fo:layout-master-set>
<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.4in" margin-right="0.4in">
<fo:region-body margin-top="0.5in" margin-bottom="0.45in"/>
<fo:region-before extent="0.5in"/>
<fo:region-after extent="0.45in"/>
</fo:simple-page-master>
</fo:layout-master-set>
</xsl:variable>
<xsl:template match="/">
<fo:root>
<xsl:copy-of select="$fo:layout-master-set"/>
<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
<xsl:call-template name="headerall"/>
<xsl:call-template name="footerall"/>
<fo:flow flow-name="xsl-region-body">
<fo:block>
<xsl:for-each select="$XML">
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-body start-indent="0pt">
<fo:table-row>
<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-weight="bold">
<xsl:text>CHECKLIST</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-body>
</fo:table>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:table font-size="8pt" table-layout="fixed" width="100%" border-spacing="2pt">
<fo:table-column column-width="50%"/>
<fo:table-column column-width="20%"/>
<fo:table-column column-width="20%"/>
<fo:table-body start-indent="0pt">
<fo:table-row>
<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>TYPE OF APPLICATION </xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>(check all that apply.)</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
<fo:block>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicationCategory/CategoryIdentifier !=&apos;New&apos;">
<fo:inline>
<xsl:text>___</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicationCategory/CategoryIdentifier =&apos;New&apos;">
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>__ </xsl:text>
</fo:inline>
</xsl:when>
</xsl:choose>
<fo:inline font-family="Verdana" font-size="8pt" margin-bottom="0pt">
<xsl:text>NEW application. (This application is being submitted to the PHS for the first time.)</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="9pt" line-height="9pt" padding="2pt" height="8" display-align="before">
<fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block font-size="9pt" line-height="9pt" margin="0pt">
<fo:block>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicationCategory/CategoryIdentifier != &apos;Resubmission&apos;">
<fo:inline>
<xsl:text>___</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicationCategory/CategoryIdentifier = &apos;Resubmission&apos;">
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
</xsl:choose>
<fo:inline margin-bottom="0pt">
<xsl:text>&#160; </xsl:text>
</fo:inline>
<fo:inline font-size="8pt" margin-bottom="0pt">
<xsl:text>RESUBMISSION </xsl:text>
</fo:inline>
<fo:inline margin-bottom="0pt">
<xsl:text>of application number: </xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="before">
<fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nihPriorGrantNumber">
<xsl:if test="../nih:ResearchCoverPage/ApplicationCategory/CategoryIdentifier =&apos;Revision&apos; or 
../nih:ResearchCoverPage/ApplicationCategory/CategoryIdentifier = &apos;Resubmission&apos;">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-size="8pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-size="8pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>&#160; (This application replaces a prior unfunded version of a new, renewal, or revision application.)</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="9pt" line-height="9pt" padding="2pt" display-align="before">
<fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block font-size="9pt" line-height="9pt" margin="0pt">
<fo:block>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicationCategory/CategoryIdentifier !=&apos;Continuation&apos; and nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicationCategory/CategoryIdentifier !=&apos;Renewal&apos;">
<fo:inline>
<xsl:text>__</xsl:text>
</fo:inline>
<fo:inline margin-bottom="0pt">
<xsl:text>_ </xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicationCategory/CategoryIdentifier =&apos;Continuation&apos; or nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicationCategory/CategoryIdentifier =&apos;Renewal&apos;">
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
</xsl:choose>
<fo:inline margin-bottom="0pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-size="8pt" margin-bottom="0pt">
<xsl:text>RENEWAL of grant number:</xsl:text>
</fo:inline>
<fo:inline margin-bottom="0pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="before">
<fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nihPriorGrantNumber">
<xsl:if test="../nih:ResearchCoverPage/ApplicationCategory/CategoryIdentifier =&apos;Competing Continuation&apos; or ../nih:ResearchCoverPage/ApplicationCategory/CategoryIdentifier =&apos;Renewal&apos;">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-size="8pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-size="8pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>&#160; (This application is to extend a funded grant beyond its current project period.)</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" line-height="6pt" padding="2pt" display-align="before">
<fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="6pt" margin="0pt">
<fo:block>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicationCategory/CategoryIdentifier !=&apos;Revision&apos;">
<fo:inline>
<xsl:text>___</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicationCategory/CategoryIdentifier =&apos;Revision&apos;">
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
</xsl:choose>
<fo:inline margin-bottom="0pt">
<xsl:text>&#160; REVISION to grant number: </xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="before">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nihPriorGrantNumber">
<xsl:if test="../nih:ResearchCoverPage/ApplicationCategory/CategoryIdentifier = &apos;Supplement&apos;">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block>
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline>
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>&#160; (This application is for additional funds to supplement a currently funded grant.)</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" line-height="6pt" number-columns-spanned="3" padding="2pt" display-align="center">
<fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="6pt" margin="0pt">
<fo:block>
<fo:inline>
<xsl:text>___ CHANGE of program director/principal investigator.</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell padding="2pt" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>&#160;&#160;&#160;&#160; Name of former program director/principal investigator.</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" line-height="6pt" number-columns-spanned="2" padding="2pt" display-align="center">
<fo:block/>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" line-height="6pt" padding="2pt" display-align="before">
<fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="6pt" margin="0pt">
<fo:block>
<fo:inline>
<xsl:text>___ CHANGE of Grantee Institution</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" line-height="6pt" number-columns-spanned="2" padding="2pt" display-align="before">
<fo:block>
<fo:inline>
<xsl:text>Name of former institution:</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" line-height="6pt" padding="2pt" display-align="before">
<fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="6pt" margin="0pt">
<fo:block>
<fo:inline>
<xsl:text>___ FOREIGN application</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" padding="2pt" display-align="before">
<fo:block>
<fo:inline>
<xsl:text>&#160;&#160; __ Domestic Grant with&#160; foreign involvement&#160;&#160; </xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" padding="2pt" display-align="before">
<fo:block>
<fo:inline>
<xsl:text>List country(ies) involved: </xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-body>
</fo:table>
<fo:inline font-size="8pt">
<xsl:text>INVENTIONS AND PATENTS (Renewal appl. only)&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nihInventions">
<xsl:choose>
<xsl:when test="string(.)=''X''">
<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:otherwise>
<fo:inline border="solid 1pt black">
<fo:leader leader-length="10pt" leader-pattern="space"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<fo:inline font-size="8pt">
<xsl:text>No&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nihInventions">
<xsl:choose>
<xsl:when test="string(.)=''true''">
<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt " width="21px">
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="string(.)=''1''">
<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt " width="21px">
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="string(.)=''Y''">
<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt " width="21px">
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="string(.)=''N''">
<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt " width="21px">
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:otherwise>
<fo:inline border="1" width="21px">
<fo:leader leader-length="10pt" leader-pattern="space"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<fo:inline font-size="8pt">
<xsl:text>Yes</xsl:text>
</fo:inline>
<fo:block/>
<fo:inline font-size="8pt">
<xsl:text>If &quot;Yes,&quot;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nihInventions">
<xsl:choose>
<xsl:when test="string(.)=''Y''">
<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:otherwise>
<fo:inline border="solid 1pt black">
<fo:leader leader-length="10pt" leader-pattern="space"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<fo:inline font-size="8pt">
<xsl:text>Previously reported&#160;&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nihInventions">
<xsl:choose>
<xsl:when test="string(.)=''N''">
<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:otherwise>
<fo:inline border="solid 1pt black">
<fo:leader leader-length="10pt" leader-pattern="space"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<fo:inline font-size="8pt">
<xsl:text> Not previously reported&#160; </xsl:text>
</fo:inline>
<fo:block/>
<fo:block text-align="center">
<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
</fo:block>
<fo:inline font-size="8pt" font-weight="bold">
<xsl:text>1.&#160; PROGRAM INCOME (See instructions.)</xsl:text>
</fo:inline>
<fo:block/>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block font-family="Verdana" font-size="8pt" margin="0pt">
<fo:block>
<fo:inline>
<xsl:text>All applications must indicate whether program income is anticipated during the period(s) for which grant support is requested. If program income is anticipated, use the format below to reflect the amount and source(s).</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
<xsl:if test="count(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod/ProgramIncomeDetails/AnticipatedAmount ) = 0">
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:table font-family="Verdana" font-size="9pt" font-weight="bold" table-layout="fixed" width="100%" border-spacing="2pt">
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-body start-indent="0pt">
<fo:table-row>
<fo:table-cell padding="2pt" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt" font-weight="bold">
<xsl:text>No Program Income Anticipated.</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-body>
</fo:table>
</xsl:if>
<xsl:if test="count( nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod/ProgramIncomeDetails/AnticipatedAmount ) != 0">
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-body start-indent="0pt">
<fo:table-row>
<fo:table-cell padding="2pt" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="9pt" font-weight="bold">
<xsl:text>See Attached.</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-body>
</fo:table>
</xsl:if>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline font-size="8pt" font-weight="bold">
<xsl:text>2. ASSURANCES/CERTIFICATIONS (See instructions.)</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-body start-indent="0pt">
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" number-columns-spanned="2" padding="2pt" display-align="before">
<fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block font-family="Verdana" font-size="8pt" margin="0pt">
<fo:block>
<fo:inline>
<xsl:text>In signing the application Face Page, the authorized organizational representative agrees to comply with the policies, assurances and/or certifications listed in the application instructions when applicable. Descriptions of individual assurances/certifications are provided in Part III and listed in Part 1, 4.1 under Item 14.&#160; If unable to certify compliance, where applicable, provide an explanation and place it after this page.</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-body>
</fo:table>
<fo:block text-align="center">
<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
</fo:block>
<fo:inline font-size="8pt" font-weight="bold">
<xsl:text>3. FACILITIES AND ADMINISTRATION COSTS (F &amp; A)/INDIRECT COSTS.</xsl:text>
</fo:inline>
<fo:inline font-size="8pt">
<xsl:text> See specific instructions</xsl:text>
</fo:inline>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:table font-size="8pt" table-layout="fixed" width="100%" border-spacing="2pt">
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-column column-width="1in"/>
<fo:table-body start-indent="0pt">
<fo:table-row>
<fo:table-cell font-size="8pt" padding="2pt" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/BudgetSummary/IndirectCostRateDetails/DHHSAgreementDate = true()">
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:otherwise>
<fo:inline>
<xsl:text>_</xsl:text>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
<fo:inline>
<xsl:text> DHHS Agreement dated:&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="IndirectCostRateDetails">
<xsl:for-each select="DHHSAgreementDate">
<fo:inline font-weight="bold">
<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
<xsl:text>/</xsl:text>
<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
<xsl:text>/</xsl:text>
<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
</fo:inline>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>___</xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160;&#160; No Facilities and Administration Costs Requested.</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/BudgetSummary/IndirectCostRateDetails/DHHSAgreementNegotiationOffice =true()">
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:otherwise>
<fo:inline>
<xsl:text>_</xsl:text>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
<fo:inline>
<xsl:text>&#160; DHHS Agreement being negotiated with </xsl:text>
</fo:inline>
<fo:inline font-weight="bold">
<xsl:text>____</xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="IndirectCostRateDetails">
<xsl:for-each select="DHHSAgreementNegotiationOffice">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-weight="bold" text-decoration="underline">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-weight="bold" text-decoration="underline">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
<fo:inline font-weight="bold">
<xsl:text>__________</xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160; Regional Office.</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell number-columns-spanned="2" padding="2pt" text-align="left" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/BudgetSummary/IndirectCostRateDetails/NoDHHSAgreement/AgencyName =true()">
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:otherwise>
<fo:inline>
<xsl:text>_</xsl:text>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
<fo:inline>
<xsl:text> No DHHS Agreement , but rate established with:</xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="IndirectCostRateDetails">
<xsl:for-each select="NoDHHSAgreement">
<xsl:for-each select="AgencyName">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block text-decoration="underline">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline text-decoration="underline">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
<fo:inline>
<xsl:text>&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell padding="2pt" text-align="left" display-align="before">
<fo:block>
<fo:inline>
<xsl:text>Date:</xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="IndirectCostRateDetails">
<xsl:for-each select="NoDHHSAgreement">
<xsl:for-each select="AgreementDate">
<fo:inline text-decoration="underline">
<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
<xsl:text>/</xsl:text>
<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
<xsl:text>/</xsl:text>
<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
</fo:inline>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-body>
</fo:table>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:table font-size="8pt" table-layout="fixed" width="100%" border-spacing="2pt">
<fo:table-column column-width="26%"/>
<fo:table-column column-width="18%"/>
<fo:table-column column-width="12%"/>
<fo:table-column column-width="13%"/>
<fo:table-column column-width="14%"/>
<fo:table-column column-width="17%"/>
<fo:table-body start-indent="0pt">
<fo:table-row>
<fo:table-cell line-height="10pt" number-columns-spanned="6" padding="2pt" height="16" text-align="left" display-align="after">
<fo:block>
<fo:inline>
<xsl:text>CALCULATION* (The entire grant application, including the Checklist, will be reproduced and provided to peer reviewers as confidential information. </xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell padding="2pt" display-align="center">
<fo:block>
<fo:inline font-size="7pt">
<xsl:text>a. Initial budget period: </xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>Amount of base $</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell padding="2pt" text-align="left" display-align="center">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID =1">
<xsl:for-each select="IndirectCostDetails/BaseAmount">
<fo:inline text-decoration="underline">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" padding="2pt" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>x Rate applied</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" padding="2pt" text-align="center" display-align="center">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID =1">
<xsl:for-each select="IndirectCostDetails/Rate">
<fo:inline text-decoration="underline">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" padding="2pt" text-align="right" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>% = F&amp;A cost $</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" padding="2pt" text-align="left" display-align="center">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID =1">
<xsl:for-each select="IndirectCostDetails/FundsRequested">
<fo:inline text-decoration="underline">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell padding="2pt" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>b.&#160; 02 year&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; Amount of base $</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell padding="2pt" text-align="right" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell padding="2pt" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>x Rate applied</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell padding="2pt" text-align="right" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell padding="2pt" text-align="right" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>% = F&amp;A cost $</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell padding="2pt" text-align="left" display-align="center">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID =2">
<xsl:for-each select="IndirectCostsTotal">
<fo:inline text-decoration="underline">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell padding="2pt" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>c.&#160; 03 year&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; Amount of base $</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell padding="2pt" text-align="right" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell padding="2pt" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>x Rate applied</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell padding="2pt" text-align="right" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell padding="2pt" text-align="right" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>% = F&amp;A cost $</xsl:text>
</fo:inline>
 </fo:block>
</fo:table-cell>
<fo:table-cell padding="2pt" text-align="left" display-align="center">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID =3">
<xsl:for-each select="IndirectCostsTotal">
<fo:inline text-decoration="underline">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell padding="2pt" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>d.&#160; 04 year&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; Amount of base $</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell padding="2pt" text-align="right" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell padding="2pt" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>x Rate applied</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell padding="2pt" text-align="right" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell padding="2pt" text-align="right" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>% = F&amp;A cost $</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell padding="2pt" text-align="left" display-align="center">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID =4">
<xsl:for-each select="IndirectCostsTotal">
<fo:inline text-decoration="underline">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell padding="2pt" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>e.&#160; 05 year&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; Amount of base $</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell padding="2pt" text-align="right" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell padding="2pt" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>x Rate applied</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell padding="2pt" text-align="right" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell padding="2pt" text-align="right" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>% = F&amp;A cost $</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell padding="2pt" text-align="left" display-align="center">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID =5">
<xsl:for-each select="IndirectCostsTotal">
<fo:inline text-decoration="underline">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-body>
</fo:table>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:table font-size="8pt" table-layout="fixed" width="100%" border-spacing="2pt">
<fo:table-column column-width="30%"/>
<fo:table-column column-width="30%"/>
<fo:table-column column-width="40%"/>
<fo:table-body start-indent="0pt">
<fo:table-row>
<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>*Check appropriate box(es):</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell padding="2pt" display-align="center">
<fo:block>
<xsl:if test="nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod/BudgetPeriodID =1 and nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=1]/IndirectCostDetails/CostType != &apos;SandW&apos;">
<fo:inline font-family="Verdana" font-size="9pt" font-weight="bold">
<xsl:text>___</xsl:text>
</fo:inline>
</xsl:if>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:for-each select="BudgetPeriodID">
<xsl:if test=". =1 and ../IndirectCostDetails/CostType =&apos;SandW&apos;">
<xsl:choose>
<xsl:when test="string(.)=''true''">
<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="string(.)=''1''">
<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:otherwise>
<fo:inline border="solid 1pt black">
<fo:leader leader-length="10pt" leader-pattern="space"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
<fo:inline>
<xsl:text> Salary and wages base</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell padding="2pt" display-align="center">
<fo:block>
<xsl:if test="nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod/BudgetPeriodID =1 and nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=1]/IndirectCostDetails/CostType != &apos;MTDC&apos;">
<fo:inline font-family="Verdana" font-size="9pt" font-weight="bold">
<xsl:text>___</xsl:text>
</fo:inline>
</xsl:if>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:for-each select="BudgetPeriodID">
<xsl:if test=". =1 and ../IndirectCostDetails/CostType =&apos;MTDC&apos;">
<xsl:choose>
<xsl:when test="string(.)=''true''">
<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="string(.)=''1''">
<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:otherwise>
<fo:inline border="solid 1pt black">
<fo:leader leader-length="10pt" leader-pattern="space"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
<fo:inline>
<xsl:text> Modified total direct cost base</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell padding="2pt" display-align="center">
<fo:block>
<xsl:if test="nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod/BudgetPeriodID =1 and (nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=1]/IndirectCostDetails/CostType = &apos;SandW&apos; or nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=1]/IndirectCostDetails/CostType = &apos;MTDC&apos;)">
<fo:inline font-family="Verdana" font-size="9pt" font-weight="bold">
<xsl:text>___</xsl:text>
</fo:inline>
</xsl:if>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:for-each select="BudgetPeriodID">
<xsl:if test=". =1 and ../IndirectCostDetails/CostType !=&apos;MTDC&apos; and ../IndirectCostDetails/CostType !=&apos;SandW&apos;">
<xsl:choose>
<xsl:when test="string(.)=''true''">
<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="string(.)=''1''">
<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:otherwise>
<fo:inline border="solid 1pt black">
<fo:leader leader-length="10pt" leader-pattern="space"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
<fo:inline>
<xsl:text> Other base (Explain)</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:for-each select="BudgetPeriodID">
<xsl:if test=". =1">
<xsl:choose>
<xsl:when test="string(.)=''true''">
<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="string(.)=''1''">
<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:otherwise>
<fo:inline border="solid 1pt black">
<fo:leader leader-length="10pt" leader-pattern="space"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
<fo:inline>
<xsl:text> Off-site, other special rate, or more than one rate involved (Explain)</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>Explanation (Attach separate sheet, if necessary.): </xsl:text>
</fo:inline>
<fo:inline font-size="9pt" font-weight="bold">
<xsl:text>SEE ATTACHED</xsl:text>
</fo:inline>
<fo:block/>
<fo:block text-align="center">
<fo:leader font-variant="normal" leader-pattern="rule" rule-thickness="1" leader-length="100%"/>
</fo:block>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-body>
</fo:table>
<fo:inline font-size="8pt" font-weight="bold">
<xsl:text>4. DISCLOSURE PERMISSION STATEMENT: </xsl:text>
</fo:inline>
<fo:inline font-size="8pt">
<xsl:text>If this application does not result in an award, is the Government permitted to disclose the title of your proposed project, and the name, address, telephone number and e-mail address of the official signing for the appliant organization, to organizations that may be interested in contacting you for further information (e.g. possible collaborations, investment)?&#160;&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ProjectDescription">
<xsl:for-each select="rar:ProjectSurvey">
<xsl:for-each select="DisclosurePermissionQuestion">
<xsl:choose>
<xsl:when test="string(.)=''true''">
<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="string(.)=''1''">
<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:otherwise>
<fo:inline border="solid 1pt black">
<fo:leader leader-length="10pt" leader-pattern="space"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-size="8pt">
<xsl:text>Yes </xsl:text>
</fo:inline>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ProjectDescription">
<xsl:for-each select="rar:ProjectSurvey">
<xsl:for-each select="DisclosurePermissionQuestion">
<xsl:choose>
<xsl:when test="string(.)=''false''">
<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="string(.)=''0''">
<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:otherwise>
<fo:inline border="solid 1pt black">
<fo:leader leader-length="10pt" leader-pattern="space"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-size="8pt">
<xsl:text>No </xsl:text>
</fo:inline>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
<fo:block/>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block font-family="Verdana" font-size="8pt" margin="0pt">
<fo:block>
<xsl:if test="boolean(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod/ProgramIncome =true() or nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod/IndirectCostDetails/BaseAmount = true())">
<fo:block break-after="page">
<fo:leader leader-pattern="space"/>
</fo:block>
</xsl:if>
<xsl:if test="count( nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod/ProgramIncomeDetails/AnticipatedAmount ) != 0">
<fo:inline font-weight="bold">
<xsl:text>Program Income</xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<fo:block/>
<xsl:for-each select="BudgetSummary">
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<xsl:if test="BudgetPeriod">
<fo:table font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-header start-indent="0pt">
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="9pt" line-height="6pt" border="solid 1pt gray" padding="2pt" display-align="before">
<fo:block>
<fo:inline>
<xsl:text>Budget Period</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="9pt" line-height="6pt" border="solid 1pt gray" padding="2pt" display-align="before">
<fo:block>
<fo:inline>
<xsl:text>Anticipated Amount</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="9pt" line-height="6pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>Source(s)</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-header>
<fo:table-body start-indent="0pt">
<xsl:for-each select="BudgetPeriod">
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="9pt" line-height="6pt" border="solid 1pt gray" padding="2pt" height="21" display-align="before">
<fo:block>
<xsl:for-each select="BudgetPeriodID">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block>
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline>
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="9pt" line-height="6pt" border="solid 1pt gray" padding="2pt" height="21" display-align="before">
<fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<xsl:if test="ProgramIncomeDetails">
<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-body start-indent="0pt">
<xsl:for-each select="ProgramIncomeDetails">
<fo:table-row>
<fo:table-cell font-size="9pt" padding="2pt" display-align="center">
<fo:block>
<xsl:for-each select="AnticipatedAmount">
<fo:inline font-family="Verdana">
<xsl:text>$</xsl:text>
</fo:inline>
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
</xsl:for-each>
</fo:table-body>
</fo:table>
</xsl:if>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="9pt" border="solid 1pt gray" padding="2pt" height="21" display-align="center">
<fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<xsl:if test="ProgramIncomeDetails">
<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-body start-indent="0pt">
<xsl:for-each select="ProgramIncomeDetails">
<fo:table-row>
<fo:table-cell font-size="9pt" padding="2pt" display-align="center">
<fo:block>
<xsl:for-each select="Sources">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block>
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline>
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
</xsl:for-each>
</fo:table-body>
</fo:table>
</xsl:if>
<fo:inline>
<xsl:text>&#160; </xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</xsl:for-each>
</fo:table-body>
</fo:table>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:if>
<fo:block/>
<fo:inline font-weight="bold">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>FACILITIES AND ADMINISTRATION COSTS (F &amp; A)/INDIRECT COSTS.</xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
<fo:block/>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID =1">
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<xsl:if test="IndirectCostDetails">
<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-header start-indent="0pt">
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" number-columns-spanned="3" border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>Budget Period 1</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>Base Amount</xsl:text>
 </fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>Rate Applied</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>Funds Requested</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-header>
<fo:table-body start-indent="0pt">
<xsl:for-each select="IndirectCostDetails">
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<xsl:for-each select="BaseAmount">
<fo:inline>
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline>
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<xsl:for-each select="Rate">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block>
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline>
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
<fo:inline>
<xsl:text>%</xsl:text>
</fo:inline>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<xsl:for-each select="FundsRequested">
<fo:inline>
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline>
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
</xsl:for-each>
</fo:table-body>
</fo:table>
</xsl:if>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID =2">
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<xsl:if test="IndirectCostDetails">
<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-header start-indent="0pt">
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" number-columns-spanned="3" border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>Budget Period 2</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>Base Amount</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>Rate Applied</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>Funds Requested</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-header>
<fo:table-body start-indent="0pt">
<xsl:for-each select="IndirectCostDetails">
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<xsl:for-each select="BaseAmount">
<fo:inline>
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline>
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<xsl:for-each select="Rate">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block>
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline>
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
<fo:inline>
<xsl:text>%</xsl:text>
</fo:inline>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<xsl:for-each select="FundsRequested">
<fo:inline>
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline>
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
</xsl:for-each>
</fo:table-body>
</fo:table>
</xsl:if>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID =3">
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<xsl:if test="IndirectCostDetails">
<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-header start-indent="0pt">
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" number-columns-spanned="3" border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>Budget Period 3</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>Base Amount</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>Rate Applied</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>Funds Requested</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-header>
<fo:table-body start-indent="0pt">
<xsl:for-each select="IndirectCostDetails">
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<xsl:for-each select="BaseAmount">
<fo:inline>
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline>
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</fo:block>
</fo:table-cell>
 <fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<xsl:for-each select="Rate">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block>
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline>
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
<fo:inline>
<xsl:text>%</xsl:text>
</fo:inline>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<xsl:for-each select="FundsRequested">
<fo:inline>
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline>
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
</xsl:for-each>
</fo:table-body>
</fo:table>
</xsl:if>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID =4">
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<xsl:if test="IndirectCostDetails">
<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-header start-indent="0pt">
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" number-columns-spanned="3" border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>Budget Period 4</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>Base Amount</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>Rate Applied</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
 <fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>Funds Requested</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-header>
<fo:table-body start-indent="0pt">
<xsl:for-each select="IndirectCostDetails">
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<xsl:for-each select="BaseAmount">
<fo:inline>
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline>
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<xsl:for-each select="Rate">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block>
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline>
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
<fo:inline>
<xsl:text>%</xsl:text>
</fo:inline>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<xsl:for-each select="FundsRequested">
<fo:inline>
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline>
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
</xsl:for-each>
</fo:table-body>
</fo:table>
</xsl:if>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID =5">
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<xsl:if test="IndirectCostDetails">
<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-header start-indent="0pt">
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" number-columns-spanned="3" border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>Budget Period 5</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>Base Amount</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>Rate Applied</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<fo:inline font-weight="bold">
<xsl:text>Funds Requested</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-header>
<fo:table-body start-indent="0pt">
<xsl:for-each select="IndirectCostDetails">
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<xsl:for-each select="BaseAmount">
<fo:inline>
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline>
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<xsl:for-each select="Rate">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block>
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline>
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
<fo:inline>
<xsl:text>%</xsl:text>
</fo:inline>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" display-align="center">
<fo:block>
<xsl:for-each select="FundsRequested">
<fo:inline>
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline>
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
 </fo:block>
</fo:table-cell>
</fo:table-row>
</xsl:for-each>
</fo:table-body>
</fo:table>
</xsl:if>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
</xsl:for-each>
</fo:block>
<fo:block id="SV_RefID_PageTotal"/>
</fo:flow>
</fo:page-sequence>
</fo:root>
</xsl:template>
<xsl:template name="headerall">
<fo:static-content flow-name="xsl-region-before">
<fo:block>
<xsl:for-each select="$XML">
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-body start-indent="0pt">
<fo:table-row>
<fo:table-cell padding="0" number-columns-spanned="2" height="18" display-align="center">
<fo:block/>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-size="9pt" padding="0" number-columns-spanned="2" text-align="left" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>Principal Investigator/Program Director (Last, first, middle): </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="nih:ProgramDirectorPrincipalInvestigator">
<xsl:for-each select="Name">
<xsl:for-each select="LastName">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block text-decoration="underline">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline text-decoration="underline">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
<fo:inline text-decoration="underline">
<xsl:text>, </xsl:text>
</fo:inline>
</xsl:for-each>
<xsl:for-each select="FirstName">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block text-decoration="underline">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline text-decoration="underline">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
<xsl:for-each select="MiddleName">
<fo:inline text-decoration="underline">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block text-decoration="underline">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline text-decoration="underline">
 <xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell padding="0" number-columns-spanned="2" height="1" display-align="center">
<fo:block/>
</fo:table-cell>
</fo:table-row>
</fo:table-body>
</fo:table>
</xsl:for-each>
</fo:block>
</fo:static-content>
</xsl:template>
<xsl:template name="footerall">
<fo:static-content flow-name="xsl-region-after">
<fo:block>
<xsl:for-each select="$XML">
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-column column-width="150"/>
<fo:table-body start-indent="0pt">
<fo:table-row>
<fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
<fo:block>
<fo:block text-align="center">
<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
</fo:block>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-size="9pt" padding="0" text-align="left" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>PHS 398 (Rev. 11/07)&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; Page: __</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-size="9pt" padding="0" text-align="right" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>Checklist Form Page</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-body>
</fo:table>
</xsl:for-each>
</fo:block>
</fo:static-content>
</xsl:template>
<xsl:template name="double-backslash">
<xsl:param name="text"/>
<xsl:param name="text-length"/>
<xsl:variable name="text-after-bs" select="substring-after($text, '''')"/>
<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
<xsl:choose>
<xsl:when test="$text-after-bs-length = 0">
<xsl:choose>
<xsl:when test="substring($text, $text-length) = ''''">
<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\'\\\'\')"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="$text"/>
</xsl:otherwise>
</xsl:choose>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\'\\\'\')"/>
<xsl:call-template name="double-backslash">
<xsl:with-param name="text" select="$text-after-bs"/>
<xsl:with-param name="text-length" select="$text-after-bs-length"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:template>
</xsl:stylesheet>','admin',NOW(),UUID(),1)
/
DELIMITER ;
