-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

INSERT INTO KRIM_PERM_ID_S
VALUES (NULL);

INSERT INTO KRIM_PERM_T (PERM_ID, OBJ_ID, VER_NBR, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND)
VALUES (concat('KC', (SELECT (MAX(ID)) FROM KRIM_PERM_ID_S)), UUID(), 1,
        (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NM = 'Recall Document'),
        'KC-AWARD', 'Recall Document', 'Recall Award Document', 'Y');

INSERT INTO KRIM_ATTR_DATA_ID_S
VALUES (NULL);

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, OBJ_ID, VER_NBR, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL)
VALUES (concat('KC', (SELECT (MAX(ID)) FROM KRIM_ATTR_DATA_ID_S)), UUID(), 1,
        (SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'Recall Document' and NMSPC_CD = 'KC-AWARD'),
        (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NM LIKE 'Document Type % Routing Node or State'),
        (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NM = 'documentTypeName'),
        'AwardDocument');

INSERT INTO KRIM_ROLE_PERM_ID_S
VALUES (NULL);

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
VALUES (concat('KC', (SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S)), UUID(), 1,
        (SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'Award Modifier' AND NMSPC_CD = 'KC-AWARD'),
        (SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'Recall Document' AND NMSPC_CD = 'KC-AWARD'), 'Y');

INSERT INTO KRIM_PERM_ID_S
VALUES (NULL);

INSERT INTO KRIM_PERM_T (PERM_ID, OBJ_ID, VER_NBR, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND)
VALUES (concat('KC', (SELECT (MAX(ID)) FROM KRIM_PERM_ID_S)), UUID(), 1,
        (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NM = 'Recall Document'),
        'KC-SUBAWARD', 'Recall Document', 'Recall SubAward Document', 'Y');

INSERT INTO KRIM_ATTR_DATA_ID_S
VALUES (NULL);

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, OBJ_ID, VER_NBR, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL)
VALUES (concat('KC', (SELECT (MAX(ID)) FROM KRIM_ATTR_DATA_ID_S)), UUID(), 1,
        (SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'Recall Document' and NMSPC_CD = 'KC-SUBAWARD'),
        (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NM LIKE 'Document Type % Routing Node or State'),
        (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NM = 'documentTypeName'),
        'SubAwardDocument');

INSERT INTO KRIM_ROLE_PERM_ID_S
VALUES (NULL);

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
VALUES (concat('KC', (SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S)), UUID(), 1,
        (SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'Modify Subaward' AND NMSPC_CD = 'KC-SUBAWARD'),
        (SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'Recall Document' AND NMSPC_CD = 'KC-SUBAWARD'), 'Y');