-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -
-- Proposal Development Sponsor Hierarchy Group Function/Term

-- update primary keys in colostate
SET FOREIGN_KEY_CHECKS = 0;

SET @funcId = (SELECT FUNC_ID FROM KRMS_FUNC_T WHERE nm = 'isPrimeSponsorInSponsorHierarchyGroupRule' AND nmspc_cd = 'KC-PD');
UPDATE KRMS_FUNC_T SET FUNC_ID = 'RES-BOOT10066' WHERE FUNC_ID = @funcId;
UPDATE KRMS_FUNC_PARM_T SET FUNC_ID = 'RES-BOOT10066' WHERE FUNC_ID = @funcId;
UPDATE KRMS_TERM_SPEC_T SET nm = 'RES-BOOT10066' WHERE nm = @funcId;

SET FOREIGN_KEY_CHECKS = 1;

-- create function
SET FOREIGN_KEY_CHECKS = 0;

REPLACE INTO krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
values ('RES-BOOT10066', 'KC-PD', 'isPrimeSponsorInSponsorHierarchyGroupRule', 'Check if Prime Sponsor is in sponsor hierarchy group', 'java.lang.Boolean', 'KC1006', 'Y', 1);
REPLACE INTO krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values ('RES-BOOT10119', 'DevelopmentProposal', 'DevelopmentProposal', 'org.kuali.coeus.propdev.impl.core.DevelopmentProposal', 'RES-BOOT10066', 1);
REPLACE INTO krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values ('RES-BOOT10120', 'sponsorHierarchy', 'Sponsor Hierarchy Name', 'java.lang.String','RES-BOOT10066', 2);
REPLACE INTO krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values ('RES-BOOT10121', 'sponsorHierarchyGroup', 'Sponsor Hierarchy Group', 'java.lang.String', 'RES-BOOT10066', 3);
REPLACE INTO KRMS_TERM_SPEC_T (TERM_SPEC_ID, NM, TYP, ACTV, VER_NBR, DESC_TXT, NMSPC_CD)
VALUES ('RES-BOOT2149','RES-BOOT10066','java.lang.Boolean','Y','1','Check if Prime Sponsor is in sponsor hierarchy group','KC-PD');
REPLACE INTO KRMS_TERM_RSLVR_T (TERM_RSLVR_ID, NMSPC_CD, NM, TYP_ID, OUTPUT_TERM_SPEC_ID, ACTV, VER_NBR)
VALUES ('RES-BOOT2136','KC-PD','Check if Prime Sponsor is in sponsor hierarchy group','KC1001','RES-BOOT2149','Y','1');
REPLACE INTO KRMS_TERM_RSLVR_PARM_SPEC_T (TERM_RSLVR_PARM_SPEC_ID, TERM_RSLVR_ID, NM, VER_NBR)
VALUES ('RES-BOOT2120','RES-BOOT2136','sponsorHierarchy','1');
REPLACE INTO KRMS_TERM_RSLVR_PARM_SPEC_T (TERM_RSLVR_PARM_SPEC_ID, TERM_RSLVR_ID, NM, VER_NBR)
VALUES ('RES-BOOT2121','RES-BOOT2136','sponsorHierarchyGroup','1');
REPLACE INTO KRMS_TERM_SPEC_CTGRY_T (TERM_SPEC_ID, CTGRY_ID) VALUES ('RES-BOOT2149','KC1001');
REPLACE INTO KRMS_CNTXT_VLD_TERM_SPEC_T (CNTXT_TERM_SPEC_PREREQ_ID, CNTXT_ID, TERM_SPEC_ID, PREREQ)
VALUES ('RES-BOOT1089','KC-PD-CONTEXT','RES-BOOT2149','Y');

SET FOREIGN_KEY_CHECKS = 1;

-- update primary keys in colostate
SET FOREIGN_KEY_CHECKS = 0;

SET @funcId = (SELECT FUNC_ID FROM KRMS_FUNC_T WHERE nm = 'isSponsorInSponsorHierarchyGroupRule' AND nmspc_cd = 'KC-PD');
UPDATE KRMS_FUNC_T SET FUNC_ID = 'RES-BOOT10067' WHERE FUNC_ID = @funcId;
UPDATE KRMS_FUNC_PARM_T SET FUNC_ID = 'RES-BOOT10067' WHERE FUNC_ID = @funcId;
UPDATE KRMS_TERM_SPEC_T SET nm = 'RES-BOOT10067' WHERE nm = @funcId;

SET FOREIGN_KEY_CHECKS = 1;

-- create function
SET FOREIGN_KEY_CHECKS = 0;

REPLACE INTO krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
values ('RES-BOOT10067', 'KC-PD', 'isSponsorInSponsorHierarchyGroupRule', 'Check if Sponsor is in sponsor hierarchy group', 'java.lang.Boolean', 'KC1006', 'Y', 1);
REPLACE INTO krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values ('RES-BOOT10126', 'DevelopmentProposal', 'DevelopmentProposal', 'org.kuali.coeus.propdev.impl.core.DevelopmentProposal', 'RES-BOOT10067', 1);
REPLACE INTO krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values ('RES-BOOT10127', 'sponsorHierarchy', 'Sponsor Hierarchy Name', 'java.lang.String','RES-BOOT10067', 2);
REPLACE INTO krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values ('RES-BOOT10128', 'sponsorHierarchyGroup', 'Sponsor Hierarchy Group', 'java.lang.String', 'RES-BOOT10067', 3);
REPLACE INTO KRMS_TERM_SPEC_T (TERM_SPEC_ID, NM, TYP, ACTV, VER_NBR, DESC_TXT, NMSPC_CD)
VALUES ('RES-BOOT2150','RES-BOOT10067','java.lang.Boolean','Y','1','Check if Sponsor is in sponsor hierarchy group','KC-PD');
REPLACE INTO KRMS_TERM_RSLVR_T (TERM_RSLVR_ID, NMSPC_CD, NM, TYP_ID, OUTPUT_TERM_SPEC_ID, ACTV, VER_NBR)
VALUES ('RES-BOOT2137','KC-PD','Check if Sponsor is in sponsor hierarchy group','KC1001','RES-BOOT2150','Y','1');
REPLACE INTO KRMS_TERM_RSLVR_PARM_SPEC_T (TERM_RSLVR_PARM_SPEC_ID, TERM_RSLVR_ID, NM, VER_NBR)
VALUES ('RES-BOOT2122','RES-BOOT2137','sponsorHierarchy','1');
REPLACE INTO KRMS_TERM_RSLVR_PARM_SPEC_T (TERM_RSLVR_PARM_SPEC_ID, TERM_RSLVR_ID, NM, VER_NBR)
VALUES ('RES-BOOT2123','RES-BOOT2137','sponsorHierarchyGroup','1');
REPLACE INTO KRMS_TERM_SPEC_CTGRY_T (TERM_SPEC_ID, CTGRY_ID) VALUES ('RES-BOOT2150','KC1001');
REPLACE INTO KRMS_CNTXT_VLD_TERM_SPEC_T (CNTXT_TERM_SPEC_PREREQ_ID, CNTXT_ID, TERM_SPEC_ID, PREREQ)
VALUES ('RES-BOOT1090','KC-PD-CONTEXT','RES-BOOT2150','Y');

SET FOREIGN_KEY_CHECKS = 1;
