-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /

INSERT INTO KRIM_TYP_ID_S VALUES (NULL)
/

INSERT INTO KRIM_TYP_T (KIM_TYP_ID, OBJ_ID, VER_NBR, NM, SRVC_NM, ACTV_IND, NMSPC_CD)
VALUES (CONCAT('KC', (SELECT MAX(ID) FROM KRIM_TYP_ID_S)), UUID(), 1, 'Derived Role: IACUC Correspondent', 'iacucCorrespondentDerivedRoleTypeService', 'Y', 'KC-IACUC')
/

INSERT INTO KRIM_ROLE_ID_S VALUES (NULL)
/

INSERT INTO KRIM_ROLE_T (ROLE_ID, OBJ_ID, VER_NBR, ROLE_NM, NMSPC_CD, DESC_TXT, KIM_TYP_ID, ACTV_IND, LAST_UPDT_DT)
VALUES (CONCAT('KC', (SELECT MAX(ID) FROM KRIM_ROLE_ID_S)), UUID(), 1, 'IACUC Unit Correspondent', 'KC-IACUC', 'The IACUC Unit Correspondent role', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NM = 'Derived Role: IACUC Correspondent'), 'Y', NOW())
/

INSERT INTO KRIM_ROLE_ID_S VALUES (NULL)
/

INSERT INTO KRIM_ROLE_T (ROLE_ID, OBJ_ID, VER_NBR, ROLE_NM, NMSPC_CD, DESC_TXT, KIM_TYP_ID, ACTV_IND, LAST_UPDT_DT)
VALUES (CONCAT('KC', (SELECT MAX(ID) FROM KRIM_ROLE_ID_S)), UUID(), 1, 'IACUC Organization Correspondent', 'KC-IACUC', 'The IACUC Organization Correspondent role', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NM = 'Derived Role: IACUC Correspondent'), 'Y', NOW())
/

DELIMITER ;
