<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2014 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->


<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:footer="http://apply.grants.gov/system/Footer-V1.0"
xmlns:fo="http://www.w3.org/1999/XSL/Format" 
xmlns:att="http://apply.grants.gov/system/Attachments-V1.0" 
xmlns:ED_SF424_Supplement="http://apply.grants.gov/forms/ED_SF424_Supplement-V1.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
    <xsl:variable name="fo:layout-master-set">
        <fo:layout-master-set>
            <fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="0.6in">
                <fo:region-body margin-top="0.79in" margin-bottom="0.79in" />
                <fo:region-after extent=".79in" /> 
            </fo:simple-page-master>
        </fo:layout-master-set>
    </xsl:variable>
    <xsl:template match="ED_SF424_Supplement:ED_SF424_Supplement">
        <fo:root>
            <xsl:copy-of select="$fo:layout-master-set" />
            <fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
            <fo:static-content flow-name="xsl-region-after">
 <fo:block>
	<fo:inline font-size="6px" font-weight="bold">
   Tracking Number: 
  <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber" /> 
  </fo:inline>
  </fo:block>
  </fo:static-content>

                <fo:flow flow-name="xsl-region-body">
                    <fo:block>
                     
                            <fo:table width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                <fo:table-column />
                                <fo:table-body>
                                    <fo:table-row>
                                        <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                            <fo:block>
                                                <fo:inline font-size="16px" font-weight="bold">SUPPLEMENTAL INFORMATION 
REQUIRED FOR 
DEPARTMENT OF EDUCATION GRANTS</fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                            <fo:block>
                                                <fo:inline font-size="10px" font-weight="bold" text-decoration="underline">1. Project Director</fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                            <fo:block>
                                                <fo:inline font-size="10px" font-weight="bold">* Name:</fo:inline>
                                                <fo:inline font-size="10px">&#160;</fo:inline>
                                                <xsl:for-each select="ED_SF424_Supplement:ProjectDirector">
                                                    <xsl:for-each select="globLib:Name">
                                                        <xsl:for-each select="globLib:PrefixName">
                                                            <fo:inline font-size="10px">
                                                                <xsl:apply-templates />
                                                            </fo:inline>
                                                        </xsl:for-each>
                                                        <fo:inline font-size="10px">&#160;</fo:inline>
                                                        <xsl:for-each select="globLib:FirstName">
                                                            <fo:inline font-size="10px">
                                                                <xsl:apply-templates />
                                                            </fo:inline>
                                                        </xsl:for-each>
                                                        <fo:inline font-size="10px">&#160;</fo:inline>
                                                        <xsl:for-each select="globLib:MiddleName">
                                                            <fo:inline font-size="10px">
                                                                <xsl:apply-templates />
                                                            </fo:inline>
                                                        </xsl:for-each>
                                                        <fo:inline font-size="10px">&#160;</fo:inline>
                                                        <xsl:for-each select="globLib:LastName">
                                                            <fo:inline font-size="10px">
                                                                <xsl:apply-templates />
                                                            </fo:inline>
                                                        </xsl:for-each>
                                                        <fo:inline font-size="10px">&#160;</fo:inline>
                                                        <xsl:for-each select="globLib:SuffixName">
                                                            <fo:inline font-size="10px">
                                                                <xsl:apply-templates />
                                                            </fo:inline>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                            <fo:block>
                                                <fo:inline font-size="10px" font-weight="bold">* Address:</fo:inline>
                                                <fo:inline font-size="10px">&#160;</fo:inline>
                                                <xsl:for-each select="ED_SF424_Supplement:ProjectDirector">
                                                    <xsl:for-each select="globLib:Address">
                                                        <xsl:for-each select="globLib:Street1">
                                                            <fo:inline font-size="10px">
                                                                <xsl:apply-templates />
                                                            </fo:inline>
                                                        </xsl:for-each>
                                                        <fo:inline font-size="10px">&#160;</fo:inline>
                                                        <xsl:for-each select="globLib:Street2">
                                                            <fo:inline font-size="10px">
                                                                <xsl:apply-templates />
                                                            </fo:inline>
                                                        </xsl:for-each>
                                                        
                                                        <xsl:if test="globLib:County!=''">
                                                        <fo:block></fo:block>
                                                          <fo:inline font-size="10px">&#160;</fo:inline>

                                                        <xsl:for-each select="globLib:County">
                                                        <fo:inline font-size="10px">
                                                        <xsl:apply-templates />
                                                        </fo:inline>
                                                          <fo:inline font-size="10px">&#160;County</fo:inline>
                                                        </xsl:for-each>
                                                        </xsl:if>
                                                        
                                                        
                                                        <fo:block></fo:block>
                                                        <fo:inline font-size="10px">&#160;</fo:inline>
                                                        <xsl:for-each select="globLib:City">
                                                            <fo:inline font-size="10px">
                                                                <xsl:apply-templates />
                                                            </fo:inline>
                                                        </xsl:for-each>
                                                        <fo:inline font-size="10px">&#160;</fo:inline>
                                                        <xsl:for-each select="globLib:State">
                                                            <fo:inline font-size="10px">
                                                                <xsl:apply-templates />
                                                            </fo:inline>
                                                        </xsl:for-each>
                                                        <fo:inline font-size="10px">&#160;</fo:inline>
                                                        <xsl:for-each select="globLib:ZipCode">
                                                            <fo:inline font-size="10px">
                                                                <xsl:apply-templates />
                                                            </fo:inline>
                                                        </xsl:for-each>
                                                        <fo:inline font-size="10px">&#160;</fo:inline>
                                                        <xsl:for-each select="globLib:Country">
                                                            <fo:inline font-size="10px">
                                                                <xsl:apply-templates />
                                                            </fo:inline>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                            <fo:block>
                                                <fo:inline font-size="10px" font-weight="bold">* Phone Number: </fo:inline>
                                                <xsl:for-each select="ED_SF424_Supplement:ProjectDirector">
                                                    <xsl:for-each select="globLib:Phone">
                                                        <fo:inline font-size="10px">
                                                            <xsl:apply-templates />
                                                        </fo:inline>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                            <fo:block>
                                                <fo:inline font-size="10px" font-weight="bold">Fax Number: </fo:inline>
                                                <xsl:for-each select="ED_SF424_Supplement:ProjectDirector">
                                                    <xsl:for-each select="globLib:Fax">
                                                        <fo:inline font-size="10px">
                                                            <xsl:apply-templates />
                                                        </fo:inline>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                            <fo:block>
                                                <fo:inline font-size="10px" font-weight="bold">Email: </fo:inline>
                                                <xsl:for-each select="ED_SF424_Supplement:ProjectDirector">
                                                    <xsl:for-each select="globLib:Email">
                                                        <fo:inline font-size="10px">
                                                            <xsl:apply-templates />
                                                        </fo:inline>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                            <fo:block>
                                                <fo:inline font-size="10px" font-weight="bold" text-decoration="underline">2. Applicant Experience:</fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                            <fo:block>
                                                <xsl:for-each select="ED_SF424_Supplement:IsNoviceApplicant">
                                                    <fo:inline font-size="10px">
                                                        <fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
                                                            <fo:inline>
                                                                <xsl:choose>
                                                                    <xsl:when test=".='Yes'">
                                                                        <fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <fo:inline text-decoration="underline" color="black">
                                                                            <fo:leader leader-length="7pt" leader-pattern="rule" />
                                                                        </fo:inline>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                            </fo:inline>
                                                        </fo:inline>
                                                    </fo:inline>
                                                </xsl:for-each>
                                                <fo:inline font-size="10px"> Yes&#160; </fo:inline>
                                                <xsl:for-each select="ED_SF424_Supplement:IsNoviceApplicant">
                                                    <fo:inline font-size="10px">
                                                        <fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
                                                            <fo:inline>
                                                                <xsl:choose>
                                                                    <xsl:when test=".='No'">
                                                                        <fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <fo:inline text-decoration="underline" color="black">
                                                                            <fo:leader leader-length="7pt" leader-pattern="rule" />
                                                                        </fo:inline>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                            </fo:inline>
                                                        </fo:inline>
                                                    </fo:inline>
                                                </xsl:for-each>
                                                <fo:inline font-size="10px"> No </fo:inline>
                                                <xsl:for-each select="ED_SF424_Supplement:IsNoviceApplicant">
                                                    <fo:inline font-size="10px">
                                                        <fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
                                                            <fo:inline>
                                                                <xsl:choose>
                                                                    <xsl:when test=".='NotApplicable'">
                                                                        <fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <fo:inline text-decoration="underline" color="black">
                                                                            <fo:leader leader-length="7pt" leader-pattern="rule" />
                                                                        </fo:inline>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                            </fo:inline>
                                                        </fo:inline>
                                                    </fo:inline>
                                                </xsl:for-each>
                                                <fo:inline font-size="10px">&#160; Not applicable to this program</fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                            <fo:block>
                                                <fo:inline font-size="10px" font-weight="bold" text-decoration="underline">3. Human Subjects Research</fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                            <fo:block>
                                                <fo:inline font-size="10px">Are any research activities involving human subjects planned at any time during the proposed project Period?</fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                            <fo:block>
                                                <fo:inline font-size="10px">&#160;</fo:inline>
                                                <xsl:for-each select="ED_SF424_Supplement:IsHumanResearch">
                                                    <fo:inline font-size="10px">
                                                        <fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
                                                            <fo:inline>
                                                                <xsl:choose>
                                                                    <xsl:when test=".='Yes'">
                                                                        <fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <fo:inline text-decoration="underline" color="black">
                                                                            <fo:leader leader-length="7pt" leader-pattern="rule" />
                                                                        </fo:inline>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                            </fo:inline>
                                                        </fo:inline>
                                                    </fo:inline>
                                                </xsl:for-each>
                                                <fo:inline font-size="10px">Yes </fo:inline>
                                                <xsl:for-each select="ED_SF424_Supplement:IsHumanResearch">
                                                    <fo:inline font-size="10px">
                                                        <fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
                                                            <fo:inline>
                                                                <xsl:choose>
                                                                    <xsl:when test=".='No'">
                                                                        <fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <fo:inline text-decoration="underline" color="black">
                                                                            <fo:leader leader-length="7pt" leader-pattern="rule" />
                                                                        </fo:inline>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                            </fo:inline>
                                                        </fo:inline>
                                                    </fo:inline>
                                                </xsl:for-each>
                                                <fo:inline font-size="10px"> No</fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                            <fo:block>
                                                <fo:inline font-size="10px">Are ALL the research activities proposed designated to be exempt from the regulations?</fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                            <fo:block>
                                                <xsl:for-each select="ED_SF424_Supplement:IsHumanResearchExempt">
                                                    <fo:inline font-size="10px">
                                                        <fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
                                                            <fo:inline>
                                                                <xsl:choose>
                                                                    <xsl:when test=".='Yes'">
                                                                        <fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <fo:inline text-decoration="underline" color="black">
                                                                            <fo:leader leader-length="7pt" leader-pattern="rule" />
                                                                        </fo:inline>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                            </fo:inline>
                                                        </fo:inline>
                                                    </fo:inline>
                                                </xsl:for-each>
                                                <fo:inline font-size="10px"> Yes&#160; Provide Exemption(s) #: </fo:inline>
                                                <xsl:for-each select="ED_SF424_Supplement:ExemptionsNumber">
                                                    <fo:inline font-size="10px">
                                                        <xsl:apply-templates />
                                                    </fo:inline>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell height="17pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                            <fo:block>
                                                <fo:inline font-size="10px">&#160;</fo:inline>
                                                <xsl:for-each select="ED_SF424_Supplement:IsHumanResearchExempt">
                                                    <fo:inline font-size="10px">
                                                        <fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
                                                            <fo:inline>
                                                                <xsl:choose>
                                                                    <xsl:when test=".='No'">
                                                                        <fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <fo:inline text-decoration="underline" color="black">
                                                                            <fo:leader leader-length="7pt" leader-pattern="rule" />
                                                                        </fo:inline>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                            </fo:inline>
                                                        </fo:inline>
                                                    </fo:inline>
                                                </xsl:for-each>
                                                <fo:inline font-size="10px">No&#160;&#160; Provide Assurance #, if available: </fo:inline>
                                                <xsl:for-each select="ED_SF424_Supplement:AssuranceNumber">
                                                    <fo:inline font-size="10px">
                                                        <xsl:apply-templates />
                                                    </fo:inline>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </fo:table-body>
                           </fo:table>
                           
                            <fo:table width="100%" space-before.optimum="1pt" space-after.optimum="1pt">
                                    <fo:table-column />
                                    <fo:table-body>
                                        <fo:table-row>
                                            <fo:table-cell padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                <fo:block>
                                                    <fo:inline font-size="10px" font-weight="bold">Please attach an explanation Narrative: </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>

                            
              <fo:table width="100%" space-before.optimum="1pt" space-after.optimum="1pt">
                                    <fo:table-column />
                                    <fo:table-column />
                                    <fo:table-body>
                                        <fo:table-row>
                                            <fo:table-cell padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                <fo:block>
                                                    <fo:inline font-size="10px">FileName</fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                <fo:block>
                                                    <fo:inline font-size="10px">MimeType</fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                <fo:block>
                                                    <xsl:for-each select="ED_SF424_Supplement:Attachment">
                                                        <xsl:for-each select="att:FileName">
                                                            <fo:inline font-size="10px">
                                                                <xsl:apply-templates />
                                                            </fo:inline>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                <fo:block>
                                                    <xsl:for-each select="ED_SF424_Supplement:Attachment">
                                                        <xsl:for-each select="att:MimeType">
                                                            <fo:inline font-size="10px">
                                                                <xsl:apply-templates />
                                                            </fo:inline>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>

              
              
              
              
                    </fo:block>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>
</xsl:stylesheet>
