<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2014 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:PHSHumanSubjectsAndClinicalTrialsInfo_2_0="http://apply.grants.gov/forms/PHSHumanSubjectsAndClinicalTrialsInfo_2_0-V2.0"
	xmlns:HumanSubjectStudy_2_0="http://apply.grants.gov/forms/HumanSubjectStudy_2_0-V2.0"
	xmlns:att="http://apply.grants.gov/system/Attachments-V1.0"
	xmlns:codes="http://apply.grants.gov/system/UniversalCodes-V2.0"
	xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:glob="http://apply.grants.gov/system/Global-V1.0"
	xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0"
	xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:header="http://apply.grants.gov/system/Header-V1.0"
	xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:output version="1.0" method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:param name="studyNumber" />
	<xsl:param name="govTrackingNumber" />
	<xsl:param name="opportunityID" />
	<xsl:param name="receivedDateTime" />
	
	<xsl:template match="HumanSubjectStudy_2_0:HumanSubjectStudy_2_0">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="rest"
					page-height="11in" page-width="8.5in" margin-left="0.6in"
					margin-right="0.6in">
					<fo:region-body margin-top="0.5in" />
					<fo:region-before region-name="header" />
					<fo:region-after region-name="footer" extent="0.6in" />
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="all-pages">
					<fo:repeatable-page-master-alternatives>
						<fo:conditional-page-master-reference
							master-reference="rest" page-position="rest" />
					</fo:repeatable-page-master-alternatives>
				</fo:page-sequence-master>
			</fo:layout-master-set>

			<!-- Study -->
			<fo:page-sequence master-reference="rest" format="1">

				<fo:static-content flow-name="footer">
					<fo:table width="100%" space-before.optimum="0pt"
						space-after.optimum="0pt" table-layout="fixed">
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell hyphenate="true" language="en"
									padding-start="0pt" padding-end="0pt" padding-before="1pt"
									padding-after="1pt" display-align="before" text-align="left"
									border-style="solid" border-width="0pt" border-color="white">
									<fo:block>
										<fo:inline font-size="8px">
											Tracking Number:
											<xsl:value-of select="$govTrackingNumber" />
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell hyphenate="true" language="en"
									line-height="9pt" padding-start="0pt" padding-end="0pt"
									padding-before="1pt" padding-after="1pt" display-align="before"
									text-align="right" border-style="solid" border-width="0pt"
									border-color="white">
									<fo:block>
										<fo:inline font-size="8px">
											Funding Opportunity Number:
											<xsl:value-of select="$opportunityID" />
										</fo:inline>
										<fo:inline font-size="8px">
											Received Date:
											<xsl:value-of select="$receivedDateTime" />
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
					<xsl:call-template name="humanSubjectStudiesSection3" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

	<!-- PHS Human Subjects and Clinical Trials Information -> Study -> Section 
		3 -->
	<xsl:template name="humanSubjectStudiesSection3">
		<fo:block>
			<fo:table width="100%" table-layout="fixed"
				left="100pt">
				<fo:table-column column-width="10%"/>
				<fo:table-column column-width="15%"/>
				<fo:table-column column-width="25%"/>
				<fo:table-column column-width="25%" />
				<fo:table-column column-width="25%"/>

				<fo:table-body start-indent="0pt">
					<fo:table-row>
						<fo:table-cell number-columns-spanned="5">
							<fo:block padding="10pt">
								<fo:inline font-weight="bold" font-size="10px"
									padding="4pt">
									<xsl:text>Section 3 - Protection and Monitoring Plans</xsl:text>
									<xsl:choose>
										<xsl:when test="normalize-space($studyNumber) != ''">
											(Study <xsl:value-of select="$studyNumber" />)
										</xsl:when>
									</xsl:choose>
								</fo:inline>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>

					<!-- 3.1 -->
					<fo:table-row>

						<xsl:call-template name="label">
							<xsl:with-param name="label_text">
								3.1. Protection of Human Subjects
							</xsl:with-param>
						</xsl:call-template>
						<xsl:call-template name="text-field">
							<xsl:with-param name="number-columns-spanned">
								2
							</xsl:with-param>
							<xsl:with-param name="field_value"
								select="HumanSubjectStudy_2_0:ProtectionMonitoringPlans/HumanSubjectStudy_2_0:ProtectionOfHumanSubjects/HumanSubjectStudy_2_0:attFile/att:FileName" />
						</xsl:call-template>
					</fo:table-row>
					<!-- 3.2 -->
					<fo:table-row>
						<xsl:call-template name="label">
							<xsl:with-param name="label_text">
								3.2. Is this a multi-site study that will use the same protocol to conduct non-exempt human subjects research at more than one domestic site?
							</xsl:with-param>
						</xsl:call-template>
						<xsl:call-template name="radio-field-truefalsena">
							<xsl:with-param name="xml_field"
								select="HumanSubjectStudy_2_0:ProtectionMonitoringPlans/HumanSubjectStudy_2_0:MultiSiteStudy" />
						</xsl:call-template>
					</fo:table-row>
					<!-- 3.2 if yes -->
					<fo:table-row>
						<fo:table-cell>
							<fo:block>
								<fo:leader leader-pattern="space" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell number-columns-spanned="2" top="0pt">
							<fo:block padding="1pt">
								<fo:inline font-size="9px" padding="4pt" padding-before="5">
									<xsl:text>If yes, describe the single IRB plan</xsl:text>
								</fo:inline>
							</fo:block>
						</fo:table-cell>

						<xsl:call-template name="text-field">
							<xsl:with-param name="number-columns-spanned">
								2
							</xsl:with-param>
							<xsl:with-param name="field_value"
								select="HumanSubjectStudy_2_0:ProtectionMonitoringPlans/HumanSubjectStudy_2_0:IRBPlan/HumanSubjectStudy_2_0:attFile/att:FileName" />
						</xsl:call-template>
					</fo:table-row>

					<!-- 3.3 -->
					<fo:table-row>
						<xsl:call-template name="label">
							<xsl:with-param name="label_text">
								3.3. Data and Safety Monitoring Plan
							</xsl:with-param>
						</xsl:call-template>
						<xsl:call-template name="text-field">
							<xsl:with-param name="number-columns-spanned">
								2
							</xsl:with-param>
							<xsl:with-param name="field_value"
								select="HumanSubjectStudy_2_0:ProtectionMonitoringPlans/HumanSubjectStudy_2_0:DataSafetyMonitoringPlan/HumanSubjectStudy_2_0:attFile/att:FileName" />
						</xsl:call-template>
					</fo:table-row>

					<!-- 3.4 -->
					<fo:table-row>
						<xsl:call-template name="label">
							<xsl:with-param name="label_text">
								3.4. Will a Data and Safety Monitoring Board be appointed for
								this study?
							</xsl:with-param>
						</xsl:call-template>
						<xsl:call-template name="radio-field">
							<xsl:with-param name="xml_field"
								select="HumanSubjectStudy_2_0:ProtectionMonitoringPlans/HumanSubjectStudy_2_0:BoardAppointed" />
						</xsl:call-template>
					</fo:table-row>

					<!-- 3.5 -->
					<fo:table-row>
						<xsl:call-template name="label">
							<xsl:with-param name="label_text">
								3.5. Overall structure of the study team
							</xsl:with-param>
						</xsl:call-template>
						<xsl:call-template name="text-field">
							<xsl:with-param name="number-columns-spanned">
								2
							</xsl:with-param>
							<xsl:with-param name="field_value"
								select="HumanSubjectStudy_2_0:ProtectionMonitoringPlans/HumanSubjectStudy_2_0:StudyTeamStructure/HumanSubjectStudy_2_0:attFile/att:FileName" />
						</xsl:call-template>
					</fo:table-row>


				</fo:table-body>
			</fo:table>
		</fo:block>
	</xsl:template>
	<!-- End of Section 3 -->


<!-- A generic field value area: $text-field will be displayed in the cell -->
	<xsl:template name="text-field">
		<xsl:param name="field_value" />
		<xsl:param name="number-columns-spanned" select="1" />
		<fo:table-cell number-columns-spanned="{$number-columns-spanned}"
			text-align="left" padding-start="3pt" padding-end="3pt"
			padding-before="5pt" padding-after="6pt" >
			<fo:block>
				<fo:table font-size="9px" table-layout="fixed" width="100%">
					<fo:table-column column-width="proportional-column-width(1)" />
					<fo:table-body start-indent="0pt">
						<fo:table-row>
							<fo:table-cell text-align="left" padding-start="1pt" padding-end="3pt"
			padding-before="1pt" padding-after="6pt">
								<fo:block font-family="arialuni" font-size="9px">
									<fo:inline>
										<xsl:value-of select="$field_value" />
									</fo:inline>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	<!-- Create label with display text, ${label_text} -->
	<xsl:template name="label">
		<xsl:param name="padding-start" select="3" />
		<xsl:param name="number-columns-spanned" select="3" />
		<xsl:param name="label_text" />

		<fo:table-cell number-columns-spanned="{$number-columns-spanned}"  
			text-align="left" padding-start="{$padding-start}" padding-end="3pt"
			padding-before="6pt" padding-after="6pt">
			<fo:block font-family="arialuni" font-size="9px">
				<xsl:value-of select="$label_text" />
			</fo:block>
		</fo:table-cell>
	</xsl:template>

	<!-- Creates radio field for a given ${xml_field} with 'Yes' or 'No' options 
		Marks the value where ${xml_field} = radio_box value as selected -->
	<xsl:template name="radio-field">
		<xsl:param name="xml_field" />
		<fo:table-cell text-align="left" padding-start="3pt"
			padding-end="3pt" padding-before="1pt" padding-after="6pt"
			 >
			<fo:block>
				<fo:table font-size="9px" table-layout="fixed" width="100%">
					<fo:table-column column-width="proportional-column-width(1)" />
					<fo:table-body start-indent="0pt">
						<fo:table-row>
							<fo:table-cell border="solid 1pt white"
								border-spacing="1pt" padding="2pt">
								<fo:table>
									<fo:table-column column-width="12%" />
									<fo:table-column column-width="28%" />
									<fo:table-column column-width="12%" />
									<fo:table-column column-width="28%" />
									<fo:table-body>
										<fo:table-row>
											<xsl:call-template name="yesOrNoRadio">
												<xsl:with-param name="xml_field" select="$xml_field" />
											</xsl:call-template>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	<!-- Creates radio field for a given ${xml_field} with 'Yes' or 'No' options 
		Marks the value where ${xml_field} = radio_box value as selected -->
	<xsl:template name="radio-field-truefalsena">
		<xsl:param name="xml_field" />
		<fo:table-cell text-align="left" padding-start="3pt"
			padding-end="3pt" padding-before="1pt" padding-after="6pt"
			 number-columns-spanned="2">
			<fo:block>
				<fo:table font-size="9px" table-layout="fixed" width="100%">
					<fo:table-column column-width="proportional-column-width(1)" />
					<fo:table-body start-indent="0pt">
						<fo:table-row>
							<fo:table-cell border="solid 1pt white"
								border-spacing="1pt" padding="2pt">
								<fo:table>
									<fo:table-column column-width="6%" />
									<fo:table-column column-width="14%" />
									<fo:table-column column-width="6%" />
									<fo:table-column column-width="14%" />
									<fo:table-column column-width="6%" />
									<fo:table-column column-width="14%" />
									<fo:table-body>
										<fo:table-row>
											<xsl:call-template name="YesNoNARadio">
												<xsl:with-param name="xml_field" select="$xml_field" />
											</xsl:call-template>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	<xsl:template name="yesOrNoRadio">
		<xsl:param name="xml_field" />
		<!-- YES -->
		<xsl:call-template name="options">
			<xsl:with-param name="xml_field" select="$xml_field" />
			<xsl:with-param name="radio_text">
				Yes
			</xsl:with-param>
			<xsl:with-param name="radio_value">
				Y: Yes
			</xsl:with-param>
		</xsl:call-template>
		<!-- NO -->
		<xsl:call-template name="options">
			<xsl:with-param name="xml_field" select="$xml_field" />
			<xsl:with-param name="radio_text">
				No
			</xsl:with-param>
			<xsl:with-param name="radio_value">
				N: No
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="YesNoNARadio">
		<xsl:param name="xml_field" />
		<!-- YES -->
		<xsl:call-template name="options">
			<xsl:with-param name="xml_field" select="$xml_field" />
			<xsl:with-param name="radio_text">
				Yes
			</xsl:with-param>
			<xsl:with-param name="radio_value">
				Y: Yes
			</xsl:with-param>
		</xsl:call-template>
		<!-- NO -->
		<xsl:call-template name="options">
			<xsl:with-param name="xml_field" select="$xml_field" />
			<xsl:with-param name="radio_text">
				No
			</xsl:with-param>
			<xsl:with-param name="radio_value">
				N: No
			</xsl:with-param>
		</xsl:call-template>
		<!-- N/A -->
		<xsl:call-template name="options">
			<xsl:with-param name="xml_field" select="$xml_field" />
			<xsl:with-param name="radio_text">
				N/A
			</xsl:with-param>
			<xsl:with-param name="radio_value">
				NA: Not Applicable
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="options">
		<xsl:param name="xml_field" />
		<xsl:param name="radio_text" />
		<xsl:param name="radio_value" />
		<fo:table-cell line-height="15pt">
			<fo:block>
				<xsl:call-template name="radio">
					<xsl:with-param name="xml_field" select="$xml_field" />
					<xsl:with-param name="radio_value" select="$radio_value" />
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell line-height="15pt">
			<fo:block>
				<xsl:value-of select="$radio_text" />
			</fo:block>
		</fo:table-cell>
	</xsl:template>

	<xsl:template name="radio">
		<xsl:param name="xml_field" />
		<xsl:param name="radio_value" />
		<xsl:choose>
			<xsl:when
				test="normalize-space($xml_field) = normalize-space($radio_value)">
				<fo:inline font-family="ZapfDingbats" font-size="9px"
					padding-end="1pt">&#x25cf;</fo:inline>
			</xsl:when>
			<xsl:otherwise>
				<fo:inline font-family="ZapfDingbats" font-size="9px"
					padding-end="1pt">&#x274d;</fo:inline>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
