<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2014 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:PHSHumanSubjectsAndClinicalTrialsInfo_3_0="http://apply.grants.gov/forms/PHSHumanSubjectsAndClinicalTrialsInfo_3_0-V3.0"
                xmlns:HumanSubjectStudy_3_0="http://apply.grants.gov/forms/HumanSubjectStudy_3_0-V3.0"
                xmlns:att="http://apply.grants.gov/system/Attachments-V1.0"
                xmlns:codes="http://apply.grants.gov/system/UniversalCodes-V2.0"
                xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:glob="http://apply.grants.gov/system/Global-V1.0"
                xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0"
                xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:header="http://apply.grants.gov/system/Header-V1.0"
                xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:output version="1.0" method="xml" encoding="UTF-8" indent="yes"/>
    <xsl:param name="studyNumber"/>
    <xsl:param name="govTrackingNumber"/>
    <xsl:param name="opportunityID"/>
    <xsl:param name="receivedDateTime"/>

    <xsl:template match="/">
        <fo:root>
            <fo:layout-master-set>
                <fo:simple-page-master master-name="rest"
                                       page-height="11in" page-width="8.5in" margin-left="0.6in"
                                       margin-right="0.6in">
                    <fo:region-body margin-top="0.5in" margin-bottom="0.8in"/>
                    <fo:region-before region-name="header"/>
                    <fo:region-after region-name="footer" extent="0.6in"/>
                </fo:simple-page-master>
                <fo:page-sequence-master master-name="all-pages">
                    <fo:repeatable-page-master-alternatives>
                        <fo:conditional-page-master-reference
                                master-reference="rest" page-position="rest"/>
                    </fo:repeatable-page-master-alternatives>
                </fo:page-sequence-master>
            </fo:layout-master-set>

            <!-- Section 4 -->
            <fo:page-sequence master-reference="rest" format="1">

                <fo:static-content flow-name="footer">
                    <fo:table width="100%" space-before.optimum="0pt"
                              space-after.optimum="0pt" table-layout="fixed">
                        <fo:table-column column-width="proportional-column-width(1)"/>
                        <fo:table-column column-width="proportional-column-width(1)"/>
                        <fo:table-body>
                            <fo:table-row>
                                <fo:table-cell hyphenate="true" language="en"
                                               padding-start="0pt" padding-end="0pt" padding-before="1pt"
                                               padding-after="1pt" display-align="before" text-align="left"
                                               border-style="solid" border-width="0pt" border-color="white">
                                    <fo:block>
                                        <fo:inline font-size="8px">
                                            Tracking Number:
                                            <xsl:value-of select="$govTrackingNumber"/>
                                        </fo:inline>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell hyphenate="true" language="en"
                                               line-height="9pt" padding-start="0pt" padding-end="0pt"
                                               padding-before="1pt" padding-after="1pt" display-align="before"
                                               text-align="right" border-style="solid" border-width="0pt"
                                               border-color="white">
                                    <fo:block>
                                        <fo:inline font-size="8px">
                                            Funding Opportunity Number:
                                            <xsl:value-of select="$opportunityID"/>
                                        </fo:inline>
                                        <fo:inline font-size="8px">
                                            Received Date:
                                            <xsl:value-of select="$receivedDateTime"/>
                                        </fo:inline>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                </fo:static-content>

                <fo:flow flow-name="xsl-region-body">
                    <xsl:call-template name="humanSubjectStudiesSection4"/>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>

    <!-- PHS Human Subjects and Clinical Trials Information -> Study -> Section
        3 -->
    <xsl:template name="humanSubjectStudiesSection4">
        <fo:block>
            <xsl:for-each select="//HumanSubjectStudy_3_0:HumanSubjectStudy_3_0">
                <fo:block>

                    <fo:table width="100%" table-layout="fixed" border-color="black"
                              left="100pt">
                        <fo:table-column column-width="10%"/>
                        <fo:table-column column-width="15%"/>
                        <fo:table-column column-width="25%"/>
                        <fo:table-column column-width="25%"/>
                        <fo:table-column column-width="25%"/>

                        <fo:table-body start-indent="0pt">
                            <fo:table-row>
                                <fo:table-cell number-columns-spanned="5">
                                    <fo:block padding="10pt">
                                        <fo:inline font-weight="bold" font-size="10px"
                                        >
                                            <xsl:text>Section 4 - Protocol Synopsis</xsl:text>
                                            <xsl:if test="$studyNumber > 0">(Study <xsl:value-of select="$studyNumber"/>)
                                            </xsl:if>

                                        </fo:inline>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>

                            <!-- 4.1 -->
                            <fo:table-row>

                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text">
                                        4.1. Study Design
                                    </xsl:with-param>
                                    <xsl:with-param name="number-columns-spanned">2</xsl:with-param>
                                </xsl:call-template>
                            </fo:table-row>
                            <fo:table-row>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text">
                                        4.1.a. Detailed Description
                                    </xsl:with-param>
                                    <xsl:with-param name="number-columns-spanned">3</xsl:with-param>
                                    <xsl:with-param name="padding-start">18</xsl:with-param>
                                </xsl:call-template>
                            </fo:table-row>
                            <fo:table-row>
                                <xsl:call-template name="textarea-textwith-tabs-newline">
                                    <xsl:with-param name="label_text"
                                                    select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:StudyDesign/HumanSubjectStudy_3_0:DetailedDescription"/>
                                    <xsl:with-param name="number-columns-spanned">5</xsl:with-param>
                                    <xsl:with-param name="padding-start">43</xsl:with-param>
                                </xsl:call-template>
                            </fo:table-row>
                            <fo:table-row>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text">
                                        4.1.b. Primary Purpose
                                    </xsl:with-param>
                                    <xsl:with-param name="number-columns-spanned">3</xsl:with-param>
                                    <xsl:with-param name="padding-start">18</xsl:with-param>
                                </xsl:call-template>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text"
                                                    select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:StudyDesign/HumanSubjectStudy_3_0:PrimaryPurpose"/>
                                    <xsl:with-param name="number-columns-spanned">2</xsl:with-param>
                                </xsl:call-template>
                            </fo:table-row>
                            <fo:table-row>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text"
                                                    select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:StudyDesign/HumanSubjectStudy_3_0:OtherPrimaryPurpose"/>
                                    <xsl:with-param name="number-columns-spanned">5</xsl:with-param>
                                    <xsl:with-param name="padding-start">43</xsl:with-param>
                                </xsl:call-template>
                            </fo:table-row>
                            <fo:table-row>

                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text">
                                        4.1.c. Interventions
                                    </xsl:with-param>
                                    <xsl:with-param name="padding-start">18</xsl:with-param>
                                    <xsl:with-param name="number-columns-spanned">2</xsl:with-param>
                                </xsl:call-template>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell number-columns-spanned="5" padding-start="18">
                                    <fo:table width="100%" table-layout="fixed" border-style="solid"
                                              border-width="1pt" border-color="black" margin-bottom="0.2in">
                                        <fo:table-column column-width="15%"/>
                                        <fo:table-column column-width="25%"/>
                                        <fo:table-column column-width="60%"/>

                                        <fo:table-body start-indent="0pt">
                                            <fo:table-row>
                                                <xsl:call-template name="table_header_cell">
                                                    <xsl:with-param name="label_text">
                                                        Type
                                                    </xsl:with-param>
                                                </xsl:call-template>
                                                <xsl:call-template name="table_header_cell">
                                                    <xsl:with-param name="label_text">
                                                        Name
                                                    </xsl:with-param>
                                                </xsl:call-template>
                                                <xsl:call-template name="table_header_cell">
                                                    <xsl:with-param name="label_text">
                                                        Description
                                                    </xsl:with-param>
                                                </xsl:call-template>
                                            </fo:table-row>
                                            <xsl:for-each
                                                    select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:StudyDesign/HumanSubjectStudy_3_0:Interventions">
                                                <fo:table-row>
                                                    <xsl:call-template name="table_body_cell">
                                                        <xsl:with-param name="cell_text"
                                                                        select="HumanSubjectStudy_3_0:InterventionType"/>
                                                    </xsl:call-template>
                                                    <xsl:call-template name="table_body_cell">
                                                        <xsl:with-param name="cell_text"
                                                                        select="HumanSubjectStudy_3_0:InterventionName"/>
                                                    </xsl:call-template>
                                                    <xsl:call-template name="table_body_cell_tabs_newline">
                                                        <xsl:with-param name="cell_text"
                                                                        select="HumanSubjectStudy_3_0:InterventionDescription"/>
                                                    </xsl:call-template>
                                                </fo:table-row>
                                            </xsl:for-each>
                                        </fo:table-body>
                                    </fo:table>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text">
                                        4.1.d. Study Phase
                                    </xsl:with-param>
                                    <xsl:with-param name="number-columns-spanned">3</xsl:with-param>
                                    <xsl:with-param name="padding-start">18</xsl:with-param>
                                </xsl:call-template>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text"
                                                    select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:StudyDesign/HumanSubjectStudy_3_0:StudyPhase"/>
                                    <xsl:with-param name="number-columns-spanned">2</xsl:with-param>
                                </xsl:call-template>
                            </fo:table-row>
                            <fo:table-row>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text"
                                                    select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:StudyDesign/HumanSubjectStudy_3_0:OtherStudyPhase"/>
                                    <xsl:with-param name="number-columns-spanned">5</xsl:with-param>
                                    <xsl:with-param name="padding-start">43</xsl:with-param>
                                </xsl:call-template>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell number-columns-spanned="3" padding-before="6" padding-start="43">
                                    <fo:block font-size="9px">Is this an NIH-defined Phase III Clinical Trial?</fo:block>
                                </fo:table-cell>

                                <xsl:call-template name="radio-field">
                                    <xsl:with-param name="xml_field"
                                                    select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:StudyDesign/HumanSubjectStudy_3_0:NIHPhase3ClinicalTrial"/>
                                </xsl:call-template>
                            </fo:table-row>
                            <fo:table-row>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text">
                                        4.1.e. Intervention Model
                                    </xsl:with-param>
                                    <xsl:with-param name="number-columns-spanned">3</xsl:with-param>
                                    <xsl:with-param name="padding-start">18</xsl:with-param>
                                </xsl:call-template>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text"
                                                    select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:StudyDesign/HumanSubjectStudy_3_0:InterventionModel"/>
                                    <xsl:with-param name="number-columns-spanned">2</xsl:with-param>
                                </xsl:call-template>
                            </fo:table-row>
                            <fo:table-row>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text"
                                                    select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:StudyDesign/HumanSubjectStudy_3_0:OtherInterventionModel"/>
                                    <xsl:with-param name="number-columns-spanned">5</xsl:with-param>
                                    <xsl:with-param name="padding-start">43</xsl:with-param>
                                </xsl:call-template>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell number-columns-spanned="2" padding-before="6" padding-start="18">
                                    <fo:block font-size="9px">4.1.f. Masking</fo:block>
                                </fo:table-cell>
                                <fo:table-cell>
                                    <fo:block></fo:block>
                                </fo:table-cell>
                                <xsl:call-template name="radio-field">
                                    <xsl:with-param name="xml_field"
                                                    select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:StudyDesign/HumanSubjectStudy_3_0:Masking"/>
                                </xsl:call-template>
                            </fo:table-row>
                            <fo:table-row>

                                <fo:table-cell number-columns-spanned="2"
                                               text-align="left" display-align="center">
                                    <fo:block font-size="8px"></fo:block>
                                </fo:table-cell>

                                <fo:table-cell number-columns-spanned="3"
                                               text-align="left" display-align="center">
                                    <fo:block>
                                        <fo:table font-size="9px" table-layout="fixed" width="100%">
                                            <fo:table-column column-width="proportional-column-width(1)"/>
                                            <fo:table-body start-indent="0pt">
                                                <fo:table-row>
                                                    <fo:table-cell border="solid 1pt white"
                                                                   border-spacing="1pt" display-align="center">
                                                        <fo:table font-size="9px" table-layout="fixed"
                                                                  width="100%">
                                                            <fo:table-column column-width="proportional-column-width(1)"/>
                                                            <fo:table-column column-width="proportional-column-width(1)"/>
                                                            <fo:table-column column-width="proportional-column-width(1)"/>
                                                            <fo:table-column column-width="proportional-column-width(1)"/>

                                                            <fo:table-body start-indent="0pt">
                                                                <fo:table-row>
                                                                    <xsl:call-template name="masking_checkbox">

                                                                        <xsl:with-param name="checkbox_value"
                                                                                        select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:StudyDesign/HumanSubjectStudy_3_0:MaskingType/HumanSubjectStudy_3_0:Participant"/>
                                                                        <xsl:with-param name="checkbox_text">Participant</xsl:with-param>
                                                                    </xsl:call-template>

                                                                    <xsl:call-template name="masking_checkbox">
                                                                        <xsl:with-param name="checkbox_value"
                                                                                        select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:StudyDesign/HumanSubjectStudy_3_0:MaskingType/HumanSubjectStudy_3_0:CareProvider"/>
                                                                        <xsl:with-param name="checkbox_text">Care Provider</xsl:with-param>
                                                                    </xsl:call-template>

                                                                    <xsl:call-template name="masking_checkbox">
                                                                        <xsl:with-param name="checkbox_value"
                                                                                        select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:StudyDesign/HumanSubjectStudy_3_0:MaskingType/HumanSubjectStudy_3_0:Investigator"/>
                                                                        <xsl:with-param name="checkbox_text">Investigator</xsl:with-param>
                                                                    </xsl:call-template>

                                                                    <xsl:call-template name="masking_checkbox">
                                                                        <xsl:with-param name="checkbox_value"
                                                                                        select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:StudyDesign/HumanSubjectStudy_3_0:MaskingType/HumanSubjectStudy_3_0:OutcomesAssessor"/>
                                                                        <xsl:with-param name="checkbox_text">Outcomes Assessor</xsl:with-param>
                                                                    </xsl:call-template>


                                                                </fo:table-row>
                                                            </fo:table-body>
                                                        </fo:table>
                                                    </fo:table-cell>
                                                </fo:table-row>
                                            </fo:table-body>
                                        </fo:table>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell number-columns-spanned="3" padding-before="12" padding-start="18" padding-after="18">
                                    <fo:block font-size="9px">4.1.g. Allocation</fo:block>
                                </fo:table-cell>
                                <fo:table-cell number-columns-spanned="2" padding-before="11" padding-after="18">
                                    <fo:block font-size="9px">
                                        <fo:inline>
                                            <xsl:value-of
                                                    select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:StudyDesign/HumanSubjectStudy_3_0:Allocation"/>
                                        </fo:inline>
                                    </fo:block>
                                </fo:table-cell>

                            </fo:table-row>
                            <fo:table-row>
                                <!-- 4.2 -->
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text">
                                        4.2. Outcome Measures
                                    </xsl:with-param>
                                    <xsl:with-param name="number-columns-spanned">2</xsl:with-param>
                                </xsl:call-template>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell number-columns-spanned="5">
                                    <fo:table width="100%" table-layout="fixed" border-style="solid"
                                              border-width="1pt" border-color="black" margin-bottom="0.2in">
                                        <fo:table-column column-width="10%"/>
                                        <fo:table-column column-width="25%"/>
                                        <fo:table-column column-width="25%"/>
                                        <fo:table-column column-width="40%"/>

                                        <fo:table-body start-indent="0pt">
                                            <fo:table-row>
                                                <xsl:call-template name="table_header_cell">
                                                    <xsl:with-param name="label_text">
                                                        Type
                                                    </xsl:with-param>
                                                </xsl:call-template>
                                                <xsl:call-template name="table_header_cell">
                                                    <xsl:with-param name="label_text">
                                                        Name
                                                    </xsl:with-param>
                                                </xsl:call-template>
                                                <xsl:call-template name="table_header_cell">
                                                    <xsl:with-param name="label_text">
                                                        Time Frame
                                                    </xsl:with-param>
                                                </xsl:call-template>
                                                <xsl:call-template name="table_header_cell">
                                                    <xsl:with-param name="label_text">
                                                        Brief Description
                                                    </xsl:with-param>
                                                </xsl:call-template>
                                            </fo:table-row>

                                            <xsl:for-each select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:OutcomesMeasures">
                                                <fo:table-row>
                                                    <xsl:call-template name="table_body_cell">
                                                        <xsl:with-param name="cell_text"
                                                                        select="HumanSubjectStudy_3_0:OutcomeType"/>
                                                        <xsl:with-param name="line_max">25</xsl:with-param>
                                                    </xsl:call-template>
                                                    <xsl:call-template name="table_body_cell">
                                                        <xsl:with-param name="cell_text"
                                                                        select="HumanSubjectStudy_3_0:OutcomeName"/>
                                                        <xsl:with-param name="line_max">25</xsl:with-param>
                                                    </xsl:call-template>
                                                    <xsl:call-template name="table_body_cell">
                                                        <xsl:with-param name="cell_text"
                                                                        select="HumanSubjectStudy_3_0:TimeFrame"/>
                                                        <xsl:with-param name="line_max">25</xsl:with-param>
                                                    </xsl:call-template>
                                                    <xsl:call-template name="table_body_cell_tabs_newline">
                                                        <xsl:with-param name="cell_text"
                                                                        select="HumanSubjectStudy_3_0:OutcomeDescription"/>
                                                        <xsl:with-param name="line_max">40</xsl:with-param>
                                                    </xsl:call-template>
                                                </fo:table-row>


                                            </xsl:for-each>
                                        </fo:table-body>
                                    </fo:table>
                                </fo:table-cell>
                            </fo:table-row>
                            <!-- 4.3 -->
                            <fo:table-row>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text">
                                        4.3. Statistical Design and Power
                                    </xsl:with-param>
                                    <xsl:with-param name="number-columns-spanned">3</xsl:with-param>
                                </xsl:call-template>
                                <xsl:call-template name="text-field">
                                    <xsl:with-param name="number-columns-spanned">
                                        2
                                    </xsl:with-param>
                                    <xsl:with-param name="field_value"
                                                    select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:StatisticalDesignPower/HumanSubjectStudy_3_0:attFile/att:FileName"/>
                                </xsl:call-template>
                            </fo:table-row>
                            <!-- 4.4 -->
                            <fo:table-row>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text">
                                        4.4. Subject Participation Duration
                                    </xsl:with-param>
                                    <xsl:with-param name="number-columns-spanned">3</xsl:with-param>
                                </xsl:call-template>
                                <xsl:call-template name="text-field">
                                    <xsl:with-param name="number-columns-spanned">
                                        2
                                    </xsl:with-param>
                                    <xsl:with-param name="field_value"
                                                    select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:SubjectParticipationDuration"/>
                                </xsl:call-template>
                            </fo:table-row>
                            <!-- 4.5 -->
                            <fo:table-row>
                                <fo:table-cell number-columns-spanned="3" padding-before="6">
                                    <fo:block font-size="9px">4.5. Will the study use an FDA-regulated intervention?</fo:block>
                                </fo:table-cell>
                                <xsl:call-template name="radio-field">
                                    <xsl:with-param name="xml_field"
                                                    select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:FDARegulatedIntervention"/>
                                </xsl:call-template>
                            </fo:table-row>
                            <fo:table-row>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text">
                                        4.5.a. If yes, describe the availability of Investigational Product (IP) and Investigational New Drug
                                        (IND)/Investigational Device Exemption (IDE) status
                                    </xsl:with-param>
                                    <xsl:with-param name="number-columns-spanned">3</xsl:with-param>
                                    <xsl:with-param name="padding-start">18</xsl:with-param>
                                </xsl:call-template>
                                <xsl:call-template name="text-field">
                                    <xsl:with-param name="number-columns-spanned">
                                        2
                                    </xsl:with-param>
                                    <xsl:with-param name="field_value"
                                                    select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:InvestigationalAvailability/HumanSubjectStudy_3_0:attFile/att:FileName"/>
                                </xsl:call-template>
                            </fo:table-row>
                            <!-- 4.6 -->
                            <fo:table-row>
                                <fo:table-cell number-columns-spanned="3" padding-before="6">
                                    <fo:block font-size="9px">4.6. Is this an applicable clinical trial under FDAAA?</fo:block>
                                </fo:table-cell>
                                <xsl:call-template name="radio-field">
                                    <xsl:with-param name="xml_field"
                                                    select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:ApplicableClinicalTrial"/>
                                </xsl:call-template>
                            </fo:table-row>
                            <!-- 4.7 -->
                            <fo:table-row>
                                <fo:table-cell number-columns-spanned="3" padding-before="12">
                                    <fo:block font-size="9px">4.7. Dissemination Plan</fo:block>
                                </fo:table-cell>
                                <fo:table-cell number-columns-spanned="2" padding-before="12">
                                    <fo:block font-size="9px">
                                        <fo:inline>
                                            <xsl:value-of
                                                    select="HumanSubjectStudy_3_0:ProtocolSynopsis/HumanSubjectStudy_3_0:DisseminationPlan/HumanSubjectStudy_3_0:attFile/att:FileName"/>
                                        </fo:inline>
                                    </fo:block>
                                </fo:table-cell>

                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                </fo:block>
            </xsl:for-each>
        </fo:block>
    </xsl:template>
    <!-- End of Section 4 -->


    <!-- Utility Templates -->

    <!--
    Create checkboxes with display text, ${checkbox_text}, and assign the value, ${checkbox_value}
     -->
    <xsl:template name="masking_checkbox">
        <xsl:param name="checkbox_text"/>
        <xsl:param name="checkbox_value"/>
        <fo:table-cell hyphenate="true" language="en" padding-end="0pt" padding-before="0pt"
                       padding-after="0pt" display-align="before" text-align="start"
                       border-style="solid" border-width="0pt" border-color="white">
            <fo:block font-size="9px">
                <fo:inline font-family="ZapfDingbats">&#x274F;</fo:inline>
                <fo:block-container keep-together="always"
                                    position="absolute">
                    <fo:block>
                        <xsl:choose>
                            <xsl:when
                                    test="normalize-space($checkbox_value) = normalize-space('Y: Yes')">
                                <fo:inline font-family="ZapfDingbats" font-size="8pt">&#x2714;
                                </fo:inline>
                            </xsl:when>
                        </xsl:choose>
                    </fo:block>
                </fo:block-container>
                <fo:block-container position="absolute" left="10pt">
                    <fo:block>
                        <xsl:value-of select="$checkbox_text"/>
                    </fo:block>
                </fo:block-container>
            </fo:block>
        </fo:table-cell>
    </xsl:template>


    <!-- A generic field value area: $text-field will be displayed in the cell -->
    <xsl:template name="text-field">
        <xsl:param name="field_value"/>
        <xsl:param name="number-columns-spanned" select="1"/>
        <fo:table-cell number-columns-spanned="{$number-columns-spanned}"
                       text-align="left" padding-end="3pt"
                       padding-before="0pt" padding-after="6pt">
            <fo:block>
                <fo:table font-size="9px" table-layout="fixed" width="100%">
                    <fo:table-column column-width="proportional-column-width(1)"/>
                    <fo:table-body start-indent="0pt">
                        <fo:table-row>
                            <fo:table-cell text-align="left" padding-start="1pt" padding-end="3pt"
                                           padding-before="1pt" padding-after="6pt">
                                <fo:block font-family="arialuni" font-size="9px">
                                    <fo:inline>
                                        <xsl:value-of select="$field_value"/>
                                    </fo:inline>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </fo:table-cell>
    </xsl:template>
    <!-- Create label with display text, ${label_text} -->
    <xsl:template name="label">
        <xsl:param name="padding-start" select="0"/>
        <xsl:param name="number-columns-spanned"/>
        <xsl:param name="label_text"/>

        <fo:table-cell number-columns-spanned="{$number-columns-spanned}"
                       text-align="left" padding-start="{$padding-start}" padding-end="3pt"
                       padding-before="1pt" padding-after="6pt">
            <fo:block font-family="arialuni" font-size="9px">
                <xsl:value-of select="$label_text"/>
            </fo:block>
        </fo:table-cell>
    </xsl:template>

    <!-- Creates radio field for a given ${xml_field} with 'Yes' or 'No' options
        Marks the value where ${xml_field} = radio_box value as selected -->
    <xsl:template name="radio-field">
        <xsl:param name="xml_field"/>
        <fo:table-cell text-align="left"
                       padding-end="3pt" padding-after="6pt"
                       number-columns-spanned="2">
            <fo:block>
                <fo:table font-size="9px" table-layout="fixed" width="100%">
                    <fo:table-column column-width="proportional-column-width(1)"/>
                    <fo:table-body start-indent="0pt">
                        <fo:table-row>
                            <fo:table-cell border="solid 1pt white"
                                           border-spacing="1pt" padding="2pt">
                                <fo:table border-color="red">
                                    <fo:table-column column-width="6%"/>
                                    <fo:table-column column-width="22%"/>
                                    <fo:table-column column-width="6%"/>
                                    <fo:table-column column-width="22%"/>
                                    <fo:table-body>
                                        <fo:table-row>
                                            <xsl:call-template name="yesOrNoRadio">
                                                <xsl:with-param name="xml_field" select="$xml_field"/>
                                            </xsl:call-template>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </fo:table-cell>
                        </fo:table-row>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </fo:table-cell>
    </xsl:template>
    <!-- Creates radio field for a given ${xml_field} with 'Yes' or 'No' options
        Marks the value where ${xml_field} = radio_box value as selected -->

    <xsl:template name="yesOrNoRadio">
        <xsl:param name="xml_field"/>
        <!-- YES -->
        <xsl:call-template name="options">
            <xsl:with-param name="xml_field" select="$xml_field"/>
            <xsl:with-param name="radio_text">
                Yes
            </xsl:with-param>
            <xsl:with-param name="radio_value">
                Y: Yes
            </xsl:with-param>
        </xsl:call-template>
        <!-- NO -->
        <xsl:call-template name="options">
            <xsl:with-param name="xml_field" select="$xml_field"/>
            <xsl:with-param name="radio_text">
                No
            </xsl:with-param>
            <xsl:with-param name="radio_value">
                N: No
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="options">
        <xsl:param name="xml_field"/>
        <xsl:param name="radio_text"/>
        <xsl:param name="radio_value"/>
        <fo:table-cell line-height="15pt">
            <fo:block>
                <xsl:call-template name="radio">
                    <xsl:with-param name="xml_field" select="$xml_field"/>
                    <xsl:with-param name="radio_value" select="$radio_value"/>
                </xsl:call-template>
            </fo:block>
        </fo:table-cell>
        <fo:table-cell line-height="15pt">
            <fo:block>
                <xsl:value-of select="$radio_text"/>
            </fo:block>
        </fo:table-cell>
    </xsl:template>

    <xsl:template name="radio">
        <xsl:param name="xml_field"/>
        <xsl:param name="radio_value"/>
        <xsl:choose>
            <xsl:when
                    test="normalize-space($xml_field) = normalize-space($radio_value)">
                <fo:inline font-family="ZapfDingbats" font-size="9px"
                           padding-end="1pt">&#x25cf;
                </fo:inline>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline font-family="ZapfDingbats" font-size="9px"
                           padding-end="1pt">&#x274d;
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="table_header_cell">
        <xsl:param name="label_text"/>
        <fo:table-cell padding="3pt" border-style="solid"
                       border-width="1pt" border-color="black" background-color="#EEEEEE">
            <fo:block>
                <fo:inline font-weight="bold" font-size="9px">
                    <xsl:value-of select="$label_text"/>
                </fo:inline>
            </fo:block>
        </fo:table-cell>
    </xsl:template>
    <xsl:template name="table_body_cell">
        <xsl:param name="cell_text"/>
        <xsl:param name="line_max" select="30"/>
        <xsl:variable name="string-mod">
            <xsl:call-template name="string-replace">
                <xsl:with-param name="str" select="$cell_text"/>
                <xsl:with-param name="gap" select="$line_max"/>
            </xsl:call-template>
        </xsl:variable>
        <fo:table-cell padding="3pt" hyphenate="true" border-style="solid" border-width="1pt" border-color="black" page-break-inside="avoid">
            <fo:block font-family="arialuni" font-size="9px">
                <xsl:value-of select="$string-mod"/>
            </fo:block>
        </fo:table-cell>
    </xsl:template>

    <!-- breaking long string -->
    <xsl:template name="string-replace">
        <xsl:param name="str"/>
        <xsl:param name="gap"/>
        <xsl:choose>
            <xsl:when test="string-length($str) > $gap">
                <xsl:value-of select="substring($str,1,$gap)"/>
                <xsl:value-of select="''"/>
                <xsl:call-template name="string-replace">
                    <xsl:with-param name="str" select="substring($str,$gap + 1)"/>
                    <xsl:with-param name="gap" select="$gap"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$str"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- Preserves new line character inside table cell -->
    <xsl:template name="table_body_cell_newline">
        <xsl:param name="cell_text"/>
        <xsl:param name="line_max" select="30"/>
        <xsl:variable name="string-mod">
            <xsl:call-template name="string-replace">
                <xsl:with-param name="str" select="$cell_text"/>
                <xsl:with-param name="gap" select="$line_max"/>
            </xsl:call-template>
        </xsl:variable>
        <fo:table-cell padding="3pt" hyphenate="true" border-style="solid" border-width="1pt" border-color="black" page-break-inside="avoid">
            <fo:block font-family="arialuni" font-size="9px" linefeed-treatment="preserve" white-space-collapse="false" wrap-option="wrap"
                      white-space-treatment="preserve">
                <xsl:value-of select="$string-mod"/>
            </fo:block>
        </fo:table-cell>
    </xsl:template>

    <!--  template to replace tabs with 5 spaces and to preserve new line characters-->
    <xsl:template name="table_body_cell_tabs_newline">
        <xsl:param name="cell_text" select="."/>
        <xsl:param name="line_max" select="30"/>
        <xsl:param name="text" select="$cell_text"/>

        <xsl:variable name="tabspaces" select="'     '"/>
        <xsl:variable name="tabText" select="'&#x09;'"/>
        <xsl:variable name="tabIndex" select="string-length(substring-before($cell_text, $tabText))"/>
        <xsl:choose>
            <xsl:when test="$tabIndex > 0">
                <xsl:variable name="newLabeltext1">
                    <xsl:call-template name="replace-all-string-template">
                        <xsl:with-param name="text" select="$text"/>
                        <xsl:with-param name="replace" select="$tabText"/>
                        <xsl:with-param name="with" select="$tabspaces"/>
                    </xsl:call-template>
                </xsl:variable>
                <xsl:call-template name="table_body_cell_newline">
                    <xsl:with-param name="cell_text" select="$newLabeltext1"/>
                    <xsl:with-param name="line_max" select="$line_max"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="table_body_cell_newline">
                    <xsl:with-param name="cell_text" select="$cell_text"/>
                    <xsl:with-param name="line_max" select="$line_max"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- Template for textarea to preserve white space, new line character and tabs, ${label_text} -->
    <xsl:template name="textarea-label">
        <xsl:param name="padding-start" select="0"/>
        <xsl:param name="number-columns-spanned"/>
        <xsl:param name="label_text"/>
        <fo:table-cell number-columns-spanned="{$number-columns-spanned}"
                       text-align="left" padding-start="{$padding-start}" padding-end="3pt"
                       padding-before="1pt" padding-after="6pt">
            <fo:block font-family="arialuni" font-size="9px" linefeed-treatment="preserve" white-space-collapse="false" wrap-option="wrap"
                      white-space-treatment="preserve">
                <xsl:value-of select="$label_text"/>
            </fo:block>
        </fo:table-cell>
    </xsl:template>

    <!--  template to replace tabs with 5 spaces and to preserve new line characters-->
    <xsl:template name="textarea-textwith-tabs-newline">
        <xsl:param name="label_text" select="."/>
        <xsl:param name="padding-start" select="0"/>
        <xsl:param name="number-columns-spanned"/>
        <xsl:param name="text" select="$label_text"/>

        <xsl:variable name="tabspaces" select="'     '"/>
        <xsl:variable name="tabText" select="'&#x09;'"/>
        <xsl:variable name="tabIndex" select="string-length(substring-before($label_text, $tabText))"/>
        <xsl:choose>
            <xsl:when test="$tabIndex > 0">
                <xsl:variable name="newLabeltext1">
                    <xsl:call-template name="replace-all-string-template">
                        <xsl:with-param name="text" select="$text"/>
                        <xsl:with-param name="replace" select="$tabText"/>
                        <xsl:with-param name="with" select="$tabspaces"/>
                    </xsl:call-template>
                </xsl:variable>
                <xsl:call-template name="textarea-label">
                    <xsl:with-param name="label_text" select="$newLabeltext1"/>
                    <xsl:with-param name="number-columns-spanned" select="$number-columns-spanned"/>
                    <xsl:with-param name="padding-start" select="$padding-start"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="textarea-label">
                    <xsl:with-param name="label_text" select="$label_text"/>
                    <xsl:with-param name="number-columns-spanned" select="$number-columns-spanned"/>
                    <xsl:with-param name="padding-start" select="$padding-start"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- Replace all String  
        text         : main string
        replace : the string fragment to be replaced
        with    :  the replacement string -->
    <xsl:template name="replace-all-string-template">
        <xsl:param name="text"/>
        <xsl:param name="replace"/>
        <xsl:param name="with"/>
        <xsl:choose>
            <xsl:when test="contains($text,$replace)">
                <xsl:value-of select="substring-before($text,$replace)"/>
                <xsl:value-of select="$with"/>
                <xsl:call-template name="replace-all-string-template">
                    <xsl:with-param name="text" select="substring-after($text,$replace)"/>
                    <xsl:with-param name="replace" select="$replace"/>
                    <xsl:with-param name="with" select="$with"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$text"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
